package com.ptteng.course.admin.controller;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import com.ptteng.learn.course.service.MemberService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyArrayUtil;
import com.gemantic.common.util.MyListUtil;
import com.gemantic.common.util.MyMapUtil;
import com.gemantic.common.util.StringUtil;
import com.ptteng.course.util.CommonUtil;
import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.admin.model.Manager;
import com.ptteng.learn.common.model.Message;
import com.ptteng.learn.common.model.UserMessageRelation;
import com.ptteng.learn.common.service.MessageService;
import com.ptteng.learn.common.service.UserMessageRelationService;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.MailMessage;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


/**
 * User  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class UserController {
    private static final Log log = LogFactory.getLog("user");

    @Autowired
    private UserService userService;
    @Autowired
    private UserFavoriteRelationService userFavoriteRelationService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private PeriodService periodService;
    @Autowired
    private ProgressService progressService;
    @Autowired
    private PaperService paperService;
    @Autowired
    private LocksService locksService;
    @Autowired
    private UserOrderService userOrderService;
    @Autowired
    private BookService bookService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private UserOpenidRelationService userOpenidRelationService;
    @Autowired
    private UserRecommendService userRecommendService;
    @Autowired
    private ScoreRecordService scoreRecordService;
    @Autowired
    private UserMemberRelationService userMemberRelationService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private BookVersionService bookVersionService;
    @Autowired
    private BookSubjectService bookSubjectService;
    @Autowired
    private UserMessageRelationService userMessageRelationService;
    @Autowired
    private LoginRecordService loginRecordService;

    //1、用户详情
    @RequestMapping(value = "/a/u/user/{id}", method = RequestMethod.GET)
    public String getUserJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            User user = userService.getObjectById(id);
            log.info("get user data is " + user);
            Long now = System.currentTimeMillis();
            if (null == user) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            List<Long> memeberIds = userMemberRelationService.getUserMemberRelationIdsByUid(id, 0, Integer.MAX_VALUE);
            Boolean isVip=false;
            Long VipLine=null;

            if (memeberIds.size() > 0) {

//              这边只处理是不是会员。
                  List <UserMemberRelation> userMemberRelationList = userMemberRelationService.getObjectsByIds(memeberIds);

                for(UserMemberRelation userMemberRelation : userMemberRelationList){
                    if(userMemberRelation.getStartAt()<now &&  userMemberRelation.getEndAt()>now ){
                        userMemberRelation.setStatus(User.IS_MEMBER);
//
                    }else if( userMemberRelation.getEndAt()<now || (userMemberRelation.getStartAt()>now &&  userMemberRelation.getEndAt()>now) ){
                        userMemberRelation.setStatus(User.IS_NOT_MEMBER);
                    }
//                    判断是不是会员
                    if(userMemberRelation.getStatus().equals(User.IS_MEMBER)){

                        isVip=true;
                        VipLine = userMemberRelation.getEndAt();
                    }
//
                }
                userMemberRelationService.updateList(userMemberRelationList);

//                如果是会员 ，那么就判断有没有续费。
                if(isVip.equals(true)){
                    for(UserMemberRelation userMemberRelation : userMemberRelationList){
                        if(now<userMemberRelation.getStartAt()&&userMemberRelation.getEndAt()>now){
                            if(VipLine<userMemberRelation.getEndAt()){
                                VipLine=userMemberRelation.getEndAt();
                            }
                        }
                    }
                }
                model.addAttribute("vipLine", VipLine);

//                Boolean isVip=false;
//                List <UserMemberRelation> userMemberRelationList = userMemberRelationService.getObjectsByIds(memeberIds);
//                for(UserMemberRelation userMemberRelation : userMemberRelationList){
//                    if(userMemberRelation.getStartAt()<now &&  userMemberRelation.getEndAt()>now ){
//                        userMemberRelation.setStatus(User.IS_MEMBER);
//                        isVip=true;
////
//                    }else if( userMemberRelation.getEndAt()<now ){
//                        userMemberRelation.setStatus(User.IS_NOT_MEMBER);
//                    }else if( userMemberRelation.getStartAt()>now && userMemberRelation.getEndAt()>now &&  isVip.equals(true)){
//                        userMemberRelation.setStatus(User.IS_MEMBER);
//
//                    }
//                }
//                userMemberRelationService.updateList(userMemberRelationList);
//                Long vipLine=0L;
//
//                for (UserMemberRelation userMemberRelation : userMemberRelationList){
//                    if(userMemberRelation.getStartAt()<now &&  userMemberRelation.getEndAt()>now || userMemberRelation.getStartAt()>now && userMemberRelation.getEndAt()>now && isVip.equals(true)){
//                        if(vipLine<userMemberRelation.getEndAt()){
//                            vipLine=userMemberRelation.getEndAt();
//                        }
//                        user.setMember(User.IS_MEMBER);
//
//
//                    }
//                }
//                model.addAttribute("vipLine", vipLine);
            }

            model.addAttribute("code", 0);
            model.addAttribute("user", user);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/user/json/userDetailJson";
    }

    //2、冻结解冻用户
    @RequestMapping(value = "/a/u/freeze/user/{id}", method = RequestMethod.PUT)
    public String updateUserJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                 @PathVariable Long id, Integer status) throws Exception {

        log.info("update user : userId is= " + id + " status : " + status);

        try {
            User user = userService.getObjectById(id);
            if (user == null) {
                model.addAttribute("code", 2);
                return "/common/success";
            }

            if (User.status_freeze != status && User.status_normal != status) {
                model.addAttribute("code", -1001);
                return "/common/success";
            }

            user.setStatus(status);
            userService.update(user);
            log.info("update user status " + status + " success ");

            model.addAttribute("code", 0);
            model.addAttribute("user", user);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update user error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }


    //12、设为推广人/校正推广人
    @RequestMapping(value = "/a/u/user/recommend/{id}", method = RequestMethod.PUT)
    public String updateUserAsRecommendJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                            @PathVariable Long id) throws Exception {

        log.info("update user as recommend,: userId is= " + id);

        try {
            User user = userService.getObjectById(id);
            if (user == null) {
                model.addAttribute("code", 2);
                return "/common/success";
            }

            if (StringUtil.isNotEmpty(user.getInvitationCode())) {
                //已经是推广人的情况下，更新修正用户推广信息

                UserRecommend userRecommend = userRecommendService.getObjectById(id);
                if (null == userRecommend) {
                    //用户是推广人有邀请码但是无userRecommend数据（可能是老版本数据，补充userRecommend数据）
                    UserRecommend newUserRecommend = new UserRecommend();
                    newUserRecommend.setId(id);
                    userRecommendService.insert(newUserRecommend);

                    userRecommend = userRecommendService.getObjectById(id);
                    log.info("create user recommend : " + userRecommend);

                } else {
                    //用户是推广人且有userRecommend数据
                    log.info("get user recommend : " + userRecommend);

                }

                //校正用户消费状态
                List<Long> oids = userOrderService.getUserOrderIdsByUidAndStatus(id, UserOrder.COMPLETED, 0, 1);
                if (CollectionUtils.isNotEmpty(oids)) {
                    log.info("user have completed order");
                    user.setSpendStatus(User.spend);
                } else {
                    log.info("user have no completed order");
                    user.setSpendStatus(User.no_spend);
                }

                //校正用户各平台消费状态
                BigDecimal androidPriceTot = BigDecimal.ZERO;
                BigDecimal iosPriceTot = BigDecimal.ZERO;

                //安卓消费总金额
                List<Long> androidOrderIds = userOrderService.getUserOrderIdsByUidAndStatusAndOs(id, UserOrder.COMPLETED, UserOrder.OS_ANDROID, 0, Integer.MAX_VALUE);
                log.info("user android order list : " + androidOrderIds);
                List<UserOrder> androidOrders = userOrderService.getObjectsByIds(androidOrderIds);
                for (UserOrder androidOrder : androidOrders) {
                    androidPriceTot = androidPriceTot.add(androidOrder.getPrice());
                }
                log.info("user android orders price total : " + androidPriceTot);
                user.setAndroidAmount(androidPriceTot);
                //IOS消费总金额
                List<Long> iosOrderIds = userOrderService.getUserOrderIdsByUidAndStatusAndOs(id, UserOrder.COMPLETED, UserOrder.OS_IOS, 0, Integer.MAX_VALUE);
                log.info("user ios order list : " + iosOrderIds);
                List<UserOrder> iosOrders = userOrderService.getObjectsByIds(iosOrderIds);
                for (UserOrder iosOrder : iosOrders) {
                    iosPriceTot = iosPriceTot.add(iosOrder.getPrice());
                }
                log.info("user ios orders price total : " + iosPriceTot);
                user.setIosAmount(iosPriceTot);

                //校正推广人总数
                List<Long> uids = userService.getUserIdByRecommendId(id, 0, Integer.MAX_VALUE);
                log.info("user recommend : " + uids);
                userRecommend.setRecommendNum(uids.size());

                //消费人数、安卓消费金额、ios消费金额
                Integer spendNum = 0;
                BigDecimal androidAmount = BigDecimal.ZERO;
                BigDecimal iosAmount = BigDecimal.ZERO;
                List<User> users = userService.getObjectsByIds(uids);
                for (User recommendUser : users) {
                    androidAmount = androidAmount.add(recommendUser.getAndroidAmount());
                    iosAmount = iosAmount.add(recommendUser.getIosAmount());
                    if (User.spend.equals(recommendUser.getSpendStatus())) {
                        log.info("user : " + recommendUser.getId() + " no cost");
                        spendNum++;
                    } else {
                        log.info("user : " + recommendUser.getId() + " already cost");
                    }
                }
                log.info("recommend user cost number : " + spendNum + " , android amount : " + androidAmount + " , ios amount : " + iosAmount);

                userRecommend.setSpendNum(spendNum);
                userRecommend.setAndroidAmount(androidAmount);
                userRecommend.setIosAmount(iosAmount);

                userRecommendService.update(userRecommend);
                log.info("update user recommend " + userRecommend + " success ");

            } else {
                user.setRecommendFlag(User.IS_MEMBER);
                //生成8位邀请码

                int idLength = (id + "").length();
                String invitationCode = RandomStringUtils.randomNumeric(8 - idLength);
                log.info(" user " + id + " invitationCode is " + invitationCode);
                user.setInvitationCode(id + invitationCode);
                user.setRecommendAt(System.currentTimeMillis());

                //插入userRecommend数据
                UserRecommend newUserRecommend = new UserRecommend();
                newUserRecommend.setId(id);
                log.info("insert newUserRecommend : " + newUserRecommend);
                userRecommendService.insert(newUserRecommend);
                log.info("insert user recommend data success");
            }

            userService.update(user);
            log.info("update user  success ");

            model.addAttribute("code", 0);
            model.addAttribute("user", user);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update user error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success1";
    }


    /**
     * @param
     * @Description 校正全部用户推广信息
     * @Author: PeiyuFeng
     * @Time 2017/2/16 14:50
     */
    @RequestMapping(value = "/a/u/user/recommend/verify", method = RequestMethod.PUT)
    public String userRecommendInfoVerify(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

        log.info("update all user recommend info !!!!!!!!!!!!!!!!!");

        try {
            List<Long> uids = userService.getUserIds(0, Integer.MAX_VALUE);

            List<User> users = userService.getObjectsByIds(uids);

            for (User user : users) {
                Long id = user.getId();

                log.info("========= user : " + id + " info verify ==========");
                //校正用户消费状态
                List<Long> oids = userOrderService.getUserOrderIdsByUidAndStatus(id, UserOrder.COMPLETED, 0, 1);
                if (CollectionUtils.isNotEmpty(oids)) {
                    log.info("user have completed order");
                    user.setSpendStatus(User.spend);
                } else {
                    log.info("user have no completed order");
                    user.setSpendStatus(User.no_spend);
                }

                //校正用户各平台消费状态
                BigDecimal androidPriceTot = BigDecimal.ZERO;
                BigDecimal iosPriceTot = BigDecimal.ZERO;

                //安卓消费总金额
                List<Long> androidOrderIds = userOrderService.getUserOrderIdsByUidAndStatusAndOs(id, UserOrder.COMPLETED, UserOrder.OS_ANDROID, 0, Integer.MAX_VALUE);
                log.info("user android order list : " + androidOrderIds);
                List<UserOrder> androidOrders = userOrderService.getObjectsByIds(androidOrderIds);
                for (UserOrder androidOrder : androidOrders) {
                    androidPriceTot = androidPriceTot.add(androidOrder.getPrice());
                }
                log.info("user android orders price total : " + androidPriceTot);
                user.setAndroidAmount(androidPriceTot);
                //IOS消费总金额
                List<Long> iosOrderIds = userOrderService.getUserOrderIdsByUidAndStatusAndOs(id, UserOrder.COMPLETED, UserOrder.OS_IOS, 0, Integer.MAX_VALUE);
                log.info("user ios order list : " + iosOrderIds);
                List<UserOrder> iosOrders = userOrderService.getObjectsByIds(iosOrderIds);
                for (UserOrder iosOrder : iosOrders) {
                    log.info("order : " + iosOrder.getId() + " price " + iosOrder.getPrice());
                    iosPriceTot = iosPriceTot.add(iosOrder.getPrice());
                    log.info("ios price tot : " + iosPriceTot);
                }
                log.info("user ios orders price total : " + iosPriceTot);
                user.setIosAmount(iosPriceTot);

                userService.update(user);
                log.info("update user : " + user + " success");

            }

            log.info("user info update over ==========================================================");

            for (User user : users) {
                Long id = user.getId();


                if (StringUtil.isNotEmpty(user.getInvitationCode())) {
                    log.info("========= user : " + id + " recommend verify ==========");
                    UserRecommend userRecommend = userRecommendService.getObjectById(id);
                    if (null == userRecommend) {
                        //用户是推广人有邀请码但是无userRecommend数据（可能是老版本数据，补充userRecommend数据）
                        UserRecommend newUserRecommend = new UserRecommend();
                        newUserRecommend.setId(id);
                        userRecommendService.insert(newUserRecommend);

                        userRecommend = userRecommendService.getObjectById(id);
                        log.info("create user recommend : " + userRecommend);

                    } else {
                        //用户是推广人且有userRecommend数据
                        log.info("get user recommend : " + userRecommend);

                    }

                    //校正推广人总数
                    List<Long> recommendUids = userService.getUserIdByRecommendId(id, 0, Integer.MAX_VALUE);
                    log.info("user recommend : " + recommendUids);
                    userRecommend.setRecommendNum(recommendUids.size());

                    //消费人数、安卓消费金额、ios消费金额
                    Integer spendNum = 0;
                    BigDecimal androidAmount = BigDecimal.ZERO;
                    BigDecimal iosAmount = BigDecimal.ZERO;
                    List<User> recommendUsers = userService.getObjectsByIds(recommendUids);
                    for (User recommendUser : recommendUsers) {
                        androidAmount = androidAmount.add(recommendUser.getAndroidAmount());
                        iosAmount = iosAmount.add(recommendUser.getIosAmount());
                        if (User.spend.equals(recommendUser.getSpendStatus())) {
                            log.info("user : " + recommendUser.getId() + " already cost");
                            spendNum++;
                        } else {
                            log.info("user : " + recommendUser.getId() + " no cost");
                        }
                    }
                    log.info("recommend user cost number : " + spendNum + " , android amount : " + androidAmount + " , ios amount : " + iosAmount);

                    userRecommend.setSpendNum(spendNum);
                    userRecommend.setAndroidAmount(androidAmount);
                    userRecommend.setIosAmount(iosAmount);

                    userRecommendService.update(userRecommend);
                    log.info("update user recommend info : " + userRecommend + " success");
                } else {
//                    log.info("user not recommend user");
                }

            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update user recommend error ");
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }


    /**
     * @param id 用户id
     * @Description 启用/禁用推广人
     * @Author: PeiyuFeng
     * @Time 2017/2/10 11:39
     */
    @RequestMapping(value = "/a/u/user/recommend/status/{id}", method = RequestMethod.PUT)
    public String changeRecommendStatus(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("change recommend status : id = " + id);

        Manager manager = (Manager) request.getAttribute("manager");
        Long managerId = manager.getId();

        try {
            //确认用户是否存在
            User user = userService.getObjectById(id);
            if (null == user) {
                model.addAttribute("code", -2000);
                log.info("user not exist");
                return "/common/success";
            } else {
                log.info("user exist : " + user);
            }

            //确定用户是否是推广人
            if (User.IS_NOT_MEMBER == user.getRecommendFlag()) {
                //用户不是推广人且无userRecommend数据（错误）
                model.addAttribute("code", -10000);
                log.info("user not recommend");
                return "/common/success";
            } else {

                UserRecommend userRecommend = userRecommendService.getObjectById(id);
                if (null == userRecommend) {
                    //用户是推广人有邀请码但是无userRecommend数据（可能是老版本数据，补充userRecommend数据）
                    UserRecommend newUserRecommend = new UserRecommend();
                    newUserRecommend.setId(id);
                    userRecommendService.insert(newUserRecommend);
                } else {
                    //用户是推广人且有userRecommend数据，判断推荐人状态
                    if (UserRecommend.Recommend_forbidden.equals(userRecommend.getRecommendStatus())) {
                        userRecommend.setRecommendStatus(UserRecommend.Recommend_normal);

                    } else {
                        userRecommend.setRecommendStatus(UserRecommend.Recommend_forbidden);
                    }
                    log.info("update user recommend : " + userRecommend);
                    userRecommendService.update(userRecommend);
                }
            }

            log.info("user " + id + " change recommend status success");

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("change recommend status error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }
    /**
     * @param id 用户id
     * @Description 显示/隐藏推广统计
     * @Author: ShaoboLi
     * @Time 2017/8/30 11:29
     */
    @RequestMapping(value = "/a/u/user/recommend/statistics/{id}", method = RequestMethod.PUT)
    public String changeRecommendDisplay(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("change recommend statistics : id = " + id);

        Manager manager = (Manager) request.getAttribute("manager");
        Long managerId = manager.getId();

        try {
            //确认用户是否存在
            User user = userService.getObjectById(id);
            if (null == user) {
                model.addAttribute("code", -2000);
                log.info("user not exist");
                return "/common/success";
            } else {
                log.info("user exist : " + user);
            }

            //确定用户是否是推广人
            if (User.IS_NOT_MEMBER == user.getRecommendFlag()) {
                //用户不是推广人且无userRecommend数据（错误）
                model.addAttribute("code", -10000);
                log.info("user not recommend");
                return "/common/success";
            } else {

                UserRecommend userRecommend = userRecommendService.getObjectById(id);
                if (null == userRecommend) {
                    //用户是推广人有邀请码但是无userRecommend数据（可能是老版本数据，补充userRecommend数据）
                    UserRecommend newUserRecommend = new UserRecommend();
                    newUserRecommend.setId(id);
                    userRecommendService.insert(newUserRecommend);
                } else {
                    //用户是推广人且有userRecommend数据，判断推荐人显示隐藏状态
                    if (UserRecommend.Stats_Hidden.equals(userRecommend.getStatsDisplay())) {
                        userRecommend.setStatsDisplay(UserRecommend.Stats_Show);

                    } else {
                        userRecommend.setStatsDisplay(UserRecommend.Stats_Hidden);
                    }
                    log.info("update user recommend : " + userRecommend);
                    userRecommendService.update(userRecommend);
                }
            }

            log.info("user " + id + " change recommend statistics status success");

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("change recommend status error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }

    /**
     * @param id 用户id
     * @Description 推广详情
     * @Author: PeiyuFeng
     * @Time 2017/2/10 12:24
     */
    @RequestMapping(value = "/a/u/recommend/detail/{id}", method = RequestMethod.GET)
    public String recommendDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get recommend detail : id = " + id);

        Manager manager = (Manager) request.getAttribute("manager");
        Long managerId = manager.getId();

        UserRecommend userRecommend = new UserRecommend();

        try {
            //确认用户是否存在
            User user = userService.getObjectById(id);
            if (null == user) {
                model.addAttribute("code", -2000);
                log.info("user not exist");
                return "/common/success";
            } else {
                log.info("user exist : " + user);
            }

            //确定用户是否是推广人
            if (User.IS_NOT_MEMBER == user.getRecommendFlag()) {
                //用户不是推广人且无userRecommend数据（错误）
                model.addAttribute("code", -10000);
                log.info("user not recommend");
                return "/common/success";
            } else {

                userRecommend = userRecommendService.getObjectById(id);
                if (null == userRecommend) {
                    //用户是推广人有邀请码但是无userRecommend数据（可能是老版本数据，补充userRecommend数据）
                    UserRecommend newUserRecommend = new UserRecommend();
                    newUserRecommend.setId(id);
                    log.info("insert newUserRecommend : " + newUserRecommend);
                    userRecommendService.insert(newUserRecommend);

                    userRecommend = userRecommendService.getObjectById(id);
                    log.info("user recommend info not exist , create and insert data : " + userRecommend);
                } else {

                    log.info("user recommend info : " + userRecommend);
                }
            }

            log.info("get user " + id + " recommend info success");

            model.addAttribute("code", 0);
            model.addAttribute("user", user);
            model.addAttribute("userRecommend", userRecommend);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("change recommend status error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/learn-course-service/user/json/recommendDetail";
    }


    /**
     * @param id 用户id
     * @Description 修改推广人折扣
     * @Author: PeiyuFeng
     * @Time 2017/2/10 15:44
     */
    @RequestMapping(value = "/a/u/user/recommend/discount/{id}", method = RequestMethod.PUT)
    public String setRecommendDiscount(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                       @PathVariable Long id, String discount, Integer display) throws Exception {

        log.info("set recommend discount : id = " + id + " discount = " + discount + " display = " + display);

        BigDecimal discountNum = BigDecimal.ZERO;

        if (StringUtil.isEmpty(discount)) {
            model.addAttribute("code", -1000);
            log.info("discount null");
            return "/common/success";
        } else {
            //校验折扣参数是否合法
            try {
                discountNum = new BigDecimal(discount);
            } catch (NumberFormatException e) {
                model.addAttribute("code", -10001);
                log.info("discount illegal");
                return "/common/success";
            }

            Integer resultMax = discountNum.compareTo(BigDecimal.TEN);
            Integer resultMin = discountNum.compareTo(BigDecimal.ZERO);
            if ((resultMax == -1 || resultMax == 0) && resultMin == 1) {
                log.info("discountNum " + discountNum + " legal");
            } else {
                model.addAttribute("code", -10001);
                log.info("discount illegal");
                return "/common/success";
            }
        }

        Manager manager = (Manager) request.getAttribute("manager");
        Long managerId = manager.getId();

        try {
            //确认用户是否存在
            User user = userService.getObjectById(id);
            if (null == user) {
                model.addAttribute("code", -2000);
                log.info("user not exist");
                return "/common/success";
            } else {
                log.info("user exist : " + user);
            }

            //确定用户是否是推广人
            if (User.IS_NOT_MEMBER == user.getRecommendFlag()) {
                //用户不是推广人且无userRecommend数据（错误）
                model.addAttribute("code", -10000);
                log.info("user not recommend");
                return "/common/success";
            } else {

                UserRecommend userRecommend = userRecommendService.getObjectById(id);
                if (null == userRecommend) {
                    //用户是推广人有邀请码但是无userRecommend数据（可能是老版本数据，补充userRecommend数据）
                    UserRecommend newUserRecommend = new UserRecommend();
                    newUserRecommend.setId(id);
                    userRecommendService.insert(newUserRecommend);
                } else {
                    //用户是推广人且有userRecommend数据，更新折扣信息
                    userRecommend.setDiscount(discountNum);
                    if (UserRecommend.DISPLAY_TRUE.equals(display)) {
                        userRecommend.setDisplay(display);
                    } else {
                        userRecommend.setDisplay(UserRecommend.DISPLAY_FALSE);
                    }
                    log.info("update user recommend : " + userRecommend);
                    userRecommendService.update(userRecommend);
                }
            }

            log.info("user " + id + " update recommend discount success");

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update recommend discount error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }


    //3、用户列表
    @RequestMapping(value = "/a/u/user/list", method = RequestMethod.GET)
    public String getMultiUserJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer status,
                                   String nick, Integer grade, String mail, String mobile, Integer scoreStart, Integer scoreEnd, Integer learnPeriodStart,
                                   Integer learnPeriodEnd, Integer page, Integer size) throws Exception {

        List<Long> idList = new ArrayList();
        Boolean next = false;

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            Map<String, Object> params = DynamicUtil.getUserList(nick, mail, mobile, grade, status, scoreStart, scoreEnd,
                    learnPeriodStart, learnPeriodEnd);
            idList = userService.getIdsByDynamicCondition(User.class, params, start, size);
            List<User> userList = userService.getObjectsByIds(idList);
            log.info("get  user data is " + userList.size());

            Integer userCount = userService.countUserIds();

            log.info("   total = " + userCount);
            model.addAttribute("userCount", userCount);
            List<Long> usercountIds = userService.getIdsByDynamicCondition(User.class, params, 0, Integer.MAX_VALUE);
            userCount = usercountIds.size();
            Integer totalPage = (((userCount - 1)) / size) + 1;
            log.info("   totalPage = " + totalPage);

            if (idList != null && idList.size() > 0) {
                if (size.equals(idList.size())) {
                    next = true;
                    idList = idList.subList(0, size);
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);

            model.addAttribute("userList", userList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get user list error");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/user/json/userListJson";
    }


    //12、用户收藏课程列表
    @RequestMapping(value = "/a/u/lesson/favorite/list/{uid}", method = RequestMethod.GET)
    public String getFavoriteLesson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long uid, Integer page, Integer size) throws Exception {

        List<Long> lessonIds = new ArrayList<>();
        List<Lesson> lessons = new ArrayList<>();
        List<Long> totalIds = new ArrayList<>();
        HashMap<Long, Subject> subjectId_subject = new HashMap<>();
        Long relationId = 0L;
        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }
        int firstNmuber = (page - 1) * size;
        Boolean next = false;

        log.info("get uid " + uid);
        User user = userService.getObjectById(uid);

        log.info("user : " + uid + " get favorite list");

        try {
            log.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            log.info("=====获取收藏课程列表id=====");
            List<Long> relationIds = userFavoriteRelationService.getUserFavoriteRelationIdsByUserIDAndType(uid, UserFavoriteRelation.TYPE_LESSON, firstNmuber, size);
            if (CollectionUtils.isNotEmpty(relationIds)) {
                List<UserFavoriteRelation> userFavoriteRelations = userFavoriteRelationService.getObjectsByIds(relationIds);
                for (UserFavoriteRelation userFavoriteRelation : userFavoriteRelations) {
                    lessonIds.add(userFavoriteRelation.getTargetID());
                }
            }
            log.info("favorite lessonIds : " + lessonIds);

            if (CollectionUtils.isNotEmpty(lessonIds)) {
                lessons = lessonService.getObjectsByIds(lessonIds);
            }

            List<Long> lessonIds1 = new ArrayList<>();

            List<Long> relationIds1 = userFavoriteRelationService.getUserFavoriteRelationIdsByUserIDAndType(uid, UserFavoriteRelation.TYPE_LESSON, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isNotEmpty(relationIds1)) {
                List<UserFavoriteRelation> userFavoriteRelations = userFavoriteRelationService.getObjectsByIds(relationIds1);
                for (UserFavoriteRelation userFavoriteRelation : userFavoriteRelations) {
                    lessonIds1.add(userFavoriteRelation.getTargetID());
                }
            }


            log.info("   total = " + lessonIds1.size());
            Integer totalPage = (((lessonIds1.size() - 1)) / size) + 1;
            log.info("   totalPage = " + totalPage);


            List<Long> subjectIds = MyListUtil.getFieldValueListFromModelList(lessons, false, Lesson.class.getDeclaredField("subjectId"));
            List<Subject> subjects = subjectService.getObjectsByIds(subjectIds);

            for (Subject subject : subjects) {
                subjectId_subject.put(subject.getId(), subject);
            }

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("page", page);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("lessons", lessons);
            model.addAttribute("subjectId_subject", subjectId_subject);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get favorite lesson error ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/lesson/json/userFavoriteLesson";
    }


    /**
     * @param id 用户id
     * @Description 推广名单
     * @Author: PeiyuFeng
     * @Time 2017/2/10 17:44
     */
    @RequestMapping(value = "/a/recommend/list/{id}", method = RequestMethod.GET)
    public String getRecommendList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                   @PathVariable Long id, Integer page, Integer size) throws Exception {

        log.info("get user : " + id + " recommend list ");

        Boolean next = false;

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            //确认用户是否存在
            User user = userService.getObjectById(id);
            if (null == user) {
                model.addAttribute("code", -2000);
                log.info("user not exist");
                return "/common/success";
            } else {
                log.info("user exist : " + user);
            }

            //确定用户是否是推广人
            if (User.IS_NOT_MEMBER == user.getRecommendFlag()) {
                //用户不是推广人且无userRecommend数据（错误）
                model.addAttribute("code", -10000);
                log.info("user not recommend");
                return "/common/success";
            } else {
                List<Long> uids = userService.getUserIdByRecommendId(id, start, size);

                List<User> userList = userService.getObjectsByIds(uids);
                log.info("get  user data is " + userList.size());
                Integer userCount = userService.countUserIdByRecommendId(id);

                for (User userObj : userList) {
                    List<Long> userMemberRelationIds = userMemberRelationService.getUserMemberRelationIdsByUidAndStatus(userObj.getId(), User.IS_MEMBER, 0, 1);
                    if (CollectionUtils.isEmpty(userMemberRelationIds)) {
                        log.info(" user " + userObj.getId() + " is not a member ");
                        userObj.setMember(User.IS_NOT_MEMBER);
                    } else {
                        log.info(" user " + userObj.getId() + "  member record id = " + userMemberRelationIds.get(0));
                        UserMemberRelation userMemberRelation = userMemberRelationService.getObjectById(userMemberRelationIds.get(0));
                        Long now = System.currentTimeMillis();
                        log.info(" user member endAt is " + getDate(userMemberRelation.getEndAt()) + " now is " + getDate(now));
                        if (now.longValue() >= userMemberRelation.getEndAt().longValue()) {
                            log.info(" user member is out of date ");
                            userMemberRelation.setStatus(User.IS_NOT_MEMBER);
                            userMemberRelationService.update(userMemberRelation);
                            userObj.setMember(User.IS_NOT_MEMBER);
                        } else {
                            log.info(" user is member ");
                            userObj.setMember(User.IS_MEMBER);
                        }
                    }
                }

                log.info(" total = " + userCount);
                model.addAttribute("userCount", userCount);

                Integer totalPage = (((userCount - 1)) / size) + 1;
                log.info("   totalPage = " + totalPage);

                if (uids != null && uids.size() > 0) {
                    if (size.equals(uids.size())) {
                        next = true;
                        uids = uids.subList(0, size);
                    }
                }

                model.addAttribute("totalPage", totalPage);
                model.addAttribute("userList", userList);

            }

            model.addAttribute("code", 0);
            model.addAttribute("next", next);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update recommend discount error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/learn-course-service/user/json/recommendList";
    }


    //13、用户收藏课时列表
    @RequestMapping(value = "/a/u/period/favorite/list/{uid}", method = RequestMethod.GET)
    public String getFavoritePeriod(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                    @PathVariable Long uid, Integer page, Integer size) throws Exception {

        List<Long> periodIds = new ArrayList<>();
        List<Period> periods = new ArrayList<>();
        List<Long> totalIds = new ArrayList<>();
        HashMap<Long, Subject> subjectId_subject = new HashMap<>();
        HashMap<Long, Lesson> lessonId_lesson = new HashMap<>();
        Long relationId = 0L;
        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }
        int firstNmuber = (page - 1) * size;
        Boolean next = false;

        log.info("get uid " + uid);
        User user = userService.getObjectById(uid);

        log.info("user : " + uid + " get favorite list");

        try {

            log.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            log.info("=====获取收藏课时列表id=====");
            List<Long> relationIds = userFavoriteRelationService.getUserFavoriteRelationIdsByUserIDAndType(uid, UserFavoriteRelation.TYPE_PERIOD, firstNmuber, size);
            log.info("relationIds size : " + relationIds.size());
            if (CollectionUtils.isNotEmpty(relationIds)) {
                List<UserFavoriteRelation> userFavoriteRelations = userFavoriteRelationService.getObjectsByIds(relationIds);
                for (UserFavoriteRelation userFavoriteRelation : userFavoriteRelations) {
                    periodIds.add(userFavoriteRelation.getTargetID());
                }
            }
            totalIds = userFavoriteRelationService.getUserFavoriteRelationIdsByUserIDAndType(uid, UserFavoriteRelation.TYPE_PERIOD, 0, Integer.MAX_VALUE);
            log.info("totalIds size : " + totalIds.size());

            log.info(" total = " + totalIds.size());
            Integer totalPage = (((totalIds.size() - 1)) / size) + 1;
            log.info(" totalPage = " + totalPage);


            if (CollectionUtils.isNotEmpty(periodIds)) {
                periods = periodService.getObjectsByIds(periodIds);
            }


            if (periodIds != null && periodIds.size() > 0) {
                if (size.equals(periodIds.size())) {
                    next = true;
                    periodIds = periodIds.subList(0, size);
                }
            }

            List<Long> lessonIds = MyListUtil.getFieldValueListFromModelList(periods, false, Period.class.getDeclaredField("lessonID"));
            List<Lesson> lessons = lessonService.getObjectsByIds(lessonIds);

            List<Long> subjectIds = MyListUtil.getFieldValueListFromModelList(periods, false, Period.class.getDeclaredField("subjectID"));
            List<Subject> subjects = subjectService.getObjectsByIds(subjectIds);

            List<Long> bookIds = MyListUtil.getFieldValueListFromModelList(periods, false, Period.class.getDeclaredField("bookID"));
            List<Book> books = bookService.getObjectsByIds(bookIds);
            Map<Long, Long> bid_name = MyListUtil.convert2Map(Book.class.getDeclaredField("id"), Book.class.getDeclaredField("name"), books);

            List<Long> sids = MyListUtil.getFieldValueListFromModelList(books, false, Book.class.getDeclaredField("sid"));
            Map<Long, Long> bid_sid = MyListUtil.convert2Map(Book.class.getDeclaredField("id"), Book.class.getDeclaredField("sid"), books);
            List<BookSubject> bookSubjects = bookSubjectService.getObjectsByIds(sids);
            Map<Long, Long> sid_name = MyListUtil.convert2Map(BookSubject.class.getDeclaredField("id"), BookSubject.class.getDeclaredField("subjectName"), bookSubjects);
            log.info("bid_sid : " + bid_sid);
            log.info("sid_name : " + sid_name);

            for (Subject subject : subjects) {
                subjectId_subject.put(subject.getId(), subject);
            }

            for (Lesson lesson : lessons) {
                lessonId_lesson.put(lesson.getId(), lesson);
            }

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("page", page);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("periods", periods);
            model.addAttribute("subjectId_subject", subjectId_subject);
            model.addAttribute("lessonId_lesson", lessonId_lesson);
            model.addAttribute("bid_sid", bid_sid);
            model.addAttribute("sid_name", sid_name);
            model.addAttribute("bid_name", bid_name);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get favorite period error ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/period/json/userFavoritePeriod";
    }

    //13、用户资料列表
    @RequestMapping(value = "/a/u/user/paper/list/{uid}", method = RequestMethod.GET)
    public String paperList(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long uid, Integer page, Integer size) throws Exception {

        Lesson lesson = new Lesson();
        Period period = new Period();
        Book book = new Book();
        Long lessonId = null;
        Long periodId = null;
        Long subjectId = null;
        Long bookId = null;
        List<Long> lessonIdList = new ArrayList<>();
        List<Long> periodIdList = new ArrayList<>();
        List<Long> subjectIdList = new ArrayList<>();
        List<Long> bookIdList = new ArrayList<>();
        HashMap<Long, Long> orderId_lessonId = new HashMap<>();
        HashMap<Long, Long> orderId_periodId = new HashMap<>();
        HashMap<Long, Long> orderId_subjectId = new HashMap<>();
        HashMap<Long, Long> orderId_bookId = new HashMap<>();
        HashMap<Long, Subject> subjectId_subject = new HashMap<>();
        HashMap<Long, Lesson> lessonId_lesson = new HashMap<>();
        HashMap<Long, Period> periodId_period = new HashMap<>();
        HashMap<Long, Book> bookId_book = new HashMap<>();
        List<Long> orderIds = new ArrayList<>();
        List<UserOrder> orders = new ArrayList<>();

        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }
        int firstNmuber = (page - 1) * size;
        Boolean next = false;

        log.info("get uid " + uid);
        User user = userService.getObjectById(uid);

        log.info("user : " + uid + " get favorite list");

        try {
            log.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            log.info("=====获取购买资料订单id=====");
            orderIds = userOrderService.getPaperUserOrderIdsByUid(uid, firstNmuber, size);
            log.info("orderIds size : " + orderIds.size());
            if (CollectionUtils.isNotEmpty(orderIds)) {
                orders = userOrderService.getObjectsByIds(orderIds);
                for (UserOrder order : orders) {
                    log.info("orderId : " + order.getId());
                    if (UserOrder.ORDER_LPAPER == order.getBuyType()) {
                        lesson = lessonService.getObjectById(order.getTargetId());
                        if (null == lesson) {
                            log.info("data mistake , orderId " + order.getId() + " target lesson not exist");
                            model.addAttribute("code", -4031);
                            return "/common/success";
                        }
                        lessonId = lesson.getId();
                        subjectId = lesson.getSubject();
                        lessonIdList.add(lessonId);
                        subjectIdList.add(subjectId);
                    } else if (UserOrder.ORDER_PPAPER == order.getBuyType()) {
                        period = periodService.getObjectById(order.getTargetId());
                        if (null == period) {
                            log.info("data mistake , orderId " + order.getId() + " target period not exist");
                            model.addAttribute("code", -4032);
                            return "/common/success";
                        }
                        periodId = period.getId();
                        lessonId = period.getLessonID();
                        subjectId = period.getSubjectID();
                        periodIdList.add(periodId);
                        lessonIdList.add(lessonId);
                        subjectIdList.add(subjectId);
                    } else if (UserOrder.ORDER_BPAPER == order.getBuyType()) {
                        book = bookService.getObjectById(order.getTargetId());
                        if (null == book) {
                            log.info("data mistake , orderId " + order.getId() + " target book not exist");
                            model.addAttribute("code", -4039);
                            return "/common/success";
                        }
                        bookId = book.getId();
                        bookIdList.add(bookId);
                    } else {
                        log.info("data mistake , orderId " + order.getId() + " buy type error");
                        model.addAttribute("code", -4040);
                        return "/common/success";
                    }
                    orderId_periodId.put(order.getId(), periodId);
                    orderId_lessonId.put(order.getId(), lessonId);
                    orderId_subjectId.put(order.getId(), subjectId);
                    orderId_bookId.put(order.getId(), bookId);
                }
                orders = userOrderService.getObjectsByIds(orderIds);
                Collections.sort(orders);

                List<Lesson> lessons = lessonService.getObjectsByIds(lessonIdList);
                List<Subject> subjects = subjectService.getObjectsByIds(subjectIdList);
                List<Period> periods = periodService.getObjectsByIds(periodIdList);
                List<Book> books = bookService.getObjectsByIds(bookIdList);

                for (Subject subjectObj : subjects) {
                    subjectId_subject.put(subjectObj.getId(), subjectObj);
                }
                for (Lesson lessonObj : lessons) {
                    lessonId_lesson.put(lessonObj.getId(), lessonObj);
                }
                for (Book bookObj : books) {
                    bookId_book.put(bookObj.getId(), bookObj);
                }
                for (Period periodObj : periods) {
                    periodId_period.put(periodObj.getId(), periodObj);
                }
            }
            log.info("user orderIds : " + orderIds);

            log.info("   total = " + orderIds.size());
            Integer totalPage = (((orderIds.size() - 1)) / size) + 1;
            log.info("   totalPage = " + totalPage);

            if (orderIds != null && orderIds.size() > 0) {
                if (size.equals(orderIds.size())) {
                    next = true;
                    orderIds = orderIds.subList(0, size);
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("page", page);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("orders", orders);

            model.addAttribute("subjectId_subject", subjectId_subject);
            model.addAttribute("lessonId_lesson", lessonId_lesson);
            model.addAttribute("bookId_book", bookId_book);
            model.addAttribute("periodId_period", periodId_period);

            model.addAttribute("orderId_periodId", orderId_periodId);
            model.addAttribute("orderId_lessonId", orderId_lessonId);
            model.addAttribute("orderId_subjectId", orderId_subjectId);
            model.addAttribute("orderId_bookId", orderId_bookId);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user paper list error ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/paper/json/userPaperList";
    }

    //1、用户学习课程列表
    @RequestMapping(value = "/a/u/user/lesson/list/{uid}", method = RequestMethod.GET)
    public String getUserLesson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long uid, Integer page, Integer size) throws Exception {

        Long periodId = 0l;
        //课程id
        Long lid = 0L;
        //用户解锁状态
        Integer userLock = Locks.USER_UNLOCK;
        //是否收藏
        Integer favorite_status = 0;
        //用户收藏表id
        Long favorite_relation = 0L;
        //peogressId
        Long progressId = 0L;
        //课程id_是否收藏关系
        Map<Long, Integer> lid_favorite = new HashMap<>();
        //课程id_学习进度
        Map<Long, Integer> lid_progress = new HashMap<>();
        //课程id_是否完成
        Map<Long, Integer> lid_over = new HashMap<>();
        //课程id_是否下架
        Map<Long, Integer> lid_freeze = new HashMap<>();
        //用户是否解锁
        Map<Long, Integer> lid_userLock = new HashMap();
        Map<String, Object> param = null;
        List<Long> periodIdList = new LinkedList<>();
        List<Period> periodList = new LinkedList<>();
        Long lockId = null;
        //课程课时id
        List<Long> periodIds = new ArrayList<>();
        List<Long> lessonIds = new ArrayList<>();
        List<Lesson> lessons = new ArrayList<>();
        List<Long> totalIds = new ArrayList<>();
        HashMap<Long, Subject> subjectId_subject = new HashMap<>();
        Long relationId = 0L;
        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }
        int firstNmuber = (page - 1) * size;
        Boolean next = false;

        log.info("get uid " + uid);
        User user = userService.getObjectById(uid);

        log.info("user : " + uid + " get favorite list");

        try {

            log.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            log.info("=====获取在学课程列表id=====");
            List<Long> relationIds = progressService.getProgressIdsByUserIDAndTypeOrderByUpdateAt(uid, Progress.TYPE_LESSON, firstNmuber, size);
            log.info("relationIds size : " + relationIds.size());
            if (CollectionUtils.isNotEmpty(relationIds)) {
                List<Progress> progresses = progressService.getObjectsByIds(relationIds);
                for (Progress progress : progresses) {
                    lid = progress.getTargetID();
                    log.info("lid is " + lid);
                    lessonIds.add(progress.getTargetID());

                    //是否收藏
                    favorite_relation = userFavoriteRelationService.getUserFavoriteRelationIdByUserIDAndTypeAndTargetID(uid, UserFavoriteRelation.TYPE_LESSON, lid);
                    if (null == favorite_relation) {
                        favorite_status = UserFavoriteRelation.STATUS_DISLIKE;
                    } else {
                        favorite_status = UserFavoriteRelation.STATUS_LIKE;
                    }
                    lid_favorite.put(lid, favorite_status);

                    //学习进度
                    //是否解锁
                    //这里的课时总进度是上架总课时，在学课时数量也是上架在学课时数量
                    List<Long> progressList = new ArrayList<>();
                    periodIds = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(lid, Period.status_normal, 0, Integer.MAX_VALUE);
                    Lesson lesson = lessonService.getObjectById(lid);
                    if (lesson != null) {
                        lesson.setPeriodCount(periodIds.size());
                        lessonService.update(lesson);
                    } else {
                        log.info("the progress : " + progress.getId() + " lessonId not exist");
                        model.addAttribute("code", -4035);
                        return "/common/success";
                    }
                    List<Period> periods = periodService.getObjectsByIds(periodIds);
                    for (Period period : periods) {
                        periodId = period.getId();
                        progressId = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, periodId, Progress.TYPE_PERIOD);
                        if (null != progressId) {
                            progressList.add(progressId);
                        }
                        if (Period.Lock.equals(period.getLocked())) {
                            lockId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, periodId);
                            if (lockId != null) {
                                userLock = Locks.USER_UNLOCK;
                            }
                        }

                    }
                    lid_userLock.put(lid, userLock);
                    lid_progress.put(lid, progressList.size());

                    //是否完成
                    lid_over.put(lid, progress.getStatus());

                    //课程上下架状态
                    Integer freeze = lesson.getStatus();
                    lid_freeze.put(lid, freeze);
                }
            }
            log.info("user lessonIds : " + lessonIds);

            if (CollectionUtils.isNotEmpty(lessonIds)) {
                lessons = lessonService.getObjectsByIds(lessonIds);
            }

            log.info("   total = " + lessonIds.size());
            Integer totalPage = (((lessonIds.size() - 1)) / size) + 1;
            log.info("   totalPage = " + totalPage);

            if (lessonIds != null && lessonIds.size() > 0) {
                if (size.equals(lessonIds.size())) {
                    next = true;
                    lessonIds = lessonIds.subList(0, size);
                }
            }

            List<Long> subjectIds = MyListUtil.getFieldValueListFromModelList(lessons, false, Lesson.class.getDeclaredField("subjectId"));
            List<Subject> subjects = subjectService.getObjectsByIds(subjectIds);

            for (Subject subject : subjects) {
                subjectId_subject.put(subject.getId(), subject);
            }

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("page", page);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("lessons", lessons);
            model.addAttribute("lid_progress", lid_progress);
            model.addAttribute("lid_userLock", lid_userLock);
            model.addAttribute("lid_favorite", lid_favorite);
            model.addAttribute("lid_over", lid_over);
            model.addAttribute("lid_freeze", lid_freeze);
            model.addAttribute("lid_userLock", lid_userLock);
            model.addAttribute("subjectId_subject", subjectId_subject);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user lessons error ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/lesson/json/userLessonList";
    }

    @RequestMapping(value = "/a/u/user/ceshi", method = RequestMethod.POST)
    public String addLessonJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, Lesson lesson, String introduceHome) throws Exception {

        log.info("insert lesson : lesson= " + lesson);

        try {

            List<User> userList = new LinkedList<>();
            for (int i = 0; i < 100000; i++) {
                User user = new User();
                user.setPwd("测试");
                user.setStatus(1);
                user.setGrade(1);
                user.setNick("ceshi");
                user.setImg("1");
                user.setMobile("1");
                user.setScore(1);
                user.setSign(1);
                user.setRegisterAt(1L);
                user.setLastLoginAt(1L);
                userList.add(user);
            }
            userService.insertList(userList);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add lesson error ");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }


    /**
     * 修改用户手机号
     *
     * @param request
     * @param response
     * @param model
     * @param uid
     * @param mobile
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/user/mobile/{uid}", method = RequestMethod.PUT)
    public String updateUserMobile(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, @PathVariable Long uid, String mobile) throws Exception {

        log.info("update  user mobile  : uid= " + uid + " mobile = " + mobile);

        try {
            Long mobileUid = userService.getUserIdByMobile(mobile);
            if (null != mobileUid) {
                model.addAttribute("code", -2003);
                return "/common/success";

            }

            User user = userService.getObjectById(uid);
            Long oldUserOpenId = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndType(user.getMobile(), UserOpenidRelation.TYPE_MOBILE);
            log.info(" oldUserOpenId = " + oldUserOpenId);
            if (null != oldUserOpenId) {
                UserOpenidRelation userOpenidRelation = userOpenidRelationService.getObjectById(oldUserOpenId);
                userOpenidRelation.setOpenid(mobile);
                userOpenidRelationService.update(userOpenidRelation);
            }


            user.setMobile(mobile);
            userService.update(user);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add lesson error ");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    /**
     * 充值学习星(新)
     *
     * @param request
     * @param response
     * @param model
     * @param uid
     * @param score
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/user/score/{uid}", method = RequestMethod.PUT)
    public String updateUserScore(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, @PathVariable Long uid, Integer score) throws Exception {

        log.info("insert lesson : uid= " + uid + " score = " + score);

        try {
            if (null == score) {
                model.addAttribute("code", -1000);
                return "/common/success";
            }
            Manager manager = (Manager) request.getAttribute("manager");

            User user = userService.getObjectById(uid);
            Integer totalScore = user.getScore() + score;
            log.info(" totalScore = " + totalScore);
            user.setScore(totalScore);
            userService.update(user);

            //这是一个垃圾的单发短信。。。。
            DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String date = dateFormat.format(new Date(System.currentTimeMillis()));
            String title = "获得学习星通知";
            String content = "您于" + date + "充值" + score + "颗学习星。";

            Message message = new Message();
            message.setType(Message.Type_pesson);
            message.setName(title);
            message.setContent(content);
            message.setUserId(uid);
            message.setPublishAt(System.currentTimeMillis());
            message.setSort(1);
            Long mid = messageService.insert(message);
            log.info("send message success");

            UserMessageRelation userMessageRelation = new UserMessageRelation();
            userMessageRelation.setUserRead(UserMessageRelation.notRead);
            userMessageRelation.setTargetId(mid);
            userMessageRelation.setUserId(uid);
            userMessageRelationService.insert(userMessageRelation);

            ScoreRecord scoreRecord = new ScoreRecord();
            scoreRecord.setScore(score);
            scoreRecord.setTotalScore(totalScore);
            scoreRecord.setUid(user.getId());
            scoreRecord.setCreateBy(manager.getId());
            scoreRecord.setUpdateBy(manager.getId());
            Long scoreId = scoreRecordService.insert(scoreRecord);
            log.info(" scoreId = " + scoreId);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add lesson error ");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }


    /**
     * @param uid 用户id
     * @Description 获取用户在学教材id
     * @Author: PeiyuFeng
     * @Time 2017/4/5 13:24
     */
    @RequestMapping(value = "/a/u/learn/book/{uid}", method = RequestMethod.GET)
    public String getBook(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long uid) throws Exception {

        Long bookId = null;

        log.info("user : " + uid + " get learn book");

        try {

            List<Long> bookIds = new ArrayList<>();
            List<Book> books = new ArrayList<>();
            Map<Long, String> id_version = new HashMap<>();

            log.info("=====是否有在学教材=====");
            List<Long> progressId = progressService.getProgressIdsByUserIDAndTypeOrderByUpdateAt(uid, Progress.TYPE_BOOK, 0, Integer.MAX_VALUE);

            if (CollectionUtils.isNotEmpty(progressId)) {
                log.info("=====继续学习=====");
                List<Progress> progress = progressService.getObjectsByIds(progressId);
                bookIds = MyListUtil.getFieldValueListFromModelList(progress, false, Progress.class.getDeclaredField("targetID"));

                books = bookService.getObjectsByIds(bookIds);
                List<Long> versionIds = MyListUtil.getFieldValueListFromModelList(books, false, Book.class.getDeclaredField("press"));
                log.info("version ids : " + versionIds);

                List<BookVersion> bookVersions = bookVersionService.getObjectsByIds(versionIds);
                id_version = MyListUtil.convert2Map(BookVersion.class.getDeclaredField("id"), BookVersion.class.getDeclaredField("versionName"), bookVersions);
                log.info("id_version : " + id_version);

            } else {
                log.info("=====无在学教材=====");
            }

            model.addAttribute("code", 0);
            model.addAttribute("books", books);
            model.addAttribute("id_version", id_version);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get learn book error");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/book/json/getBook";
    }


    /**
     * @param
     * @Description 获取会员列表
     * @Author: PeiyuFeng
     * @Time 2017/5/24 13:23
     */
    @RequestMapping(value = "/a/u/member/list", method = RequestMethod.GET)
    public String getMemberUserJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, String member,
                                    String nick, Integer grade, String mail, String mobile, Integer scoreStart, Integer scoreEnd,
                                    Integer learnPeriodStart, Integer learnPeriodEnd, Integer page, Integer size) throws Exception {

        List<Long> idList = new ArrayList();
        Boolean next = false;

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            Map<String, Object> params = DynamicUtil.getMemberUserList(nick, mail, mobile, grade, member, scoreStart, scoreEnd,
                    learnPeriodStart, learnPeriodEnd);
            idList = userService.getIdsByDynamicCondition(User.class, params, start, size);
            List<User> userList = userService.getObjectsByIds(idList);
            log.info("get  user data is " + userList.size());

            Map<Long, String> uid_memberName = new HashMap<>();
            for(User user : userList){
                List<Long> rids = userMemberRelationService.getUserMemberRelationIdsByUid(user.getId(), 0, 1);
                UserMemberRelation relation = userMemberRelationService.getObjectById(rids.get(0));
                if(User.IS_MEMBER == relation.getStatus()){
                    uid_memberName.put(user.getId(), relation.getName());
                }else {
                    uid_memberName.put(user.getId(), "过期会员");
                }
            }

            List<Long> usercountIds = userService.getIdsByDynamicCondition(User.class, params, 0, Integer.MAX_VALUE);
            Integer userCount = usercountIds.size();
            log.info("   total = " + userCount);
            model.addAttribute("userCount", userCount);
            Integer totalPage = (((userCount - 1)) / size) + 1;
            log.info("   totalPage = " + totalPage);

            if (idList != null && idList.size() > 0) {
                if (size.equals(idList.size())) {
                    next = true;
                    idList = idList.subList(0, size);
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("uid_memberName", uid_memberName);
            model.addAttribute("userList", userList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get user list error");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/user/json/memberListJson";
    }



    /**
     * @Description 会员详情
     * @param
     * @Author: PeiyuFeng
     * @Time 2017/5/28 13:24
     */
    @RequestMapping(value = "/a/u/member/{id}", method = RequestMethod.GET)
    public String getMemberDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                  @PathVariable Long id) throws Exception {

        log.info("get member data : id= " + id);

        try {
            User user = userService.getObjectById(id);
            log.info("get user data is " + user);

            if (null == user) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            List<Long> memeberIds = userMemberRelationService.getUserMemberRelationIdsByUid(id, 0, Integer.MAX_VALUE);
            List<UserMemberRelation> relations = userMemberRelationService.getObjectsByIds(memeberIds);
            if (relations.size() > 0) {
                UserMemberRelation endRelation = relations.get(0);
                model.addAttribute("vipEnd", endRelation.getEndAt());
                if(User.IS_MEMBER == endRelation.getStatus()){
                    model.addAttribute("memberName", endRelation.getName());
                }else {
                    model.addAttribute("memberName", "过期会员");
                }
                UserMemberRelation beginRelation = relations.get(relations.size()-1);
                model.addAttribute("vipBegin", beginRelation.getStartAt());

                BigDecimal total = BigDecimal.ZERO;
                for(UserMemberRelation relation : relations){
                    total.add(relation.getPrice());
                }

                model.addAttribute("totalPrice", total);

            }else {
                log.info("user not member");
                model.addAttribute("code", -2200);
                return "/common/success";
            }

            List<Long> rids = loginRecordService.getLoginRecordIdsByUid(id, 0, Integer.MAX_VALUE);
            List<LoginRecord> loginRecords = loginRecordService.getObjectsByIds(rids);

            model.addAttribute("code", 0);
            model.addAttribute("user", user);
            model.addAttribute("relations", relations);
            model.addAttribute("loginRecords", loginRecords);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/user/json/memberDetailJson";
    }


    /**
     * @Description 会员购买记录
     * @param
     * @Author: PeiyuFeng
     * @Time 2017/5/31 2:30
     */
    @RequestMapping(value = "/a/u/member/order/list", method = RequestMethod.GET)
    public String getMemberOrderList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long uid,
                                     Integer page, Integer size) throws Exception {

        log.info("get member data : id= " + uid);

        List<Long> idList = new ArrayList();
        Boolean next = false;

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            User user = userService.getObjectById(uid);
            log.info("get user data is " + user);

            if (null == user) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            List<Long> memeberIds = userMemberRelationService.getUserMemberRelationIdsByUid(uid, start, size);
            List<UserMemberRelation> relations = userMemberRelationService.getObjectsByIds(memeberIds);

            List<Long> countIds = userMemberRelationService.getUserMemberRelationIdsByUid(uid, 0, Integer.MAX_VALUE);
            Integer count = countIds.size();
            log.info("   total = " + count);
            model.addAttribute("userCount", count);
            Integer totalPage = (((count - 1)) / size) + 1;
            log.info("   totalPage = " + totalPage);

            if (idList != null && idList.size() > 0) {
                if (size.equals(idList.size())) {
                    next = true;
                    idList = idList.subList(0, size);
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("relations", relations);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user error,id is  " + uid);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/user/json/memberOrderListJson";
    }



    public static String getDate(Long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = "";

        if (null != time) {
            date = dateFormat.format(new Date(time));
        }
        return date;
    }

    @RequestMapping(value = "/a/u/member/add", method = RequestMethod.GET)
    public String addMember(HttpServletRequest request,
                            HttpServletResponse response, ModelMap model,Long type, Long uid,Long startTime) throws Exception {

        if(null==type ||  null==uid  || null == startTime ){
            model.addAttribute("code", -1);
            return "/common/success";

        }
        log.info("startTime is "+startTime +"type is "+type  +"uid is "  );
        User user = userService.getObjectById(uid);
        try {
//

            Long endAt = 0L;
            Long startAt = 0L;
            Long now = System.currentTimeMillis();
            log.info(now);
            log.info(startTime);
            log.info("-==--=");


            //判断是开会员还是续费会员
            List<Long> userMemberRelationIds = userMemberRelationService.getUserMemberRelationIdsByUid(uid, 0, Integer.MAX_VALUE);
            log.info("-00--0-00-0--00-");
            log.info(userMemberRelationIds);
            if(CollectionUtils.isEmpty(userMemberRelationIds)){
//			非会员
                log.info(" user "+uid+" is not a member ");

                log.info("==========开会员逻辑==========");

                if(now>startTime){
                    startAt = now;
                }else{
                    startAt = startTime;

                }
            }else {
//			是会员


                List<UserMemberRelation> userMemberRelations = userMemberRelationService.getObjectsByIds(userMemberRelationIds);
                log.info(userMemberRelations);
//                找到会员记录中  会员到期时间为开始时间
                for (UserMemberRelation userMemberRelation : userMemberRelations) {
                    log.info(" user member endAt is " + getDate(userMemberRelation.getEndAt()) + " now is " + getDate(now));
                    if (userMemberRelation.getEndAt().longValue() >= endAt) {
                        log.info(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is more than " + endAt);
                        endAt = userMemberRelation.getEndAt().longValue();
                    } else {
                        log.info(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is less than " + endAt);
                    }
                }
                log.info("final end at member time is : " + endAt);
                if(now>endAt){
                    startAt = now;
                }else{
                    startAt = endAt;

                }


            }

            log.info("-00--0-00-0--00-");
            log.info(startAt);
            Map<String, Object> map = DynamicUtil.getMemberList(null, null, null, null, null, null, false);
            log.info(" map = " + map);
//          费用为0；
            BigDecimal price_zero=new BigDecimal("0");
//            List<Long> ids = memberService.getIdsByDynamicCondition(Member.class, map, 0, Integer.MAX_VALUE);
            UserMemberRelation userMemberRelation = new UserMemberRelation();
            Member member = memberService.getObjectById(type);
            userMemberRelation.setName(member.getName());
            userMemberRelation.setUid(uid);
            userMemberRelation.setStatus(User.IS_MEMBER);
            userMemberRelation.setPrice(price_zero);
            userMemberRelation.setStartAt(startAt);
            userMemberRelation.setCouponId(null);
            userMemberRelation.setPeriod(member.getPeriod());

            Date startDate = new Date(startAt);

            Date endDate=null;

            if(member.getIosId().equals("free_member") && member.getName().equals("试用会员")){
                 endDate = DateUtils.addDays(startDate,7 );

            }else{
                 endDate = DateUtils.addMonths(startDate,member.getPeriod().intValue());
            }
//
            userMemberRelation.setEndAt(endDate.getTime());
            log.info(member.getPeriod().intValue());
            log.info(startAt);
            log.info(endDate.getTime());
            log.info(" user "+uid+" member startAt = "+getDate(now)+" endAt = "+getDate(endAt));
            Long userMemberRelationId = userMemberRelationService.insert(userMemberRelation);
            log.info(" user "+uid+" member id is = "+userMemberRelationId);



            user.setFreeMember(User.status_member);
            userService.update(user);
            model.addAttribute("code", 0);



        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update coupon error,id is  " + user.getId());
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }



}

