package com.ptteng.course.admin.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.gemantic.common.util.json.GsonUtil;
import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import com.ptteng.learn.course.vo.GradeAndClass;
import com.qding.common.util.http.cookie.CookieUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Array;
import java.util.*;

/**
 * Subject  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class SubjectController {
	private static final Log log = LogFactory.getLog("subject");

	@Autowired
	private SubjectService subjectService;
	@Autowired
	private GradeClassRelationService gradeClassRelationService;
	@Autowired
	private LessonService lessonService;
	@Autowired
	private PeriodService periodService;
	@Autowired
	private TaskService taskService;
	@Autowired
	private CookieUtil cookieUtil;


    /**
	 *
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/a/u/updown/subject/{id}", method = RequestMethod.PUT)
	public String getSubjectIdsByNameAndClassIdJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,@PathVariable Long id) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {
			Subject subject = subjectService.getObjectById(id);
			if (subject != null) {
				if (subject.getStatus() == 1) {
					subject.setStatus(2);
					subject.setSort(10086);

					Map<String, Object> param = DynamicUtil.getLessonList(null, id, null, null, null);
					List<Long> idList = lessonService.getIdsByDynamicCondition(Lesson.class, param, 0, Integer.MAX_VALUE);
					if (idList.size() > 0) {
						List<Lesson> lessonList = lessonService.getObjectsByIds(idList);
						for (Lesson lesson : lessonList) {
							if (lesson.getRecommend() == 1) {
								model.addAttribute("code", -5070);
								return "/common/success";
							}
							lesson.setStatus(2);
							lesson.setPeriodCount(0);
						}
						lessonService.updateList(lessonList);
					}
					param = DynamicUtil.getPeriodList(null, null, null, id, 1, null, null, Period.status_normal ,null);
					idList = periodService.getIdsByDynamicCondition(Period.class, param, 0, Integer.MAX_VALUE);
					if (idList.size() > 0) {
						List<Period> periodList = periodService.getObjectsByIds(idList);
						for (Period period : periodList) {
							period.setStatus(2);
							period.setTaskCount(0);
							periodService.update(period);
						}
					}
					param = DynamicUtil.getTaskList(1, null, id, null, null, null, null, Task.status_normal ,null,null);
					idList = taskService.getIdsByDynamicCondition(Task.class, param, 0, Integer.MAX_VALUE);
					if (idList.size() > 0) {
						List<Task> taskList = taskService.getObjectsByIds(idList);
						for (Task task : taskList) {
							task.setStatus(2);
							taskService.update(task);
						}
					}
				} else {
					List<Long> lessonIds = lessonService.getLessonIdsBySubjectOrderBySort(id, 0, Integer.MAX_VALUE);
					if (lessonIds == null||lessonIds.size()<1) {
						model.addAttribute("code", -5054);
						return "/common/success";
					}
//					subject.setStatus(1);
//					subjectService.update(subject);
					Map<String, Object> param = DynamicUtil.getLessonList(null, id, null, null, null);
					List<Long> idList = lessonService.getIdsByDynamicCondition(Lesson.class, param, 0, Integer.MAX_VALUE);
					if (idList.size() > 0) {
						List<Lesson> lessonList = lessonService.getObjectsByIds(idList);
						int taskcount = 0;
						int periodcount = 0;
						int papercount = 0;
						int lessoncount = 0;
						int lessonSort=1;
						for (Lesson lesson : lessonList) {
							Map<String, Object> periodParam = DynamicUtil.getPeriodList(null, null, lesson.getId(), null, null, null, null, null,null);
							List<Long> upPeriodIdList = periodService.getIdsByDynamicCondition(Period.class, periodParam, 0, Integer.MAX_VALUE);
							if (upPeriodIdList.size() > 0) {
//								lesson.setStatus(1);
								List<Period> upPeriodList = periodService.getObjectsByIds(upPeriodIdList);
								int periodSort=1;
								for (Period period : upPeriodList) {
									Map<String, Object> taskParam = DynamicUtil.getTaskList(null, null, null, null, period.getId(), null, null, null, null,null);
									List<Long> upTaskIdList = taskService.getIdsByDynamicCondition(Task.class, taskParam, 0, Integer.MAX_VALUE);
									if (upTaskIdList.size() > 0) {
										period.setStatus(Period.status_normal);
										period.setSort(periodSort);
										periodSort++;
										period.setTaskCount(upTaskIdList.size());
										periodService.update(period);
										periodcount++;
										lesson.setStatus(Lesson.status_normal);
										subject.setStatus(Subject.status_normal);
									}

								}
							}
							if (subject.getStatus().equals(Subject.status_freeze)) {
								model.addAttribute("code", -5077);
								return "/common/success";
							}
							param = DynamicUtil.getPeriodList(null, null, lesson.getId(), id, 1, null, null, Period.status_normal,null);
							idList = periodService.getIdsByDynamicCondition(Period.class, param, 0, Integer.MAX_VALUE);
							lesson.setPeriodCount(idList.size());
							lessonService.update(lesson);
//							if (idList.size() > 0) {
//								List<Period> periodList = periodService.getObjectsByIds(idList);
//								for (Period period : periodList) {
//									period.setStatus(1);
//									period.setTaskCount(0);
//
//									param = DynamicUtil.getTaskList(1, null, id, lesson.getId(), period.getId(), null, 2,null);
//									idList = taskService.getIdsByDynamicCondition(Task.class, param, 0, Integer.MAX_VALUE);
//									period.setTaskCount(idList.size());
//									periodService.update(period);
//									if (idList.size() > 0) {
//										List<Task> taskList = taskService.getObjectsByIds(idList);
//										for (Task task : taskList) {
//											task.setStatus(1);
//											taskService.update(task);
//										}
//									}
//								}
//							}
						}

//
//						param = DynamicUtil.getLessonList(null, subject.getId(), null, Lesson.status_normal);
//						idList = lessonService.getIdsByDynamicCondition(Lesson.class, param, 0, Integer.MAX_VALUE);
					}
					//重新给课程排序
					param = DynamicUtil.getLessonList(null, id, null, Lesson.status_normal, null);
					idList = lessonService.getIdsByDynamicCondition(Lesson.class, param, 0, Integer.MAX_VALUE);
					List<Lesson> lessonList = lessonService.getObjectsByIds(idList);
					int lessonSort = 1;
					List<Lesson> lessonList1 = new LinkedList<>();
					for (Lesson lesson : lessonList) {
						lesson.setSort(lessonSort);
						lessonList1.add(lesson);
						lessonSort++;
					}
					lessonService.updateList(lessonList1);
				}
			}
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
			subject.setUpdateBy(Long.parseLong(userId));
			if (subject.getStatus().equals(Subject.status_normal)) {
				Map<String, Object> lessonParam = DynamicUtil.getLessonList(null, id, null, Lesson.status_normal, null);
				List<Long> lessonIds = lessonService.getIdsByDynamicCondition(Lesson.class, lessonParam, 0, Integer.MAX_VALUE);
				List<Lesson> lessonList = lessonService.getObjectsByIds(lessonIds);
				List<Lesson> newLessonList = new LinkedList<>();
				for (Lesson lesson : lessonList) {
					Map<String, Object> periodParam = DynamicUtil.getPeriodList(null, null, lesson.getId(), null, null, null, null, Period.status_normal, null);
					List<Long> periodIds = periodService.getIdsByDynamicCondition(Period.class, periodParam, 0, Integer.MAX_VALUE);
					List<Period> periodList = periodService.getObjectsByIds(periodIds);
					lesson.setLocked(Lesson.Lock);
					for (Period period : periodList) {
						if (period.getLocked().equals(Period.UnLock)) {
							lesson.setLocked(Lesson.UnLock);
							lesson.setPeriodCount(periodIds.size());
							newLessonList.add(lesson);
						}
					}
				}
				lessonService.updateList(newLessonList);
			}
			subjectService.update(subject);
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get subject list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}
			


    /**
	 * 查看详情
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
     */
	@RequestMapping(value = "/a/u/subject/{id}", method = RequestMethod.GET)
	public String getSubjectJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id,Integer page,Integer size)
			throws Exception {

		log.info("get data : id= " + id);

		try {
			Subject subject = subjectService.getObjectById(id);
			log.info("get subject data is " + subject);
			List<Long> gradeIdList=gradeClassRelationService.getGradeClassRelationIdsBySubject(id, 0, Integer.MAX_VALUE);
			List<GradeClassRelation> gradeClassRelationList = gradeClassRelationService.getObjectsByIds(gradeIdList);
			model.addAttribute("gradeClassRelationList", gradeClassRelationList);
			model.addAttribute("code", 0);

			model.addAttribute("subject", subject);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get subject error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/subject/json/subjectDetailJson";
	}

	/**
	 * 更新科目
	 * @param request
	 * @param response
	 * @param model
	 * @param subject
	 * @param id
     * @return
     * @throws Exception
     */
	@RequestMapping(value = "/a/u/subject/{id}", method = RequestMethod.PUT)
	public String updateSubjectJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Subject subject,
									//GradeAndClass gradeAndClass,
									@PathVariable Long id) throws Exception {
		
		log.info("update subject : subject= " + subject);

		Subject oldSubject = subjectService.getObjectById(id);

		if(null == oldSubject){
			log.info("old subject is null ");
			model.addAttribute("code", -5042);
			return "/common/success";
		}

		if (null == subject) {
			log.info(" subject is null ");
			model.addAttribute("code", -1000);
			return "/common/success";
		}

		subject.setGradeType(oldSubject.getGradeType());

		if (!subject.getGradeType().equals(Subject.GRADE_TYPE_1)&&
				!subject.getGradeType().equals(Subject.GRADE_TYPE_2)) {
			log.info(" GradeType is not 1 or 2 ");

			model.addAttribute("code", -5008);
			return "/common/success";
		}

		if (Subject.GRADE_TYPE_2.equals(subject.getGradeType())) {
			log.info(" gradetype = 2 ");
			if(StringUtil.isEmpty(subject.getLevelInfo())){
				model.addAttribute("code", -5084);
				return "/common/success";
			}
			JSONObject gradeAndClassJson =  JSONObject.fromObject(subject.getLevelInfo());
			JSONArray gradeClassRelationList =  JSONArray.fromObject(gradeAndClassJson.get("list"));
			for(int i=0;i<gradeClassRelationList.size();i++){
				JSONObject jsonObject = (JSONObject) gradeClassRelationList.get(i);
				if (StringUtil.isEmpty((String)jsonObject.get("name"))) {
					model.addAttribute("code", -5081);
					return "/common/success";
				}
				if (StringUtil.isEmpty((String)jsonObject.get("level"))) {
					model.addAttribute("code", -5082);
					return "/common/success";
				}
				if (StringUtil.isEmpty((String)jsonObject.get("introduce"))) {
					model.addAttribute("code", -5083);
					return "/common/success";
				}
			}

		}


		try {
			String levelInof = subject.getLevelInfo();
			List<String> classes=new ArrayList<>();
			subject.setId(null);


			if (subject.getName().equals(oldSubject.getName())) {
				log.info("name not change");
			}else if (subjectService.getSubjectIdsByName(subject.getName(), 0, Integer.MAX_VALUE).size()>0) {
				model.addAttribute("code", -5011);
				return "/common/success";
			}
			subject.setLevelInfo("");

			subject.setId(id);
			subject.setCreateAt(oldSubject.getCreateAt());
			subject.setSort(oldSubject.getSort());
			subject.setStatus(oldSubject.getStatus());
			subject.setUserType(oldSubject.getUserType());
//			if (subject.getStep() != oldSubject.getStep()) {
//				Map<String, Object> taskParam = DynamicUtil.getTaskList(null, null, subject.getId(), null, null, null, null, null, null,null);
//				List<Long> taskIds = taskService.getIdsByDynamicCondition(Task.class, taskParam, 0, Integer.MAX_VALUE);
//				List<Task> taskList = taskService.getObjectsByIds(taskIds);
//				for (Task task : taskList) {
//					task.setStep(subject.getStep());
//				}
//				taskService.updateList(taskList);
//			}
			subjectService.update(subject);
			List<GradeClassRelation> gradeClassRelations = new ArrayList<>();

			List<GradeClassRelation> updateGradeClassRelations = new ArrayList<>();

			if (Subject.GRADE_TYPE_1.equals(subject.getGradeType())) {
				log.info(" gradetype is 1,nianji ");
				List<Long> gradeIds = gradeClassRelationService.getGradeClassRelationIdsBySubject(id, 0, Integer.MAX_VALUE);
				//
				gradeClassRelationService.deleteList(GradeClassRelation.class, gradeIds);
				for (int i=0;i<7;i++) {
					GradeClassRelation gradeClassRelation=new GradeClassRelation();

					gradeClassRelation.setSubjectId(id);
					getLevel(i,gradeClassRelation);
					gradeClassRelation.setGradeName(i);
					gradeClassRelations.add(gradeClassRelation);

				}
				gradeClassRelationService.insertList(gradeClassRelations);

			}else{
				log.info(" gradetype is 2,等级 ");

				JSONObject gradeAndClassJson =  JSONObject.fromObject(levelInof);
				JSONArray gradeClassRelationList =  JSONArray.fromObject(gradeAndClassJson.get("list"));
				List<Long> gradeIds =  gradeClassRelationService.getGradeClassRelationIdsBySubjectOrderByGradeNameDesc(id, 0, 1);
				log.info("gradeIds : " + gradeIds);

				int grade = 10;
				if(CollectionUtils.isEmpty(gradeIds)){
					log.info("now list is null, set first grade 11");
				}else {
					GradeClassRelation lastGrade = gradeClassRelationService.getObjectById(gradeIds.get(0));
					grade = lastGrade.getGradeName();
				}
				log.info("  lastGrade gradeName = "+grade);

				for(int i=0;i<gradeClassRelationList.size();i++){
					JSONObject jsonObject = (JSONObject) gradeClassRelationList.get(i);

					//校验难度关联年级是否匹配用户类型
					String nameObj = (String) jsonObject.get("name");
					List<String> nameList = new ArrayList(Arrays.asList(nameObj.split(",")));
					if(StringUtil.isEmpty(nameObj)){
						log.info("name verify wrong");
						model.addAttribute("code", -5086);
						return "/common/success";
					}else {
						log.info("name not null");
					}
					if(Subject.user_type_preschool.equals(subject.getUserType())){
						log.info("user_type : preschool");
						if(nameObj.equals("0")){
							log.info("name verify ok");
						}else {
							subjectService.delete(id);
							log.info("name verify wrong");
							model.addAttribute("code", -5086);
							return "/common/success";
						}
					}else if(Subject.user_type_primaryschool.equals(subject.getUserType())){
						log.info("user_type : primarySchool");
						if(nameList.contains("0")){
							subjectService.delete(id);
							log.info("name verify wrong");
							model.addAttribute("code", -5086);
							return "/common/success";
						}else {
							log.info("name verify ok");
						}
					}else {
						log.info("user_type : both , don't need user_type");
					}

					log.info(" gradeClassRelaion id = "+jsonObject.get("id"));
					if(GradeClassRelation.ID.equals(Long.valueOf((Integer) jsonObject.get("id")))){
						GradeClassRelation gradeClassRelation=new GradeClassRelation();

						log.info(" add ");
						grade++;
						//新增
						gradeClassRelation.setSubjectId(id);
						gradeClassRelation.setGradeName(grade);
						gradeClassRelation.setIntroduce((String) jsonObject.get("introduce"));
						gradeClassRelation.setLevel((String) jsonObject.get("level"));
						gradeClassRelation.setName((String) jsonObject.get("name"));

						gradeClassRelations.add(gradeClassRelation);

					}else {
						log.info(" update ");
						//修改
						GradeClassRelation gradeClassRelation1 = gradeClassRelationService.getObjectById(Long.valueOf((Integer) jsonObject.get("id")));
						log.info(" introduce = "+jsonObject.get("introduce"));
						gradeClassRelation1.setIntroduce("" + jsonObject.get("introduce"));
						gradeClassRelation1.setLevel("" + jsonObject.get("level"));
						gradeClassRelation1.setName(""+ jsonObject.get("name"));
						updateGradeClassRelations.add(gradeClassRelation1);
					}



				}
				log.info(" add size = "+gradeClassRelations.size()+" update size = "+updateGradeClassRelations.size());
				if(gradeClassRelations.size()>0){
					gradeClassRelationService.insertList(gradeClassRelations);
				}
				if(updateGradeClassRelations.size()>0){
					gradeClassRelationService.updateList(updateGradeClassRelations);
				}
//				classes.add(gradeAndClass.getGrade_a());
//				classes.add(gradeAndClass.getIntroduce_a());
//				classes.add(gradeAndClass.getGrade_b());
//				classes.add(gradeAndClass.getIntroduce_b());
//				classes.add(gradeAndClass.getGrade_c());
//				classes.add(gradeAndClass.getIntroduce_c());
//				classes.add(gradeAndClass.getGrade_d());
//				classes.add(gradeAndClass.getIntroduce_d());
//				classes.add(gradeAndClass.getGrade_e());
//				classes.add(gradeAndClass.getIntroduce_e());
//				int grade=11;
//				for (int i=0;i<classes.size();i++) {
//
//					gradeClassRelation.setGradeName(grade);
//					grade++;
//					gradeClassRelation.setName(classes.get(i));
//					i++;
//					gradeClassRelation.setIntroduce(classes.get(i));
//					gradeClassRelation.setSubjectId(id);
//					gradeClassRelationService.insert(gradeClassRelation);
//				}
			}



			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add subject error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	/**
	 * 新增科目
	 * @param request
	 * @param response
	 * @param model
	 * @param subject
	 * @return
     * @throws Exception
     */
	@RequestMapping(value = "/a/u/subject", method = RequestMethod.POST)
	public String addSubjectJson(HttpServletRequest request,
								 HttpServletResponse response, ModelMap model, Subject subject
								 ) throws Exception {

		log.info("update subject : subject= " + subject);

		if (null == subject) {
			log.info(" subject is null ");
			model.addAttribute("code", -1000);
			return "/common/success";
		}
		if (null == subject.getGradeType()) {
			log.info(" GradeType is null ");
			model.addAttribute("code", -1000);
			return "/common/success";
		}
		if(null == subject.getUserType()){
			log.info(" userType is null ");
			model.addAttribute("code", -1000);
			return "/common/success";
		}
		if (!subject.getGradeType().equals(Subject.GRADE_TYPE_1)&&
				!subject.getGradeType().equals(Subject.GRADE_TYPE_2)) {
			log.info(" GradeType is not 1 and 2 ");

			model.addAttribute("code", -5008);
			return "/common/success";
		}

		if (Subject.GRADE_TYPE_2.equals(subject.getGradeType())) {
			log.info(" gradetype = 2 ");
			if(StringUtil.isEmpty(subject.getLevelInfo())){
				model.addAttribute("code", -5084);
				return "/common/success";
			}
			JSONObject gradeAndClassJson =  JSONObject.fromObject(subject.getLevelInfo());
			JSONArray gradeClassRelationList =  JSONArray.fromObject(gradeAndClassJson.get("list"));
			for(int i=0;i<gradeClassRelationList.size();i++){
				JSONObject jsonObject = (JSONObject) gradeClassRelationList.get(i);
				if (StringUtil.isEmpty((String)jsonObject.get("name"))) {
					model.addAttribute("code", -5081);
					return "/common/success";
				}
				if (StringUtil.isEmpty((String)jsonObject.get("level"))) {
					model.addAttribute("code", -5082);
					return "/common/success";
				}
				if (StringUtil.isEmpty((String)jsonObject.get("introduce"))) {
					model.addAttribute("code", -5083);
					return "/common/success";
				}
			}

		}

		try {
			String levelInfo = subject.getLevelInfo();
			List<GradeClassRelation> gradeClassRelations = new ArrayList<>();
			List<String> classes=new ArrayList<>();
			subject.setId(null);
			if (subjectService.getSubjectIdsByName(subject.getName(), 0, Integer.MAX_VALUE).size()>0) {
				model.addAttribute("code", -5011);
				return "/common/success";
			}
			subject.setLevelInfo("");
			subject.setSort(this.getMaxSort());
			Long id = subjectService.insert(subject);

			if ( Subject.GRADE_TYPE_1.equals(subject.getGradeType() )) {
				log.info(" gradetype = 1 ");
				Integer start = 0;
				Integer end = 0;

				if(Subject.user_type_preschool.equals(subject.getUserType())){
					log.info("user_type : preschool");
					start = 0;
					end = 1;
				}else if(Subject.user_type_primaryschool.equals(subject.getUserType())){
					log.info("user_type : primarySchool");
					start = 1;
					end = 7;
				}else {
					start = 0;
					end = 7;
				}

				for(int i=start;i<end;i++){
					GradeClassRelation gradeClassRelation=new GradeClassRelation();

					gradeClassRelation.setSubjectId(id);
					gradeClassRelation.setGradeName(i);
					getLevel(i,gradeClassRelation);
					gradeClassRelations.add(gradeClassRelation);
				}

			}else{

			JSONObject gradeAndClassJson =  JSONObject.fromObject(levelInfo);
			JSONArray gradeClassRelationList =  JSONArray.fromObject(gradeAndClassJson.get("list"));
				log.info(" gradetype = 2 ");
				int grade=11;
				for(int i=0;i<gradeClassRelationList.size();i++){
					JSONObject jsonObject = (JSONObject) gradeClassRelationList.get(i);

					//校验难度关联年级是否匹配用户类型
					String nameObj = (String) jsonObject.get("name");
					List<String> nameList = new ArrayList(Arrays.asList(nameObj.split(",")));
					if(StringUtil.isEmpty(nameObj)){
						log.info("name verify wrong");
						model.addAttribute("code", -5086);
						return "/common/success";
					}else {
						log.info("name not null");
					}
					if(Subject.user_type_preschool.equals(subject.getUserType())){
						log.info("user_type : preschool");
						if(nameObj.equals("0")){
							log.info("name verify ok");
						}else {
							subjectService.delete(id);
							log.info("name verify wrong");
							model.addAttribute("code", -5086);
							return "/common/success";
						}
					}else if(Subject.user_type_primaryschool.equals(subject.getUserType())){
						log.info("user_type : primarySchool");
						if(nameList.contains("0")){
							subjectService.delete(id);
							log.info("name verify wrong");
							model.addAttribute("code", -5086);
							return "/common/success";
						}else {
							log.info("name verify ok");
						}
					}else {
						log.info("user_type : both , don't need user_type");
					}

					GradeClassRelation gradeClassRelation=new GradeClassRelation();
					gradeClassRelation.setSubjectId(id);
					gradeClassRelation.setIntroduce((String) jsonObject.get("introduce"));
					gradeClassRelation.setLevel((String) jsonObject.get("level"));
					gradeClassRelation.setName((String) jsonObject.get("name"));
					gradeClassRelation.setGradeName(grade);
					grade++;
					gradeClassRelations.add(gradeClassRelation);
				}

			}
			log.info(" gradeClassRelations size = "+gradeClassRelations.size());
			if (gradeClassRelations.size()>0){
				gradeClassRelationService.insertList(gradeClassRelations);
			}

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add subject error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	private void getLevel(int i,GradeClassRelation gradeClassRelation){
		switch (i){
			case 0:gradeClassRelation.setLevel("幼升小");break;
			case 1:gradeClassRelation.setLevel("一年级");break;
			case 2:gradeClassRelation.setLevel("二年级");break;
			case 3:gradeClassRelation.setLevel("三年级");break;
			case 4:gradeClassRelation.setLevel("四年级");break;
			case 5:gradeClassRelation.setLevel("五年级");break;
			case 6:gradeClassRelation.setLevel("六年级");break;
			default:gradeClassRelation.setLevel("幼升小");break;
		}
	}

	public static void main(String[] args){
		Subject subject = new Subject();
		String levelInfo = "{\"list\":[" +
				"{\"level\":\"一级\",\"name\":\"0,1\",\"introduce\":\"一级适合于一年级\"}," +
				"{\"level\":\"二级\",\"name\":\"1,2\",\"introduce\":\"一级适合于一年级\"}" +
				"]}";
		subject.setLevelInfo(levelInfo);

		JSONObject gradeAndClassJson =  JSONObject.fromObject(subject.getLevelInfo());
		System.out.println("gradeAndClassJson =  "+gradeAndClassJson);
		JSONArray gradeClassRelationList =  JSONArray.fromObject(gradeAndClassJson.get("list"));
		System.out.println( " size = "+gradeClassRelationList.size());
		for(int i=0;i<gradeClassRelationList.size();i++){
			JSONObject jsonObject = (JSONObject) gradeClassRelationList.get(i);
			System.out.println(" gradename = "+jsonObject.get("level"));

		}
	}

//	@RequestMapping(value = "/a/subject/{id}", method = RequestMethod.DELETE)
//	public String deleteSubjectJson(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model, @PathVariable Long id)
//			throws Exception {
//
//		log.info("delete subject : id= " + id);
//		try {
//			subjectService.delete(id);
//
//			log.info("add subject success");
//			model.addAttribute("code", 0);
//
//		} catch (Throwable t) {
//		    t.printStackTrace();
//			log.error(t.getMessage());
//			log.error("delete subject error,id is  " + id);
//			model.addAttribute("code", -6004);
//
//		}
//
//		return "/data/json";
//	}

	/**
	 * 获得科目列表
	 * @param request
	 * @param response
	 * @param model
	 * @return
     * @throws Exception
     */
	@RequestMapping(value = "/a/u/subject/list", method = RequestMethod.GET)
	public String getMultiSubjectJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Integer page,Integer size,Integer type,String name,Integer status)
			throws Exception {
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}


		List<Long> ids=null;

		try {
			log.info(subjectService);
			Map<String,Object> param= DynamicUtil.getSubjectList(type,name,status);
			ids=subjectService.getIdsByDynamicCondition(Subject.class, param, start, size);
			List<Long> count = subjectService.getIdsByDynamicCondition(Subject.class, param, 0, Integer.MAX_VALUE);
			if (ids == null) {
				log.info("get subject error and ids is null");
				model.addAttribute("code", 2);
				return "/common/success";
			}
			List<Subject> subjectList = subjectService.getObjectsByIds(ids);

			log.info("get  subject data is " + ids);
			Integer total=count.size();
			model.addAttribute("code", 0);			
			model.addAttribute("total",total);
			boolean next=false;
			if (ids.size() + start+1 <= total) {
				next=true;
			}
			Integer totalPage=(total-1)/size+1;
			model.addAttribute("next", next);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("subjectList", subjectList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get subject error,id is  " + ids);
			model.addAttribute("code", -100000);
		}
		return "/learn-course-service/subject/json/subjectListJson";
	}


	/**
	 * 排序科目
	 * @param request
	 * @param response
	 * @param model
	 * @param ids
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/subject/sort", method = RequestMethod.POST)
	public String sort(HttpServletRequest request,
					   HttpServletResponse response, ModelMap model,
					   @RequestBody List<Long> ids) throws Exception {

		log.info("sort lesson : uids= " + ids);

		try {
			List<Subject> subjectList = subjectService.getObjectsByIds(ids);

			int index = 1;
			for (Subject subject : subjectList) {
				subject.setSort(index);
				index = index +1;
			}
			this.subjectService.updateList(subjectList);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add bookUnit error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}
	private Integer getMaxSort() throws ServiceException, ServiceDaoException {
		List<Long> maxs = subjectService.getSubjectIdsByStatusOrderBySort(Subject.status_normal, 0, Integer.MAX_VALUE);
		Integer max = 0;
		if (CollectionUtils.isEmpty(maxs)) {
			log.info("first order ");

		} else {
			Long maxID = maxs.get(0);
			max = this.subjectService.getObjectById(maxID).getSort();
			log.info("quiz max order is " + max);
		}
		return max+1;
	}


	/**
	 * 批量删除科目等级
	 * @param request
	 * @param response
	 * @param model
	 * @param ids
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/subject/list", method = RequestMethod.DELETE)
	public String deleteGradeClassRelation(HttpServletRequest request,
					   HttpServletResponse response, ModelMap model,
					   @RequestBody List<Long> ids) throws Exception {
		log.info(" deleteGradeClassRelation ids = " + ids);


		if(ids==null || ids.size()==0){
			model.addAttribute("code",-1000);
			return "/common/success";
		}
		List<Long> newIds = new ArrayList<>();
		for(Object id : ids){
			log.info(" id = " + id);
			newIds.add(Long.valueOf(id+""));
		}
		List<GradeClassRelation> gradeClassRelations =  gradeClassRelationService.getObjectsByIds(newIds);
		if(gradeClassRelations.size()>0){
			//不能删除掉所有等级
			List<Long> allIds = gradeClassRelationService.getGradeClassRelationIdsBySubjectOrderByGradeNameDesc
					(gradeClassRelations.get(0).getSubjectId(),0,Integer.MAX_VALUE);
			log.info(" delete subject grade,allIds = "+allIds);
			if(newIds.size()==allIds.size()){
				model.addAttribute("code",-5085);
				return "/common/success";
			}

		}


		log.info("  get gradeClassRelations size = "+gradeClassRelations.size());
		//删除时候查询是否有课程使用该等级
		for(GradeClassRelation gradeClassRelation : gradeClassRelations){
			log.info(" gradeName = "+gradeClassRelation.getGradeName()+" sub = "+gradeClassRelation.getSubjectId());
			List<Long> lessonIds = lessonService.getLessonIdsByLevelAndSubjectOrderBySort
					(gradeClassRelation.getGradeName(),gradeClassRelation.getSubjectId(),0,2);
			log.info(" gradeName = " + gradeClassRelation.getLevel() + " lessonIds = " + lessonIds);
			if(lessonIds.size()>0){
				model.addAttribute("code",-5080);
				model.addAttribute("message","有课程使用该科目等级"+gradeClassRelation.getLevel()+"，不能删除");
				return "/data/json3";
			}
		}

		gradeClassRelationService.deleteList(GradeClassRelation.class,newIds);

		model.addAttribute("code",0);

		return "/common/success";

	}


	}

