package com.ptteng.course.admin.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.DictationLessonService;
import com.ptteng.learn.course.service.DictationLevelService;
import com.ptteng.learn.course.service.DictationSubjectService;
import com.qding.common.util.http.cookie.CookieUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * DictationSubject  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class DictationSubjectController {
    private static final Log log = LogFactory.getLog(DictationSubjectController.class);

    @Autowired
    private DictationSubjectService dictationSubjectService;

    @Autowired
    private DictationLevelService dictationLevelService;

    @Autowired
    private DictationLessonService dictationLessonService;

    @Autowired
    private CookieUtil cookieUtil;


    /**
     * @param
     * @Description 听写科目列表
     * @Author: PeiyuFeng
     * @Time 2017/5/17 14:56
     */
    @RequestMapping(value = "/a/u/dictation/subject/list", method = RequestMethod.GET)
    public String getDictationSubjectList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                          String name) throws Exception {

        log.info("get dictation subject list by name : " + name);
        List<Long> idList = new ArrayList();

        try {
            Map<String, Object> params = DynamicUtil.getDictationSubjectList(name);
            idList = dictationSubjectService.getIdsByDynamicCondition(DictationSubject.class, params, 0, Integer.MAX_VALUE);
            List<DictationSubject> subjects = dictationSubjectService.getObjectsByIds(idList);
            log.info("get book subject data is " + subjects.size());

            model.addAttribute("code", 0);
            model.addAttribute("total", subjects.size());

            model.addAttribute("dictationSubjectList", subjects);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get dictationSubject error ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/dictationSubject/json/dictationSubjectListJson";
    }





    /**
     * @param
     * @Description 新建听写科目
     * @Author: PeiyuFeng
     * @Time 2017/5/18 14:06
     */
    @RequestMapping(value = "/a/u/dictation/subject", method = RequestMethod.POST)
    public String addSubjectJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, DictationSubject subject) throws Exception {

        log.info("insert subject : subject= " + subject);

        if (null == subject) {
            log.info(" subject is null ");
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        if (null == subject.getName() || null == subject.getNoteImg() || null == subject.getNoteName()) {
            log.info(" params is null ");
            model.addAttribute("code", -1000);
            return "/common/success";
        }


        log.info("========== 校验等级json ==========");
        if (StringUtil.isEmpty(subject.getLevelJson())) {
            model.addAttribute("code", -2103);
            return "/common/success";
        }else {
            log.info("levelJson exist");
        }
        JSONObject gradeAndClassJson = JSONObject.fromObject(subject.getLevelJson());
        JSONArray gradeClassRelationList = JSONArray.fromObject(gradeAndClassJson.get("list"));
        log.info("level list : " + gradeClassRelationList);

        for (int i = 0; i < gradeClassRelationList.size(); i++) {
            JSONObject jsonObject = (JSONObject) gradeClassRelationList.get(i);
            if (StringUtil.isEmpty((String) jsonObject.get("name"))) {
                model.addAttribute("code", -2104);
                return "/common/success";
            }
        }

        log.info("params verify OK");

        try {

            List<DictationLevel> levels = new ArrayList<>();
            subject.setId(null);

            //校验同名科目
            Long idByName = dictationSubjectService.getIdByName(subject.getName());
            if (idByName != null) {
                model.addAttribute("code", -2105);
                return "/common/success";
            }else {
                log.info("name verify OK");
            }
            subject.setLevelJson("");
            subject.setSort(this.getMaxSort());
            subject.setStatus(DictationSubject.STATUS_OFFLINE);
            log.info("insert subject : " + subject);
            Long id = dictationSubjectService.insert(subject);
            log.info("insert dictation subject success");

            //插入科目难度
            for (int i = 0; i < gradeClassRelationList.size(); i++) {
                JSONObject jsonObject = (JSONObject) gradeClassRelationList.get(i);

                //校验难度关联年级是否匹配用户类型
                String nameObj = (String) jsonObject.get("name");
                List<String> nameList = new ArrayList(Arrays.asList(nameObj.split(",")));
                if (StringUtil.isEmpty(nameObj)) {
                    log.info("name verify wrong");
                    model.addAttribute("code", -2104);
                    return "/common/success";
                } else {
                    log.info("name not null");
                }

                DictationLevel level = new DictationLevel();
                level.setSid(id);
                level.setName((String) jsonObject.get("name"));
                levels.add(level);
            }

            log.info(" levels size = " + levels.size());
            if (levels.size() > 0) {
                dictationLevelService.insertList(levels);
            }

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add subject error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param
     * @Description 编辑听写科目
     * @Author: PeiyuFeng
     * @Time 2017/5/18 14:45
     */
    @RequestMapping(value = "/a/u/dictation/subject/{id}", method = RequestMethod.PUT)
    public String updateSubject(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                DictationSubject subject, @PathVariable Long id) throws Exception {

        log.info("update subject " + id + " : subject= " + subject);

        DictationSubject oldSubject = dictationSubjectService.getObjectById(id);

        if (null == oldSubject) {
            log.info("old subject is null ");
            model.addAttribute("code", -2106);
            return "/common/success";
        }

        if (null == subject) {
            log.info(" subject is null ");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        log.info("========== 校验等级json ==========");
        if (StringUtil.isEmpty(subject.getLevelJson())) {
            model.addAttribute("code", -2103);
            return "/common/success";
        }
        JSONObject gradeAndClassJson = JSONObject.fromObject(subject.getLevelJson());
        JSONArray gradeClassRelationList = JSONArray.fromObject(gradeAndClassJson.get("list"));
        for (int i = 0; i < gradeClassRelationList.size(); i++) {
            JSONObject jsonObject = (JSONObject) gradeClassRelationList.get(i);
            if (StringUtil.isEmpty((String) jsonObject.get("name"))) {
                model.addAttribute("code", -2104);
                return "/common/success";
            }
        }

        try {

            subject.setId(null);

            if (subject.getName().equals(oldSubject.getName())) {
                log.info("name not change");
            } else {
                Long idByName = dictationSubjectService.getIdByName(subject.getName());
                if (idByName != null) {
                    model.addAttribute("code", -2105);
                    return "/common/success";
                }
            }
            subject.setLevelJson("");

            subject.setId(id);
            subject.setCreateAt(oldSubject.getCreateAt());
            subject.setSort(oldSubject.getSort());
            subject.setStatus(oldSubject.getStatus());

            dictationSubjectService.update(subject);
            log.info("subject update success");

            List<DictationLevel> levels = new ArrayList<>();
            List<DictationLevel> updateLevels = new ArrayList<>();


            log.info("修改科目等级信息");
            List<Long> lids = dictationLevelService.getIdsBySid(id);
            log.info("lids : " + lids);

            for (int i = 0; i < gradeClassRelationList.size(); i++) {
                JSONObject jsonObject = (JSONObject) gradeClassRelationList.get(i);

                String nameObj = (String) jsonObject.get("name");

                log.info(" level id = " + jsonObject.get("id"));
                if (DictationLevel.ID.equals(Long.valueOf((Integer) jsonObject.get("id")))) {
                    DictationLevel level = new DictationLevel();

                    log.info(" add ");

                    //新增
                    level.setSid(id);
                    level.setName((String) jsonObject.get("name"));

                    levels.add(level);

                } else {
                    log.info(" update ");
                    //修改
                    DictationLevel level = dictationLevelService.getObjectById(Long.valueOf((Integer) jsonObject.get("id")));
                    level.setName("" + jsonObject.get("name"));
                    updateLevels.add(level);
                }

            }
            log.info(" add size = " + levels.size() + " update size = " + updateLevels.size());
            if (levels.size() > 0) {
                dictationLevelService.insertList(levels);
            }
            if (updateLevels.size() > 0) {
                dictationLevelService.updateList(updateLevels);
            }


            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add subject error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param
     * @Description 听写科目详情
     * @Author: PeiyuFeng
     * @Time 2017/5/18 15:21
     */
    @RequestMapping(value = "/a/u/dictation/subject/{id}", method = RequestMethod.GET)
    public String getDictationSubjectLevelList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                               @PathVariable Long id) throws Exception {

        log.info("get dictation subject : " + id + " detail ");

        try {
            DictationSubject subject = dictationSubjectService.getObjectById(id);
            if (subject == null) {
                log.info("subject is null ");
                model.addAttribute("code", -2106);
                return "/common/success";
            } else {
                log.info("get subject : " + id);
            }

            List<Long> idList = dictationLevelService.getIdsBySid(id);
            List<DictationLevel> dictationLevelList = dictationLevelService.getObjectsByIds(idList);
            log.info("get  dictationLevel data is " + dictationLevelList);

            model.addAttribute("code", 0);
            model.addAttribute("total", dictationLevelList.size());
            model.addAttribute("dictationSubject", subject);
            model.addAttribute("dictationLevelList", dictationLevelList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get dictationSubject error ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/dictationSubject/json/dictationSubjectDetailJson";
    }


    /**
     * @param
     * @Description 听写科目排序
     * @Author: zeping
     * @Time 2017/8/15 15:29
     */
    @RequestMapping(value = "/a/u/dictation/subject/sort", method = RequestMethod.POST)
    public String sort(HttpServletRequest request,
                       HttpServletResponse response, ModelMap model,
                       @RequestBody List<Long> ids) throws Exception {

        log.info("sort dictation subject : ids = " + ids);

        try {
            List<DictationSubject> subjectList = dictationSubjectService.getObjectsByIds(ids);

            int index = 1;
            for (DictationSubject subject : subjectList) {
                subject.setSort(index);
                index = index + 1;
            }
            this.dictationSubjectService.updateList(subjectList);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("sort dictation subject error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param
     * @Description 上下架听写课程
     * @Author: PeiyuFeng
     * @Time 2017/5/18 15:52
     */
    @RequestMapping(value = "/a/u/updown/dictation/subject/{id}", method = RequestMethod.PUT)
    public String updownSubject(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page,
                                Integer size, @PathVariable Long id) throws Exception {

        log.info("up or down dictation subject : " + id);

        try {
            DictationSubject subject = dictationSubjectService.getObjectById(id);
            if (subject == null) {
                log.info("dictation subject not exist");
                model.addAttribute("code", -2106);
                return "/common/success";
            } else {
                log.info("dictation subject : " + id + " exist");
            }

            if (DictationSubject.STATUS_ONLINE.equals(subject.getStatus())) {
                //下架
                log.info("dictation subject down");
                subject.setStatus(DictationSubject.STATUS_OFFLINE);
                subject.setSort(10086);

                List<Long> idList = dictationLessonService.getLessonListBySid(id, 0, Integer.MAX_VALUE);
                log.info("lesson id list : " + idList);
                if (idList.size() > 0) {
                    List<DictationLesson> lessonList = dictationLessonService.getObjectsByIds(idList);
                    for (DictationLesson lesson : lessonList) {
                        lesson.setStatus(DictationLesson.STATUS_FORBIDDEN);
                    }
                    dictationLessonService.updateList(lessonList);
                    log.info("update lesson list success");
                }
            } else {
                //上架
                log.info("dictation subject up");
                List<Long> idList = dictationLessonService.getLessonListBySid(id, 0, Integer.MAX_VALUE);
                log.info("lesson id list : " + idList);
                if (idList.size() > 0) {

                    List<DictationLesson> lessonList = dictationLessonService.getObjectsByIds(idList);
                    for (DictationLesson lesson : lessonList) {
                        lesson.setStatus(DictationLesson.STATUS_NORMAL);
                    }

                    dictationLessonService.updateList(lessonList);
                    subject.setStatus(DictationSubject.STATUS_ONLINE);

                } else {
                    log.info("dictation subject have no lesson");
                    model.addAttribute("code", -2107);
                    return "/common/success";
                }
            }

            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            subject.setUpdateBy(Long.parseLong(userId));

            dictationSubjectService.update(subject);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update dictation subject status error");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    private Integer getMaxSort() throws ServiceException, ServiceDaoException {
        List<Long> maxs = dictationSubjectService.getIdsOnline(0, Integer.MAX_VALUE);
        Integer max = 0;
        if (CollectionUtils.isEmpty(maxs)) {
            log.info("first order ");

        } else {
            Long maxID = maxs.get(maxs.size() - 1);
            max = this.dictationSubjectService.getObjectById(maxID).getSort();
            log.info("quiz max order is " + max);
        }
        return max + 1;
    }

}

