package com.ptteng.course.admin.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyListUtil;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import com.qding.common.util.http.cookie.CookieUtil;
import com.ptteng.course.util.DynamicUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

import static com.ptteng.course.util.Constants.OnLine;

/**
 * BookUnit  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class BookUnitController {
    private static final Log log = LogFactory.getLog("bookUnit");

    @Autowired
    private BookVersionService bookVersionService;
    @Autowired
    private BookSubjectService bookSubjectService;
    @Autowired
    private BookUnitService bookUnitService;
    @Autowired
    private PeriodService periodService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private BookService bookService;
    @Autowired
    private CookieUtil cookieUtil;


    /**
     * @param id 单元id
     * @Description 教材单元详情
     * @Author: PeiyuFeng
     * @Time 2017/4/4 1:13
     */
    @RequestMapping(value = "/a/u/book/unit/{id}", method = RequestMethod.GET)
    public String getBookSubjectJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                     @PathVariable Long id) throws Exception {

        log.info("get book unit : id= " + id);
        try {
            BookUnit bookUnit = bookUnitService.getObjectById(id);

            if (bookUnit == null) {
                log.info("get bookUnit data null ");
                model.addAttribute("code", -3200);
                return "/common/success";
            } else {
                log.info("get bookUnit data is " + bookUnit);
            }

            model.addAttribute("code", 0);
            model.addAttribute("bookUnit", bookUnit);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get bookUnit error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/bookUnit/json/bookUnitDetailJson";
    }

    /**
     * @param id 单元id
     * @Description 编辑单元详情
     * @Author: PeiyuFeng
     * @Time 2017/4/4 1:24
     */
    @RequestMapping(value = "/a/u/book/unit/{id}", method = RequestMethod.PUT)
    public String updateBookSubjectJson(HttpServletRequest request, HttpServletResponse response,
                                        ModelMap model, String name, @PathVariable Long id) throws Exception {

        log.info("update bookUnit : name = " + name);

        try {

            BookUnit bookUnit = bookUnitService.getObjectById(id);

            if (bookUnit == null) {
                log.info("book unit not exist");
                model.addAttribute("code", -3200);
                return "/common/success";
            } else {
                log.info("get book unit name : " + bookUnit.getUnitName());

                Long nameId = bookUnitService.getIdByNameAndBookId(name, bookUnit.getBookId());
                if(nameId != null){
                    log.info("same name unit : " + id + " exist, init forbidden");
                    model.addAttribute("code", -3201);
                    return "/common/success";
                }else {
                    bookUnit.setUnitName(name);
                    bookUnitService.update(bookUnit);
                    log.info("update book unit success");
                }
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update bookUnit error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }

    /**
     * @param name 单元名称
     * @Description 新建单元
     * @Author: PeiyuFeng
     * @Time 2017/4/4 2:11
     */
    @RequestMapping(value = "/a/u/book/unit/{id}", method = RequestMethod.POST)
    public String addBookSubjectJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, String name, @PathVariable Long id) throws Exception {

        log.info("add BookUnit : name = " + name);

        try {
            //检验该教材中是否有同名单元
            Long nameId = bookUnitService.getIdByNameAndBookId(name, id);

            if(nameId != null){
                log.info("same name unit : " + nameId + " exist, init forbidden");
                model.addAttribute("code", -3201);
                return "/common/success";
            }else {
                log.info("same name subject not exist, init allow");

                BookUnit bookUnit = new BookUnit();
                bookUnit.setUnitName(name);
                bookUnit.setBookId(id);
                bookUnit.setStatus(BookUnit.STATUS_OFF);
                bookUnit.setSort(this.getMaxSort(id));
                bookUnitService.insert(bookUnit);
            }

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add BookUnit error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    /**
     * @param id 教材id
     * @Description 教材单元排序
     * @Author: PeiyuFeng
     * @Time 2017/4/4 2:33
     */
    @RequestMapping(value = "/a/u/book/unit/sort/{id}", method = RequestMethod.POST)
    public String sort(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id,
                       @RequestBody List<Long> ids) throws Exception {

        log.info("sort unit " + id + " : ids = " + ids);

        try {

            List<BookUnit> unitList = bookUnitService.getObjectsByIds(ids);

            for (BookUnit unit : unitList) {
                if (!id.equals(unit.getBookId())) {
                    log.info("unit : " + unit.getId() + " not belong book : " + id);
                    model.addAttribute("bid", id);
                    model.addAttribute("uid", unit.getId());
                    return "/learn-course-service/bookUnit/json/sortError";
                } else if(BookUnit.STATUS_OFF.equals(unit.getStatus())){
                    model.addAttribute("code", -3204);
                    return "/common/success";
                }else {
                    //单元属于该教材
                }
            }

            int index = 1;
            for (BookUnit unit : unitList) {
                unit.setSort(index);
                index = index + 1;
            }
            this.bookUnitService.updateList(unitList);
            log.info("book unit sort update success");

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("sort book unit error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    /**
     * @param id 教材id
     * @Description 获取教材单元列表
     * @Author: PeiyuFeng
     * @Time 2017/4/4 2:51
     */
    @RequestMapping(value = "/a/u/book/unit/list/{id}", method = RequestMethod.GET)
    public String getBookUnitsList(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id,
                                     String name, Integer status) throws Exception {

        log.info("get book unit list by bid : " + id + " name : " + name + " status : " + status);
        List<Long> idList = new ArrayList();

        try {
            Map<String, Object> params = DynamicUtil.getBookUnitList(name, status, id);
            idList = bookUnitService.getIdsByDynamicCondition(BookUnit.class, params, 0, Integer.MAX_VALUE);
            List<BookUnit> bookUnit = bookUnitService.getObjectsByIds(idList);
            log.info("get book unit data is " + bookUnit.size());

            List<Long> bids = MyListUtil.getFieldValueListFromModelList(bookUnit, false, BookUnit.class.getDeclaredField("bookId"));
            List<Book> books = bookService.getObjectsByIds(bids);
            Map<Long, Book> id_book = MyListUtil.convert2Map(Book.class.getDeclaredField("id"), books);

            List<Long> versionIds = MyListUtil.getFieldValueListFromModelList(books, false, Book.class.getDeclaredField("press"));
            List<BookVersion> bookVersions = bookVersionService.getObjectsByIds(versionIds);
            Map<Long, String> id_version = MyListUtil.convert2Map(BookVersion.class.getDeclaredField("id"), BookVersion.class.getDeclaredField("versionName"), bookVersions);
            log.info("id_version : " + id_version);

            List<Long> sids = MyListUtil.getFieldValueListFromModelList(books, false, Book.class.getDeclaredField("sid"));
            List<BookSubject> bookSubjects = bookSubjectService.getObjectsByIds(sids);
            Map<Long, String> id_subject = MyListUtil.convert2Map(BookSubject.class.getDeclaredField("id"), BookSubject.class.getDeclaredField("subjectName"), bookSubjects);
            log.info("id_subject : " + id_subject);

            model.addAttribute("code", 0);
            model.addAttribute("id_book", id_book);
            model.addAttribute("bookUnitList", bookUnit);
            model.addAttribute("id_version", id_version);
            model.addAttribute("id_subject", id_subject);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get bookSubject error by name : " + name + " status : " + status);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/bookUnit/json/bookUnitListJson";
    }


    /**
     * @Description 教材单元列表
     * @param
     * @Author: PeiyuFeng
     * @Time 2017/4/10 12:00
     */
    @RequestMapping(value = "/a/u/book/unit/list", method = RequestMethod.GET)
    public String getAllUnitsList(HttpServletRequest request, HttpServletResponse response, ModelMap model, String name,
                                  Integer grade, Long book, Long vid, Integer status, Integer page, Integer size) throws Exception {

        log.info("get book unit list by name : " + name + " status : " + status + " grade : " + grade + " book : " + book
        + " vid : ");
        List<Long> idList = new ArrayList();

        Boolean next = false;

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            Map<String, Object> params = DynamicUtil.getAllBookUnitList(name, status, book, grade, vid);
            idList = bookUnitService.getIdsByDynamicCondition(BookUnit.class, params, start, size);
            List<BookUnit> bookUnit = bookUnitService.getObjectsByIds(idList);
            log.info("get book unit data is " + bookUnit.size());

            List<Long> bids = MyListUtil.getFieldValueListFromModelList(bookUnit, false, BookUnit.class.getDeclaredField("bookId"));
            List<Book> books = bookService.getObjectsByIds(bids);
            Map<Long, Book> id_book = MyListUtil.convert2Map(Book.class.getDeclaredField("id"), books);

            List<Long> versionIds = MyListUtil.getFieldValueListFromModelList(books, false, Book.class.getDeclaredField("press"));
            List<BookVersion> bookVersions = bookVersionService.getObjectsByIds(versionIds);
            Map<Long, String> id_version = MyListUtil.convert2Map(BookVersion.class.getDeclaredField("id"), BookVersion.class.getDeclaredField("versionName"), bookVersions);
            log.info("id_version : " + id_version);

            List<Long> sids = MyListUtil.getFieldValueListFromModelList(books, false, Book.class.getDeclaredField("sid"));
            List<BookSubject> bookSubjects = bookSubjectService.getObjectsByIds(sids);
            Map<Long, String> id_subject = MyListUtil.convert2Map(BookSubject.class.getDeclaredField("id"), BookSubject.class.getDeclaredField("subjectName"), bookSubjects);
            log.info("id_subject : " + id_subject);

            List<Long> countList = bookUnitService.getIdsByDynamicCondition(BookUnit.class, params, 0, Integer.MAX_VALUE);
            log.info("total size : " + countList.size());

            Integer count = countList.size();
            Integer totalPage = (((count - 1)) / size) + 1;
            log.info("   totalPage = " + totalPage);

            if (idList != null && idList.size() > 0) {
                if (size.equals(idList.size())) {
                    next = true;
                    idList = idList.subList(0, size);
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("id_book", id_book);
            model.addAttribute("id_version", id_version);
            model.addAttribute("id_subject", id_subject);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("bookUnitList", bookUnit);


        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get bookSubject error by name : " + name + " status : " + status);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/bookUnit/json/bookUnitListJson";
    }


    /**
     * @param id 单元id
     * @Description 上下架单元
     * @Author: PeiyuFeng
     * @Time 2017/4/4 3:19
     */
    @RequestMapping(value = "/a/u/book/unit/up/{id}", method = RequestMethod.PUT)
    public String upSubject(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {


        log.info("up or down unit : " + id);

        try {
            BookUnit bookUnit = bookUnitService.getObjectById(id);
            if (bookUnit == null) {
                log.info("book unit not exist");
                model.addAttribute("code", -3200);
                return "/common/success";
            } else {
                log.info("book unit : " + id + " exist");
            }

            if (BookUnit.STATUS_ON.equals(bookUnit.getStatus())) {
                //下架
                log.info("book unit down");
                bookUnit.setStatus(BookUnit.STATUS_OFF);
                bookUnit.setSort(10086);

                Map param = DynamicUtil.getPeriodList(null, null, null, null, null, null, id, Period.status_normal, null);
                List<Long> idList = periodService.getIdsByDynamicCondition(Period.class, param, 0, Integer.MAX_VALUE);
                log.info("period id list : " + idList);
                if (idList.size() > 0) {
                    List<Period> periodList = periodService.getObjectsByIds(idList);
                    for (Period period : periodList) {
                        period.setStatus(Period.status_freeze);
                        period.setTaskCount(0);
                        periodService.update(period);
                    }
                }
                param = DynamicUtil.getTaskList(Task.book, null, null, null, null, id, null, Task.status_normal, null, null);
                idList = taskService.getIdsByDynamicCondition(Task.class, param, 0, Integer.MAX_VALUE);
                log.info("task id list : " + idList);
                if (idList.size() > 0) {
                    List<Task> taskList = taskService.getObjectsByIds(idList);
                    for (Task task : taskList) {
                        task.setStatus(Task.status_freeze);
                        taskService.update(task);
                    }
                }
            } else {
                //上架
                log.info("book unit up");

                Map<String, Object> periodParam = DynamicUtil.getPeriodList(null, null, null, null, null, null, id, Period.status_freeze, null);
                List<Long> upPeriodIdList = periodService.getIdsByDynamicCondition(Period.class, periodParam, 0, Integer.MAX_VALUE);
                log.info("period id list : " + upPeriodIdList);
                if (upPeriodIdList.size() > 0) {
                    List<Period> upPeriodList = periodService.getObjectsByIds(upPeriodIdList);
                    int periodSort = 1;
                    for (Period period : upPeriodList) {
                        Map<String, Object> taskParam = DynamicUtil.getTaskList(null, null, null, null, period.getId(), null, null, null, null, null);
                        List<Long> upTaskIdList = taskService.getIdsByDynamicCondition(Task.class, taskParam, 0, Integer.MAX_VALUE);
                        if (upTaskIdList.size() > 0) {
                            List<Task> taskList = taskService.getObjectsByIds(upTaskIdList);
                            for (Task task : taskList) {
                                task.setStatus(Task.status_normal);
                            }
                            taskService.updateList(taskList);
                            period.setStatus(Period.status_normal);
                            period.setSort(periodSort);
                            periodSort++;
                            period.setTaskCount(upTaskIdList.size());
                            bookUnit.setStatus(BookUnit.STATUS_ON);
                        }else {
                            period.setStatus(Period.status_freeze);
                            period.setSort(10086);
                        }
                        periodService.updateList(upPeriodList);
                    }
                }
                if (bookUnit.getStatus().equals(BookUnit.STATUS_OFF)) {
                    model.addAttribute("code", -3203);
                    return "/common/success";
                }

            }

            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            bookUnit.setUpdateBy(Long.parseLong(userId));
            bookUnitService.update(bookUnit);

            //对教材下所有单元进行排序
            BookUnit sortUnit = null;
            List<Long> bookUnitIds = bookUnitService.getBookUnitIdsByBidAndStatus(bookUnit.getBookId(), BookUnit.STATUS_ON);

            int index = 1;
            if (bookUnitIds != null && bookUnitIds.size() > 0) {
                for (Long sortId : bookUnitIds) {
                    sortUnit = bookUnitService.getObjectById(sortId);
                    if (sortUnit != null) {
                        sortUnit.setSort(index);
                        bookUnitService.update(sortUnit);
                        index++;
                    }
                }
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get update book unit status error");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    private Integer getMaxSort(Long id) throws ServiceException, ServiceDaoException {
        List<Long> maxs = bookUnitService.getBookUnitIdsByBidAndStatus(id, BookUnit.STATUS_ON);
        Integer max = 0;
        if (CollectionUtils.isEmpty(maxs)) {
            log.info("first order ");

        } else {
            Long maxID = maxs.get(maxs.size()-1);
            max = this.bookUnitService.getObjectById(maxID).getSort();
            log.info("quiz max order is " + max);
        }
        return max + 1;
    }


}

