package com.ptteng.course.admin.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.storage.util.ImgStorageUtil;
import com.ptteng.learn.admin.service.ArticleService;
import com.ptteng.learn.admin.model.Manager;
import com.ptteng.learn.admin.model.Article;
import com.ptteng.learn.admin.service.ManagerService;
import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.course.model.Lesson;
import com.qding.common.util.DataUtils;
import com.qding.common.util.FileUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.*;

/**
 * Article  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 *
 */
@Controller
public class ArticleController {
	private static final Log log = LogFactory.getLog(ArticleController.class);

	private final String Img_Module_Common = "common";
	@Autowired
	private ArticleService articleService;

	@Autowired
	private ImgStorageUtil imgStorageUtil;

	@Autowired
	private ManagerService managerService;


	@Autowired
	private com.qding.common.util.http.cookie.CookieUtil cookieUtil;

	// 图片上传
		@RequestMapping(value = "/a/u/img/{module}", method = RequestMethod.POST)
	public String uploadFile(HttpServletRequest request,
							 HttpServletResponse response, ModelMap model,
							 @RequestParam MultipartFile file, @PathVariable String module)
			throws Exception {
		log.info("hello upload " + module);
		if (org.apache.commons.lang3.StringUtils.isBlank(module)) {
			module = "common";
		}
		int code = 0;
		log.info(file.getOriginalFilename());

		//Long uid = cookieUtil.getID(request, response);
		try {
			String type = file.getContentType();
			long size = file.getSize();
			log.info("  size is =" + size / 1048576);
			String extend = FileUtil.getFileExtension(file
					.getOriginalFilename());
			String fileName = "";

			if("apk".equals(extend)){
				fileName = file.getOriginalFilename();
			}else {
				fileName = UUID.randomUUID().toString() + "." + extend;

			}


			log.info("new name is " + fileName);
			//  /data/temp/
			String filePath = "/data/temp/" + fileName;

			File tempPic = new File(filePath);
			file.transferTo(tempPic);
			String url = this.imgStorageUtil.imgStorage(module, module + "/"
					+ fileName, filePath);
			log.info(module + " upload success ,and file name is " + fileName
					+ "temp path is " + filePath + " access url is " + url);
			tempPic.delete();
			log.info(file.getOriginalFilename() + " delete success ");
			model.addAttribute("url", url);
			model.addAttribute("code", 0);
			return "/common/img";
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			return "/common/success";
		}

	}




	/**
	 * 单个查询展示内容
	 * @param request
	 * @param response
	 * @param model
	 * @param aid
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/article/{aid}", method = RequestMethod.GET)
	public String getArticleJson(HttpServletRequest request,
									 HttpServletResponse response, ModelMap model, @PathVariable Long aid)
			throws Exception {

		log.info("get data : id= " + aid);
		try {
			if(aid == null) {
				model.addAttribute("code", -1000);
				return "/common/success";
			}else {

			Article article = articleService.getObjectById(aid);
			if (article == null) {
				model.addAttribute("code", 2);
				return "/common/success";
			}else{
					log.info("get article data is " + article);
					model.addAttribute("code", 0);
					model.addAttribute("article", article);
				}
			}
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get article error,id is  " + aid);
			model.addAttribute("code", -100000);
		}

		return "/admin/article/json/articleDetailJson";
	}

	/**
	 * 修改内容
	 * @param request
	 * @param response
	 * @param model
	 * @param article
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/article/{aid}", method = RequestMethod.PUT)
	public String updateArticleJson(HttpServletRequest request,
										HttpServletResponse response, ModelMap model,  Article article,@PathVariable Long aid) throws Exception {

		log.info("update article : article= "/* + article*/);

		try {

			Integer status=article.getStatus();
			if (status!=1&&status!=2) {
				model.addAttribute("code", -5040);
				return "common/success";
			}
			if(null == article.getType()){
				log.info(article.getImg());
				model.addAttribute("code", -5030);
				return "common/success";
			}
			if (DataUtils.isNullOrEmpty(article.getImg())) {
				log.info(article.getImg());
				model.addAttribute("code", -5014);
				return "common/success";
			}
			if (DataUtils.isNullOrEmpty(article.getTitle())) {
				model.addAttribute("code", -5049);
				return "common/success";
			}
//			if (article.getPublishType().equals(Article.Publish_Future)) {
//				if (article.getPublishat() == null) {
//					model.addAttribute("code", -5057);
//					return "/common/success";
//				}
//			}
			if (article.getPublishType().equals(Article.Publish_Now)) {
				article.setStatus(Article.Status_Published);
				article.setPublishat(System.currentTimeMillis());
			}
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

			article.setUpdateBy(Long.parseLong(userId));
			article.setId(aid);
			articleService.update(article);
//			Manager manager=managerService.getObjectById(uid);
//			article.setAuthor(manager.getName());



			model.addAttribute("code", 0);

			model.addAttribute("article", article);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update article error,id is  " + article.getId());
			model.addAttribute("code", -100000);
		}
		return "common/success";
	}

	/**
	 * 发布或取消发布
	 * @param request
	 * @param response
	 * @param model
	 * @param
	 * @param aid
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/article/{aid}/status", method = RequestMethod.PUT)
	public String updateArticleJson(HttpServletRequest request,
										HttpServletResponse response, ModelMap model,@PathVariable Long aid) throws Exception {
		if (aid==null){
			model.addAttribute("code", -1000);
			log.info("put article error aid is null");
			return "common/success";
		}
		Article article =  articleService.getObjectById(aid);
		Integer status=article.getStatus();
		Integer type = article.getType();
		log.info("update article status : article id ,status = " +aid+" , "+status +" , type is "+ type);
		//banner限制8条数据上架
		if (type >=4 && article.getStatus().equals(Article.Status_Unpublished)) {
			Map<String ,Object> param = DynamicUtil.getBannerListByStatusParam(null,Article.Status_Published);
			List <Long> ids = articleService.getIdsByDynamicCondition(Article.class,param,0,Integer.MAX_VALUE);
			log.info("update article status : Article has been published size = " +ids.size());
			if (ids.size()>=8) {
				model.addAttribute("code", -12000);
				return "common/success";
			}
		}

		try {

			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

			article.setUpdateBy(Long.parseLong(userId));
			log.info("article is  " + article);
			if(Article.Status_Unpublished.equals(status)){
				log.info("change strtus4");
				Long time = System.currentTimeMillis();
				article.setStatus(Article.Status_Published);//取消发布
				article.setPublishat(time);
			}else{
				log.info("change strtus5");

				article.setStatus(Article.Status_Unpublished);//发布内容

			}
//			Manager manager=managerService.getObjectById(uid);
//			article.setAuthor(manager.getName());
//			article.setId(null);



			articleService.update(article);

			model.addAttribute("code", 0);



		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update article error,id is  " + aid);
			model.addAttribute("code", -100000);

		}

		return "common/success";
	}

	/**
	 * 添加内容
	 * @param request
	 * @param response
	 * @param model
	 * @param article
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/article", method = RequestMethod.POST)
	public String addArticleJson(HttpServletRequest request,
									 HttpServletResponse response, ModelMap model,  Article article) throws Exception {

		log.info("update article : article= " + article);

		try {

			Integer status=article.getStatus();
			if (status!=1&&status!=2) {
				model.addAttribute("code", -4020);
				return "common/success";
			}
			if(null == article.getType()){
				log.info(article.getImg());
				model.addAttribute("code", -5030);
				return "common/success";
			}
			if (DataUtils.isNullOrEmpty(article.getImg())) {
				log.info(article.getImg());
				model.addAttribute("code", -5014);
				return "common/success";
			}
			if (DataUtils.isNullOrEmpty(article.getTitle())) {
				model.addAttribute("code", -5049);
				return "common/success";
			}
			//banner限制8条上架数据
			if (article.getType() >=4 && article.getStatus().equals(Article.Status_Published)) {
				Map<String ,Object> param = DynamicUtil.getBannerListByStatusParam(null,Article.Status_Published);
				List <Long> ids = articleService.getIdsByDynamicCondition(Article.class,param,0,Integer.MAX_VALUE);
				log.info("insert article status : Article has been published size = " +ids.size());
				if (ids.size()>=8) {
					model.addAttribute("code", -12000);
					return "common/success";
				}
			}






//			if (article.getPublishType().equals(Article.Publish_Future)) {
//				if (article.getPublishat() == null) {
//					model.addAttribute("code", -5057);
//					return "/common/success";
//				}
//			}
//			if (article.getPublishType().equals(Article.Publish_Now)) {
//				article.setStatus(Article.Status_Published);
//				article.setPublishat(System.currentTimeMillis());
//			}


//			if(Article.Status_Unpublished==article.getStatus()){
//				article.setStatus(Article.Status_Unpublished);//保存草稿，不发布\
//				article.setPublishat(0L);
//			}else if(Article.Status_Published==article.getStatus()){
//				Long time = System.currentTimeMillis();
//				article.setStatus(Article.Status_Published);//发布
//				article.setPublishat(time);
//			}else{
//				article.setStatus(Article.Status_Unpublished);
//			}
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
			article.setCreateBy(Long.parseLong(userId));
			article.setUpdateBy(Long.parseLong(userId));
//			Manager manager=managerService.getObjectById(uid);
//			article.setAuthor(manager.getName());
			article.setOrderBy(getMaxSort());
			article.setId(null);
			if (article.getType() == 3) {
				article.setStatus(Article.Status_Published);
				article.setPublishat(System.currentTimeMillis());
			}
			Long aid=articleService.insert(article);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add article error ");
			model.addAttribute("code", -100000);
		}
		return "common/success";
	}
	private Integer getMaxSort() throws ServiceException, ServiceDaoException {
		Map<String, Object> param = DynamicUtil.getArticleListParam
				(null, null, null, "", "", null);
		List<Long> maxs = this.articleService.getIdsByDynamicCondition(
				Article.class, param, 0, Integer.MAX_VALUE);
		Integer max = 0;
		if (CollectionUtils.isEmpty(maxs)) {
			log.info("first order ");

		} else {
			Long maxID = maxs.get(maxs.size() - 1);
			log.info(" maxID = " + maxID);
			max = this.articleService.getObjectById(maxID).getOrderBy();
			if (null == max) {
				max = 0;
			}
			log.info("quiz max order is " + max);
		}
		return max + 1;
	}

	/**
	 * 资讯排序
	 * @param request
	 * @param response
	 * @param model
	 * @param ids
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/article/sort", method = RequestMethod.POST)
	public String sort(HttpServletRequest request,
					   HttpServletResponse response, ModelMap model,
					   @RequestBody List<Long> ids) throws Exception {

		log.info("sort lesson : uids= " + ids);

		try {
			List<Article> articleList = articleService
					.getObjectsByIds(ids);

			int index = 1;
			for (Article article : articleList) {
				article.setOrderBy(index);
				index = index +1;
			}
			this.articleService.updateList(articleList);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add bookUnit error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}
	/**
	 * 删除内容
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/article/{id}", method = RequestMethod.DELETE)
	public String deleteArticleJson(HttpServletRequest request,
										HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete article : id= " + id);
		try {
			articleService.delete(id);

			log.info("add article success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete article error,id is  " + id);
			model.addAttribute("code", -100000);

		}

		return "common/success";
	}

	/**
	 * 条件查询内容
	 * @param request
	 * @param response
	 * @param model
	 * @param page
	 * @param size
	 * @param startAt
	 * @param endAt
	 * @param type
	 * @param createBy
	 * @param status
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/article/list", method = RequestMethod.GET)
	public String getArticleList(HttpServletRequest request,
									 HttpServletResponse response, ModelMap model, Integer page, Integer size,
									 Long startAt,Long endAt,Integer type,String title,String createBy,String status)
			throws Exception {
		log.info("/web/a/article/list ,page is:"+page+",size is"+size+",startAt is"+startAt+",endAt is"+endAt+", type is " +
				""+type+" , source is "+" createBy is " +
				createBy+" status is "+status);
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		Integer total=0;
		List<Long> count=null;
		List<Long>  ids =null;
		try {

//			if(startAt == null && endAt == null && type == null && createBy == null && status == null){
//				ids = articleService.getArticleIds(start, size);
//				total=articleService.countArticleIds();
//				log.info("===============================================1"+ids + "=====" + total);
//			} else {
				Map<String, Object> param = DynamicUtil.getArticleListParam(startAt, endAt, type, createBy, title, status);
				log.info("        param is    " + param);
//				Map<String, Object> countparam = DynamicUtil.getListParam(startAt, endAt, type, createBy, source, status, true);
				log.info("pageList : page= " + start + " , size=" + size);
				ids = articleService.getIdsByDynamicCondition(Article.class, param, start, size);
				count = articleService.getIdsByDynamicCondition(Article.class, param, 0, Integer.MAX_VALUE);
				total = count.size();
				log.info("===============================================2"+ids+"====="+total);
//			}

			if(ids!=null && ids.size()>0){

				log.info("get article list ids is" + ids);
				List<Article> articleList=articleService.getObjectsByIds(ids);
				model.addAttribute("articleList",articleList);
			}else{
				model.addAttribute("code", 2);
				return "/common/success";
			}
			Boolean next=false;
			Integer nex=start+size;

			if (total>nex) {

				next=true;
			}
			model.addAttribute("next",next);
			log.info("next is : " + next);

			Integer totalPage=1;
			if (total > 0) {

				totalPage=(total-1)/size+1;
				log.info("totalPage is : " + totalPage);
			}

			log.info("code : " + 0);
			model.addAttribute("total", total);
			model.addAttribute("totalPage",totalPage);
			model.addAttribute("size",size);
			model.addAttribute("page", page);
			model.addAttribute("code",0);
			model.addAttribute("next",next);
		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get articleList error,qfrom is"+startAt+",qto is"+endAt+", type is " +
					""+type+" , source is "+" createBy is " +
					createBy+" status is "+status);
			model.addAttribute("code", -100000);
		}

		return "/admin/article/json/articleMultiJson";
	}

	/**
	 * 条件查询banner内容
	 * @param request
	 * @param response
	 * @param model
	 * @param page
	 * @param size
	 * @param createStart
	 * @param createEnd
	 * @param updateStart
	 * @param updateEnd
	 * @param type
	 * @param createBy
	 * @param status
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/banner/list", method = RequestMethod.GET)
	public String getBannerList(HttpServletRequest request,
								 HttpServletResponse response, ModelMap model, Integer page, Integer size,
								 Long createStart,Long createEnd,Long updateStart, Long updateEnd,Integer type,String title,String createBy,String status)
			throws Exception {
		log.info("/web/a/article/list ,page is:"+page+",size is"+size+",createStart is"+createStart+",createEnd is"+createEnd+",updateStart is"+updateStart+",updateEnd is"+updateEnd+", type is " +
				""+type+" , source is "+" createBy is " +
				createBy+" status is "+status);
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		Integer total=0;
		List<Long> count=null;
		List<Long>  ids =null;
		try {

//			if(startAt == null && endAt == null && type == null && createBy == null && status == null){
//				ids = articleService.getArticleIds(start, size);
//				total=articleService.countArticleIds();
//				log.info("===============================================1"+ids + "=====" + total);
//			} else {
			Map<String, Object> param = DynamicUtil.getBannerListParam(createStart,createEnd,updateStart,updateEnd, type, createBy, title, status);
			log.info("        param is    " + param);
//				Map<String, Object> countparam = DynamicUtil.getListParam(startAt, endAt, type, createBy, source, status, true);
			log.info("pageList : page= " + start + " , size=" + size);
			ids = articleService.getIdsByDynamicCondition(Article.class, param, start, size);
			count = articleService.getIdsByDynamicCondition(Article.class, param, 0, Integer.MAX_VALUE);
			total = count.size();
			log.info("===============================================2"+ids+"====="+total);
//			}

			if(ids!=null && ids.size()>0){

				log.info("get article list ids is" + ids);
				List<Article> articleList=articleService.getObjectsByIds(ids);
				model.addAttribute("articleList",articleList);
			}else{
				model.addAttribute("code", 2);
				return "/common/success";
			}
			Boolean next=false;
			Integer nex=start+size;

			if (total>nex) {

				next=true;
			}
			model.addAttribute("next",next);
			log.info("next is : " + next);

			Integer totalPage=1;
			if (total > 0) {

				totalPage=(total-1)/size+1;
				log.info("totalPage is : " + totalPage);
			}

			log.info("code : " + 0);
			model.addAttribute("total", total);
			model.addAttribute("totalPage",totalPage);
			model.addAttribute("size",size);
			model.addAttribute("page", page);
			model.addAttribute("code",0);
			model.addAttribute("next",next);
		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get articleList error,createStart is"+createStart+",createEnd is"+createEnd+",updateStart is"+updateStart+",updateEnd is"+updateEnd+", type is " +
					""+type+" , source is "+" createBy is " +
					createBy+" status is "+status);
			model.addAttribute("code", -100000);
		}

		return "/admin/article/json/articleMultiJson";
	}
	
	/**
	 * 根据type查找已发布内容
	 * @param page
	 * @param size
	 * @param type
	 * @return
	 * @throws Exception
	 */
	public List<Article> getArticleListByType(Integer page,Integer size,Integer type) throws  Exception{

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		List<Long> ids= articleService.getArticleIdsByTypeAndStatusOrderByPublishat(type, Article.Status_Published, start, size);
		log.info("get countArticleIdsByTypeAndStatusOrderByPublishat size is " + ids);


		List<Article> articleList = articleService.getObjectsByIds(ids);
		log.info("get article data is " + articleList);




		return  articleList;
	}
}

