package com.ptteng.course.admin.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;




import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.learn.course.model.UserTaskRecordRelation;
import com.ptteng.learn.course.service.UserTaskRecordRelationService;

/**
 * UserTaskRecordRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserTaskRecordRelationController {
	private static final Log log = LogFactory.getLog(UserTaskRecordRelationController.class);

	@Autowired
	private UserTaskRecordRelationService userTaskRecordRelationService;






    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/userTaskRecordRelation", method = RequestMethod.GET)
	public String getuserTaskRecordRelationList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/userTaskRecordRelation  to /userTaskRecordRelation/view/userTaskRecordRelationList");

		return "/learn-course-service/userTaskRecordRelation/view/userTaskRecordRelationList";
	}
    
    

    		

		/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */


		 @RequestMapping(value = "/c/userTaskRecordRelation1 ", method = RequestMethod.GET)
	public String getUserTaskRecordRelationIdsByUserIdAndNoteTypeOrderByCreateAtList1(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Long userId,Long taskId) throws Exception {

		log.info("/userTaskRecordRelation  to /userTaskRecordRelation/view/userTaskRecordRelationList");

		return "/learn-course-service/userTaskRecordRelation/view/userTaskRecordRelationList";
	}



	
	



			
    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

		
	
	

	@RequestMapping(value = "/a/u/userTaskRecordRelation/{id}", method = RequestMethod.GET)
	public String getUserTaskRecordRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			UserTaskRecordRelation userTaskRecordRelation = userTaskRecordRelationService.getObjectById(id);
			log.info("get userTaskRecordRelation data is " + userTaskRecordRelation);

			model.addAttribute("code", 0);

			model.addAttribute("userTaskRecordRelation", userTaskRecordRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userTaskRecordRelation error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/userTaskRecordRelation/json/userTaskRecordRelationDetailJson";
	}

	@RequestMapping(value = "/a/userTaskRecordRelation/{id}", method = RequestMethod.PUT)
	public String updateUserTaskRecordRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, UserTaskRecordRelation userTaskRecordRelation) throws Exception {
		
		log.info("update userTaskRecordRelation : userTaskRecordRelation= " + userTaskRecordRelation);
		
		try {
			
			userTaskRecordRelationService.update(userTaskRecordRelation);

			model.addAttribute("code", 0);

			model.addAttribute("userTaskRecordRelation", userTaskRecordRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update userTaskRecordRelation error,id is  " + userTaskRecordRelation.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userTaskRecordRelation", method = RequestMethod.POST)
	public String addUserTaskRecordRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, UserTaskRecordRelation userTaskRecordRelation) throws Exception {
		
		log.info("update userTaskRecordRelation : userTaskRecordRelation= " + userTaskRecordRelation);
		
		try { 
			userTaskRecordRelation.setId(null);

			userTaskRecordRelationService.insert(userTaskRecordRelation);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add userTaskRecordRelation error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userTaskRecordRelation/{id}", method = RequestMethod.DELETE)
	public String deleteUserTaskRecordRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete userTaskRecordRelation : id= " + id);
		try {
			userTaskRecordRelationService.delete(id);

			log.info("add userTaskRecordRelation success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete userTaskRecordRelation error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/userTaskRecordRelation", method = RequestMethod.GET)
	public String getMultiUserTaskRecordRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<UserTaskRecordRelation> userTaskRecordRelationList = userTaskRecordRelationService.getObjectsByIds(idList);
			log.info("get  userTaskRecordRelation data is " + userTaskRecordRelationList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",userTaskRecordRelationList.size());

			model.addAttribute("userTaskRecordRelationList", userTaskRecordRelationList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get userTaskRecordRelation error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/userTaskRecordRelation/json/userTaskRecordRelationListJson";
	}
	
	
	
	
	
}

