package com.ptteng.course.admin.controller;

import com.gemantic.common.util.MyListUtil;
import com.gemantic.common.util.StringUtil;
import com.ptteng.course.util.StatisticsUtil;
import com.ptteng.learn.admin.model.Manager;
import com.ptteng.learn.course.model.RecommendStatistics;
import com.ptteng.learn.course.model.User;
import com.ptteng.learn.course.model.UserRecommend;
import com.ptteng.learn.course.service.RecommendStatisticsService;
import com.ptteng.learn.course.service.UserRecommendService;
import com.ptteng.learn.course.service.UserService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * RecommendStatistics  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class RecommendStatisticsController {
	private static final Log log = LogFactory.getLog(RecommendStatisticsController.class);

	@Autowired
	private RecommendStatisticsService recommendStatisticsService;
	@Autowired
	private UserService userService;
	@Autowired
	private UserRecommendService userRecommendService;

//	/**
//	 * 推广统计
//	 * @param request
//	 * @param response
//	 * @param model
//	 * @param page
//	 * @param size
//	 * @param invitationCode 邀请码
//	 * @param name 推广人名称
//	 * @param registerNumStart 注册量起始
//	 * @param registerNumEnd 注册量终止
//	 * @param minAmount 销售额小
//	 * @param maxAmount 销售额大
//	 * @return
//	 * @throws Exception
//	 */
//	@RequestMapping(value = "/a/recommend/search", method = RequestMethod.GET)
//	public String getProductStatisticsList(HttpServletRequest request,
//										   HttpServletResponse response, ModelMap model,Integer page,Integer size,
//										   String invitationCode,String name,String registerNumStart,String registerNumEnd,
//										   String minAmount,String maxAmount ,String mobile) throws Exception {
//		log.info("page===" + page + "size====" + size+" name = "+name+" invitationCode = "+invitationCode+"" +
//				" registerNumStart = "+registerNumStart+" registerNumEnd = "+registerNumEnd+" minAmount = "+minAmount+"" +
//				" maxAmount = "+maxAmount);
//		if (page == null) {
//			page = 1;
//		}
//		if (size == null) {
//			size = 10;
//		}
//		int start = (page - 1) * size;
//		if (start < 0) {
//			start = 0;
//		}
//
//
//		log.info("pageList : page= " + start + " , size=" + size);
//
//		try {
//			List<RecommendStatistics> list = StatisticsUtil.getStatisticsListByMore(invitationCode, name, registerNumStart, registerNumEnd, minAmount, maxAmount
//					,mobile,start, size);
//			log.info(" get pro recommendStatistics list size  = "+list.size());
//
//			model.addAttribute("list", list);
//
//			List<Long> ids = MyListUtil.getDistinctList(RecommendStatistics.class.getDeclaredField("uid"), list);
//			log.info("ids : " + ids);
//
//			List<UserRecommend> userRecommends = userRecommendService.getObjectsByIds(ids);
//			Map<Long,UserRecommend> id_userRecommend = MyListUtil.convert2Map(UserRecommend.class.getDeclaredField("id"), userRecommends);
//			model.addAttribute("id_userRecommend", id_userRecommend);
//
//			List<RecommendStatistics> listTotal = StatisticsUtil.getStatisticsListByMore(invitationCode, name, registerNumStart, registerNumEnd, minAmount, maxAmount,
//					mobile,0, Integer.MAX_VALUE);
//			log.info(" get product total size = " + listTotal.size());
//			int total = listTotal.size();
//			int  totalPage =1;
//			if (total>0) {
//				totalPage=(total-1)/size +1;
//			}
//
//			model.addAttribute("code", 0);
//			model.addAttribute("total", total);
//			model.addAttribute("totalPage", totalPage);
//			model.addAttribute("size", size);
//			model.addAttribute("page", page);
//
//		}catch (Throwable t) {
//			t.printStackTrace();
//			log.error(t.getMessage());
//			log.error("get lotteryList  error,page is  " + start + " , size "
//					+ size);
//			model.addAttribute("code", -1);
//		}
//
//		log.info("/web/product  to /product/json/productList");
//
//		return "/learn-course-service/recommendStatistics/json/recommendStatisticsListJson";
//	}



	/**
	 * 推广统计
	 * @param request
	 * @param response
	 * @param model
	 * @param page
	 * @param size
	 * @param invitationCode 邀请码
	 * @param name 推广人名称
	 * @param registerNumStart 注册量起始
	 * @param registerNumEnd 注册量终止
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/recommend/search", method = RequestMethod.GET)
	public String getRecommendList(HttpServletRequest request, HttpServletResponse response, ModelMap model,Integer page,
										   Integer size, String invitationCode,String name,String registerNumStart,
										   String registerNumEnd, String minDiscount,String maxDiscount , String minSettlement,
										   String maxSettlement, Integer recommendStatus, String mobile, String mail) throws Exception {

		log.info("page===" + page + "size====" + size+" name = "+name+" invitationCode = "+invitationCode+"" + " registerNumStart = "
				+registerNumStart+" registerNumEnd = "+registerNumEnd+" minDiscount = "+minDiscount+"" + " maxDiscount = "+maxDiscount +
				" minSettlement = "+minSettlement+" maxSettlement = "+maxSettlement+" recommendStatus = "+recommendStatus+"" +
				" mobile = "+mobile+" mail = " + mail);
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}


		log.info("pageList : page= " + start + " , size=" + size);

		try {
			Map<String, Object> params = StatisticsUtil.getRecommendList(invitationCode, name, registerNumStart, registerNumEnd, minDiscount, maxDiscount,
					minSettlement, maxSettlement, recommendStatus, mobile, mail, false);
			log.info(" get recommend list param = "+params);
			List<Long> uids =  userService.getIdsByDynamicCondition(User.class, params, start, size);
			log.info(" get uid list size  = "+uids.size());

			List<Long> listTotal =  userService.getIdsByDynamicCondition(User.class, params, 0, Integer.MAX_VALUE);

			List list = userService.getObjectsByIds(uids);

			model.addAttribute("list", list);

			List<Long> ids = MyListUtil.getDistinctList(User.class.getDeclaredField("id"), list);
			log.info("ids : " + ids);

			List<UserRecommend> userRecommends = userRecommendService.getObjectsByIds(ids);
			Map<Long,UserRecommend> id_userRecommend = MyListUtil.convert2Map(UserRecommend.class.getDeclaredField("id"), userRecommends);
			model.addAttribute("id_userRecommend", id_userRecommend);
			log.info(id_userRecommend);


			log.info(" get total size = " + listTotal.size());
			int total = listTotal.size();
			int  totalPage =1;
			if (total>0) {
				totalPage=(total-1)/size +1;
			}

			model.addAttribute("code", 0);
			model.addAttribute("total", total);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("size", size);
			model.addAttribute("page", page);

			return "/learn-course-service/recommendStatistics/json/getRecommendListJson";

		}catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get lotteryList  error,page is  " + start + " , size "
					+ size);
			model.addAttribute("code", -1);
		}

		log.info("/web/product  to /product/json/productList");

		return "/common/success";
	}



	@RequestMapping(value = "/a/recommend/day/search", method = RequestMethod.GET)
	public String getproductList(HttpServletRequest request,
								 HttpServletResponse response, ModelMap model,Integer page,Integer size,
								 Long startAt,Long endAt, Long uid,
								 String period) throws Exception {
		log.info("page===" + page + "size====" + size+" uid = "+uid+" period = "+period+" startAt = "+startAt+" endAt = "+endAt);
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			if(null== uid){
				model.addAttribute("code",-1000);
				return "/common/success";
			}


			User user = userService.getObjectById(uid);
			model.addAttribute("name",user.getNick());
			if(StringUtils.isBlank(period)){
				period=StatisticsUtil.Period_Day;
			}
			if(StatisticsUtil.Period_Day.equals(period)){

				Map<String, Object> map = StatisticsUtil.getDailyStatistcsList(startAt, endAt, uid,
						false);
				log.info(" get Daily list param = " + map);
				List<Long> productDayilyIds =  recommendStatisticsService.getIdsByDynamicCondition(RecommendStatistics.class, map, start, size);
				log.info(" get Daily list ids size = "+productDayilyIds.size());
				if(productDayilyIds.size()>0){
					List<RecommendStatistics> DailyList = recommendStatisticsService.getObjectsByIds(productDayilyIds);
					log.info(" DailyList size = " + DailyList.size());
					for (RecommendStatistics recommendStatistics : DailyList){
						recommendStatistics.setDate(getDate(recommendStatistics.getStaticAt()));
					}


					model.addAttribute("list",DailyList);
				}
				BigInteger total = new BigInteger("0");
				BigInteger totalPage = new BigInteger("0") ;


				Map<String, Object> mapTotal = StatisticsUtil.getDailyStatistcsList( startAt, endAt, uid,
						true);
				log.info(" get recommend total size param = "+mapTotal);
				total =(BigInteger)  recommendStatisticsService.getObjectByDynamicCondition(RecommendStatistics.class, mapTotal, 0, Integer.MAX_VALUE);
				log.info(" get recommend total size = "+total);
				totalPage = new BigInteger("1");
				if (total.compareTo(new BigInteger("0"))==1) {
					totalPage=((total.subtract(new BigInteger("1"))).divide(new BigInteger(""+size))).add(new BigInteger("1"));
				}
				model.addAttribute("total", total);
				model.addAttribute("totalPage", totalPage);
			}else {
				//周统计和月统计
				List<RecommendStatistics> DailyList = new ArrayList<>();
				Map<String, Object> map = StatisticsUtil.getStatisticsGroupParam(period,uid, startAt, endAt);
				log.info(" get Daily list param = " + map);
				Object results =  recommendStatisticsService.getObjectByDynamicCondition(RecommendStatistics.class, map, start, size);
				int i = 0;
				if(results instanceof ArrayList){
					ArrayList resultArrays=(ArrayList) results;
					int statisticsSize = resultArrays.size();
					for(Object result:resultArrays){
						Object[] rs=(Object[])result;

						RecommendStatistics Daily = new RecommendStatistics();
						log.info(" 0 " + rs[0] + " 1=" + rs[1] + " 2=" + rs[2] + " week = " + rs[2]);
						Daily.setRegisters(new BigDecimal(rs[0] + ""));
						Daily.setAmount(new BigDecimal(rs[1] + ""));
						String week = rs[2]+"";
						Daily.setDate(StatisticsUtil.getStatisticsDate(period, week, i, startAt, endAt, statisticsSize));

						DailyList.add(Daily);
						i++;
						log.info("week date is  "+Daily.getDate());
					}


				}
				else{
					Object[] rs=(Object[])results;

					RecommendStatistics Daily = new RecommendStatistics();
					log.info(" 0 " + rs[0] + " 1=" + rs[1] + " 2=" + rs[2] + " week = " + rs[2]);
					Daily.setRegisters(new BigDecimal(rs[0] + ""));
					Daily.setAmount(new BigDecimal(rs[1] + ""));

					String week = rs[2]+"";

					Daily.setDate(StatisticsUtil.getStatisticsDate(period,week,i,startAt,endAt,1));
					DailyList.add(Daily);
					i++;
					log.info("week date is  "+Daily.getDate());

				}

				model.addAttribute("list",DailyList);



				Object totalResults =  recommendStatisticsService.getObjectByDynamicCondition(RecommendStatistics.class, map, 0, Integer.MAX_VALUE);
				if(totalResults instanceof ArrayList){
					ArrayList resultArrays=(ArrayList) totalResults;
					int total = ((ArrayList) totalResults).size();
					int totalPage = 1;
					if(total >0 ){
						totalPage = (total-1)/size+1;
					}
					model.addAttribute("total", total);
					model.addAttribute("totalPage", totalPage);
				}else{
					Object[] rs=(Object[])totalResults;
					log.info("  rs length = "+rs.length);
					int total = 0;
					if(rs.length==10){
						total = 1;
					}
					int totalPage = 1;
					model.addAttribute("total", total);
					model.addAttribute("totalPage", totalPage);
				}
			}
			model.addAttribute("code", 0);
			model.addAttribute("size", size);
			model.addAttribute("page", page);

		}catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get lotteryList  error,page is  " + start + " , size "
					+ size);
			model.addAttribute("code", -1);
		}

		log.info("/web/recommend  to /recommend/json/recommendList");

		return "/learn-course-service/recommendStatistics/json/recommendStatisticsListJson";
	}
	public static String getDate(Long time) {
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
		String date = "";
		if (null != time) {
			date = dateFormat.format(new Date(time));
		}
		return date;
	}

	
	/**
	 * @Description 结算
	 * @Author: PeiyuFeng
	 * @param id 用户id
	 * @param type 结算类型
	 * @param amount 结算金额
	 * @Time 2017/2/10 16:33
	 */
	@RequestMapping(value = "/a/u/user/recommend/settlement/{id}", method = RequestMethod.PUT)
	public String settlement(HttpServletRequest request, HttpServletResponse response, ModelMap model,
									   @PathVariable Long id, Integer type, String amount) throws Exception {

		log.info("set recommend discount : id = " + id + " type = " + type + " amount = " + amount);

		BigDecimal amountNum = BigDecimal.ZERO;

		if (StringUtil.isEmpty(amount) || type == null) {
			model.addAttribute("code", -1000);
			log.info("discount null");
			return "/common/success";
		} else {
			//校验折扣参数是否合法
			try {
				amountNum = new BigDecimal(amount);
			} catch (NumberFormatException e) {
				model.addAttribute("code", -10002);
				log.info("amount illegal");
				return "/common/success";
			}

			log.info("params OK");
		}

		Manager manager = (Manager) request.getAttribute("manager");
		Long managerId = manager.getId();

		try {

			//确认用户是否存在
			User user = userService.getObjectById(id);
			if (null == user) {
				model.addAttribute("code", -2000);
				log.info("user not exist");
				return "/common/success";
			} else {
				log.info("user exist : " + user);
			}


			//确定用户是否是推广人
			if (User.IS_NOT_MEMBER == user.getRecommendFlag()) {
				//用户不是推广人且无userRecommend数据（错误）
				model.addAttribute("code", -10000);
				log.info("user not recommend");
				return "/common/success";
			} else {

				UserRecommend userRecommend = userRecommendService.getObjectById(id);
				if (null == userRecommend) {
					//用户是推广人有邀请码但是无userRecommend数据（可能是老版本数据，补充userRecommend数据）
					UserRecommend newUserRecommend = new UserRecommend();
					newUserRecommend.setId(id);
					userRecommendService.insert(newUserRecommend);

					//用户无userRecommend数据,无法结算（错误）
					model.addAttribute("code", -10003);
					log.info("user not recommend");
					return "/common/success";

				} else {

					// 将结算金额加上原结算金额判断是否超过推广销售额
					BigDecimal settlementBefore = BigDecimal.ZERO;
					BigDecimal amountTot = BigDecimal.ZERO;
					String settlementType = "";
					if(UserRecommend.android.equals(type)){
						settlementBefore = userRecommend.getAndroidSettlement();
						amountTot = userRecommend.getAndroidAmount();
						settlementType = "android";
					}else {
						settlementBefore = userRecommend.getIosSettlement();
						amountTot = userRecommend.getIosAmount();
						settlementType = "ios";
					}
					log.info(settlementType + " settlementBefore : " + settlementBefore + " amountTot : " + amountTot);
					BigDecimal settlementTot = amountNum.add(settlementBefore);
					Integer resultMax = amountTot.compareTo(settlementTot);
					Integer resultMin = amountNum.compareTo(BigDecimal.ZERO);

					//结算总金额小于推广销售总金额且结算金额大于0
					if (resultMax == 1 && resultMin == 1) {
						log.info("amountNum " + amountNum + " legal");
					} else {
						model.addAttribute("code", -10003);
						log.info("settlement amount illegal");
						return "/common/success";
					}

					//加上结算金额记录
					if(UserRecommend.android.equals(type)){
						userRecommend.setAndroidSettlement(settlementTot);
						log.info("user : " + id + " Android settlement amount : " + settlementBefore + " >>>>>>>>>> " + settlementTot);
					}else {
						userRecommend.setIosSettlement(settlementTot);
						log.info("user : " + id + " iOS settlement amount : " + settlementBefore + " >>>>>>>>>> " + settlementTot);
					}

					log.info("update user recommend : " + userRecommend);
					userRecommendService.update(userRecommend);
				}
			}

			log.info("user " + id + " update recommend settlement success");

			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update recommend settlement error,id is  " + id);
			model.addAttribute("code", -1);

		}

		return "/common/success";
	}
}

