package com.ptteng.course.util;


import com.gemantic.common.util.StringUtil;
import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.learn.common.model.Message;
import com.ptteng.learn.course.model.User;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * Created by liangxj on 2015/9/7.
 */
public class DynamicUtil {
	public static Map<String,Object> getMemberList(String name,String minPeriod,String maxPeriod,String minPrice,String maxPrice,Integer status,boolean count){
		Map<String,Object> params=new HashedMap();
		if (StringUtil.isNotEmpty(name)) {
			params.put("name & like", " '%" + name + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("status", " '" + status + "'");
		}
		if (DataUtils.isNotNullOrEmpty(minPeriod)) {
			params.put("period+0 & >= ", " '" + minPeriod + "'");
		}
		if (DataUtils.isNotNullOrEmpty(maxPeriod)) {
			params.put("period+0 & <= ", " '" + maxPeriod + "'");
		}
		if (DataUtils.isNotNullOrEmpty(minPrice)) {
			params.put("price+0 & >= ", " '" + minPrice + "'");
		}
		if (DataUtils.isNotNullOrEmpty(maxPrice)) {
			params.put("price+0 & <= ", " '" + maxPrice + "'");
		}


		if(count){
			params.put("@query", " count(id)");

		}else {
			params.put("@order", "   period desc ");
			params.put("@query", " id");
		}


		params.put("@table", " member ");

		return params;
	}


	public static Map<String, Object> getCouponList(Integer status,String number,String minPeriod,String maxPeriod,Long  effectBegin,Long effectEnd,
													Long  invalidBegin,Long invalidEnd,Long memberId,boolean count) {
		Map<String, Object> params = new HashedMap();
		Set<String> tables = new HashSet();
		tables.add("coupon");
		if (DataUtils.isNotNullOrEmpty(number)) {
			params.put("coupon.number & like", " '%" + number + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("coupon.status ", " '" + status + "'");
		}
		if(DataUtils.isNotNullOrEmpty(minPeriod)
				||DataUtils.isNotNullOrEmpty(maxPeriod)
				||DataUtils.isNotNullOrEmpty(memberId)){
			if (DataUtils.isNotNullOrEmpty(minPeriod)) {
				params.put("member.period+0 & >= ", " '" + minPeriod + "'");
			}
			if (DataUtils.isNotNullOrEmpty(maxPeriod)) {
				params.put("member.period+0 & <= ", " '" + maxPeriod + "'");
			}
			if(DataUtils.isNotNullOrEmpty(memberId)){
				params.put(" coupon.member_id  ", " '" + memberId + "'");

			}
			params.put(" coupon.member_id ", " member.id");
			tables.add("member");

		}
		if (DataUtils.isNotNullOrEmpty(effectBegin)) {
			params.put("coupon.create_at & >= ", " '" + effectBegin + "'");
		}
		if (DataUtils.isNotNullOrEmpty(effectEnd)) {
			params.put("coupon.create_at & <= ", " '" + effectEnd + "'");
		}

		if (DataUtils.isNotNullOrEmpty(invalidBegin)) {
			params.put("coupon.deadline & >= ", " '" + invalidBegin + "'");
		}
		if (DataUtils.isNotNullOrEmpty(invalidEnd)) {
			params.put("coupon.deadline & <= ", " '" + invalidEnd + "'");
		}

		if(count){
			params.put("@query", " count(coupon.id) ");

		}else{
			params.put("@order", "  coupon.create_at desc ");
			params.put("@query", " coupon.id ");
		}

		String table = SQLUtil.convertTable(tables);
		params.put("@table", table);

		return params;

	}

	public static Map<String,Object> getLessonList(String name,Long subjectId,Integer level,Integer status, Integer selected){
		Map<String,Object> params=new HashedMap();
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("name & like", " '%" + name + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(subjectId) ){
			params.put("subject_id", "'" + subjectId+ "'");
		}
		if (DataUtils.isNotNullOrEmpty(status) ){
			params.put("status", "'" + status+ "'");
		}
		if (DataUtils.isNotNullOrEmpty(level) ) {
			params.put("level", "'" + level + "'");
		}
		if (DataUtils.isNotNullOrEmpty(selected)) {
			params.put("selected", "'" + selected + "'");
		}
			params.put("@order", "  sort asc,update_at desc,level ");
			params.put("@query", " id");

		params.put("@table", " lesson ");

		return params;
	}
	public static Map<String,Object> getMinLessonList(String name,Long subjectId,Integer level,Integer status){
		Map<String,Object> params=new HashedMap();
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("name & like", " '%" + name + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(subjectId) ){
			params.put("subject_id", "'" + subjectId+ "'");
		}
		if (DataUtils.isNotNullOrEmpty(status) ){
			params.put("status", "'" + status+ "'");
		}
		if (DataUtils.isNotNullOrEmpty(level) ) {
			params.put("level", "'" + level + "'");
		}
		params.put("@order", "  sort desc ");
		params.put("@query", " id");

		params.put("@table", " lesson ");

		return params;
	}
	public static Map<String, Object> getPeriodList(Integer level,String name, Long lessonId, Long subjectId,Integer type,Long bookId,
													Long unitId, Integer status,Integer press) {
		Map<String, Object> params = new HashedMap();
		System.out.println(name+"name"+"lessonId"+lessonId+"subjectID"+subjectId+"type"+type);
		Set<String> tables = new HashSet();
		tables.add("period");
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("period.name & like", " '%" + name + "%'");
		}

		if (DataUtils.isNotNullOrEmpty(lessonId)) {

			params.put("period.lesson_id", "'" +lessonId + "'");
		}
		if (DataUtils.isNotNullOrEmpty(subjectId)) {

			params.put("period.subject_id", "'" + subjectId + "'");
		}
		if (DataUtils.isNotNullOrEmpty(status)) {

			params.put("period.status", "'" + status + "'");
		}
		if (DataUtils.isNotNullOrEmpty(type)) {

			params.put("period.type", "'" + type + "'");
		}
		if (DataUtils.isNotNullOrEmpty(level)) {

			params.put("period.level", "'" + level + "'");
		}
		if (DataUtils.isNotNullOrEmpty(bookId)) {

			params.put("period.book_id", "'" + bookId + "'");
		}
		if (DataUtils.isNotNullOrEmpty(unitId)) {

			params.put("period.unit_id", "'" + unitId + "'");
		}
		if (DataUtils.isNotNullOrEmpty(press)) {
			tables.add("book");
			params.put("(period.book_id", "book.id and book.press ="+"'" + press + "')");
//			params.put("book.press", "'" + press + "'");
		}

		params.put("@order", "  period.sort,period.level ");
			params.put("@query", " period.id ");
		String table = SQLUtil.convertTable(tables);
		params.put("@table", table);

		return params;

	}


//	public static Map<String, Object> getUpStreamList(String name,Integer keep) {
//		Map<String, Object> params = new HashedMap();
//		if (DataUtils.isNotNullOrEmpty(name)) {
//			params.put("name & like", " '%" + name + "%'");
//		}
////		if (keep == 1) {
////			params.put("keep", keep);
////		}
//			params.put("type", 1);
//			params.put("@order", "  create_at desc ");
//			params.put("@query", "id");
//		params.put("@table", " stream ");
//
//		return params;
//
//	}


	public static Map<String, Object> getArticleListParam(Long startAt, Long endAt,
												  Integer type, String createBy, String title, String status) {

		Map<String, Object> params = new HashMap<String, Object>();
		Set<String> tables = new HashSet();
		tables.add("article");
		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put(" article.update_at & >= ", "'" + startAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(title)) {
			params.put(" article.title & like", " '%" + title + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put(" article.update_at & <= ", "'" + endAt + "'");
		}
		if (type == null) {
			params.put(" (article.type ", " 1 or type = 2)");
		}
		if (DataUtils.isNotNullOrEmpty(type)) {

			params.put(" article.type", type);
		}

		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put(" article.status", status);

		}
		if(StringUtil.isNotEmpty(createBy)){
			params.put("manager.id ", "article.create_by");
			params.put(" manager.name & like ", "'%" + createBy + "'");
			tables.add("manager");
		}


			params.put("@order", "  orderBy asc , create_at desc ");
			params.put("@query", " id ");
		String table = SQLUtil.convertTable(tables);


		params.put("@table", table);

		return params;
	}






	public static Map<String, Object> getBookList(String name,Long press,Integer grade,Integer term,Integer status,Long sid) {
		Map<String, Object> params = new HashMap<String, Object>();

		Set<String> tables = new HashSet();
		tables.add("statistics");
		if (name!=null) {
			params.put("name & like", " '%" + name + "%'");
		}
		if (grade!=null) {
			params.put("grade", "'" +grade+"'" );
		}
		if (press!=null) {
			params.put("press", "'" +press+"'" );
		}
		if (status!=null) {
			params.put("status", status );
		}
		if (term!=null) {
			params.put("term", term);
		}
		if (sid!=null) {
			params.put("sid", sid);
		}


			params.put("@order", " grade asc,press asc");

			params.put("@query", " id ");


		params.put("@table"," book");

		return params;

	}



	public static Map<String,Object> getMessageList(Integer grade,String name,Integer messageType,String nick,Long timeLow,Long timeHigh,String mail,Integer type){
		Map<String,Object> params=new HashedMap();
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("name & like", " '%" + name + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(mail)) {
			params.put("mail & like", " '%" + mail + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(nick)) {
			params.put("nick & like", " '%" + nick + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(messageType) ) {
			params.put("message_type", "'" + messageType + "'");
		}
		if (DataUtils.isNotNullOrEmpty(grade) ) {
			params.put("grade", "'" + grade + "'");
		}
		if (DataUtils.isNotNullOrEmpty(type) ) {
			params.put("type", "'" + type + "'");
			if (type == 1) {
				params.put("grade & <", "'" + 8 + "'");
			}
		}
		if (DataUtils.isNotNullOrEmpty(timeLow) ) {
			params.put("create_at&>", "'" + timeLow + "'");
		}
		if (DataUtils.isNotNullOrEmpty(timeHigh) ) {
			params.put("create_at&<", "'" + timeHigh + "'");
		}

		if(Message.Type_Help.equals(type)){
			params.put("@order", " sort asc  ");
		}else {
			params.put("@order", " create_at desc  ");
		}

		params.put("@query", " id");

		params.put("@table", " message ");

		return params;
	}


//	public static Map<String,Object> getTaskList(Long subjectId,Long lessonId,Long periodId){
//		Map<String,Object> params=new HashedMap();
//		if (DataUtils.isNotNullOrEmpty(subjectId)) {
//			params.put("subjectId", " '" + subjectId + "'");
//		}
//		if (DataUtils.isNotNullOrEmpty(lessonId)) {
//			params.put("lessonId", " '" + lessonId + "'");
//		}
//		if (DataUtils.isNotNullOrEmpty(periodId)) {
//			params.put("periodId", " '" + periodId + "'");
//		}
//
//		params.put("@order", "  create_at desc ");
//		params.put("@query", " id");
//
//		params.put("@table", " paper ");
//
//		return params;
//	}

	public static Map<String,Object> getPaperList(String periodName,Long subjectId,Long lessonId,Long periodId,Long bookId,Integer level,Integer type){
		Map<String,Object> params=new HashedMap();
		Set<String> tables = new HashSet();
		tables.add("paper");
		if (DataUtils.isNotNullOrEmpty(subjectId)) {
			params.put("paper.subject_id", " '" + subjectId + "'");
		}

			if (DataUtils.isNotNullOrEmpty(lessonId)) {
				params.put("paper.lesson_id", " '" + lessonId + "'");
			}

		if (DataUtils.isNotNullOrEmpty(bookId)) {
			params.put("paper.book_id", " '" + bookId + "'");
		}
		if (DataUtils.isNotNullOrEmpty(type)) {
			params.put("paper.type", " '" + type + "'");
		}

		if (DataUtils.isNotNullOrEmpty(periodId)) {
			params.put("paper.period_id", " '" + periodId + "'");
		}
		if (DataUtils.isNotNullOrEmpty(level)) {
			params.put("paper.level", " '" + level + "'");
		}
		if (DataUtils.isNotNullOrEmpty(periodName)) {
			tables.add("period");
			params.put("paper.period_id", "period.id");
			params.put("period.name & like", "'%" + periodName + "%'");
		}
		params.put("@order", "  paper.create_at desc ");
		params.put("@query", " paper.id");
		String table = SQLUtil.convertTable(tables);
		params.put("@table", table);

		return params;
	}


	public static Map<String,Object> getSubjectList(Integer type,String name,Integer status){
		Map<String,Object> params=new HashedMap();
		if (DataUtils.isNotNullOrEmpty(type)) {
			params.put("type", " '" + type + "'");
		}
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("name & like", " '%" + name + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("status", " '" + status + "'");
		}
		params.put("@order", "  sort asc ");
		params.put("@query", " id");

		params.put("@table", " subject ");

		return params;
	}

	public static Map<String,Object> getCollaborateList(String name){
		Map<String,Object> params=new HashedMap();

		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("name & like", " '%" + name + "%'");
		}

		params.put("@order", "  create_at desc ");
		params.put("@query", " id");

		params.put("@table", " collaborate ");

		return params;
	}



	public static Map<String,Object> getTaskList(Integer type,String name,Long subjectId,Long lessonId,Long periodId,
												 Long unitId,Integer level,Integer status,Long bookId,Integer press){
		Map<String,Object> params=new HashedMap();
		Set<String> tables = new HashSet();
		tables.add("task");
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("task.name & like", " '%" + name + "%'");
		}

		if (DataUtils.isNotNullOrEmpty(subjectId)) {
			params.put("task.subject_id", " '" + subjectId + "'");
		}
		if (DataUtils.isNotNullOrEmpty(type)) {
			if (type == 1) {
				params.put("task.type & in ", "(" + type + ",3)");
			}
			if (type == 2) {
				params.put("task.type & in ", "(" + type + ",4)");
			}
		}
		if (DataUtils.isNotNullOrEmpty(lessonId)) {
			params.put("task.lesson_id", " '" + lessonId + "'");
		}
		if (DataUtils.isNotNullOrEmpty(periodId)) {
			params.put("task.period_id", " '" + periodId + "'");
		}
		if (DataUtils.isNotNullOrEmpty(bookId)) {
			params.put("task.book_id", " '" + bookId + "'");
		}
		if (DataUtils.isNotNullOrEmpty(unitId)) {
			tables.add("period");
			params.put("period.unit_id", " '" + unitId + "'");
			params.put("task.period_id", "period.id");
		}
		if (DataUtils.isNotNullOrEmpty(level)) {
			params.put("task.level", " '" + level + "'");
		}
		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("task.status", " '" + status + "'");
		}
		if (DataUtils.isNotNullOrEmpty(press)) {
			tables.add("book");
			params.put("(task.book_id", "book.id and book.press = "+"'" + press + "')");
//			params.put("book.press", "'" + press + "'");
		}
		params.put("@order", "  task.sort ,task.level ");
		params.put("@query", " task.id");
		String table = SQLUtil.convertTable(tables);
		params.put("@table", table);

		return params;
	}




	public static Map<String,Object> getIntroduceList(Integer type,String name,Long subjectId,Long lessonId,Long periodId){
		Map<String,Object> params=new HashedMap();

		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("name & like", " '%" + name + "%'");
		}

		if (DataUtils.isNotNullOrEmpty(subjectId)) {
			params.put("subject_id", " '" + subjectId + "'");
		}
		if (DataUtils.isNotNullOrEmpty(type)) {
			params.put("type", " '" + type + "'");
		}
		if (DataUtils.isNotNullOrEmpty(lessonId)) {
			params.put("lesson_id", " '" + lessonId + "'");
		}
		if (DataUtils.isNotNullOrEmpty(periodId)) {
			params.put("period_id", " '" + periodId + "'");
		}
		params.put("@order", "  create_at desc ");
		params.put("@query", " id");

		params.put("@table", " task ");

		return params;
	}
	public static Map<String,Object> getLessonByGradeType2(Integer level,Long subjectId){
		Map<String,Object> params=new HashedMap();
//		Set<String> tables = new HashSet();
//		tables.add("lesson");
		if (DataUtils.isNotNullOrEmpty(subjectId)) {
			params.put("suject_id", " '" + subjectId + "'");
		}
		if (DataUtils.isNotNullOrEmpty(level)) {
			params.put("name & like", " '%" + level + "%'");
		}

		params.put("@order", "  create_at desc ");
		params.put("@query", " id");

		params.put("@table", " grade_class_relation ");

		return params;
	}
	public static Map<String,Object> getLessonBySubjectIdAndLevel(Integer level,Long subjectId,Integer status){
		Map<String,Object> params=new HashedMap();
//		Set<String> tables = new HashSet();
//		tables.add("lesson");
		if (DataUtils.isNotNullOrEmpty(subjectId)) {
			params.put("subject_id", " '" + subjectId + "'");
		}
		if (DataUtils.isNotNullOrEmpty(level)) {
			params.put("level", " '" + level + "'");
		}
		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("status", " '" + status + "'");
		}

		params.put("@order", "  sort asc ,update_at desc ");
		params.put("@query", " id");

		params.put("@table", " lesson ");

		return params;
	}



	public static Map<String, Object> getUserList(String nick,String mail,String mobile, Integer grade,Integer status, Integer scoreStart,
												  Integer scoreEnd, Integer learnPeriodStart, Integer learnPeriodEnd) {
		Map<String, Object> params = new HashMap<String, Object>();

		if (nick!=null) {
			params.put("nick & like", " '%" + nick + "%'");
		}
		if (mail!=null) {
			params.put("mail & like", " '%" + mail + "%'" );
		}
		if (mobile!=null) {
			params.put("mobile & like", " '%" + mobile + "%'" );
		}
		if (grade!=null) {
			params.put("grade", grade );
		}
		if (status!=null) {
			params.put("status", status);
		}
		if (scoreStart!=null) {
			params.put("score & >=", scoreStart);
		}
		if (scoreEnd!=null) {
			params.put("score & <=", scoreEnd);
		}
		if (learnPeriodStart!=null) {
			params.put("learn_score & >=", learnPeriodStart);
		}
		if (learnPeriodEnd!=null) {
			params.put("learn_score & <=", learnPeriodEnd);
		}


		params.put("@order", " create_at desc");


		params.put("@table"," user");

		return params;

	}

	public static Map<String,Object> getBookSubjectList(String name,Integer status){
		Map<String,Object> params=new HashedMap();
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("subject_name & like", " '%" + name + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(status) ){
			params.put("status", status);
		}
		params.put("@order", "  sort asc,update_at desc ");
		params.put("@query", " id");

		params.put("@table", " book_subject ");

		return params;
	}

	public static Map<String,Object> getBookVersionList(String name,Integer status){
		Map<String,Object> params=new HashedMap();
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("version_name & like", " '%" + name + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(status) ){
			params.put("status", status);
		}
		params.put("@order", " create_at desc ");
		params.put("@query", " id");

		params.put("@table", " book_version ");

		return params;
	}

	public static Map<String,Object> getBookUnitList(String name, Integer status, Long id) {
		Map<String,Object> params=new HashedMap();
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("unit_name & like", " '%" + name + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(status) ){
			params.put("status", status);
		}
		if(DataUtils.isNotNullOrEmpty(id)){
			params.put("book_id", id);
			params.put("@order", " sort asc,update_at desc ");
		}else {
			params.put("@order", " update_at desc ");
		}

		params.put("@query", " id");

		params.put("@table", " book_unit ");

		return params;
	}


	public static Map<String,Object> getAllBookUnitList(String name, Integer status, Long id, Integer grade, Long vid) {
		Map<String,Object> params=new HashedMap();
		Set<String> tables = new HashSet();
		tables.add("book_unit");
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("book_unit.unit_name & like", " '%" + name + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(status) ){
			params.put("book_unit.status", status);
		}
		if(DataUtils.isNotNullOrEmpty(id)){
			params.put("book_unit.book_id", id);
			params.put("@order", " book_unit.sort asc, book_unit.update_at desc ");
		}else {
			params.put("@order", " book_unit.update_at desc ");
		}

		if(DataUtils.isNotNullOrEmpty(grade) || DataUtils.isNotNullOrEmpty(vid)){
			if (DataUtils.isNotNullOrEmpty(grade)) {
				params.put("book.grade ", grade );
			}
			if(DataUtils.isNotNullOrEmpty(vid)){
				params.put("book.press ",  vid );

			}
			params.put(" book.id ", " book_unit.book_id");
			tables.add("book");
		}

		params.put("@query", " book_unit.id");

		String table = SQLUtil.convertTable(tables);
		params.put("@table", table);

		return params;
	}


	public static Map<String,Object> getDictationSubjectList(String name){
		Map<String,Object> params=new HashedMap();
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("name & like", " '%" + name + "%'");
		}

		params.put("@order", "  sort asc,update_at desc ");
		params.put("@query", " id");

		params.put("@table", " dictation_subject ");

		return params;
	}


	public static Map<String, Object> getDictationLessonList(Long sid, Long lid, String name, Integer status, Long vid) {
		Map<String, Object> params = new HashMap<String, Object>();

		Set<String> tables = new HashSet();

		if (name != null) {
			params.put("name & like", " '%" + name + "%'");
		}
		if (sid != null) {
			params.put("sid", "'" + sid + "'");
		}
		if (lid != null) {
			params.put("level_id", "'" + lid + "'");
		}
		if (vid != null) {
			params.put("version_id", vid);
		}
		if (status != null) {
			params.put("status", status);
		}

		params.put("@order", " create_at desc");

		params.put("@query", " id ");

		params.put("@table", " dictation_lesson ");

		return params;

	}


	public static Map<String, Object> getDictationPeriodList(Long sid, Long levelId, String name, Long lid, Long vid) {
		Map<String, Object> params = new HashMap<String, Object>();

		Set<String> tables = new HashSet();
		tables.add("dictation_period");
		params.put(" dictation_lesson.id ", " dictation_period.lid");
		tables.add("dictation_lesson");

		if (name != null) {
			params.put("dictation_period.name & like", " '%" + name + "%'");
		}
		if (sid != null) {
			params.put("dictation_lesson.sid", sid);
		}
		if (levelId != null) {
			params.put("dictation_lesson.level_id", levelId);
		}
		if (vid != null) {
			params.put("dictation_lesson.version_id", vid);
		}
		if (lid != null) {
			params.put("dictation_lesson.id", lid);
		}

		params.put("@order", " dictation_period.create_at desc");

		params.put("@query", " dictation_period.id ");

		String table = SQLUtil.convertTable(tables);
		params.put("@table", table);

		return params;

	}



	public static Map<String, Object> getMemberUserList(String nick,String mail,String mobile, Integer grade,String member, Integer scoreStart,
												  Integer scoreEnd, Integer learnPeriodStart, Integer learnPeriodEnd) {
		Map<String, Object> params = new HashMap<String, Object>();

		Set<String> tables = new HashSet();
		tables.add("user");
		params.put(" user.id ", " user_member_relation.uid");
		tables.add("user_member_relation");

		if (nick!=null) {
			params.put("user.nick & like", " '%" + nick + "%'");
		}
		if (mail!=null) {
			params.put("user.mail & like", " '%" + mail + "%'" );
		}
		if (mobile!=null) {
			params.put("user.mobile & like", " '%" + mobile + "%'" );
		}
		if (grade!=null) {
			params.put("user.grade", grade );
		}
		if (member!=null) {
			params.put("user_member_relation.name & like", " '%" + member + "%'");
		}
		if (scoreStart!=null) {
			params.put("user.score & >=", scoreStart);
		}
		if (scoreEnd!=null) {
			params.put("user.score & <=", scoreEnd);
		}
		if (learnPeriodStart!=null) {
			params.put("user.learn_score & >=", learnPeriodStart);
		}
		if (learnPeriodEnd!=null) {
			params.put("user.learn_score & <=", learnPeriodEnd);
		}

		params.put("@query", " distinct user.id ");

		params.put("@order", " user.create_at desc");


		String table = SQLUtil.convertTable(tables);
		params.put("@table", table);

		return params;

	}

	public static Map<String,Object> getOrderList(Long staticAtStart, Long staticAtEnd){
		Map<String,Object> params=new HashedMap();
		if (DataUtils.isNotNullOrEmpty(staticAtStart)) {
			params.put("static_at & >=", staticAtStart);
		}

		if (DataUtils.isNotNullOrEmpty(staticAtStart)) {
			params.put("static_at & <=", staticAtEnd);
		}

		params.put("@order", "  static_at desc ");
		params.put("@query", " id");

		params.put("@table", " order_statistics ");

		return params;
	}

	public static Map<String,Object> getOrderDailyList(Long staticAt){
		Map<String,Object> params=new HashedMap();
		if (DataUtils.isNotNullOrEmpty(staticAt)) {
			params.put("pay_at & >=", staticAt);
			params.put("pay_at & <=", staticAt + 86400000L);
		}

		params.put("pay_type & >=", "  3 ");
		params.put("status ", "  3 ");
		params.put("@order", "  pay_at desc ");
		params.put("@query", " id");

		params.put("@table", " user_order ");

		return params;
	}

}
