package com.ptteng.course.admin.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyListUtil;
import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.criterion.Order;
import org.restlet.util.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * UserOrder  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class UserOrderController {
    private static final Log orderlog = LogFactory.getLog("order");


    @Autowired
    private OrderStatisticsService orderStatisticsService;
    @Autowired
    private UserOrderService userOrderService;
    @Autowired
    private UserService userService;
    @Autowired
    private PeriodService periodService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private BookService bookService;
    @Autowired
    private MemberService memberService;


    /**
     * @Description 订单统计列表
     * @param
     * @Author: PeiyuFeng
     * @Time 2017/5/30 0:11
     */
    @RequestMapping(value = "/a/u/order/list", method = RequestMethod.GET)
    public String getOrderList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long staticAtStart,
                                   Long staticAtEnd, Integer page, Integer size) throws Exception {

        List<Long> idList = new ArrayList();
        Boolean next = false;

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            Map<String, Object> params = DynamicUtil.getOrderList(staticAtStart, staticAtEnd);
            idList = orderStatisticsService.getIdsByDynamicCondition(OrderStatistics.class, params, start, size);
            List<OrderStatistics> orderStatisticsList = orderStatisticsService.getObjectsByIds(idList);
            orderlog.info("get  orderStatistics data is " + orderStatisticsList.size());

            List<Long> countIds = orderStatisticsService.getIdsByDynamicCondition(OrderStatistics.class, params, 0, Integer.MAX_VALUE);
            Integer orderCount = countIds.size();
            orderlog.info("   total = " + orderCount);
            model.addAttribute("userCount", orderCount);

            Integer totalPage = (((orderCount - 1)) / size) + 1;
            orderlog.info("   totalPage = " + totalPage);

            if (idList != null && idList.size() > 0) {
                if (size.equals(idList.size())) {
                    next = true;
                    idList = idList.subList(0, size);
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);

            model.addAttribute("orderStatisticsList", orderStatisticsList);

        } catch (Throwable t) {
            orderlog.error(t.getMessage());
            orderlog.error("get user list error");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/orderStatistics/json/orderStatisticsListJson";
    }


    /**
     * @Description 订单总体信息
     * @param
     * @Author: PeiyuFeng
     * @Time 2017/5/30 0:11
     */
    @RequestMapping(value = "/a/u/order/info", method = RequestMethod.GET)
    public String getOrderInfo(HttpServletRequest request, HttpServletResponse response, Long staticAtStart,
                               Long staticAtEnd, ModelMap model) throws Exception {

        orderlog.info("get order info");

        try {

            Map<String, Object> params = DynamicUtil.getOrderList(staticAtStart, staticAtEnd);
            List<Long> idList = orderStatisticsService.getIdsByDynamicCondition(OrderStatistics.class, params, 0, Integer.MAX_VALUE);
            List<OrderStatistics> orderStatisticsList = orderStatisticsService.getObjectsByIds(idList);
            orderlog.info("get  orderStatistics data is " + orderStatisticsList.size());

            Integer orderCount = 0;
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal weixinAmount = BigDecimal.ZERO;
            BigDecimal alipayAmount = BigDecimal.ZERO;
            BigDecimal appleAmount = BigDecimal.ZERO;
            Integer vipCount = 0;
            Integer lessonCount = 0;
            Integer paperCount = 0;
            BigDecimal vipAmount = BigDecimal.ZERO;
            BigDecimal lessonAmount = BigDecimal.ZERO;
            BigDecimal paperAmount = BigDecimal.ZERO;
            for(OrderStatistics orderStatistics : orderStatisticsList){
                orderCount = orderCount + orderStatistics.getOrderCount();
                totalAmount =  totalAmount.add(orderStatistics.getTotalAmount());
                weixinAmount =  weixinAmount.add(orderStatistics.getWeixinAmount());
                alipayAmount =  alipayAmount.add(orderStatistics.getAlipayAmount());
                appleAmount =  appleAmount.add(orderStatistics.getAppleAmount());
                vipAmount =  vipAmount.add(orderStatistics.getVipAmount());
                lessonAmount =  lessonAmount.add(orderStatistics.getLessonAmount());
                paperAmount =  paperAmount.add(orderStatistics.getPaperAmount());
                vipCount = vipCount + orderStatistics.getVipCount();
                lessonCount = lessonCount + orderStatistics.getLessonCount();
                paperCount = paperCount + orderStatistics.getPaperCount();
            }

            model.addAttribute("code", 0);
            model.addAttribute("orderCount", orderCount);
            model.addAttribute("totalAmount", totalAmount);
            model.addAttribute("weixinAmount", weixinAmount);
            model.addAttribute("alipayAmount", alipayAmount);
            model.addAttribute("appleAmount", appleAmount);
            model.addAttribute("vipAmount", vipAmount);
            model.addAttribute("lessonAmount", lessonAmount);
            model.addAttribute("paperAmount", paperAmount);
            model.addAttribute("vipCount", vipCount);
            model.addAttribute("lessonCount", lessonCount);
            model.addAttribute("paperCount", paperCount);

        } catch (Throwable t) {
            orderlog.error(t.getMessage());
            orderlog.error("get order info error");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/orderStatistics/json/orderInfo";
    }



    /**
     * @Description 按天统计订单列表
     * @param
     * @Author: PeiyuFeng
     * @Time 2017/5/30 18:02
     */
    @RequestMapping(value = "/a/u/order/daily/list", method = RequestMethod.GET)
    public String getOrderInfo(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long staticAt,
                               Integer page, Integer size) throws Exception {

        orderlog.info("get order daily list : staticAt " + staticAt);

        List<Long> idList = new ArrayList();
        Boolean next = false;

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {

            Map<String, Object> params = DynamicUtil.getOrderDailyList(staticAt);
            idList = userOrderService.getIdsByDynamicCondition(UserOrder.class, params, start, size);
            List<UserOrder> userOrders = userOrderService.getObjectsByIds(idList);
            orderlog.info("get  userOrders data is " + userOrders.size());

            List<Long> uids = MyListUtil.getFieldValueListFromModelList(userOrders, false, UserOrder.class.getDeclaredField("uid"));
            List<User> users = userService.getObjectsByIds(uids);
            Map<Long, String> uid_nick = MyListUtil.convert2Map(User.class.getDeclaredField("id"), User.class.getDeclaredField("nick"), users);

            Map<Long, String> oid_name = new HashMap<>();
            for(UserOrder userOrder : userOrders){
                Long targetId = userOrder.getTargetId();
                Long oid = userOrder.getId();

                switch (userOrder.getBuyType()) {

                    case UserOrder.ORDER_LESSON: {
                        Lesson lesson = lessonService.getObjectById(targetId);
                        oid_name.put(oid, lesson.getName());
                        break;
                    }

                    case UserOrder.ORDER_PERIOD: {
                        Period period = periodService.getObjectById(targetId);
                        oid_name.put(oid, period.getName());
                        break;
                    }

                    case UserOrder.ORDER_LPAPER: {
                        Lesson lesson = lessonService.getObjectById(targetId);
                        oid_name.put(oid, lesson.getName());
                        break;
                    }

                    case UserOrder.ORDER_PPAPER: {
                        Period period = periodService.getObjectById(targetId);
                        oid_name.put(oid, period.getName());
                        break;
                    }

                    case UserOrder.ORDER_BPAPER: {
                        Book book = bookService.getObjectById(targetId);
                        oid_name.put(oid, book.getName());
                        break;
                    }

                    case UserOrder.ORDER_MEMBER: {
                        Member member = memberService.getObjectById(targetId);
                        oid_name.put(oid, member.getName());
                        break;
                    }
                }
            }

            List<Long> countIds = orderStatisticsService.getIdsByDynamicCondition(UserOrder.class, params, 0, Integer.MAX_VALUE);
            Integer orderCount = countIds.size();
            orderlog.info("   total = " + orderCount);
            model.addAttribute("userCount", orderCount);

            Integer totalPage = (((orderCount - 1)) / size) + 1;
            orderlog.info("   totalPage = " + totalPage);

            if (idList != null && idList.size() > 0) {
                if (size.equals(idList.size())) {
                    next = true;
                    idList = idList.subList(0, size);
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("uid_nick", uid_nick);
            model.addAttribute("userOrders", userOrders);
            model.addAttribute("oid_name", oid_name);

        } catch (Throwable t) {
            orderlog.error(t.getMessage());
            orderlog.error("get order info error");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/orderStatistics/json/orderDailyListJson";
    }

    @RequestMapping(value = "/a/u/order/update", method = RequestMethod.PUT)
    public String updateOrderStatistics(HttpServletRequest request, HttpServletResponse response, Long staticAtStart,
                               Long staticAtEnd, ModelMap model) throws Exception {

        orderlog.info("update order info");

        try {
            Map<String, Object> params = DynamicUtil.getOrderList(staticAtStart, staticAtEnd);
            List<Long> idList = orderStatisticsService.getIdsByDynamicCondition(OrderStatistics.class, params, 0, Integer.MAX_VALUE);
            List<OrderStatistics> orderStatisticsList = orderStatisticsService.getObjectsByIds(idList);
            orderlog.info("get  orderStatistics data is " + orderStatisticsList.size());


//            //获取所有订单统计ids
//        List<Long> orderStatisticsIds = orderStatisticsService.getOrderStatisticsIds(0,Integer.MAX_VALUE);
//        orderlog.info("orderStatisticsIds size is" + orderStatisticsIds.size());
//        //获取所有订单统计.statisticsAt
//        List<OrderStatistics> orderStatisticsList = orderStatisticsService.getObjectsByIds(orderStatisticsIds);

        //获取所有范围内订单ids
            Map<String, Object> paramOrder = new HashMap<>();
            if (DataUtils.isNotNullOrEmpty(staticAtEnd)){
                paramOrder.put("pay_at & <=",staticAtEnd);
            }
            if (DataUtils.isNotNullOrEmpty(staticAtStart)){
                paramOrder.put("pay_at & >=",staticAtStart);

            }
            paramOrder.put("pay_type & >=", "  3 ");
            paramOrder.put("status ", "  3 ");
            paramOrder.put("@table","user_order");


        List<Long> orderIds = userOrderService.getIdsByDynamicCondition(UserOrder.class,paramOrder,0,Integer.MAX_VALUE);
        //获取所有订单.pay_by
        List<UserOrder> orderList = userOrderService.getObjectsByIds(orderIds);

        orderlog.info("orderList size is" + orderIds.size());
        for (OrderStatistics orderStatistics:orderStatisticsList){
            //设置订单开始时间
            orderlog.info("orderStatistics id is " + orderStatistics.getId());
            Long statisticsStartAt = orderStatistics.getStaticAt();
            orderlog.info("orderStatistics statisticsEndAt is " + statisticsStartAt);
//          //订单结束时间
            Long statisticsEndAt = statisticsStartAt + 86400000L;
            orderlog.info("orderStatistics statisticsEndAt is" + statisticsEndAt);
            BigDecimal Initial_value = BigDecimal.ZERO;

            orderStatistics.setLessonCount(0);
            orderStatistics.setPaperCount(0);
            orderStatistics.setOrderCount(0);
            orderStatistics.setVipCount(0);
            orderStatistics.setLessonAmount(Initial_value);
            orderStatistics.setVipAmount(Initial_value);
            orderStatistics.setPaperAmount(Initial_value);
            orderStatistics.setTotalAmount(Initial_value);



            orderStatistics.setAlipayAmount(Initial_value);
            orderStatistics.setAppleAmount(Initial_value);
            orderStatistics.setWeixinAmount(Initial_value);




            for (UserOrder userOrder:orderList){
                orderlog.info("userOrder id is " + userOrder.getId());
                Long payAt = userOrder.getPayAt();
                orderlog.info("payAt  is " + payAt);
                //支付类型
                Integer payType = userOrder.getPayType();
                orderlog.info("payType  is " + payType);
                //购买类型
                Integer buyType = userOrder.getBuyType();
                orderlog.info("buyType  is " + buyType);
                //支付状态
                Integer orderStatus = userOrder.getStatus();
                orderlog.info("orderStatus  is " + orderStatus);
                //支付金额
                BigDecimal price = userOrder.getPrice();
                orderlog.info("price  is " + price);
                if ((statisticsStartAt<=payAt) && (payAt<=statisticsEndAt)){
                    orderlog.info("=========时间范围内订单===========" +  userOrder.getId());
                    if( orderStatus.equals(UserOrder.COMPLETED) && payType >= UserOrder.ORDER_LPAPER){
                        orderlog.info("===========已完成订单===========" +  userOrder.getId());

                        orderStatistics.setOrderCount(orderStatistics.getOrderCount() + 1);
                        orderStatistics.setTotalAmount(orderStatistics.getTotalAmount().add(price));
                        switch (buyType) {
                            case UserOrder.ORDER_LESSON: {
                                orderStatistics.setLessonCount(orderStatistics.getLessonCount() + 1);
                                orderStatistics.setLessonAmount(orderStatistics.getLessonAmount().add(price));
                                break;
                            }
                            case UserOrder.ORDER_PERIOD: {
                                orderStatistics.setLessonCount(orderStatistics.getLessonCount() + 1);
                                orderStatistics.setLessonAmount(orderStatistics.getLessonAmount().add(price));
                                break;
                            }
                            case UserOrder.ORDER_LPAPER: {
                                orderStatistics.setPaperCount(orderStatistics.getPaperCount() + 1);
                                orderStatistics.setPaperAmount(orderStatistics.getPaperAmount().add(price));
                                break;
                            }
                            case UserOrder.ORDER_PPAPER: {
                                orderStatistics.setPaperCount(orderStatistics.getPaperCount() + 1);
                                orderStatistics.setPaperAmount(orderStatistics.getPaperAmount().add(price));
                                break;
                            }
                            case UserOrder.ORDER_BPAPER: {
                                orderStatistics.setPaperCount(orderStatistics.getPaperCount() + 1);
                                orderStatistics.setPaperAmount(orderStatistics.getPaperAmount().add(price));
                                break;
                            }
                            case UserOrder.ORDER_MEMBER: {
                                orderStatistics.setVipCount(orderStatistics.getVipCount() + 1);
                                orderStatistics.setVipAmount(orderStatistics.getVipAmount().add(price));
                                break;
                            }
                        }

                        switch (payType) {
                            case UserOrder.PAYMANNER_3: {
                                orderStatistics.setAlipayAmount(orderStatistics.getAlipayAmount().add(price));
                                break;
                            }
                            case UserOrder.PAYMANNER_4: {
                                orderStatistics.setWeixinAmount(orderStatistics.getWeixinAmount().add(price));
                                break;
                            }
                            case UserOrder.PAYMANNER_5: {
                                orderStatistics.setAppleAmount(orderStatistics.getAppleAmount().add(price));
                                break;
                            }
                        }


                    }
                }

            }

        }

        boolean su=orderStatisticsService.updateList(orderStatisticsList);
        if (su){
            orderlog.info("update order statistics success");
        }
        } catch (Throwable t) {
            orderlog.error(t.getMessage());
            orderlog.error("update order info error");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/orderStatistics/json/orderInfo";
    }



}

