package com.ptteng.course.admin.controller;

import com.ptteng.course.admin.interceptor.CookieConstant;
import com.ptteng.learn.admin.model.Constant;
import com.ptteng.learn.admin.model.Manager;
import com.ptteng.learn.admin.model.Role;
import com.ptteng.learn.admin.service.ConstantService;
import com.ptteng.learn.admin.service.ManagerService;
import com.ptteng.learn.admin.service.RoleService;
import com.ptteng.learn.course.model.User;
import com.ptteng.learn.course.service.UserService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.json.GsonUtil;
import com.qding.common.util.pwd.PasswordUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Authentication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Controller
public class SystemController {
	private static final Log log = LogFactory.getLog(SystemController.class);

	@Autowired
	private UserService userService;

	@Autowired
	private ManagerService managerService;

	@Autowired
	private ConstantService constantService;

	@Autowired
	private RoleService roleService;
	
	@Autowired
	private CookieUtil cookieUtil;

	/**
	 * 游戏准备
	 * 
	 * @param request
	 * @param response
	 * @param model
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/login/index")
	public String index(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {
		log.info(" welcome to manager index ");

		return "/index";
	}
	
	/**
	 * 游戏准备
	 * 
	 * @param request
	 * @param response
	 * @param model
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/test")
	public String test(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {
		log.info(" welcome to manager index ");
		return "/test";
	}

	
	@RequestMapping(value = "/nologin")
	public String noLogin(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size) throws Exception {
		log.info(" login wrong ");
		model.addAttribute("code", -2);
		return "/data/json";
	}

	@RequestMapping(value = "/noPermissin")
	public String noPermission(HttpServletRequest request,
						  HttpServletResponse response, ModelMap model, Integer page,
						  Integer size) throws Exception {
		log.info(" login noPermission ");
		model.addAttribute("code",-5020);
		return "/data/json";
	}


//	@RequestMapping(value = "/web/a/publics/del/{id}", method = RequestMethod.DELETE)
//	public String delete(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model, @PathVariable long id) {
//		log.info(" welcome to publics delete ");
//		if (id == 0) {
//			model.addAttribute("success", false);
//			model.addAttribute("message", "未选择公众号");
//			model.addAttribute("result", null);
//			return "/data/json";
//		}
//		try {
//			boolean success = this.publicsService.delete(id);
//			if (success) {
//				model.addAttribute("success", true);
//				model.addAttribute("message", "删除成功");
//				model.addAttribute("result", null);
//			} else {
//				model.addAttribute("success", false);
//				model.addAttribute("message", "删除失败");
//				model.addAttribute("result", null);
//			}
//		} catch (Throwable t) {
//			log.error(t.getMessage());
//			log.error("delete publics list error,id is  " + id);
//			model.addAttribute("success", false);
//			model.addAttribute("message", "删除失败");
//			model.addAttribute("result", null);
//		}
//
//		return "/data/json";
//	}
//

	/**
	 * 管理员登录
	 * @param request
	 * @param response
	 * @param model
	 * @param name
	 * @param pwd
	 * @return
	 */
	@RequestMapping(value = "/a/login", method = RequestMethod.POST)
	public String login(HttpServletRequest request, HttpServletResponse response, ModelMap model, String name, String pwd) {
		log.info(" welcome to manager login ");
		
		try {
			List<Long> managerIds = this.managerService.getManagerIdsByName(name, 0, Integer.MAX_VALUE);
			log.info(name+" get managerIDs  "+managerIds);
			if (managerIds==null || managerIds.isEmpty() || managerIds.size()>1) {
				log.info(name +" not get any user ");
				model.addAttribute("code", -7009);

			} else {
				log.info(name +"  get user "+ managerIds.get(0));
				Manager manager = this.managerService.getObjectById(managerIds.get(0));
				if (PasswordUtils.authenticatePassword(manager.getPwd(), pwd) && manager.getStatus().equals(Manager.STATUS_USING)) {
					log.info(managerIds.get(0)+" login ");
					Map<String,String> maps=new HashMap();
					maps.put(CookieConstant.Cookie_WEB_ManagerName, manager.getName());
					
					
					//maps.put(CookieConstant.Cookie_WEB_PuserPublicsHash, manager.getPublicsHash());
					//maps.put(CookieConstant.Cookie_WEB_PuserPublicsHash, "-2042484612");
					
					maps.put(CookieUtil.USER_ID, manager.getId() + "");
					cookieUtil.setIdentity(request, response, maps, manager.getId());

				    Role role = 	roleService.getObjectById(manager.getRoleID());
				    if(role==null){
				    	log.error("not get any role  " + manager.getRoleID());
						model.addAttribute("code", -7001);
						return "/data/json";
				    	
				    }
					model.addAttribute("code", 0);
                    model.addAttribute("manager", manager);
					model.addAttribute("role",role);
					log.info(managerIds.get(0)+" login over ");
				} else {
					log.info(managerIds.get(0)+" has wrong pwd ");
					model.addAttribute("code", -7008);
					model.addAttribute("result", null);
				}
			}
			
		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("manager login error,name is  " + name);
			model.addAttribute("code", -1);
			model.addAttribute("result", null);
		}

		return "/data/login";
	}

	/**
	 * 退出系统
	 * @param request
	 * @param response
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "/a/logout", method = RequestMethod.POST)
	public String logout(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
		log.info(" welcome to manager logout ");
		
		try {
			cookieUtil.clearCookie(response);
			
			model.addAttribute("code", 0);
			model.addAttribute("result", "/login/index");
			
		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("manager logout error  ");
			model.addAttribute("code", -1);
			model.addAttribute("result", null);
		}

		return "/data/json";
	}

	/**
	 *返回登陆用户信息
	 * @param request
	 * @param response
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "/a/u/manager", method = RequestMethod.GET)
	public String getUser(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
		log.info(" welcome to manager getmanager ");
		
		try {
			if (null != cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID)) {
				String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
				String userName = cookieUtil.getKeyIdentity(request, CookieConstant.Cookie_WEB_ManagerName);
				String publicsHash = cookieUtil.getKeyIdentity(request, CookieConstant.Cookie_WEB_ManagerPublicsHash);
				log.info("userid:"+userId+"userName:"+userName+"publishHash:"+publicsHash);
				Map<String,String> maps=new HashMap();
				maps.put(CookieConstant.Cookie_WEB_ManagerName, userName);
				maps.put(CookieConstant.Cookie_WEB_ManagerPublicsHash, publicsHash);
				maps.put(CookieUtil.USER_ID, userId);
				Manager manager = managerService.getObjectById(Long.valueOf(userId));
				
				model.addAttribute("code", 0);
				model.addAttribute("result", GsonUtil.toJson(manager));
			} else {
				model.addAttribute("code", -5001);
				model.addAttribute("result", null);
			}
		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("manager logout error  ");
			model.addAttribute("code", -1);
			model.addAttribute("result", null);
		}

		return "/data/json";
	}
//
//	@RequestMapping(value = "/web/a/publics/add", method = RequestMethod.POST)
//	public String update(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model, String name,
//			String appID, String appSecret, String account, String pwd) {
//		log.info(" welcome to publics add ");
//		log.info("name=" + name + "   account=" + account + "    appID="
//				+ appID + "    appSecret=" + appSecret + "    pwd=" + pwd);
//		try {
//			Publics publics = new Publics();
//			publics.setName(name);
//			publics.setAccount(account);
//			publics.setAppID(appID);
//			publics.setAppSecret(appSecret);
//			publics.setPwd(pwd);
//			publics.setToken(DataUtils.getSimpleUUID());
//			publics.setHash(DataUtils.hash(appID + appSecret));
//			log.info("to add publics = " + publics.toString());
//			long id = this.publicsService.insert(publics);
//			log.info("id==="+id);
//			if (id > 0) {
//				model.addAttribute("success", true);
//				model.addAttribute("message", "新增成功");
//				model.addAttribute("result", null);
//			} else {
//				model.addAttribute("success", false);
//				model.addAttribute("message", "新增失败");
//				model.addAttribute("result", null);
//			}
//		} catch (Throwable t) {
//			log.error(t.getMessage());
//			log.error("add publics list error");
//			model.addAttribute("success", false);
//			model.addAttribute("message", "新增失败");
//			model.addAttribute("result", null);
//		}
//
//		return "/data/json";
//	}

//	@RequestMapping(value = "/clear/sign/test", method = RequestMethod.GET)
//	public String update(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
//		log.info(" clear sign test");
//
//		try {
//			log.info("==========1、遍历用户==========");
//			List<Long> uids = userService.getUserIds(0, Integer.MAX_VALUE);
//			List<User> users = userService.getObjectsByIds(uids);
//
//			log.info("==========2、清空签到信息==========");
//			for (User user : users) {
//				log.info("uid is : " + user.getId());
//
//				user.setSign(User.NO_SIGN);
//				userService.update(user);
//				log.info("clear success");
//			}
//
//			model.addAttribute("code", 0);
//
//		} catch (Throwable t) {
//			log.error(t.getMessage());
//			log.error("clear sign test error");
//		}
//
//		return "/common/success";
//	}

	/**
	 * @Description 设置后台默认年级
	 * @param grade 默认年级
	 * @Author: PeiyuFeng
	 * @Time 2017/3/8 10:54
	 */
	@RequestMapping(value = "/a/u/default/grade", method = RequestMethod.PUT)
	public String update(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer grade) {
		log.info("manager set default grade : " + grade);

		try {
			log.info("==========1、校验参数是否为空==========");
			if(DataUtils.isNullOrEmpty(grade)){
				model.addAttribute("code", -1000);
				return "/common/success";
			}else {
				log.info("manager set default grade : " + grade);
			}

			log.info("==========2、校验年级是否合法==========");
			if(grade > 6 || grade < 0){
				log.info("grade params " + grade + " illegal ");
				model.addAttribute("code", -5024);
				return "/common/success";
			}else {
				log.info("grade params " + grade + " legal ");
			}

			Long defaultGrade = constantService.getConstantIdByKeyAndType("grade", "default");
			if(null == defaultGrade){
				Constant constant = new Constant();
				constant.setValue(grade.toString());
				constant.setMykey("grade");
				constant.setType("default");
				constantService.insert(constant);
			}else {
				Constant defaultGradeObj = constantService.getObjectById(defaultGrade);
				defaultGradeObj.setValue(grade.toString());
				defaultGradeObj.setMykey("grade");
				defaultGradeObj.setType("default");
				constantService.update(defaultGradeObj);
			}

			log.info("update default grade " + grade + " success ");

			model.addAttribute("code", 0);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("manager set default grade error");
		}

		return "/common/success";
	}


	/**
	 * @Description 获取后台默认年级
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/3/8 10:55
	 */
	@RequestMapping(value = "/a/u/default/grade", method = RequestMethod.GET)
	public String update(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
		log.info("manager get default grade ");

		try {
			String grade = "";
			Long defaultGrade = constantService.getConstantIdByKeyAndType("grade", "default");
			if(null == defaultGrade){
				log.info("no default grade");
				model.addAttribute("code", -11000);
				return "common/success";
			}else {
				grade = constantService.getValue("grade", "default");
			}

			log.info("update default grade " + grade + " success ");

			model.addAttribute("code", 0);
			model.addAttribute("grade", grade);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("manager get default grade error");
		}

		return "/learn-course-service/system/defaultGrade";
	}
}
