package com.ptteng.course.util;

import com.ptteng.learn.common.model.Message;
import com.ptteng.learn.common.model.UserMessageRelation;
import com.ptteng.learn.common.service.MessageService;
import com.ptteng.learn.common.service.UserMessageRelationService;
import com.ptteng.learn.course.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * Created by Administrator on 2016/8/9.
 */
public class MessageUpUtil {
    @Autowired
    private MessageService messageService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserMessageRelationService userMessageRelationService;
    public void messageUp(Message message) throws Exception{

            message.setPublishAt(System.currentTimeMillis());
            message.setStatus(Message.status_normal);
            List<Long> userIds = null;
            UserMessageRelation userMessageRelation = new UserMessageRelation();
            userMessageRelation.setTargetId(message.getId());
            if (message.getGrade() == 7) {
                userIds = userService.getUserIds(0, Integer.MAX_VALUE);
            } else {
                userIds = userService.getUserIdByGrade(message.getGrade());
            }
            for (Long userId : userIds) {
                userMessageRelation.setUserId(userId);
                userMessageRelationService.insert(userMessageRelation);
            }

    }
}
