package com.ptteng.course.util;


import com.gemantic.common.util.MyTimeUtil;
import com.ptteng.learn.course.model.OrderStatistics;
import com.ptteng.learn.course.model.User;
import com.ptteng.learn.course.model.UserOrder;
import com.ptteng.learn.course.service.OrderStatisticsService;
import com.ptteng.learn.course.service.UserService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;


/**
 * Created by asus on 2016/4/14.
 */
public class ClearSignUtil {

    @Autowired
    private UserService userService;
    @Autowired
    OrderStatisticsService orderStatisticsService;

    private Log log = LogFactory.getLog("ClearSignUtil");

    public void clearSign() throws Exception {

        log.info("==========1、遍历用户==========");
        List<Long> uids = userService.getUserIds(0, Integer.MAX_VALUE);
        List<User> users = userService.getObjectsByIds(uids);

        log.info("==========2、清空签到信息==========");
        for (User user : users) {
            log.info("uid is : " + user.getId());

            user.setSign(User.NO_SIGN);
            userService.update(user);
            log.info("clear success");
        }

        log.info("==========3、无订单时添加空订单统计==========");

        Long staticAt = MyTimeUtil.getTodayZeroTimeMillions();

        Long sid = orderStatisticsService.getOrderStatisticsIdByStaticAt(staticAt);
        OrderStatistics orderStatistics = orderStatisticsService.getObjectById(sid);

        if (orderStatistics != null) {
            log.info(" today order statistics exist ");
        } else {
            log.info(" new  order statistics ");
            orderStatistics = new OrderStatistics();
            orderStatistics.setStaticAt(staticAt);
            orderStatisticsService.insert(orderStatistics);
        }
    }


    public static void main(String[] args) {
        try {
            ClearSignUtil clearSignUtil = new ClearSignUtil();
            clearSignUtil.clearSign();
        }catch (Exception e){
            System.out.println(e);
        }

    }
}
