package com.ptteng.course.admin.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyListUtil;
import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.admin.model.Constant;
import com.ptteng.learn.admin.service.ConstantService;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import com.sun.org.apache.xpath.internal.operations.Bool;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * DictationPeriod  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class DictationPeriodController {
    private static final Log log = LogFactory.getLog(DictationPeriodController.class);

    @Autowired
    private DictationPeriodService dictationPeriodService;

    @Autowired
    private DictationLessonService dictationLessonService;

    @Autowired
    private DictationSubjectService dictationSubjectService;

    @Autowired
    private DperiodTypeRelationService dperiodTypeRelationService;

    @Autowired
    private DictationLevelService dictationLevelService;

    @Autowired
    private BookVersionService bookVersionService;

    @Autowired
    private ConstantService constantService;

    @Autowired
    private CookieUtil cookieUtil;


    /**
     * @param
     * @Description 听写课时列表
     * @Author: PeiyuFeng
     * @Time 2017/5/20 13:57
     */
    @RequestMapping(value = "/a/u/dictation/period/list", method = RequestMethod.GET)
    public String getDictationLessonList(HttpServletRequest request, HttpServletResponse response,
                                         ModelMap model, Integer page, Integer size, Long subject, Long level, String name,
                                         Long lid, Long version) throws Exception {

        log.info("get dictationPeriod list subject : " + subject + " level : " + level + " name : " + name + " lid : " + lid
                + " version : " + version);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {

            Integer total = 0;
            List<DictationPeriod> periodList = null;
            Map<String, Object> param = DynamicUtil.getDictationPeriodList(subject, level, name, lid, version);

            List<Long> ids = dictationPeriodService.getIdsByDynamicCondition(DictationPeriod.class, param, start, size);
            List<Long> count = dictationPeriodService.getIdsByDynamicCondition(DictationPeriod.class, param, 0, Integer.MAX_VALUE);
            periodList = dictationPeriodService.getObjectsByIds(ids);
            total = count.size();

            List<Long> lids = MyListUtil.getFieldValueListFromModelList(periodList, false, DictationPeriod.class.getDeclaredField("lid"));
            List<DictationLesson> lessons = dictationLessonService.getObjectsByIds(lids);
            Map<Long, String> id_sid = MyListUtil.convert2Map(DictationLesson.class.getDeclaredField("id"), DictationLesson.class.getDeclaredField("sid"), lessons);
            Map<Long, String> id_levelId = MyListUtil.convert2Map(DictationLesson.class.getDeclaredField("id"), DictationLesson.class.getDeclaredField("levelId"), lessons);
            Map<Long, String> id_versionId = MyListUtil.convert2Map(DictationLesson.class.getDeclaredField("id"), DictationLesson.class.getDeclaredField("versionId"), lessons);
            Map<Long, String> id_lessonName = MyListUtil.convert2Map(DictationLesson.class.getDeclaredField("id"), DictationLesson.class.getDeclaredField("name"), lessons);
            Map<Long, String> id_versionStatus = MyListUtil.convert2Map(DictationLesson.class.getDeclaredField("id"), DictationLesson.class.getDeclaredField("versionStatus"), lessons);

            List<Long> sids = MyListUtil.getFieldValueListFromModelList(lessons, false, DictationLesson.class.getDeclaredField("sid"));
            List<DictationSubject> subjects = dictationSubjectService.getObjectsByIds(sids);
            Map<Long, String> id_subjectName = MyListUtil.convert2Map(DictationSubject.class.getDeclaredField("id"), DictationSubject.class.getDeclaredField("name"), subjects);

            List<Long> levelIds = MyListUtil.getFieldValueListFromModelList(lessons, false, DictationLesson.class.getDeclaredField("levelId"));
            List<DictationLevel> levels = dictationLevelService.getObjectsByIds(levelIds);
            Map<Long, String> id_levelName = MyListUtil.convert2Map(DictationLevel.class.getDeclaredField("id"), DictationLevel.class.getDeclaredField("name"), levels);

            List<Long> versionIds = MyListUtil.getFieldValueListFromModelList(lessons, false, DictationLesson.class.getDeclaredField("versionId"));
            List<BookVersion> bookVersions = bookVersionService.getObjectsByIds(versionIds);
            Map<Long, String> id_version = MyListUtil.convert2Map(BookVersion.class.getDeclaredField("id"), BookVersion.class.getDeclaredField("versionName"), bookVersions);

            model.addAttribute("code", 0);
            boolean next = false;
            if (ids.size() + start + 1 <= total) {
                next = true;
            }
            Integer totalPage = (total - 1) / size + 1;

            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("dictationPeriodList", periodList);
            model.addAttribute("id_levelName", id_levelName);
            model.addAttribute("id_version", id_version);
            model.addAttribute("id_subjectName", id_subjectName);
            model.addAttribute("id_sid", id_sid);
            model.addAttribute("id_levelId", id_levelId);
            model.addAttribute("id_versionId", id_versionId);
            model.addAttribute("id_lessonName", id_lessonName);
            model.addAttribute("id_versionStatus", id_versionStatus);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get dictationPeriod list error ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/dictationPeriod/json/dictationPeriodListJson";
    }


    /**
     * @param
     * @Description 听写课时详情
     * @Author: PeiyuFeng
     * @Time 2017/5/17 14:40
     */
    @RequestMapping(value = "/a/u/dictation/period/detail/{id}", method = RequestMethod.GET)
    public String getDictationPeriod(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            DictationPeriod dictationPeriod = dictationPeriodService.getObjectById(id);
            if (dictationPeriod == null) {
                log.info("period not exist");
                model.addAttribute("code", -2112);
                return "/common/success";
            } else {
                log.info("get dictationPeriod data is " + dictationPeriod);
            }

            DictationLesson lesson = dictationLessonService.getObjectById(dictationPeriod.getLid());
            if (lesson == null) {
                log.info("lesson not exist");
                model.addAttribute("code", -2100);
                return "/common/success";
            } else {
                log.info("get dictation lesson data is " + lesson);
            }

            DictationSubject subject = dictationSubjectService.getObjectById(lesson.getSid());
            if (subject == null) {
                log.info("subject not exist");
                model.addAttribute("code", -2106);
                return "/common/success";
            } else {
                log.info("get dictation subject data is " + subject);
            }

            List<Long> typeIds = new ArrayList<>();
            List<Long> relationIds = dperiodTypeRelationService.getIdsByPeriodId(id, 0, Integer.MAX_VALUE);
            List<DperiodTypeRelation> relations = dperiodTypeRelationService.getObjectsByIds(relationIds);
            for (DperiodTypeRelation relation : relations) {
                typeIds.add(relation.getTypeId());
            }

            List<Constant> types = constantService.getObjectsByIds(typeIds);

            model.addAttribute("code", 0);

            model.addAttribute("dictationPeriod", dictationPeriod);
            model.addAttribute("lessonName", lesson.getName());
            model.addAttribute("subjectName", subject.getName());
            model.addAttribute("types", types);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get dictationPeriod error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/dictationPeriod/json/dictationPeriodDetailJson";
    }


    /**
     * @param
     * @Description 新增听写课时
     * @Author: PeiyuFeng
     * @Time 2017/5/20 10:41
     */
    @RequestMapping(value = "/a/u/dictation/period", method = RequestMethod.POST)
    public String addPeriod(HttpServletRequest request,
                            HttpServletResponse response, ModelMap model, DictationPeriod period, Long[] ids) throws Exception {

        log.info("add period : period= " + period + " type id : " + ids);

        if (period == null) {
            log.info("period is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        if (period.getLid() == null || period.getName() == null || period.getLeadStatus() == null || period.getVoiceJson() == null) {
            model.addAttribute("code", -1000);
            return "/common/success";
        } else {
            //校验是否展示版本状态
            if (!(period.getLeadStatus().equals(DictationPeriod.LEAD_STATUS_NORMAL) ||
                    period.getLeadStatus().equals(DictationPeriod.LEAD_STATUS_FORBIDDEN))) {
                log.info("lead status wrong");
                model.addAttribute("code", -2110);
                return "/common/success";
            }

            //校验课程id
            DictationLesson lesson = dictationLessonService.getObjectById(period.getLid());
            if (lesson == null) {
                log.info("lesson not exist");
                model.addAttribute("code", -2106);
                return "/common/success";
            } else {
                log.info("get lesson name info : " + lesson.getName());
            }
        }

        try {

            period.setId(null);
            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

            Integer sort = getMaxSort(period.getLid());
            period.setSort(sort);
            period.setCreateAt(System.currentTimeMillis());
            period.setCreateBy(Long.parseLong(userId));
            Long pid = dictationPeriodService.insert(period);

            if (pid != null) {
                List<DperiodTypeRelation> relations = new ArrayList<>();
                List<Long> cidList = Arrays.asList(ids);
                for (Long cid : cidList) {
                    Constant constant = constantService.getObjectById(cid);
                    if (constant != null) {
                        String contentType = constant.getType();
                        if (contentType.equals("dictationType")) {
                            log.info("type verify OK");
                            DperiodTypeRelation relation = new DperiodTypeRelation();
                            relation.setPeriodId(pid);
                            relation.setTypeId(cid);
                            relations.add(relation);
                        } else {
                            log.info("content not dictationType");
                            model.addAttribute("code", -2111);
                            return "/common/success";
                        }
                    } else {
                        log.info("no such constant");
                        model.addAttribute("code", -2111);
                        return "/common/success";
                    }
                }

                dperiodTypeRelationService.insertList(relations);
                log.info("relations insert success");
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add period error");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param
     * @Description 编辑听写课时
     * @Author: PeiyuFeng
     * @Time 2017/5/20 11:52
     */
    @RequestMapping(value = "/a/u/dictation/period/{id}", method = RequestMethod.PUT)
    public String updatePeriod(HttpServletRequest request, HttpServletResponse response, ModelMap model, DictationPeriod period,
                               Long[] ids, @PathVariable Long id) throws Exception {

        log.info("update period : period= " + period + " type id : " + ids);

        if (period == null) {
            log.info("period is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        if (period.getName() == null || period.getLeadContent() == null || period.getLeadStatus() == null
                || period.getLeadUrl() == null || period.getVoiceJson() == null) {
            model.addAttribute("code", -1000);
            return "/common/success";
        } else {
            //校验是否展示版本状态
            if (!(period.getLeadStatus().equals(DictationPeriod.LEAD_STATUS_NORMAL) ||
                    period.getLeadStatus().equals(DictationPeriod.LEAD_STATUS_FORBIDDEN))) {
                log.info("lead status wrong");
                model.addAttribute("code", -2110);
                return "/common/success";
            } else {
                log.info("lead status OK");
            }
        }

        try {
            DictationPeriod oldPeriod = dictationPeriodService.getObjectById(id);
            if (oldPeriod == null) {
                log.info("period is null");
                model.addAttribute("code", -2112);
                return "/common/success";
            }

            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            oldPeriod.setName(period.getName());
            oldPeriod.setLeadContent(period.getLeadContent());
            oldPeriod.setLeadStatus(period.getLeadStatus());
            oldPeriod.setLeadUrl(period.getLeadUrl());
            oldPeriod.setVoiceJson(period.getVoiceJson());
            oldPeriod.setCreateBy(Long.parseLong(userId));
            log.info("update old period : " + oldPeriod);
            dictationPeriodService.update(oldPeriod);
            log.info("update old period success");

            List<Long> oldRelationIds = dperiodTypeRelationService.getIdsByPeriodId(id, 0, Integer.MAX_VALUE);
            dperiodTypeRelationService.deleteList(DperiodTypeRelation.class, oldRelationIds);
            log.info("old relations insert success");

            List<DperiodTypeRelation> relations = new ArrayList<>();
            List<Long> cidList = Arrays.asList(ids);
            for (Long cid : cidList) {
                Constant constant = constantService.getObjectById(cid);
                if (constant != null) {
                    String contentType = constant.getType();
                    if (contentType.equals("dictationType")) {
                        log.info("type verify OK");
                        DperiodTypeRelation relation = new DperiodTypeRelation();
                        relation.setPeriodId(id);
                        relation.setTypeId(cid);
                        relations.add(relation);
                    } else {
                        log.info("content not dictationType");
                        model.addAttribute("code", -2111);
                        return "/common/success";
                    }
                } else {
                    log.info("no such constant");
                    model.addAttribute("code", -2111);
                    return "/common/success";
                }
            }

            dperiodTypeRelationService.insertList(relations);
            log.info("relations insert success");


            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add period error");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param
     * @Description 听写种类常量列表
     * @Author: PeiyuFeng
     * @Time 2017/5/17 14:40
     */
    @RequestMapping(value = "/a/u/dictation/type/list", method = RequestMethod.GET)
    public String getDictationTypeList(HttpServletRequest request,
                                       HttpServletResponse response, ModelMap model) throws Exception {

        log.info("get dictation type list");

        try {

            List<Long> ids = constantService.getConstantIdsByType("dictationType", 0, Integer.MAX_VALUE);
            List<Constant> types = constantService.getObjectsByIds(ids);

            model.addAttribute("code", 0);
            model.addAttribute("total", types.size());
            model.addAttribute("types", types);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get dictation type list error");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/dictationPeriod/json/dictationType";
    }


    /**
     * @param
     * @Description 新增听写种类常量
     * @Author: PeiyuFeng
     * @Time 2017/5/17 14:40
     */
    @RequestMapping(value = "/a/u/dictation/type", method = RequestMethod.POST)
    public String addDictationType(HttpServletRequest request, HttpServletResponse response, ModelMap model, String name,
                                   String img) throws Exception {

        log.info("add dictation type , name : " + name + " img : " + img);

        if (DataUtils.isNullOrEmpty(name)) {
            log.info("params is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        try {

            Long sameNameId = constantService.getConstantIdByKeyAndType(name, "dictationType");
            if (sameNameId == null) {
                Constant constant = new Constant();
                constant.setMykey(name);
                constant.setValue(img);
                constant.setType("dictationType");
                constantService.insert(constant);
            } else {
                log.info("same name dictationType exist");
                model.addAttribute("code", -2113);
                return "/common/success";
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add dictation type error , name : " + name + " img : " + img);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param
     * @Description 编辑听写种类常量
     * @Author: PeiyuFeng
     * @Time 2017/5/26 14:47
     */
    @RequestMapping(value = "/a/u/dictation/type/{id}", method = RequestMethod.PUT)
    public String addDictationType(HttpServletRequest request, HttpServletResponse response, ModelMap model, String name,
                                   String img, @PathVariable Long id) throws Exception {

        log.info("update dictation type : " + id + " , name : " + name + " img : " + img);

        if (DataUtils.isNullOrEmpty(name)) {
            log.info("params is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        try {

            Long sameNameId = constantService.getConstantIdByKeyAndType(name, "dictationType");
            if (sameNameId == null || sameNameId.equals(id)) {
                Constant constant = constantService.getObjectById(id);
                if (constant == null) {
                    log.info("constant : " + id + " not exist");
                    model.addAttribute("code", -2111);
                    return "/common/success";
                } else {
                    if ("dictationType".equals(constant.getType())) {
                        constant.setMykey(name);
                        constant.setValue(img);
                        constantService.update(constant);
                    } else {
                        log.info("constant : " + id + " not dictationType");
                        model.addAttribute("code", -2114);
                        return "/common/success";
                    }
                }
            } else {
                log.info("same name dictationType exist");
                model.addAttribute("code", -2113);
                return "/common/success";
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update dictation type error , name : " + name + " img : " + img);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param
     * @Description 删除听写种类常量
     * @Author: PeiyuFeng
     * @Time 2017/5/26 14:58
     */
    @RequestMapping(value = "/a/u/dictation/type/{id}", method = RequestMethod.DELETE)
    public String deleteDictationType(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                      @PathVariable Long id) throws Exception {

        log.info("delete dictation type : " + id);

        try {
            
            Constant constant = constantService.getObjectById(id);
            if (constant == null) {
                log.info("constant : " + id + " not exist");
                model.addAttribute("code", -2111);
                return "/common/success";
            } else {
                if ("dictationType".equals(constant.getType())) {
                    List<Long> rids = dperiodTypeRelationService.getIdsByTypeId(id, 0 , 1);
                    if(CollectionUtils.isEmpty(rids)){
                        constantService.delete(id);
                        log.info("delete dictationType : " + id + " success");
                    }else {
                        log.info("constant : " + id + " is using");
                        model.addAttribute("code", -2115);
                        return "/common/success";
                    }
                } else {
                    log.info("constant : " + id + " not dictationType");
                    model.addAttribute("code", -2114);
                    return "/common/success";
                }
            }
            
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete dictation type : " + id + " error");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @Description 校验语言类型是否使用中
     * @param 
     * @Author: PeiyuFeng
     * @Time 2017/5/26 16:16
     */
    @RequestMapping(value = "/a/u/dictation/type/status/{id}", method = RequestMethod.GET)
    public String getDictationTypeStatus(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                      @PathVariable Long id) throws Exception {

        log.info("get dictation type status : " + id);

        try {

            Boolean useStatus = false;
            Constant constant = constantService.getObjectById(id);
            if (constant == null) {
                log.info("constant : " + id + " not exist");
                model.addAttribute("code", -2111);
                return "/common/success";
            } else {
                if ("dictationType".equals(constant.getType())) {
                    List<Long> rids = dperiodTypeRelationService.getIdsByTypeId(id, 0 , 1);
                    if(CollectionUtils.isEmpty(rids)){
                        useStatus = false;
                        log.info("dictationType : " + id + " no use");
                    }else {
                        useStatus = true;
                        log.info("dictationType : " + id + " is using");
                    }
                } else {
                    log.info("constant : " + id + " not dictationType");
                    model.addAttribute("code", -2114);
                    return "/common/success";
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("useStatus", useStatus);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete dictation type : " + id + " error");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/dictationPeriod/json/useStatus";
    }


    private Integer getMaxSort(Long lid) throws ServiceException, ServiceDaoException {
        List<Long> maxs = dictationPeriodService.getIdsByLidOrderBySort(lid);
        Integer max = 0;
        if (CollectionUtils.isEmpty(maxs)) {
            log.info("first order ");

        } else {
            Long maxID = maxs.get(maxs.size() - 1);
            max = this.dictationPeriodService.getObjectById(maxID).getSort();
            log.info("quiz max order is " + max);
        }
        return max + 1;
    }
}

