package com.ptteng.course.admin.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.course.model.Collaborate;
import com.ptteng.learn.course.service.CollaborateService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import static com.ptteng.learn.course.model.Collaborate.Off;
import static com.ptteng.learn.course.model.Collaborate.On;


/**
 * Collaborate  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class CollaborateController {
	private static final Log log = LogFactory.getLog(CollaborateController.class);

	@Autowired
	private CollaborateService collaborateService;


    /**
	 * 查看合作机构详情
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
     */
	@RequestMapping(value = "/a/u/collaborate/{id}", method = RequestMethod.GET)
	public String getCollaborateJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Collaborate collaborate = collaborateService.getObjectById(id);
			log.info("get collaborate data is " + collaborate);

			model.addAttribute("code", 0);

			model.addAttribute("collaborate", collaborate);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get collaborate error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/collaborate/json/collaborateDetailJson";
	}

	@RequestMapping(value = "/a/u/collaborate/{id}", method = RequestMethod.PUT)
	public String updateCollaborateJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Collaborate collaborate) throws Exception {
		
		log.info("update collaborate : collaborate= " + collaborate);
		if (collaborate.getName() == null) {
			model.addAttribute("code", -5005);
			return "/common/success";
		}
		if (collaborate.getImg() == null) {
			model.addAttribute("code", -5014);
			return "/common/success";
		}
		try {
			
			collaborateService.update(collaborate);

			model.addAttribute("code", 0);

			model.addAttribute("collaborate", collaborate);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update collaborate error,id is  " + collaborate.getId());
			model.addAttribute("code", -6003);

		}

		return "/common/success";
	}

	/**
	 * 新增合作机构
	 * @param request
	 * @param response
	 * @param model
	 * @param collaborate
	 * @return
     * @throws Exception
     */
	@RequestMapping(value = "/a/u/collaborate", method = RequestMethod.POST)
	public String addCollaborateJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Collaborate collaborate) throws Exception {
		
		log.info("update collaborate : collaborate= " + collaborate);
		if (collaborate.getName() == null) {
			model.addAttribute("code", -5005);
			return "/common/success";
		}
		if (collaborate.getImg() == null) {
			model.addAttribute("code", -5014);
			return "/common/success";
		}
		try { 
			collaborate.setId(null);

			collaborateService.insert(collaborate);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add collaborate error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	/**
	 * 删除合作机构
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
     * @throws Exception
     */
	@RequestMapping(value = "/a/u/collaborate/{id}", method = RequestMethod.DELETE)
	public String deleteCollaborateJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete collaborate : id= " + id);
		try {
			collaborateService.delete(id);

			log.info("add collaborate success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete collaborate error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/u/collaborate/list", method = RequestMethod.GET)
	public String getMultiCollaborateJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,String name,Integer page,Integer size)
			throws Exception {
			
		List<Long> idList = new ArrayList();
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		try {
			Map<String, Object> param = DynamicUtil.getCollaborateList(name);
			idList=collaborateService.getIdsByDynamicCondition(Collaborate.class, param, start, size);
			List<Long> count=collaborateService.getIdsByDynamicCondition(Collaborate.class,param,0,Integer.MAX_VALUE);
			List<Collaborate> collaborateList = collaborateService.getObjectsByIds(idList);
			log.info("get  collaborate data is " + collaborateList);
			Integer total=count.size();
			Boolean next=false;
			Integer nex=start+size;
			if (total>nex) {

				next=true;
			}
			model.addAttribute("next",next);


			Integer totalPage=1;
			if (total > 0) {

				totalPage=(total-1)/size+1;
			}
			model.addAttribute("total", total);
			model.addAttribute("totalPage",totalPage);
			model.addAttribute("size",size);
			model.addAttribute("page", page);
			model.addAttribute("code",0);
			model.addAttribute("next",next);
			model.addAttribute("collaborateList", collaborateList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get collaborate error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/collaborate/json/collaborateListJson";
	}


	/**
	 * 冻结合作机构
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
     * @throws Exception
     */
	@RequestMapping(value = "/a/u/collaborate/updown/{id}", method = RequestMethod.PUT)
	public String frezeCollaborate(HttpServletRequest request,
										HttpServletResponse response, ModelMap model,@PathVariable Long id) throws Exception {

		log.info("freze collaborate : id= " + id);

		try {
			Collaborate collaborate= collaborateService.getObjectById(id);
			if (collaborate == null) {
				model.addAttribute("code", 2);
				return "/commom/success";
			}
			if (collaborate.getStatus() == 1) {
				collaborate.setStatus(Off);
				model.addAttribute("code",6);
			}else {
				collaborate.setStatus(On);
				model.addAttribute("code",5);
			}
			collaborateService.update(collaborate);
			log.info(collaborate.getStatus());

			model.addAttribute("collaborate", collaborate);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("freze collaborate error,id is  " + id);
			model.addAttribute("code", -6003);

		}

		return "/common/success";
	}




}

