package com.ptteng.course.admin.controller;

import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.learn.course.model.Lesson;
import com.ptteng.learn.course.model.Subject;
import com.ptteng.learn.course.model.UserOrder;
import com.ptteng.learn.course.service.LessonService;
import com.ptteng.learn.course.service.SubjectService;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.learn.course.model.Introduce;
import com.ptteng.learn.course.service.IntroduceService;

/**
 * Introduce  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class IntroduceController {
    private static final Log log = LogFactory.getLog("introduce");

    @Autowired
    private IntroduceService introduceService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private CookieUtil cookieUtil;


//    /**
//     * 根据年级获得推荐列表
//     *
//     * @param request
//     * @param response
//     * @param model
//     * @param page
//     * @param size
//     * @param level
//     * @return
//     * @throws Exception
//     */
//    @RequestMapping(value = "/a/u/introduce/list", method = RequestMethod.GET)
//    public String getIntroduceIdsByLevelJsonList(HttpServletRequest request,
//                                                 HttpServletResponse response, ModelMap model, Integer page,
//                                                 Integer size, Integer level) throws Exception {
//
//
//        if (page == null) {
//            page = 1;
//        }
//        if (size == null) {
//            size = 8;
//        }
//        int start = (page - 1) * size;
//        if (start < 0) {
//            start = 0;
//        }
//        if (level == null) {
//            model.addAttribute("code", -5024);
//            return "/common/success";
//        }
//        List<Introduce> introduceList = null;
//        List<Long> randomList = null;
//        log.info("pageList : page= " + start + " , size=" + size);
//        Random random = new Random();
//        Integer total = 0;
//        try {
//            if (level == 7) {
//                List<Long> idList = introduceService.getIntroduceIds(0, Integer.MAX_VALUE);
//                if (idList.size() > 0) {
//                    List<Introduce> introduceLists = introduceService.getObjectsByIds(idList);
//                    Set<Long> set = new HashSet<>();
//                    List<Long> introduceIds = new LinkedList<>();
//                    List<Long> intro = new LinkedList<>();
//                    for (Introduce introduce : introduceLists) {
//                        set.add(introduce.getLessonId());
//                    }
//                    for (Long lessonId : set) {
//                        intro = introduceService.getIdsByLessonId(lessonId);
//                        if (intro.size() > 0) {
//                            introduceIds.add(intro.get(0));
//                        }
//                    }
//                    idList = introduceIds;
//                    if (idList.size() > size) {
//                        for (int i = 0; i < size; ) {
//                            Integer index = random.nextInt(idList.size());
//                            Long id = idList.get(index);
//                            if (!randomList.contains(id)) {
//                                randomList.add(id);
//                                i++;
//                            }
//                        }
//                    } else {
//                        for (int i = 0; i < idList.size(); ) {
//                            Integer index = random.nextInt(idList.size());
//                            Long id = idList.get(index);
//                            if (!randomList.contains(id)) {
//                                randomList.add(id);
//                                i++;
//                            }
//                        }
//                    }
//                }
//                introduceList = introduceService.getObjectsByIds(idList);
//
//                total = size;
//            } else {
//                List<Long> ids = introduceService.getIntroduceIdsByLevel(level, start, size);
//                log.info("get countIntroduceIdsByLevel size is " + ids.size());
//                if (ids == null || ids.isEmpty()) {
////					model.addAttribute("code", -5025);
////					return "/common/success";
//                } else {
//                    introduceList = introduceService.getObjectsByIds(ids);
//                    log.info("get introduce data is " + introduceList.size());
//
//                    total = introduceService.countIntroduceIdsByLevel(level);
//                    log.info("get introduce count is " + total);
//                }
//
//            }
//            if (introduceList.size() > 0) {
//
//                for (Introduce introduce : introduceList) {
//                    Long lessonId = introduce.getLessonId();
//                    Long subjectId = introduce.getSubjectId();
//                    Lesson lesson = lessonService.getObjectById(lessonId);
//                    Subject subject = subjectService.getObjectById(subjectId);
//                    if (lesson != null) {
//                        introduce.setLessonName(lesson.getName());
//                    }
//                    if (subject != null) {
//                        introduce.setSubjectName(subject.getName());
//                    }
//                }
//            }
//            model.addAttribute("code", 0);
//            model.addAttribute("page", page);
//            model.addAttribute("size", size);
//
//            model.addAttribute("total", total);
//
//            model.addAttribute("introduceList", introduceList);
//
//        } catch (Throwable t) {
//            t.printStackTrace();
//            log.error(t.getMessage());
//            log.error("get introduce list error,page is  " + start + " , size "
//                    + size);
//            // for test
//            model.addAttribute("code", -1);
//        }
//
//        return "/learn-course-service/introduce/json/introduceListJson";
//    }


    /**
     * @Description 后台获取推荐列表
     * @param level 年级
     * @Author: PeiyuFeng
     * @Time 2017/3/11 12:14
     */
    @RequestMapping(value = "/a/u/introduce/list", method = RequestMethod.GET)
    public String getIntroduceIdsByLevelJsonList(HttpServletRequest request,
                                                 HttpServletResponse response, ModelMap model, Integer page,
                                                 Integer size, Integer level) throws Exception {


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        if (level == null) {
            model.addAttribute("code", -5024);
            return "/common/success";
        }
        List<Introduce> introduceList = null;
        List<Long> randomList = null;
        log.info("pageList : page= " + start + " , size=" + size);
        Random random = new Random();
        Integer total = 0;
        try {
            if (level == 7 || level == null) {
                List<Long> idList = introduceService.getIntroduceIds(0, Integer.MAX_VALUE);

                total = introduceService.countIntroduceIds();
                if (idList.size() > 0) {
                    introduceList = introduceService.getObjectsByIds(idList);
                }else {
                    log.info("introduce ids null");
                }
            } else {
                List<Long> ids = introduceService.getIntroduceIdsByLevel(level, start, size);
                log.info("get countIntroduceIdsByLevel size is " + ids.size());
                if (ids == null || ids.isEmpty()) {
                    log.info("introduce ids null");
                } else {
                    introduceList = introduceService.getObjectsByIds(ids);
                    log.info("get introduce data is " + introduceList.size());

                    total = introduceService.countIntroduceIdsByLevel(level);
                    log.info("get introduce count is " + total);
                }

            }
            if (introduceList.size() > 0) {

                for (Introduce introduce : introduceList) {
                    Long lessonId = introduce.getLessonId();
                    Long subjectId = introduce.getSubjectId();
                    Lesson lesson = lessonService.getObjectById(lessonId);
                    Subject subject = subjectService.getObjectById(subjectId);
                    if (lesson != null) {
                        introduce.setLessonName(lesson.getName());
                    }
                    if (subject != null) {
                        introduce.setSubjectName(subject.getName());
                    }
                }
            }

            Integer totalPage = (((total - 1)) / size) + 1;
            log.info("   totalPage = " + totalPage);

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("introduceList", introduceList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get introduce list error,page is  " + start + " , size " + size);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/introduce/json/introduceListJson";
    }


    /**
     * 查看推荐详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/introduce/{id}", method = RequestMethod.GET)
    public String getIntroduceJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            Introduce introduce = introduceService.getObjectById(id);
            log.info("get introduce data is " + introduce);
            Long lessonId = introduce.getLessonId();
            Long subjectId = introduce.getSubjectId();
            Lesson lesson = lessonService.getObjectById(lessonId);
            Subject subject = subjectService.getObjectById(subjectId);
            if (lesson != null) {
                introduce.setLessonName(lesson.getName());
            }
            if (subject != null) {
                introduce.setSubjectName(subject.getName());
            }
            model.addAttribute("code", 0);

            model.addAttribute("introduce", introduce);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get introduce error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/learn-course-service/introduce/json/introduceDetailJson";
    }

    /**
     * 更新推荐
     *
     * @param request
     * @param response
     * @param model
     * @param introduce
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/introduce/{id}", method = RequestMethod.PUT)
    public String updateIntroduceJson(HttpServletRequest request,
                                      HttpServletResponse response, ModelMap model, Introduce introduce, @PathVariable Long id) throws Exception {

        log.info("update introduce : introduce= " + introduce);
        if (introduce.getImg() == null) {
            model.addAttribute("code", -5014);
            return "/common/success";
        }
        if (introduce.getLessonId() == null) {
            model.addAttribute("code", -5003);
            return "/common/success";
        }
        if (introduce.getLevel() == null) {
            model.addAttribute("code", -5026);
            return "/common/success";
        }
        if (introduce.getSubjectId() == null) {
            model.addAttribute("code", -5013);
            return "/common/success";
        }

        try {
            introduce.setId(id);
            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            introduce.setUpdateBy(Long.parseLong(userId));
            Lesson newLesson = lessonService.getObjectById(introduce.getLessonId());
            if (newLesson != null) {

                if (!newLesson.getSubject().equals(introduce.getSubjectId())) {
                    model.addAttribute("code", -5064);
                    return "/common/success";
                }
            }
            newLesson.setRecommend(1);
            Introduce old = introduceService.getObjectById(id);
            if (introduce.getLessonId() != old.getLessonId()) {
                List<Long> introduceIds = introduceService.getIntroduceIdsByLevel(introduce.getLevel(), 0, Integer.MAX_VALUE);
                List<Introduce> introduceList = introduceService.getObjectsByIds(introduceIds);
                for (Introduce introduce1 : introduceList) {
                    if (introduce.getLessonId() == introduce1.getLessonId()) {
                        model.addAttribute("code", -5076);
                        return "/common/success";
                    }
                }
            }

            introduce.setCreateAt(old.getCreateAt());
            introduce.setUpdateAt(old.getUpdateAt());
            introduce.setCreateBy(old.getCreateBy());
            Long oldlessonId = old.getLessonId();
            Lesson oldlesson = lessonService.getObjectById(oldlessonId);
            //			Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
//					CookieUtil.USER_ID));
//			introduce.setUpdateBy(uid);
            introduceService.update(introduce);
            if (oldlesson != null) {
                List<Long> ids = introduceService.getIdsByLessonId(oldlesson.getId());
                if (ids.size() <= 0) {
                    oldlesson.setRecommend(2);
                    lessonService.update(oldlesson);
                }
            }

            model.addAttribute("code", 0);

            model.addAttribute("introduce", introduce);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update introduce error,id is  " + introduce.getId());
            model.addAttribute("code", -6003);

        }

        return "/common/success";
    }

    /**
     * 新增推荐
     *
     * @param request
     * @param response
     * @param model
     * @param introduce
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/introduce", method = RequestMethod.POST)
    public String addIntroduceJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Introduce introduce) throws Exception {

        log.info("update introduce : introduce= " + introduce);
        if (introduce.getLevel() == null) {
            model.addAttribute("code", -5026);
            return "/common/success";
        }
        if (introduce.getSubjectId() == null) {
            model.addAttribute("code", -5013);
            return "/common/success";
        }
        if (introduce.getLessonId() == null) {
            model.addAttribute("code", -5012);
            return "/common/success";
        }
        if (introduce.getImg() == null) {
            model.addAttribute("code", -5014);
            return "/common/success";
        }
        try {
            introduce.setId(null);
            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            introduce.setCreateBy(Long.parseLong(userId));
            List<Long> introduceIds = introduceService.getIntroduceIdsByLevel(introduce.getLevel(), 0, Integer.MAX_VALUE);
            List<Introduce> introduceList = introduceService.getObjectsByIds(introduceIds);
            for (Introduce introduce1 : introduceList) {
                if (introduce.getLessonId() == introduce1.getLessonId()) {
                    model.addAttribute("code", -5076);
                    return "/common/success";
                }
            }
            Lesson lesson = lessonService.getObjectById(introduce.getLessonId());
            lesson.setRecommend(1);
            introduceService.insert(introduce);
            lessonService.update(lesson);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add introduce error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    /**
     * 删除推荐
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/introduce/{id}", method = RequestMethod.DELETE)
    public String deleteIntroduceJson(HttpServletRequest request,
                                      HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete introduce : id= " + id);
        try {
            Introduce introduce = introduceService.getObjectById(id);
            introduceService.delete(id);
            Lesson oldlesson = lessonService.getObjectById(introduce.getLessonId());
            List<Long> ids = introduceService.getIdsByLessonId(oldlesson.getId());
            if (ids.size() <= 0) {
                oldlesson.setRecommend(2);
                lessonService.update(oldlesson);
            }
            log.info("add introduce success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete introduce error,id is  " + id);
            model.addAttribute("code", -6004);

        }

        return "/common/success";
    }


    @RequestMapping(value = "/a/multi/introduce", method = RequestMethod.GET)
    public String getMultiIntroduceJson(HttpServletRequest request,
                                        HttpServletResponse response, ModelMap model, Long[] ids)
            throws Exception {

        List<Long> idList = new ArrayList();
        if (ids == null) {

        } else {
            idList = Arrays.asList(ids);
        }
        try {


            List<Introduce> introduceList = introduceService.getObjectsByIds(idList);
            log.info("get  introduce data is " + introduceList);

            model.addAttribute("code", 0);
            model.addAttribute("total", introduceList.size());

            model.addAttribute("introduceList", introduceList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get introduce error,id is  " + idList);
            model.addAttribute("code", -100000);
        }

        return "/learn-course-service/introduce/json/introduceListJson";
    }

    @RequestMapping(value = "/a/u/introduce/start", method = RequestMethod.POST)
    public String startIntroduce(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model)
            throws Exception {

        try {
            List<Long> introduceIds = introduceService.getIntroduceIds(0, Integer.MAX_VALUE);
            introduceService.deleteList(Introduce.class, introduceIds);
            Introduce introduce = new Introduce();
            for (int i = 0; i < 7; i++) {
                introduce.setLevel(i);
                for (int m = 1; m < 9; m++) {
                    introduceService.insert(introduce);
                }
            }
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get introduce error,id is  ");
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }


}

