package com.ptteng.course.admin.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.learn.course.model.UserOpenidRelation;
import com.ptteng.learn.course.service.UserOpenidRelationService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;



/**
 * UserOpenidRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserOpenidRelationController {
	private static final Log log = LogFactory.getLog(UserOpenidRelationController.class);

	@Autowired
	private UserOpenidRelationService userOpenidRelationService;






    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/userOpenidRelation", method = RequestMethod.GET)
	public String getuserOpenidRelationList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/userOpenidRelation  to /userOpenidRelation/view/userOpenidRelationList");

		return "/learn-course-service/userOpenidRelation/view/userOpenidRelationList";
	}
    
    

    
	
	@RequestMapping(value = "/c/userOpenidRelation/{id}", method = RequestMethod.GET)
	public String getUserOpenidRelation(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/userOpenidRelation/" + id + "  to /userOpenidRelation/view/userOpenidRelationDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/learn-course-service/userOpenidRelation/view/userOpenidRelationDetail";
	}
	
	
	
	    
	

	@RequestMapping(value = "/a/userOpenidRelation/{id}", method = RequestMethod.GET)
	public String getUserOpenidRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			UserOpenidRelation userOpenidRelation = userOpenidRelationService.getObjectById(id);
			log.info("get userOpenidRelation data is " + userOpenidRelation);

			model.addAttribute("code", 0);

			model.addAttribute("userOpenidRelation", userOpenidRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userOpenidRelation error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/userOpenidRelation/json/userOpenidRelationDetailJson";
	}

	@RequestMapping(value = "/a/userOpenidRelation/{id}", method = RequestMethod.PUT)
	public String updateUserOpenidRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, UserOpenidRelation userOpenidRelation) throws Exception {
		
		log.info("update userOpenidRelation : userOpenidRelation= " + userOpenidRelation);
		
		try {
			
			userOpenidRelationService.update(userOpenidRelation);

			model.addAttribute("code", 0);

			model.addAttribute("userOpenidRelation", userOpenidRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update userOpenidRelation error,id is  " + userOpenidRelation.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userOpenidRelation", method = RequestMethod.POST)
	public String addUserOpenidRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, UserOpenidRelation userOpenidRelation) throws Exception {
		
		log.info("update userOpenidRelation : userOpenidRelation= " + userOpenidRelation);
		
		try { 
			userOpenidRelation.setId(null);

			userOpenidRelationService.insert(userOpenidRelation);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add userOpenidRelation error ");
			model.addAttribute("code", -1);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userOpenidRelation/{id}", method = RequestMethod.DELETE)
	public String deleteUserOpenidRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete userOpenidRelation : id= " + id);
		try {
			userOpenidRelationService.delete(id);

			log.info("add userOpenidRelation success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete userOpenidRelation error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/userOpenidRelation", method = RequestMethod.GET)
	public String getMultiUserOpenidRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<UserOpenidRelation> userOpenidRelationList = userOpenidRelationService.getObjectsByIds(idList);
			log.info("get  userOpenidRelation data is " + userOpenidRelationList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",userOpenidRelationList.size());

			model.addAttribute("userOpenidRelationList", userOpenidRelationList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get userOpenidRelation error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/userOpenidRelation/json/userOpenidRelationListJson";
	}
	
	
	
	
	
}

