package com.ptteng.course.admin.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


/**
 * Paper  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class PaperController {
	private static final Log log = LogFactory.getLog("paper");

	@Autowired
	private PaperService paperService;
	@Autowired
	private LessonService lessonService;
	@Autowired
	private PeriodService periodService;
	@Autowired
	private SubjectService subjectService;
	@Autowired
	private BookService bookService;
	@Autowired
	private CookieUtil cookieUtil;


	/**
	 * 更新资料
	 * @param request
	 * @param response
	 * @param model
	 * @return
     * @throws Exception
     */
	@RequestMapping(value = "/a/u/paper/{id}", method = RequestMethod.PUT)
	public String updatePaperJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,String price,String url,String iosId,@PathVariable Long id) throws Exception {
		
		log.info("update paper : id= " + id);
//		if (paper.getSubjectId() == null) {
//			model.addAttribute("code", -5035);
//			return "/common/success";
//		}
//		if (paper.getLessonId() == null) {
//			model.addAttribute("code", -5003);
//			return "/common/success";
//		}
//		if (paper.getPeriodId() == null) {
//			model.addAttribute("code", -5020);
//			return "/common/success";
//		}

		if (url == null) {
			model.addAttribute("code", -5037);
			return "/commom/success";
		}
		if (price == null) {
			model.addAttribute("code", -5038);
			return "/common/success";
		}
//		if (paper.getName() == null) {
//			model.addAttribute("code", -5005);
//			return "/common/success";
//		}
//
		try {
			Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
					com.qding.common.util.http.cookie.CookieUtil.USER_ID));

			Paper paper = paperService.getObjectById(id);
			paper.setIosId(iosId);
			paper.setUrl(url);
			paper.setPrice(price);
			paper.setUpdateBy(uid);
			paperService.update(paper);

			model.addAttribute("code", 0);

			model.addAttribute("paper", paper);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update paper error,id is  " +id);
			model.addAttribute("code", -6003);

		}

		return "/common/success";
	}

	/**
	 * 新增资料
	 * @param request
	 * @param response
	 * @param model
	 * @param paper
	 * @return
     * @throws Exception
     */
	@RequestMapping(value = "/a/u/paper", method = RequestMethod.POST)
	public String addPaperJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Paper paper) throws Exception {
		
		log.info("update paper : paper= " + paper);
		if (paper.getType() == null) {
			model.addAttribute("code", -5069);
			return "/common/success";
		}
		if (paper.getType().equals(Paper.type_Lesson)) {
			if (paper.getSubjectId() == null) {
				model.addAttribute("code", -5035);
				return "/common/success";
			}
			if (paper.getLessonId() == null) {
				model.addAttribute("code", -5003);
				return "/common/success";
			}
		} else {
			if (paper.getBookId() == null) {
				model.addAttribute("code", -5039);
				return "/common/success";
			}
		}
		if (paper.getPeriodId() == null) {
			model.addAttribute("code", -5020);
			return "/common/success";
		}

		if (paper.getUrl() == null) {
			model.addAttribute("code", -5037);
			return "/commom/success";
		}
		if (paper.getPrice() == null) {
			model.addAttribute("code", -5038);
			return "/common/success";
		}
//		if (paper.getName() == null) {
//			model.addAttribute("code", -5005);
//			return "/common/success";
//		}
		
		try {
			Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
					com.qding.common.util.http.cookie.CookieUtil.USER_ID));
			paper.setCreateBy(uid);
			paper.setId(null);
			paper.setLevel(8);
			Long paperId=paperService.insert(paper);
			Paper newPaper = paperService.getObjectById(paperId);
			Period period = periodService.getObjectById(paper.getPeriodId());
			period.setPaperID(paperId);
			if (paper.getType().equals(Paper.type_Lesson)) {

					Long lessonId = paper.getLessonId();
					Lesson lesson = lessonService.getObjectById(lessonId);
				if (period.getStatus().equals(Period.status_normal)) {
					lesson.setPaperCount(lesson.getPaperCount() + 1);
				}
					lessonService.update(lesson);
					newPaper.setLevel(lesson.getLevel());

			} else if (paper.getType().equals(Paper.type_Book)){
				Long bookId = paper.getBookId();
				Book book = bookService.getObjectById(bookId);
				if (period.getStatus().equals(Period.status_normal)) {
					book.setPaperCount(book.getPaperCount() + 1);
				}
				bookService.update(book);

				newPaper.setLevel(book.getGrade());
			}
			periodService.update(period);
			paperService.update(newPaper);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add paper error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	/**
	 * 删除资料
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
     * @throws Exception
     */
	@RequestMapping(value = "/a/u/paper/{id}", method = RequestMethod.DELETE)
	public String deletePaperJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete paper : id= " + id);
		try {
			Paper paper = paperService.getObjectById(id);
			if (paper == null) {
				model.addAttribute("code", 2);
				return "/common/success";
			}
			Period period = periodService.getObjectById(paper.getPeriodId());
			period.setPaperID(null);
			if (paper.getType().equals(Paper.type_Lesson)) {
				Long lessonId = paper.getLessonId();
				Lesson lesson = lessonService.getObjectById(lessonId);
				if (period.getStatus().equals(Period.status_normal)) {
					lesson.setPaperCount(lesson.getPaperCount() - 1);
				}
				lessonService.update(lesson);
			} else {
				Long bookId = paper.getBookId();
				Book book = bookService.getObjectById(bookId);
				if (period.getStatus().equals(Period.status_normal)) {
					book.setPaperCount(book.getPaperCount() - 1);
				}
				bookService.update(book);
			}
			paperService.delete(id);
			periodService.update(period);
			log.info("add paper success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete paper error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/common/success";
	}

	/**
	 * 条件搜索资料
	 * @param request
	 * @param response
	 * @param page
	 * @param size
	 * @param model
	 * @param subjectId
	 * @param lessonId
	 * @param periodId
     * @return
     * @throws Exception
     */
	@RequestMapping(value = "/a/u/paper/list", method = RequestMethod.GET)
	public String getMultiPaperJson(HttpServletRequest request,
			HttpServletResponse response,Integer page,Integer size, ModelMap model,String name,Long subjectId,Long lessonId,Long periodId,Integer level,Integer type,Long bookId)
			throws Exception {
			
		List<Long> idList = new ArrayList();

		if(page==null){

			page=1;
		}

		if(size == null){
			size=10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		Map<String, Object> param = DynamicUtil.getPaperList(name,subjectId, lessonId, periodId,bookId,level,type);
		try {
			idList = paperService.getIdsByDynamicCondition(Paper.class, param, start, size);
			List<Long> count = paperService.getIdsByDynamicCondition(Paper.class, param, 0, Integer.MAX_VALUE);
			List<Paper> paperList = paperService.getObjectsByIds(idList);
			log.info("get  paper data is " + paperList);
			for (Paper paper : paperList) {
				lessonId=paper.getLessonId();
				periodId=paper.getPeriodId();
				subjectId=paper.getSubjectId();
				bookId=paper.getBookId();
				log.info("get paper success");
				Lesson lesson = lessonService.getObjectById(lessonId);
				Period period = periodService.getObjectById(periodId);
				Subject subject = subjectService.getObjectById(subjectId);
				Book book = bookService.getObjectById(bookId);
				if (subject != null) {
					paper.setSubjectName(subject.getName());
				}
				if (lesson != null) {
					paper.setLeesonName(lesson.getName());
				}
				if (period != null) {
					paper.setPeriodName(period.getName());
				}
				if (book != null) {
					paper.setBookName(book.getName());
				}
			}
			Integer total=count.size();
			model.addAttribute("code", 0);
			boolean next=false;
			if (idList.size() + start +1<= total) {
				next=true;
			}
			Integer totalPage=(total-1)/size+1;
			model.addAttribute("next", next);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total",total);

			model.addAttribute("paperList", paperList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get paper error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/paper/json/paperListJson";
	}

	@RequestMapping(value = "/a/u/paper/{id}", method = RequestMethod.GET)
	public String getPaperJson(HttpServletRequest request,
								  HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete paper : id= " + id);
		try {
			Paper paper=paperService.getObjectById(id);
			Long lessonId=paper.getLessonId();
			Long periodId=paper.getPeriodId();
			Long subjectId=paper.getSubjectId();
			Long bookId = paper.getBookId();
			log.info("get paper success");
			Lesson lesson = lessonService.getObjectById(lessonId);
			Period period = periodService.getObjectById(periodId);
			Subject subject = subjectService.getObjectById(subjectId);
			Book book = bookService.getObjectById(bookId);
			if (subject != null) {
				paper.setSubjectName(subject.getName());
			}
			if (lesson != null) {
				paper.setLeesonName(lesson.getName());
			}
			if (period != null) {
				paper.setPeriodName(period.getName());
			}
			if (book != null) {
				paper.setBookName(book.getName());
			}
			model.addAttribute("code", 0);
			model.addAttribute("paper", paper);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete paper error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/learn-course-service/paper/json/paperDetailJson";
	}




}

