package com.ptteng.haichuan.audit.service;

import java.util.List;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.haichuan.audit.model.VenderTask;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface VenderTaskService extends BaseDaoService {
  
  
  public Long insert(VenderTask venderTask) throws ServiceException, ServiceDaoException;
  
  public List<VenderTask> insertList(List<VenderTask> venderTaskList)
      throws ServiceException, ServiceDaoException;
  
  public boolean delete(Long id) throws ServiceException, ServiceDaoException;
  
  public boolean update(VenderTask venderTask) throws ServiceException, ServiceDaoException;
  
  public boolean updateList(List<VenderTask> venderTaskList)
      throws ServiceException, ServiceDaoException;
  
  public VenderTask getObjectById(Long id) throws ServiceException, ServiceDaoException;
  
  public List<VenderTask> getObjectsByIds(List<Long> ids)
      throws ServiceException, ServiceDaoException;
  
  /**
   * 
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public List<Long> getVenderTaskIds(Integer start, Integer limit)
      throws ServiceException, ServiceDaoException;
  
  /**
   * 
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public Integer countVenderTaskIds() throws ServiceException, ServiceDaoException;
  
  /**
   * 统计某个厂家任务列表的盘库数、倒查数等
   * 
   * @param id
   *        厂家任务id
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   * @author liut
   */
  public List<Integer> getVenderTaskSummary(Long id) throws ServiceException, ServiceDaoException;
  
}
