package com.ptteng.haichuan.audit.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.haichuan.audit.model.InventoryImport;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface InventoryImportService extends BaseDaoService {
  
  
  public Long insert(InventoryImport inventoryImport) throws ServiceException, ServiceDaoException;
  
  public List<InventoryImport> insertList(List<InventoryImport> inventoryImportList)
      throws ServiceException, ServiceDaoException;
  
  public boolean delete(Long id) throws ServiceException, ServiceDaoException;
  
  public boolean update(InventoryImport inventoryImport)
      throws ServiceException, ServiceDaoException;
  
  public boolean updateList(List<InventoryImport> inventoryImportList)
      throws ServiceException, ServiceDaoException;
  
  public InventoryImport getObjectById(Long id) throws ServiceException, ServiceDaoException;
  
  public List<InventoryImport> getObjectsByIds(List<Long> ids)
      throws ServiceException, ServiceDaoException;
  
  /**
   * 
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public List<Long> getInventoryImportIds(Integer start, Integer limit)
      throws ServiceException, ServiceDaoException;
  
  /**
   * 
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public Integer countInventoryImportIds() throws ServiceException, ServiceDaoException;
  
}
