package com.ptteng.haichuan.audit.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.haichuan.audit.model.Storage;
import com.ptteng.haichuan.audit.model.Vender;
import com.ptteng.haichuan.pub.model.Manager;

@Remotable
public interface AuditCommonService {
  
  
  /**
   * 用来判断当前的账号是厂家账号或是第三方账号<br>
   * map中的key分三种情况：
   * <li><b>"vender"</b>对应<b>厂家账号且非禁用</b>
   * <li><b>"thirdParty"</b>对应<b>第三方账号</b>
   * <li><b>"forbidden"</b>对应<b>厂家账号但被禁用</b>
   * <br>
   * <br>
   * 这三个字符常量的定义在{@link com.ptteng.haichuan.pub.model.Manager}中
   * 
   * @param manager
   * @return
   */
  Map<String, Vender> judgeCurrentManager(Manager manager)
      throws ServiceDaoException, ServiceException;
  
  /**
   * 向环信后台添加用户
   * 
   * @param username
   *        用户名
   */
  void addHuanXinIMUser(String username) throws ServiceDaoException, ServiceException;
  
  /**
   * 给某个环信后台已录入的用户推送消息
   * 
   * @param username
   *        用户名，即member的account字段
   * @param content
   *        推送的消息内容
   */
  void pushHuanXinMsg(String username, String content) throws ServiceDaoException, ServiceException;
  
  /**
   * 获取环信的token，用于验证
   */
  String[] getHuanXinToken();
  
  /**
   * 根据传入的venderTaskId获得在途已售报告记录的storage list
   * esr表示enrouteStorageReport
   * @author huangchao
   * @param venderTaskId 厂家id
   */
  List<Storage> getEsrStorageList(Long venderTaskId) throws ServiceDaoException, ServiceException;
}
