package com.ptteng.haichuan.audit.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table(name = "memberTask")
public class MemberTask implements Serializable {
  
  
  /**
   * 
   */
  private static final long serialVersionUID = 6112746960600843264L;
  
  /**
   * 已取消
   * 
   */
  public static final int ALREADY_CANCEL = -1;
  
  /**
   * 未开始
   * 
   */
  public static final int UN_BEGIN = 0;
  
  /**
   * 执行中
   * 
   */
  public static final int EXECUTE_ING = 1;
  
  /**
   * 已重开
   * 
   */
  public static final int ALREADY_REOPEN = 2;
  
  /**
   * 已完成
   * 
   */
  public static final int ALREADY_COMPELETE = 3;
  
  /**
   * 已通过
   * 
   */
  public static final int ALREADY_PASS = 4;
  
  /**
   * 已关闭
   * 
   */
  public static final int ALREADY_CLOSE = 5;
  
  private Long id;
  
  private Long venderTaskId;
  
  private Long storageId;
  
  private String storageName;
  
  private String storageProvince;
  
  private String storageCity;
  
  private String storageAddress;
  
  private Long memberId;
  
  private String memberName;
  
  private Long beginAt;
  
  private Long planBeginAt;
  
  private Integer status;
  
  private Boolean isWithdraw = false;
  
  private Long withdrawAt;
  
  private Integer withdrawTime = 0;
  
  private String withdrawCause;
  
  private Long nextMemberTaskId;
  
  private Long createAt;
  
  private Long updateAt;
  
  private Long createBy;
  
  private Long updateBy;
  
  private String storageProvinceName;
  
  private String storageCityName;
  
  private String updateByName;
  
  private boolean isGreaterThan = false;
  
  private String storageAttribute;
  
  @Id
  @GeneratedValue(strategy = GenerationType.AUTO)
  @Column(name = "id")
  public Long getId() {
    return id;
  }
  
  public void setId(Long id) {
    this.id = id;
  }
  
  @Column(name = "vender_task_id")
  public Long getVenderTaskId() {
    return venderTaskId;
  }
  
  public void setVenderTaskId(Long venderTaskId) {
    this.venderTaskId = venderTaskId;
  }
  
  @Column(name = "storage_id")
  public Long getStorageId() {
    return storageId;
  }
  
  public void setStorageId(Long storageId) {
    this.storageId = storageId;
  }
  
  @Column(name = "storage_name")
  public String getStorageName() {
    return storageName;
  }
  
  public void setStorageName(String storageName) {
    this.storageName = storageName;
  }
  
  @Column(name = "storage_province")
  public String getStorageProvince() {
    return storageProvince;
  }
  
  public void setStorageProvince(String storageProvince) {
    this.storageProvince = storageProvince;
  }
  
  @Column(name = "storage_city")
  public String getStorageCity() {
    return storageCity;
  }
  
  public void setStorageCity(String storageCity) {
    this.storageCity = storageCity;
  }
  
  @Column(name = "storage_address")
  public String getStorageAddress() {
    return storageAddress;
  }
  
  public void setStorageAddress(String storageAddress) {
    this.storageAddress = storageAddress;
  }
  
  @Column(name = "member_id")
  public Long getMemberId() {
    return memberId;
  }
  
  public void setMemberId(Long memberId) {
    this.memberId = memberId;
  }
  
  @Column(name = "member_name")
  public String getMemberName() {
    return memberName;
  }
  
  public void setMemberName(String memberName) {
    this.memberName = memberName;
  }
  
  @Column(name = "begin_at")
  public Long getBeginAt() {
    return beginAt;
  }
  
  public void setBeginAt(Long beginAt) {
    this.beginAt = beginAt;
  }
  
  @Column(name = "plan_begin_at")
  public Long getPlanBeginAt() {
    return planBeginAt;
  }
  
  public void setPlanBeginAt(Long planBeginAt) {
    this.planBeginAt = planBeginAt;
  }
  
  @Column(name = "status")
  public Integer getStatus() {
    return status;
  }
  
  public void setStatus(Integer status) {
    this.status = status;
  }
  
  @Column(name = "is_withdraw")
  public Boolean getIsWithdraw() {
    return isWithdraw;
  }
  
  public void setIsWithdraw(Boolean isWithdraw) {
    this.isWithdraw = isWithdraw;
  }
  
  @Column(name = "withdraw_at")
  public Long getWithdrawAt() {
    return withdrawAt;
  }
  
  public void setWithdrawAt(Long withdrawAt) {
    this.withdrawAt = withdrawAt;
  }
  
  @Column(name = "withdraw_time")
  public Integer getWithdrawTime() {
    return withdrawTime;
  }
  
  public void setWithdrawTime(Integer withdrawTime) {
    this.withdrawTime = withdrawTime;
  }
  
  @Column(name = "withdraw_cause")
  public String getWithdrawCause() {
    return withdrawCause;
  }
  
  public void setWithdrawCause(String withdrawCause) {
    this.withdrawCause = withdrawCause;
  }
  
  @Column(name = "next_member_task_id")
  public Long getNextMemberTaskId() {
    return nextMemberTaskId;
  }
  
  public void setNextMemberTaskId(Long nextMemberTaskId) {
    this.nextMemberTaskId = nextMemberTaskId;
  }
  
  @Column(name = "create_at")
  public Long getCreateAt() {
    return createAt;
  }
  
  public void setCreateAt(Long createAt) {
    this.createAt = createAt;
  }
  
  @Column(name = "update_at")
  public Long getUpdateAt() {
    return updateAt;
  }
  
  public void setUpdateAt(Long updateAt) {
    this.updateAt = updateAt;
  }
  
  @Column(name = "create_by")
  public Long getCreateBy() {
    return createBy;
  }
  
  public void setCreateBy(Long createBy) {
    this.createBy = createBy;
  }
  
  @Column(name = "update_by")
  public Long getUpdateBy() {
    return updateBy;
  }
  
  public void setUpdateBy(Long updateBy) {
    this.updateBy = updateBy;
  }
  
  public String toString() {
    return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
  }
  
  @Column(name = "storage_province_name")
  public String getStorageProvinceName() {
    return storageProvinceName;
  }
  
  public void setStorageProvinceName(String storageProvinceName) {
    this.storageProvinceName = storageProvinceName;
  }
  
  @Column(name = "storage_city_name")
  public String getStorageCityName() {
    return storageCityName;
  }
  
  public void setStorageCityName(String storageCityName) {
    this.storageCityName = storageCityName;
  }
  
  @Transient
  public boolean getIsGreaterThan() {
    return isGreaterThan;
  }
  
  public void setGreaterThan(boolean isGreaterThan) {
    this.isGreaterThan = isGreaterThan;
  }
  
  @Transient
  public String getStorageAttribute() {
    return storageAttribute;
  }
  
  public void setStorageAttribute(String storageAttribute) {
    this.storageAttribute = storageAttribute;
  }
  
  @Column(name = "update_by_name")
  public String getUpdateByName() {
    return updateByName;
  }
  
  public void setUpdateByName(String updateByName) {
    this.updateByName = updateByName;
  }
  
}
