package com.ptteng.haichuan.audit.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table(name = "memberStorage")
public class MemberStorage implements Serializable {
  
  
  /**
   * 
   */
  private static final long serialVersionUID = 3832238961945281536L;
  
  /** status：未做 */
  public static final Integer NO_DATA = 0;
  
  /** status：已上传 */
  public static final Integer UPLOADED = 1;
  
  /** status：需重做 */
  public static final Integer NEED_REWORK = 2;
  
  private Long id;
  
  private Long memberTaskId;
  
  private String memberStorageImg;
  
  private String keyImg;
  
  private String otherImg;
  
  private Long storageId;
  
  private String storageName;
  
  private Integer status;
  
  private Long createAt;
  
  private Long updateAt;
  
  private Long createBy;
  
  private Long updateBy;
  
  @Id
  @GeneratedValue(strategy = GenerationType.AUTO)
  @Column(name = "id")
  public Long getId() {
    return id;
  }
  
  public void setId(Long id) {
    this.id = id;
  }
  
  @Column(name = "member_task_id")
  public Long getMemberTaskId() {
    return memberTaskId;
  }
  
  public void setMemberTaskId(Long memberTaskId) {
    this.memberTaskId = memberTaskId;
  }
  
  @Column(name = "member_storage_img")
  public String getMemberStorageImg() {
    return memberStorageImg;
  }
  
  public void setMemberStorageImg(String memberStorageImg) {
    this.memberStorageImg = memberStorageImg;
  }
  
  @Column(name = "key_img")
  public String getKeyImg() {
    return keyImg;
  }
  
  public void setKeyImg(String keyImg) {
    this.keyImg = keyImg;
  }
  
  @Column(name = "other_img")
  public String getOtherImg() {
    return otherImg;
  }
  
  public void setOtherImg(String otherImg) {
    this.otherImg = otherImg;
  }
  
  @Column(name = "storage_id")
  public Long getStorageId() {
    return storageId;
  }
  
  public void setStorageId(Long storageId) {
    this.storageId = storageId;
  }
  
  @Column(name = "storage_name")
  public String getStorageName() {
    return storageName;
  }
  
  public void setStorageName(String storageName) {
    this.storageName = storageName;
  }
  
  @Column(name = "status")
  public Integer getStatus() {
    return status;
  }
  
  public void setStatus(Integer status) {
    this.status = status;
  }
  
  @Column(name = "create_at")
  public Long getCreateAt() {
    return createAt;
  }
  
  public void setCreateAt(Long createAt) {
    this.createAt = createAt;
  }
  
  @Column(name = "update_at")
  public Long getUpdateAt() {
    return updateAt;
  }
  
  public void setUpdateAt(Long updateAt) {
    this.updateAt = updateAt;
  }
  
  @Column(name = "create_by")
  public Long getCreateBy() {
    return createBy;
  }
  
  public void setCreateBy(Long createBy) {
    this.createBy = createBy;
  }
  
  @Column(name = "update_by")
  public Long getUpdateBy() {
    return updateBy;
  }
  
  public void setUpdateBy(Long updateBy) {
    this.updateBy = updateBy;
  }
  
  public String toString() {
    return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
  }
  
}
