package com.ptteng.haichuan.audit.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table(name = "inventory")
public class Inventory implements Serializable {
  
  
  /**
   * 
   */
  private static final long serialVersionUID = 3555712434578704384L;
  
  /**
   * 未做
   * 
   */
  public static final int NOT_DONE = 0;
  
  /**
   * 已上传
   * 
   */
  public static final int ALREADY_UPLOAD = 1;
  
  /**
   * 需重做
   * 
   */
  public static final int RE_DO = 2;
  
  /**
   * 在途
   * 
   */
  public static final int EN_ROUTE = 0;
  
  /**
   * 正常在库
   * 
   */
  public static final int IN_STORE = 1;
  
  /**
   * 已售
   * 
   */
  public static final int ALREADY_SALE = 2;
  
  /**
   * 其他之故障
   * 
   */
  public static final int OTHER_BREAKDOWN = 30;
  
  /**
   * 其他之其他
   * 
   */
  public static final int OTHER_OTHER = 31;
  
  /**
   * 其他之二网违规
   * 
   */
  public static final int OTHER_SECOND_BREAK_RULE = 32;
  
  /**
   * 其他之在库违规
   * 
   */
  public static final int OTHER_STORAGE_BREAK_RULE = 33;
  
  private Long id;
  
  private Long venderTaskId;
  
  private Long memberTaskId;
  
  private String distributorName;
  
  private String vinNo;
  
  private String unitNo;
  
  private String make;
  
  private String assetCond;
  
  private Integer auditResult;
  
  private String mileage;
  
  private String color;
  
  private String comment;
  
  private String vinNoImg;
  
  private String mileageImg;
  
  private String nameplateImg;
  
  private String carImg;
  
  private String otherImg;
  
  private Integer status;
  
  private Long createAt;
  
  private Long updateAt;
  
  private Long createBy;
  
  private Long updateBy;
  
  private String colorName;
  
  private String auditDirection;
  
  private Integer auditDistance;
  
  private String removeStorageImg;
  
  private String repayCertificateImg;
  
  private String explainImg;
  
  @Id
  @GeneratedValue(strategy = GenerationType.AUTO)
  @Column(name = "id")
  public Long getId() {
    return id;
  }
  
  public void setId(Long id) {
    this.id = id;
  }
  
  @Column(name = "vender_task_id")
  public Long getVenderTaskId() {
    return venderTaskId;
  }
  
  public void setVenderTaskId(Long venderTaskId) {
    this.venderTaskId = venderTaskId;
  }
  
  @Column(name = "member_task_id")
  public Long getMemberTaskId() {
    return memberTaskId;
  }
  
  public void setMemberTaskId(Long memberTaskId) {
    this.memberTaskId = memberTaskId;
  }
  
  @Column(name = "distributor_name")
  public String getDistributorName() {
    return distributorName;
  }
  
  public void setDistributorName(String distributorName) {
    this.distributorName = distributorName;
  }
  
  @Column(name = "vin_no")
  public String getVinNo() {
    return vinNo;
  }
  
  public void setVinNo(String vinNo) {
    this.vinNo = vinNo;
  }
  
  @Column(name = "unit_no")
  public String getUnitNo() {
    return unitNo;
  }
  
  public void setUnitNo(String unitNo) {
    this.unitNo = unitNo;
  }
  
  @Column(name = "make")
  public String getMake() {
    return make;
  }
  
  public void setMake(String make) {
    this.make = make;
  }
  
  @Column(name = "asset_cond")
  public String getAssetCond() {
    return assetCond;
  }
  
  public void setAssetCond(String assetCond) {
    this.assetCond = assetCond;
  }
  
  @Column(name = "audit_result")
  public Integer getAuditResult() {
    return auditResult;
  }
  
  public void setAuditResult(Integer auditResult) {
    this.auditResult = auditResult;
  }
  
  @Column(name = "mileage")
  public String getMileage() {
    return mileage;
  }
  
  public void setMileage(String mileage) {
    this.mileage = mileage;
  }
  
  @Column(name = "color")
  public String getColor() {
    return color;
  }
  
  public void setColor(String color) {
    this.color = color;
  }
  
  @Column(name = "comment")
  public String getComment() {
    return comment;
  }
  
  public void setComment(String comment) {
    this.comment = comment;
  }
  
  @Column(name = "vin_no_img")
  public String getVinNoImg() {
    return vinNoImg;
  }
  
  public void setVinNoImg(String vinNoImg) {
    this.vinNoImg = vinNoImg;
  }
  
  @Column(name = "mileage_img")
  public String getMileageImg() {
    return mileageImg;
  }
  
  public void setMileageImg(String mileageImg) {
    this.mileageImg = mileageImg;
  }
  
  @Column(name = "nameplate_img")
  public String getNameplateImg() {
    return nameplateImg;
  }
  
  public void setNameplateImg(String nameplateImg) {
    this.nameplateImg = nameplateImg;
  }
  
  @Column(name = "car_img")
  public String getCarImg() {
    return carImg;
  }
  
  public void setCarImg(String carImg) {
    this.carImg = carImg;
  }
  
  @Column(name = "other_img")
  public String getOtherImg() {
    return otherImg;
  }
  
  public void setOtherImg(String otherImg) {
    this.otherImg = otherImg;
  }
  
  @Column(name = "status")
  public Integer getStatus() {
    return status;
  }
  
  public void setStatus(Integer status) {
    this.status = status;
  }
  
  @Column(name = "create_at")
  public Long getCreateAt() {
    return createAt;
  }
  
  public void setCreateAt(Long createAt) {
    this.createAt = createAt;
  }
  
  @Column(name = "update_at")
  public Long getUpdateAt() {
    return updateAt;
  }
  
  public void setUpdateAt(Long updateAt) {
    this.updateAt = updateAt;
  }
  
  @Column(name = "create_by")
  public Long getCreateBy() {
    return createBy;
  }
  
  public void setCreateBy(Long createBy) {
    this.createBy = createBy;
  }
  
  @Column(name = "update_by")
  public Long getUpdateBy() {
    return updateBy;
  }
  
  public void setUpdateBy(Long updateBy) {
    this.updateBy = updateBy;
  }
  
  @Column(name = "color_name")
  public String getColorName() {
    return colorName;
  }
  
  public void setColorName(String colorName) {
    this.colorName = colorName;
  }
  
  @Column(name = "audit_direction")
  public String getAuditDirection() {
    return auditDirection;
  }
  
  public void setAuditDirection(String auditDirection) {
    this.auditDirection = auditDirection;
  }
  
  @Column(name = "audit_distance")
  public Integer getAuditDistance() {
    return auditDistance;
  }
  
  public void setAuditDistance(Integer auditDistance) {
    this.auditDistance = auditDistance;
  }
  
  @Column(name = "remove_storage_img")
  public String getRemoveStorageImg() {
    return removeStorageImg;
  }
  
  public void setRemoveStorageImg(String removeStorageImg) {
    this.removeStorageImg = removeStorageImg;
  }
  
  @Column(name = "repay_certificate_img")
  public String getRepayCertificateImg() {
    return repayCertificateImg;
  }
  
  public void setRepayCertificateImg(String repayCertificateImg) {
    this.repayCertificateImg = repayCertificateImg;
  }
  
  @Column(name = "explain_img")
  public String getExplainImg() {
    return explainImg;
  }
  
  public void setExplainImg(String explainImg) {
    this.explainImg = explainImg;
  }
  
  public String toString() {
    return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
  }
  
}
