/**
 * 
 */
package com.ptteng.haichuan.audit.client;

import java.util.List;
import java.util.Map;

import com.ptteng.haichuan.audit.model.VenderTask;
import com.ptteng.haichuan.audit.service.VenderTaskService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class VenderTaskSCAClient implements VenderTaskService {
  
  
  private VenderTaskService venderTaskService;
  
  public VenderTaskService getVenderTaskService() {
    return venderTaskService;
  }
  
  public void setVenderTaskService(VenderTaskService venderTaskService) {
    this.venderTaskService = venderTaskService;
  }
  
  @Override
  public Long insert(VenderTask venderTask) throws ServiceException, ServiceDaoException {
    
    return venderTaskService.insert(venderTask);
    
  }
  
  @Override
  public List<VenderTask> insertList(List<VenderTask> venderTaskList)
      throws ServiceException, ServiceDaoException {
    
    return venderTaskService.insertList(venderTaskList);
    
  }
  
  @Override
  public boolean delete(Long id) throws ServiceException, ServiceDaoException {
    
    return venderTaskService.delete(id);
    
  }
  
  @Override
  public boolean update(VenderTask venderTask) throws ServiceException, ServiceDaoException {
    
    return venderTaskService.update(venderTask);
    
  }
  
  @Override
  public boolean updateList(List<VenderTask> venderTaskList)
      throws ServiceException, ServiceDaoException {
    
    return venderTaskService.updateList(venderTaskList);
    
  }
  
  @Override
  public VenderTask getObjectById(Long id) throws ServiceException, ServiceDaoException {
    
    return venderTaskService.getObjectById(id);
    
  }
  
  @Override
  public List<VenderTask> getObjectsByIds(List<Long> ids)
      throws ServiceException, ServiceDaoException {
    
    return venderTaskService.getObjectsByIds(ids);
    
  }
  
  @Override
  public List<Long> getVenderTaskIds(Integer start, Integer limit)
      throws ServiceException, ServiceDaoException {
    return venderTaskService.getVenderTaskIds(start, limit);
  }
  
  @Override
  public Integer countVenderTaskIds() throws ServiceException, ServiceDaoException {
    return venderTaskService.countVenderTaskIds();
  }
  
  @Override
  public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions,
                                             Integer start, Integer limit)
      throws ServiceException, ServiceDaoException {
    return venderTaskService.getIdsByDynamicCondition(clz, conditions, start, limit);
  }
  
  @Override
  public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
    return venderTaskService.fakeDelete(clz, id);
  }
  
  @Override
  public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
    venderTaskService.deleteList(clz, ids);
    
  }
  
  @Override
  public Object getObjectByDynamicCondition(Class clz, Map<String, Object> conditions,
                                            Integer start, Integer limit)
      throws ServiceException, ServiceDaoException {
    
    return this.venderTaskService.getObjectByDynamicCondition(clz, conditions, start, limit);
  }
  
  @Override
  public List<Integer> getVenderTaskSummary(Long id) throws ServiceException, ServiceDaoException {
    return venderTaskService.getVenderTaskSummary(id);
  }
  
}
