/**
 * 
 */
package com.ptteng.haichuan.audit.client;

import java.util.List;
import java.util.Map;

import com.ptteng.haichuan.audit.model.Inventory;
import com.ptteng.haichuan.audit.service.InventoryService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class InventorySCAClient implements InventoryService {
  
  
  private InventoryService inventoryService;
  
  public InventoryService getInventoryService() {
    return inventoryService;
  }
  
  public void setInventoryService(InventoryService inventoryService) {
    this.inventoryService = inventoryService;
  }
  
  @Override
  public Long insert(Inventory inventory) throws ServiceException, ServiceDaoException {
    
    return inventoryService.insert(inventory);
    
  }
  
  @Override
  public List<Inventory> insertList(List<Inventory> inventoryList)
      throws ServiceException, ServiceDaoException {
    
    return inventoryService.insertList(inventoryList);
    
  }
  
  @Override
  public boolean delete(Long id) throws ServiceException, ServiceDaoException {
    
    return inventoryService.delete(id);
    
  }
  
  @Override
  public boolean update(Inventory inventory) throws ServiceException, ServiceDaoException {
    
    return inventoryService.update(inventory);
    
  }
  
  @Override
  public boolean updateList(List<Inventory> inventoryList)
      throws ServiceException, ServiceDaoException {
    
    return inventoryService.updateList(inventoryList);
    
  }
  
  @Override
  public Inventory getObjectById(Long id) throws ServiceException, ServiceDaoException {
    
    return inventoryService.getObjectById(id);
    
  }
  
  @Override
  public List<Inventory> getObjectsByIds(List<Long> ids)
      throws ServiceException, ServiceDaoException {
    
    return inventoryService.getObjectsByIds(ids);
    
  }
  
  @Override
  public List<Long> getInventoryIds(Integer start, Integer limit)
      throws ServiceException, ServiceDaoException {
    // TODO Auto-generated method stub
    return inventoryService.getInventoryIds(start, limit);
  }
  
  @Override
  public Integer countInventoryIds() throws ServiceException, ServiceDaoException {
    // TODO Auto-generated method stub
    return inventoryService.countInventoryIds();
  }
  
  @Override
  public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions,
                                             Integer start, Integer limit)
      throws ServiceException, ServiceDaoException {
    // TODO Auto-generated method stub
    return inventoryService.getIdsByDynamicCondition(clz, conditions, start, limit);
  }
  
  @Override
  public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
    // TODO Auto-generated method stub
    return inventoryService.fakeDelete(clz, id);
  }
  
  @Override
  public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
    inventoryService.deleteList(clz, ids);
    
  }
  
  @Override
  public Object getObjectByDynamicCondition(Class clz, Map<String, Object> conditions,
                                            Integer start, Integer limit)
      throws ServiceException, ServiceDaoException {
    
    return this.inventoryService.getObjectByDynamicCondition(clz, conditions, start, limit);
  }
  
}
