package com.ptteng.haichuan.audit.client;

import java.util.List;
import java.util.Map;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.haichuan.audit.model.Storage;
import com.ptteng.haichuan.audit.model.Vender;
import com.ptteng.haichuan.audit.service.AuditCommonService;
import com.ptteng.haichuan.pub.model.Manager;

public class AuditCommonSCAClient implements AuditCommonService {
  
  
  private AuditCommonService auditCommonService;
  
  @Override
  public Map<String, Vender> judgeCurrentManager(Manager manager)
      throws ServiceDaoException, ServiceException {
    return auditCommonService.judgeCurrentManager(manager);
  }
  
  @Override
  public void addHuanXinIMUser(String username) throws ServiceDaoException, ServiceException {
    auditCommonService.addHuanXinIMUser(username);
  }
  
  @Override
  public void pushHuanXinMsg(String username, String content)
      throws ServiceDaoException, ServiceException {
    auditCommonService.pushHuanXinMsg(username, content);
  }
  
  @Override
  public String[] getHuanXinToken() {
    return auditCommonService.getHuanXinToken();
  }
  
  public AuditCommonService getAuditCommonService() {
    return auditCommonService;
  }
  
  public void setAuditCommonService(AuditCommonService auditCommonService) {
    this.auditCommonService = auditCommonService;
  }

  @Override
  public List<Storage> getEsrStorageList(Long venderTaskId)
      throws ServiceDaoException, ServiceException {
    return auditCommonService.getEsrStorageList(venderTaskId);
  }


}
