/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.graship.admin.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.graship.admin.model.Article;
import com.ptteng.graship.admin.service.ArticleService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArticleServiceImpl
extends BaseDaoServiceImpl
implements ArticleService {
    private static final Log log = LogFactory.getLog(ArticleServiceImpl.class);

    public Long insert(Article article) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + article));
        if (article == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        article.setCreateAt(Long.valueOf(currentTimeMillis));
        article.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)article);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + article));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Article> insertList(List<Article> articleList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (articleList == null ? "null" : Integer.valueOf(articleList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(articleList)) {
            return new ArrayList<Article>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Article article : articleList) {
            article.setCreateAt(Long.valueOf(currentTimeMillis));
            article.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(articleList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + articleList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Article.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Article article) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (article == null ? "null" : article.getId())));
        boolean result = false;
        if (article == null) {
            return true;
        }
        article.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)article);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + article));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + article));
        }
        return result;
    }

    public boolean updateList(List<Article> articleList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (articleList == null ? "null" : Integer.valueOf(articleList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(articleList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Article article : articleList) {
            article.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(articleList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + articleList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + articleList.size()));
        return result;
    }

    public Article getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Article article = null;
        if (id == null) {
            return article;
        }
        try {
            article = (Article)this.dao.get(Article.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return article;
    }

    public List<Article> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List article = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Article>();
        }
        try {
            article = this.dao.getList(Article.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (article == null ? "null" : Integer.valueOf(article.size()))));
        return article;
    }

    public List<Long> getArticleIdsByStatusAndSourceOrderByPublishat(Integer status, String source, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by status,source,start,limit  : " + status + " , " + source + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            System.out.println("========================" + this.dao);
            idList = this.dao.getIdList("getArticleIdsByStatusAndSourceOrderByPublishat", new Object[]{status, source}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by status,source,start,limit)  : " + status + " , " + source + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getArticleIdsBySourceOrderByPublishat(String source, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by source,start,limit  : " + source + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getArticleIdsBySourceOrderByPublishat", new Object[]{source}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by source,start,limit)  : " + source + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getArticleIdsByTypeAndStatusOrderByPublishat(Integer type, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by type,start,limit  : " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = type == 2 ? this.dao.getIdList("getArticleIdsByTypeAndStatusOrderByPublishatAscs", new Object[]{type, status}, start, limit, false) : this.dao.getIdList("getArticleIdsByTypeAndStatusOrderByPublishatDesc", new Object[]{type, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by type,status,start,limit)  : " + type + " , " + status + " ," + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getArticleIdsByTypeAndStatus(Integer type, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by type,start,limit  : " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            log.info((Object)(" dao = " + this.dao));
            idList = this.dao.getIdList("getArticleIdsByTypeAndStatusOrderByPublishatDesc", new Object[]{type, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by type,status,start,limit)  : " + type + " , " + status + " ," + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countArticleIdsByStatusAndSourceOrderByPublishat(Integer status, String source) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by status,source  : " + status + " , " + source));
        }
        Integer count = null;
        try {
            count = this.dao.count("getArticleIdsByStatusAndSourceOrderByPublishat", new Object[]{status, source});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by status,source)  : " + status + " , " + source));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countArticleIdsBySourceOrderByPublishat(String source) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by source  : " + source));
        }
        Integer count = null;
        try {
            count = this.dao.count("getArticleIdsBySourceOrderByPublishat", new Object[]{source});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by source)  : " + source));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countArticleIdsByTypeAndStatusOrderByPublishat(Integer type, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by type  : " + type));
        }
        Integer count = null;
        try {
            count = this.dao.count("getArticleIdsByTypeAndStatusOrderByPublishat", new Object[]{type, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by type,status)  : " + type + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getArticleIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getArticleIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countArticleIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getArticleIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getArticleIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

