package com.ptteng.graship.home.util;



import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.graship.home.model.Component;
import com.ptteng.graship.home.model.Moduls;
import com.ptteng.graship.home.model.Product;
import com.ptteng.graship.home.model.Serve;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.eclipse.jetty.util.log.Log;

import java.sql.Timestamp;
import java.util.*;


/**
 * Created by liangxj on 2015/9/7.
 */
public class DynamicUtil {

	public static Map<String, Object> getIdsParam(Long startAt, Long endAt,
			String name, String mobile, Boolean count) {

		Map<String, Object> params = new HashMap<String, Object>();


		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put(" create_at & >= ", "'" +startAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put(" create_at & <= ", "'" +endAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("name","'" +name + "'");
		}
		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("mobile", "'" +mobile + "'");
		}


		if (count) {
			params.put("@query", " count(id) ");
		} else {
			params.put("@order", "  create_at desc ");
			params.put("@query", " id ");
		}
		params.put("@table", "  user ");

		return params;
	}

	public static Map<String, Object> getCpyIdsParam(String cpyName, String phone,
												  String name, String mobile,String grade,Integer spare,Boolean count) {

		Map<String, Object> params = new HashMap<String, Object>();


		if (DataUtils.isNotNullOrEmpty(cpyName)) {
			params.put(" cpyName ", "'" +cpyName + "'");
		}
		if (DataUtils.isNotNullOrEmpty(phone)) {
			params.put(" phone ", "'" +phone+ "'");
		}
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("name","'" +name + "'");
		}
		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("mobile", "'" +mobile + "'");
		}
		if(DataUtils.isNotNullOrEmpty(grade)){
			params.put("grade", "'" +grade +"'");
		}
		if(DataUtils.isNotNullOrEmpty(spare)){
			params.put("spare", "'" +spare+ "'");
		}

		if (count) {
			params.put("@query", " count(id) ");
		} else {
			params.put("@order", "  create_at desc ");
			params.put("@query", " id ");
		}
		params.put("@table", "  user ");

		return params;
	}

	public static Map<String, Object> getModulsServeaAll(){
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("query", "distinct servea");
		params.put("@table", "moduls");
	return params;
	}
	public static Map<String, Object> getCpy(Long uid){
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("uid", uid);
		params.put("@table", "company");
	return params;
	}
	public static Map<String, Object> getModulsServebAll(String servea){
		Map<String, Object> params = new HashMap<String, Object>();



		params.put("servea", "'" + servea + "'");

		params.put("@query", " id");
		params.put("@table", "moduls");
		return params;
	}
	//根据服务查公司ids
	public static Map<String, Object> getCpyByServe(String cpyName, String servea, String serveb, String servec) {
		Map<String, Object> params = new HashedMap();
		if (DataUtils.isNotNullOrEmpty(cpyName)) {
			params.put("create_by", "'" +cpyName+"'" );
		}
		if (DataUtils.isNotNullOrEmpty(servea)) {
			params.put("servea", "'" +servea+ "'");
		}
		if (DataUtils.isNotNullOrEmpty(serveb)) {
			params.put("serveb", "'" +serveb+ "'");
		}
		if (DataUtils.isNotNullOrEmpty(servec)) {
			params.put("servec", "'" +servec+ "'");
		}
		params.put("query", "id");
		params.put("@table", "moduls");
		return params;
	}

	//获得未读消息、
	public static Map<String, Object> getmessageListStage(Integer mstage,Long id) {
		Map<String, Object> params = new HashedMap();
		if (DataUtils.isNotNullOrEmpty(mstage)) {
			params.put("mstage", "'" +mstage+ "'");
		}
		if (DataUtils.isNotNullOrEmpty(id)) {
			params.put("create_by", id);
		}

		params.put("@query", "id");
		params.put("@table", "message");
		return params;
	}

	public static Map<String, Object> getCpyListIds(String cpyName,String industry,
	 String stage,String name,String mobile,String status,Long startAt,Long endAt){
		Map<String, Object> params = new HashedMap();
		if (DataUtils.isNotNullOrEmpty(cpyName)) {
			params.put("cpy_name", "'" +cpyName+ "'");
		}
		if (DataUtils.isNotNullOrEmpty(industry)) {
			params.put("industry","'" + industry+ "'");
		}
		if (DataUtils.isNotNullOrEmpty(stage)) {
			params.put("stage","'" + stage+ "'");
		}
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("name", "'" +name+ "'");
		}
		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("mobile","'" +mobile+ "'");
		}
		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("staus","'" + status+ "'");
		}
		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put("apply_at & >=","'" + startAt+ "'");
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put("apply_at & <=","'" + endAt+ "'");
		}
		params.put("@order", "  status desc ");
		params.put("@query", "id");
		params.put("@table", "user");
		return params;
	}
//
	public static Map<String, Object> getSeaveListIds(String cpyName,String servea,
													String serveb,String staus,Long startAt,Long endAt){
		Map<String, Object> params = new HashedMap();
		if (DataUtils.isNotNullOrEmpty(cpyName)) {
			params.put("cpy_name", "'" +cpyName+ "'");
		}

		if (DataUtils.isNotNullOrEmpty(staus)) {
			params.put("staus","'" + staus+ "'");
		}
		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put("create_at & >=","'" + startAt+ "'");
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put("create_at & <=","'" + endAt+ "'");
		}
		params.put("@order", "  staus desc ");
		params.put("@query", "id");
		params.put("@table", "serve");
		return params;
	}

	
	//判断是企业服务还是项目融资
			public static Map<String, Object> getModulsAllList(Integer groups){
		Map<String, Object> params = new HashedMap();
		
		if(groups==1){
			params.put(" groups", 1);
		}else{
			params.put(" groups",2);	
		}
		
		params.put("parent_id", Moduls.PARENT_ID );
		params.put("groups", "'" + groups + "'");

		params.put("@query", " id");
		params.put("@table", "moduls");
		return params;
		}
			
			
			
			
		//获得服务类别的子集的公司列表的sql语句
		public static Map<String, Object> getModulsServeUserId(Long servea,Long serveb){
		Map<String, Object> params = new HashedMap();
		
		if (DataUtils.isNotNullOrEmpty(servea)){
			params.put(" servea ", "'" +servea + "'");
		}
		
		
		if (DataUtils.isNotNullOrEmpty(serveb)){
			params.put(" serveb ", "'" +serveb + "'");
		}
		//params.put("@order", "  create_at desc ");
			params.put("@query", " id ");
		
			params.put("@table", "  serve ");
			return params;
		}

		//获取前台获取个人cpy详情
		public static Map<String, Object> getIdsByCpyId(Long id) {
			Map<String, Object> params = new HashedMap();
			if(0!=id){
			params.put(" cpy_id", "'" +id + "'");
			}
			params.put("@order", "  create_at desc ");
			params.put("@query", " id ");			
			params.put("@table", " serve ");
			
			return params;
		}

		public static Map<String, Object> getOrderIdsByCpyId(Long id,Integer ostage) {
			Map<String, Object> params = new HashedMap();
			if (DataUtils.isNotNullOrEmpty(ostage)) {
				params.put("ostage","'" + ostage+ "'");
			}
			params.put(" cpy_id", "'" +id + "'");
			params.put("@order", "  ostage desc ");
			params.put("@query", " id ");	
			params.put("@table", " orderr ");
			
			return params;
		}

		public static Map<String, Object> getSonModulsByGroupList(Integer groups, Long parentId) {
			Map<String, Object> params = new HashedMap();
			if(groups==1){
			params.put(" groups", 1);
			}else{
				params.put(" groups",2);	
			}
			
			params.put(" parent_id", parentId );
			
			params.put("@order", " create_at desc ");
			params.put("@query", "id");
			params.put("@table", "moduls");
			return params;
		}

		public static Map<String, Object> getModulsServea(Integer groups,Long parentId) {
			Map<String, Object> params = new HashedMap();
			if (DataUtils.isNotNullOrEmpty(groups)){
				params.put("groups", "'" + groups+ "'");
			}
			params.put("parent_id", Serve.PARENT_ID);
			params.put("@order", "create_at desc");
			params.put("@query", "id");
			params.put("@table", "moduls");
			return params;
		}
		
		//获得子类接口
		public static Map<String, Object> getModulsServeb(Long serveaId) {
			Map<String, Object> params = new HashedMap();

			params.put("parent_id",serveaId);

			params.put("@order", "create_at desc");
			params.put("@query", "id");
			params.put("@table", "moduls");
			return params;
		}

		//根据用户id获取message的id
		public static Map<String, Object> getMessageIdsByuserId(Long id,boolean read) {
			Map<String, Object> params = new HashedMap();
			Set<String> tables = new HashSet();
			tables.add("message");
			if(!read){
				params.put("if_read &=", 0);
			}
			params.put("uid &=", id);
			params.put("@order", "create_at desc");
			params.put("@query", "id");
			String table = SQLUtil.convertTable(tables);
			params.put("@table", table);
			return params;
		}

		//返回所有的消息
		public static Map<String, Object> getAllMessageIds(Long id){
			Map<String, Object> params = new HashedMap();

			params.put("uid &=",id);
			params.put("@order", "create_at desc ");
			params.put("@query", "id");
			params.put("@table", "message");

			return params;
		}



		public static Map<String, Object> getIdsBygrade(Integer grade){
			Map<String, Object> params = new HashedMap();
			
			if (DataUtils.isNotNullOrEmpty(grade)) {
				params.put("grade ", "'" + grade + "'");
			}
			
			params.put("@order", "create_at desc ");
			params.put("@query", "id");
			params.put("@table", "user");
			
			return params;
		}
		
		public static Map<String, Object> getIdsByparentId(Long id){
			Map<String, Object> params = new HashedMap();
			params.put("@table", "server");
			
			params.put("parent_id", id);
			
			params.put("@order","sort");
			params.put("@query", "id");
			return params;
		
		}
		
		public static Map<String, Object> getIdsByServerId(Long id){
			Map<String, Object> params = new HashedMap();
			Set<String> tables = new HashSet();
			tables.add("server s");
			tables.add("company c");
			tables.add("company_server_relation csr");
			params.put("c.status", 2);
			params.put("c.id", "csr.cid");
			params.put("csr.status", 2);
			params.put("s.id", "csr.sid");
			
			params.put("s.id &=", id);
	
			params.put("@order", "csr.create_at desc");
			params.put("@query", "csr.id");
			String table = SQLUtil.convertTable(tables);
			params.put("@table", table);
			return params;
		
		}
		
		public static Map<String, Object> getCompanyIdsByServerId(Long id){
			Map<String, Object> params = new HashedMap();
			Set<String> tables = new HashSet();
			tables.add("server s");
			tables.add("company c");
			tables.add("company_server_relation csr");
			params.put("csr.status", 2);
			params.put("c.status", 2);
			params.put("c.id", "csr.cid");
			
			params.put("s.id", "csr.sid");
			
			params.put("s.id &=", id);
	
			params.put("@order", "csr.create_at desc");
			params.put("@query", "c.id");
			String table = SQLUtil.convertTable(tables);
			params.put("@table", table);
			return params;
		
		}
		
		public static Map<String, Object> getComidsByServerId(Long id){
			Map<String, Object> params = new HashedMap();
			Set<String> tables = new HashSet();
			tables.add("server s");
			tables.add("company c");
			tables.add("company_server_relation csr");
			params.put("c.status", 2);
			params.put("csr.status", 2);
			params.put("c.id", "csr.cid");
			
			params.put("s.id", "csr.sid");
			
			params.put("s.id &=", id);
	
			params.put("@order", "csr.create_at desc");
			params.put("@query", "c.id");
			String table = SQLUtil.convertTable(tables);
			params.put("@table", table);
			return params;
		
		}
		public static Map<String, Object> getIdsByStatus(Integer status){
			Map<String, Object> params = new HashedMap();
			Set<String> tables = new HashSet();
			tables.add("company c");
			params.put("c.status &=", status);
			params.put("@query", "c.id");
			String table = SQLUtil.convertTable(tables);
			params.put("@table", table);
			return params;
		}
		public static Map<String, Object> getCompanyServerIdsByStatus(Integer status){
			Map<String, Object> params = new HashedMap();
			Set<String> tables = new HashSet();
			tables.add("company_server_relation cs");
			params.put("cs.status &=", status);
			params.put("@query", "cs.id");
			params.put("@order", "cs.create_at desc");
			String table = SQLUtil.convertTable(tables);
			params.put("@table", table);
			return params;
		}
		
		public static Map<String, Object> getCompanyIdsByGradeAndId(Integer grade,Long id){
			Map<String, Object> params = new HashedMap();
			Set<String> tables = new HashSet();
			tables.add("server s");
			tables.add("company c");
			tables.add("company_server_relation csr");
			params.put("c.status", 2);
			params.put("csr.status", 2);
			params.put("s.id", "csr.sid");
			params.put("c.id", "csr.cid");
			if(null!=grade&&!"".equals(grade+""))
			params.put("c.grade &=", grade);
			params.put("s.id &=", id);
			params.put("@query", "c.id");

			params.put("@order", "csr.create_at desc");
			String table = SQLUtil.convertTable(tables);
			params.put("@table", table);
			return params;
		}
		public static Map<String, Object> getCompanyIdsById(Long id){
			Map<String, Object> params = new HashedMap();
			Set<String> tables = new HashSet();
			tables.add("server s");
			tables.add("company c");
			params.put("csr.status", 2);
			params.put("c.status", 2);
			tables.add("company_server_relation csr");
			params.put("s.id", "csr.sid");
			params.put("c.id", "csr.cid");
			params.put("s.id & =", id);
			params.put("@query", "c.id");

			params.put("@order", "csr.create_at desc");
			String table = SQLUtil.convertTable(tables);
			params.put("@table", table);
			return params;
		}
		public static Map<String, Object> getUserCompanyRelation(Long cid,Long uid){
			Map<String, Object> params = new HashedMap();
			Set<String> tables = new HashSet();
			tables.add("user_company_relation ucr");
			params.put("ucr.cid & =", cid);
			params.put("ucr.uid &=", uid);
			params.put("@query", "ucr.id");

			params.put("@order", "ucr.create_at desc");
			String table = SQLUtil.convertTable(tables);
			params.put("@table", table);
			return params;
		}
		public static Map<String, Object> getUserCompanyRelationStatus(Long cid,Long uid){
			Map<String, Object> params = new HashedMap();
			Set<String> tables = new HashSet();
			tables.add("user_company_relation ucr");
			tables.add("company c");
			params.put("ucr.cid", "c.id");
			params.put("ucr.cid & =", cid);
			params.put("ucr.uid &=", uid);
			params.put("c.grade & in", "(1,2,3)");
			params.put("c.status", "2");
			params.put("@query", "ucr.id");

			params.put("@order", "ucr.create_at desc");
			String table = SQLUtil.convertTable(tables);
			params.put("@table", table);
			return params;
		}
		public static Map<String, Object> getCompanyServerByIdAndUid(Long cid,Long sid){
			Map<String, Object> params = new HashedMap();
			Set<String> tables = new HashSet();
			tables.add("server s");
			tables.add("company c");
			tables.add("company_server_relation csr");
			params.put("s.id", "csr.sid");
			params.put("c.id", "csr.cid");
			params.put("csr.cid & =", cid);
			params.put("csr.sid &=", sid);
			params.put("csr.status", 2);
			params.put("c.status", 2);
			params.put("@query", "csr.id");

			params.put("@order", "csr.create_at desc");
			String table = SQLUtil.convertTable(tables);
			params.put("@table", table);
			return params;
		}
		
		public static Map<String, Object> getCompanyServerIdsByUid(Long uid){
			Map<String, Object> params = new HashedMap();
			Set<String> tables = new HashSet();
			tables.add("server s");
			tables.add("company c");
			tables.add("company_server_relation csr");
			params.put("s.id", "csr.sid");
			params.put("c.id", "csr.cid");
			
			params.put("csr.uid &=", uid);
			params.put("@query", "csr.id");
			params.put("@order", "csr.create_at desc");
			String table = SQLUtil.convertTable(tables);
			params.put("@table", table);
			return params;
		}
		
		public static Map<String, Object> getUserServerIdsByStatusAndUid(Long uid,String status){
			Map<String, Object> params = new HashedMap();
			Set<String> tables = new HashSet();
			tables.add("server s");
			tables.add("user u");
			tables.add("user_server_relation ucr");
			
			params.put("s.id", "ucr.sid");
			params.put("u.id", "ucr.uid");
			if(DataUtils.isNotNullOrEmpty(status)){

				params.put("ucr.status & in ", " ("+status+") ");
			}
			params.put("ucr.uid &= ", uid);
			params.put("@query", "ucr.id");
			params.put("@order", "ucr.create_at desc");
			String table = SQLUtil.convertTable(tables);
			params.put("@table", table);
			return params;
		}
		
		

		public static Map<String, Object> getIdsByServerIdAndCompanyId(Long id, Long c) {
			Map<String, Object> params = new HashedMap();
			Set<String> tables = new HashSet();
			tables.add("server s");
			tables.add("company c");
			tables.add("company_server_relation csr");
			params.put("c.status", 2);
			params.put("csr.status", 2);
			params.put("s.id", "csr.sid");
			params.put("c.id", "csr.cid");
			params.put("csr.status", 2);
			params.put("c.status", 2);
			params.put("csr.cid &=", c);
			params.put("csr.sid &=", id);
			params.put("@query", "csr.id");
			params.put("@order", "csr.create_at desc");
			String table = SQLUtil.convertTable(tables);
			params.put("@table", table);
			return params;
		}

		public static Map<String, Object> getCompanyServerByUIdAndSid(Long uid, Long sid) {
			// TODO Auto-generated method stub
			Map<String, Object> params = new HashedMap();
			Set<String> tables = new HashSet();
			tables.add("server s");
			tables.add("user u");
			tables.add("user_server_relation usr");
			
			params.put("s.id", "usr.sid");
			params.put("u.id", "usr.uid");
			params.put("usr.uid &=", uid);
			params.put("usr.sid &=", sid);
			params.put("@query", "usr.id");
			String table = SQLUtil.convertTable(tables);
			params.put("@table", table);
			return params;
		}
		
		//根据项目类型查找项目id
		public static Map<String,Object> getProjectIdsByTypeAndStatus(Integer type,Integer status){
			Map<String, Object> params = new HashedMap();
			params.put("@table", "project");

			params.put("type", type);
			if (DataUtils.isNotNullOrEmpty(status)) {

				params.put("status", status);
			}
			params.put("@query", "id");
			params.put("@order", "create_at desc");
			return params;

		}

		public static Map<String, Object> getProductListIds(){
			Map<String, Object> params = new HashMap<>();

			params.put("status", Product.STATUS_UP);
			params.put("@query","id");
			params.put("@table","product");
			params.put("@order","create_at");
			return params;
		}

		//查询所有状态为上架的父组件
		public static Map<String, Object> getComponentListByPidParams(Long pid){
			Map<String, Object> params = new HashMap<>();
			params.put("parent_id", Component.PARENT_ID);
			params.put("status",Component.STATUS_UP);
			params.put("pid",pid);
			params.put("@query","id");
			params.put("@table","component");
			params.put("@order","create_at");
			return params;
		}

		public static Map<String, Object> getChildComponentListParams(Long parentId){
			Map<String, Object> params = new HashMap<>();
			params.put("parent_id", parentId);
			params.put("status",Component.STATUS_UP);
			params.put("@query","id");
			params.put("@table","component");
			params.put("@order","create_at");
			return params;
		}

		//查询公司名字是葡萄藤的
		public static Map<String, Object> getCompanyId(String cname){
			Map<String, Object> params = new HashMap<>();
			params.put("cname",cname);
			params.put("@query","id");
			params.put("@table","company");
			return params;
		}

} 
