package com.ptteng.graship.home.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;




import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.graship.home.model.RoleModuleRelation;
import com.ptteng.graship.home.service.RoleModuleRelationService;

/**
 * RoleModuleRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class RoleModuleRelationController {
	private static final Log log = LogFactory.getLog(RoleModuleRelationController.class);

	@Autowired
	private RoleModuleRelationService roleModuleRelationService;






    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/roleModuleRelation", method = RequestMethod.GET)
	public String getroleModuleRelationList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/roleModuleRelation  to /roleModuleRelation/view/roleModuleRelationList");

		return "/graship-home-service/roleModuleRelation/view/roleModuleRelationList";
	}
    
    

    
	
	@RequestMapping(value = "/c/roleModuleRelation/{id}", method = RequestMethod.GET)
	public String getRoleModuleRelation(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/roleModuleRelation/" + id + "  to /roleModuleRelation/view/roleModuleRelationDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/graship-home-service/roleModuleRelation/view/roleModuleRelationDetail";
	}
	
	
	
	    
	

	@RequestMapping(value = "/a/roleModuleRelation/{id}", method = RequestMethod.GET)
	public String getRoleModuleRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			RoleModuleRelation roleModuleRelation = roleModuleRelationService.getObjectById(id);
			log.info("get roleModuleRelation data is " + roleModuleRelation);

			model.addAttribute("code", 0);

			model.addAttribute("roleModuleRelation", roleModuleRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get roleModuleRelation error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/graship-home-service/roleModuleRelation/json/roleModuleRelationDetailJson";
	}

	@RequestMapping(value = "/a/roleModuleRelation/{id}", method = RequestMethod.PUT)
	public String updateRoleModuleRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, RoleModuleRelation roleModuleRelation) throws Exception {
		
		log.info("update roleModuleRelation : roleModuleRelation= " + roleModuleRelation);
		
		try {
			
			roleModuleRelationService.update(roleModuleRelation);

			model.addAttribute("code", 0);

			model.addAttribute("roleModuleRelation", roleModuleRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update roleModuleRelation error,id is  " + roleModuleRelation.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/roleModuleRelation", method = RequestMethod.POST)
	public String addRoleModuleRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, RoleModuleRelation roleModuleRelation) throws Exception {
		
		log.info("update roleModuleRelation : roleModuleRelation= " + roleModuleRelation);
		
		try { 
			roleModuleRelation.setId(null);

			roleModuleRelationService.insert(roleModuleRelation);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add roleModuleRelation error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/roleModuleRelation/{id}", method = RequestMethod.DELETE)
	public String deleteRoleModuleRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete roleModuleRelation : id= " + id);
		try {
			roleModuleRelationService.delete(id);

			log.info("add roleModuleRelation success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete roleModuleRelation error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/roleModuleRelation", method = RequestMethod.GET)
	public String getMultiRoleModuleRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<RoleModuleRelation> roleModuleRelationList = roleModuleRelationService.getObjectsByIds(idList);
			log.info("get  roleModuleRelation data is " + roleModuleRelationList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",roleModuleRelationList.size());

			model.addAttribute("roleModuleRelationList", roleModuleRelationList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get roleModuleRelation error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/graship-home-service/roleModuleRelation/json/roleModuleRelationListJson";
	}
	
	
	
	
	
}

