package com.ptteng.graship.home.controller;

import com.ptteng.graship.home.model.Project;
import com.ptteng.graship.home.service.ProjectService;
import com.ptteng.graship.home.util.DynamicUtil;
import com.qding.common.util.DataUtils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Project  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ProjectController {
	private static final Log log = LogFactory.getLog(ProjectController.class);

	@Autowired
	private ProjectService projectService;






    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/project", method = RequestMethod.GET)
	public String getprojectList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/project  to /project/view/projectList");

		return "/graship-home-service/project/view/projectList";
	}
    
    

    		
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 
	
		 @RequestMapping(value = "/c/project1 ", method = RequestMethod.GET)
	public String getProjectIdsByTypeAndStatusOrderByCreateAtList1(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Integer type,Integer status) throws Exception {

		log.info("/project  to /project/view/projectList");

		return "/graship-home-service/project/view/projectList";
	}

	
	
	
	
	
	
	@RequestMapping(value = "/c/project/{id}", method = RequestMethod.GET)
	public String getProject(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/project/" + id + "  to /project/view/projectDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/graship-home-service/project/view/projectDetail";
	}
	
	
	
	    		
			
    /**
	 * 根据项目类型查询该类型下所有的项目id和name
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
	@RequestMapping(value = "/a/project/type/{type} ", method = RequestMethod.GET)
	public String getProjectIdsByTypeAndStatusOrderByCreateAtJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Integer type) throws Exception {
		log.info("get data: type = " + type);
		if(DataUtils.isNullOrEmpty(type)){
			model.addAttribute("code", -1000);
			return "/data/json";
		}
		
		Map<String, Object> param = null;
		try {
			//设置status为0，即查询所有上架的项目
			param = DynamicUtil.getProjectIdsByTypeAndStatus(type, Project.STATUS_UP);
			log.info("get data param=" + param );
			List<Long> ids = projectService.getIdsByDynamicCondition(Project.class, param, 0, Integer.MAX_VALUE);
		    log.info("get countProjectIdsByTypeAndStatusOrderByCreateAt size is " + ids);
		    if(CollectionUtils.isEmpty(ids)){
		    	log.info("ids is empty");
		    	model.addAttribute("code", -1000);
				return "/data/json";
		    }
			List<Project> projectList = projectService.getObjectsByIds(ids);
			log.info("get project data is " + projectList.size());
			model.addAttribute("code", 0);
			model.addAttribute("projectList", projectList);
		} catch (Throwable t) {
			log.error(t.getMessage(),t);
		    log.error("get project list error");
			model.addAttribute("code", -1);
		}
		return "/graship-home-service/project/json/projectListJson";
	}

	
	
		
	
	/**
	 * 根据项目id查询项目详细信息
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */

	@RequestMapping(value = "/a/project/id/{id}", method = RequestMethod.GET)
	public String getProjectJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {
		log.info("get data : id= " + id);
		if(DataUtils.isNullOrEmpty(id)){
			model.addAttribute("code", -1000);
			return "/data/json";
		}
		try {
			Project project = projectService.getObjectById(id);
			if(project == null){
				log.info("project is not find id is" + id);
				model.addAttribute("code", -10001);
				return "/data/json";
			}
			log.info("get project data is project=" + project);
			model.addAttribute("code", 0);
			model.addAttribute("project", project);
		} catch (Throwable t) {
			log.error(t.getMessage(),t);
			log.error("get project error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/graship-home-service/project/json/projectDetailJson";
	}

	
	
	
	
	
	
	@RequestMapping(value = "/a/project/{id}", method = RequestMethod.PUT)
	public String updateProjectJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Project project) throws Exception {
		
		log.info("update project : project= " + project);
		
		try {
			
			projectService.update(project);

			model.addAttribute("code", 0);

			model.addAttribute("project", project);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update project error,id is  " + project.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/project", method = RequestMethod.POST)
	public String addProjectJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Project project) throws Exception {
		
		log.info("update project : project= " + project);
		
		try { 
			project.setId(null);

			projectService.insert(project);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add project error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/project/{id}", method = RequestMethod.DELETE)
	public String deleteProjectJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete project : id= " + id);
		try {
			projectService.delete(id);

			log.info("add project success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete project error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/project", method = RequestMethod.GET)
	public String getMultiProjectJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<Project> projectList = projectService.getObjectsByIds(idList);
			log.info("get  project data is " + projectList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",projectList.size());

			model.addAttribute("projectList", projectList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get project error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/graship-home-service/project/json/projectListJson";
	}
	
	
	
	
	
}

