package com.ptteng.graship.home.controller;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gemantic.common.util.hash.Hash;
import com.ptteng.graship.home.util.DynamicUtil;
import com.ptteng.graship.home.vo.MessageAndInf;
import com.qding.common.util.http.cookie.CookieUtil;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.graship.home.model.Information;
import com.ptteng.graship.home.model.Message;
import com.ptteng.graship.home.model.Order;
import com.ptteng.graship.home.service.InformationService;
import com.ptteng.graship.home.service.MessageService;

/**
 * Message  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class MessageController {
	private static final Log log = LogFactory.getLog(MessageController.class);

	@Autowired
	private MessageService messageService;
	@Autowired
	private CookieUtil cookieUtil;

	@Autowired
	private InformationService informationService;




    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	//获得所有message
	@RequestMapping(value = "/a/u/message/all", method = RequestMethod.GET)
	public String getmessageListAll(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Integer size,Integer page) throws Exception {
			Long id=Long.valueOf(cookieUtil.getKeyIdentity(request,
					com.qding.common.util.http.cookie.CookieUtil.USER_ID));
			log.info("get message by id and id is "+id);

			if (page == null) {
				page = 1;

			}
			if (size == null) {
				size = 10;
			}
			int start = (page - 1) * size;
			if (start < 0) {
				start = 0;
			}
		List<Long> ids=null;
		List<Message> messagesList=null;
			try{								
				//动态sql来查询message表的id				
				Map<String, Object> param = DynamicUtil.getMessageIdsByuserId(id,true);
				log.info("get regist ids param is "+param);
				List<Long> messageIds = messageService.getIdsByDynamicCondition(Message.class, param,start,size);
				//获取所有消息
				Map<String, Object> AllMessageParam = DynamicUtil.getAllMessageIds(id);
				List<Long> totalIdsList =  messageService.getIdsByDynamicCondition(Message.class, AllMessageParam,0,
					Integer
					                                                                                      .MAX_VALUE);
				//返回所有消息的总数
				int totalMessage = totalIdsList.size();
				//获取message对象
				List<Message> messageList = messageService.getObjectsByIds(messageIds);
					List<String> con = new ArrayList<String>();
				List<Long> mst = new ArrayList<Long>();
				Map<String, Object> noReadParam = DynamicUtil.getMessageIdsByuserId(id,false);
				log.info("get regist ids param is "+param);
				List<Long> noReadmessageIds = messageService.getIdsByDynamicCondition(Message.class, noReadParam,0,Integer.MAX_VALUE);	
				
				//用户所有未读的消息				
				int count=noReadmessageIds.size();
						
				log.info("get count ids is" + count);

				int totalPage = 0;
				if (totalMessage % size == 0) {
					totalPage = totalMessage / size;
				} else {
					totalPage = totalMessage / size + 1;
				}
				model.addAttribute("code",page);
				model.addAttribute("size",size);
				model.addAttribute("code",1);
				model.addAttribute("message","success");
				model.addAttribute("total", count);
				model.addAttribute("totalMessage",totalMessage);
				model.addAttribute("totalPage",totalPage);
				model.addAttribute("messageList", messageList);
			}catch (Throwable t) {
				t.printStackTrace();
				log.error(t.getMessage());
				log.error("get message error,id is  " + ids);
				model.addAttribute("code", 0);
				model.addAttribute("message","error");
			}
		
		
		log.info("get /messageList success all");

		return "/graship-home-service/message/json/messageAndInfmationDetailJson";
	}


//获取任意状态的信息
	@RequestMapping(value = "/a/u/message/Stage", method = RequestMethod.GET)
	public String getmessageListStage(HttpServletRequest request,
								 HttpServletResponse response, ModelMap model,Integer page,Integer size,Integer mstage) throws Exception {
		Long createBy=Long.valueOf(cookieUtil.getKeyIdentity(request,
				com.qding.common.util.http.cookie.CookieUtil.USER_ID));
		log.info("get message by id and id is "+createBy);
		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		List<Long> ids=null;
		Map param=null;
		List<Message> messagesList=null;
		if (mstage == null) {
			mstage=0;
		}
		try{
			param = DynamicUtil.getmessageListStage(mstage, createBy);
			log.info("the sql is "+param);
			ids = messageService.getIdsByDynamicCondition(Message.class,param,start,size);
			log.info("get message ids is" + ids);

			messagesList = messageService.getObjectsByIds(ids);
			Integer total=ids.size();
			model.addAttribute("total", total);
			model.addAttribute("messagesList", messagesList);
		}catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get message error,id is  " + ids);
			model.addAttribute("code", -1);
		}


		log.info("get /messageList success all");

		return "/graship-home-service/message/json/messageDetailJson";
	}
    

    
	//批量删除
	@RequestMapping(value = "/a/u/message", method = RequestMethod.DELETE)
	public String getMessage(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {

		log.info("delete message ids is "+ids);
		List<Long> idlist = Arrays.asList(ids);
		if(idlist==null){
			model.addAttribute("code", -1);

			log.info("ids can't be null");
		}
		try{
			for(int s=0;s<ids.length;s++){
				Boolean q = messageService.delete(ids[s]);
			}
			log.info("delete message success idlist is"+idlist);
			model.addAttribute("code", 0);
		}catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete message error,id is  " + idlist);
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	//批量设为已读
	@RequestMapping(value = "/a/u/message", method = RequestMethod.PUT)
	public String updateMessage(HttpServletRequest request,
							 HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {

		log.info("update message ids is "+ids);
		List<Long> idlist = Arrays.asList(ids);
		if(idlist==null){
			model.addAttribute("code", -1);
			log.info("ids can't be null");
		}
		try{
			//messageService.getObjectsByIds(ids);
			for(int s=0;s<ids.length;s++){
				Message message=messageService.getObjectById(ids[s]);
				message.setIfRead(2);
				message.setUpdateAt(System.currentTimeMillis());
				 messageService.update(message);
			}
			log.info("update message success idlist is"+idlist);
			model.addAttribute("code", 0);
		}catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update message error,id is  " + idlist);
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}
	
	
	
	
}

