package com.ptteng.graship.home.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;



import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.graship.home.model.Order;
import com.ptteng.graship.home.service.OrderService;

/**
 * Order  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class OrderController {
	private static final Log log = LogFactory.getLog(OrderController.class);

	@Autowired
	private OrderService orderService;

    @Autowired
    private CookieUtil cookieUtil;

@Test
	public void haha() {
	System.out.println("hello world");
		log.info("orderservice"+orderService);
	}



    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

/*	@RequestMapping(value = "/web/c/order", method = RequestMethod.GET)
	public String getorderList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/web/order  to /order/view/orderList");

		return "/graship-home-service/order/view/orderList";
	}
    */
    

    
	//申请服务
	@RequestMapping(value = "/a/u/order", method = RequestMethod.PUT)
	public String getOrder(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Order order)
			throws Exception {
        Long id=Long.valueOf(cookieUtil.getKeyIdentity(request,
                com.qding.common.util.http.cookie.CookieUtil.USER_ID));
		log.info("add order begin and id is"+id);
		if(null != id){
			return null;
		}
        try{
            order.setId(null);
            order.setuId(id);
            order.setCreateAt(System.currentTimeMillis());
            order.setoStage(0);
            Long oid = orderService.insert(order);
            model.addAttribute("code", 0);
            model.addAttribute("orderId", id);
        }catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get order error,id is  " + id);
            model.addAttribute("code", -1);
        }

		return "/common/success";
	}
	
	
	
	    
	
//查看申请的服务
	@RequestMapping(value = "/a/u/order", method = RequestMethod.GET)
	public String getOrderJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Integer page,Integer size,Integer limit)
			throws Exception {
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}

		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		Long id=Long.valueOf(cookieUtil.getKeyIdentity(request,
				com.qding.common.util.http.cookie.CookieUtil.USER_ID));
		log.info("get order by id= " + id);
		try {
			List<Long> ids = orderService.getOrderIdsById(id,start,limit);
			log.info("get order ids is " + ids);
			List<Order> orderList=orderService.getObjectsByIds(ids);

			model.addAttribute("code", 0);

			model.addAttribute("orderList", orderList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get order error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/graship-home-service/order/json/orderListJson";
	}

	@RequestMapping(value = "/web/a/order/{id}", method = RequestMethod.PUT)
	public String updateOrderJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Order order) throws Exception {
		
		log.info("update order : order= " + order);
		
		try {
			
			orderService.update(order);

			model.addAttribute("code", 0);

			model.addAttribute("order", order);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update order error,id is  " + order.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/order", method = RequestMethod.POST)
	public String addOrderJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Order order) throws Exception {
		
		log.info("update order : order= " + order);
		Long id=Long.valueOf(cookieUtil.getKeyIdentity(request,
				com.qding.common.util.http.cookie.CookieUtil.USER_ID));

		
		try { 
			order.setId(null);

			orderService.insert(order);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add order error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/web/a/order/{id}", method = RequestMethod.DELETE)
	public String deleteOrderJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete order : id= " + id);
		try {
			orderService.delete(id);

			log.info("add order success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete order error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/web/a/multi/order", method = RequestMethod.GET)
	public String getMultiOrderJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<Order> orderList = orderService.getObjectsByIds(idList);
			log.info("get  order data is " + orderList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",orderList.size());

			model.addAttribute("orderList", orderList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get order error,id is  " + idList);
			model.addAttribute("code", -1);
		}

		return "/graship-home-service/order/json/orderListJson";
	}
	
	
}

