 package com.ptteng.graship.home.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.noelios.restlet.http.HttpRequest;
import com.ptteng.graship.home.model.Moduls;
import com.ptteng.graship.home.model.Serve;
import com.ptteng.graship.home.model.User;
import com.ptteng.graship.home.service.ModulsService;
import com.ptteng.graship.home.service.ServeService;
import com.ptteng.graship.home.service.UserService;
import com.ptteng.graship.home.util.ComparatorList;
import com.ptteng.graship.home.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.formula.functions.Count;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by Administrator on 2016/6/14.
 */
@Controller
public class ModulsController {
    private static final Log log = LogFactory.getLog(MessageController.class);

    @Autowired
    private ModulsService modulsService;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private ServeService serveService;
    @Autowired
    private UserService userService;

    //第三方服务的服务类别
    @RequestMapping(value = "/a/u/moduls/list", method = RequestMethod.GET)
	public String addServeJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer groups,Integer page, Integer size) throws Exception {
		
		log.info("update serve : serve= " +   groups);
		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		
		try { 
			
			//List<Long> modulsIdList = modulsService.getModulsAllByGrade(Moduls.father);
			Map<String, Object> param = DynamicUtil.getModulsAllList(groups);
			log.info("param is" + param);

			List<Long> modulsIdList = modulsService.getIdsByDynamicCondition(Moduls.class,param,start,size);
			
			List<Moduls> modulsList =  modulsService.getObjectsByIds(modulsIdList);
			
			model.addAttribute("code", 0);
			model.addAttribute("modulsList", modulsList);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add serve error ");
			model.addAttribute("code", -1);
		}

		return "/graship-home-service/moduls/json/messageListJson";
	}
    
                                                                                                                                    
   
    //服务类别的子集
    @RequestMapping(value = "/a/u/moduls/listnext", method = RequestMethod.GET)
	public String addSonServeJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long parentId,Integer groups,Integer page, Integer size) throws Exception {

		log.info("update serve : serve= " +   groups);
		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		
		log.info("update serve : serve= " + parentId);
		
		try { 	
			
			Map<String, Object> param = DynamicUtil.getSonModulsByGroupList(groups,parentId);
			log.info("param is" + param);

			List<Long> modulsIdList = modulsService.getIdsByDynamicCondition(Moduls.class,param,start,size);
			
			
			
			
			log.error("自己写的111。。。。。。。。。。。 ");
			//List<Long> modulsParentList = modulsService.getSonIdsByParents(parentId);
			
			List<Moduls> modulsList =  modulsService.getObjectsByIds(modulsIdList);
			
			
			model.addAttribute("code", 0);
			model.addAttribute("modulsList", modulsList);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add serve error ");
			model.addAttribute("code", -6002);
		}

		return "/graship-home-service/moduls/json/messageListJson";
	}
    
 
    

    
    //获得服务类别的子集的公司列表
  	@RequestMapping(value = "/a/u/moduls/user", method = RequestMethod.GET)
  	public String getuserList(HttpServletRequest request,
  			HttpServletResponse response,  ModelMap model,Long servea, Long serveb, Integer grade, boolean count, Integer page, Integer size) throws Exception {
  		log.info("getUserLIst /a/u/user  to /user/view/userList");

  		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
	  		List<Long> ids=null;
	  		List<User> userList=new ArrayList<User>();
	  		Integer total=null;
  		
  			log.info("get ids by name: servea " + servea+" serveb+ "+serveb +" count: "+count+" page : "+page);

  			
  			try { 
  				//ids是该子类别下的serve表的id
  				Map<String, Object> param = DynamicUtil.getModulsServeUserId(servea, serveb);
  	  			log.info("param is" + param);
  	  			
  	  			ids = serveService.getIdsByDynamicCondition(Serve.class,param,0,Integer.MAX_VALUE);
  	  			
  	  			total=ids.size();
  	  		
  	  			List<Serve> serveList = serveService.getObjectsByIds(ids);
  	  		//获取服务列表的所有公司id
//  	  				serve表的id--对象--cpyId--user表的对象
  	  			for(Serve serve2 : serveList){
  	  			
  	  				Long cpId = serve2.getCpyId();
  	  			    User user = userService.getObjectById(cpId);
  	  			    userList.add(user);
  	  			}
  	  			
//  	  		List<Long> cpyId = serveService.getCpyIds(ids);
  	  			
  	  			
  	  			
  	  		//获取公司列表
  	  		log.info("cpyId====================="+ids);
//  	  		users = userService.getObjectsByIds(cpyId);
  	  		log.info("users======================="+userList);
  	  			
  	  			model.addAttribute("code", 0);
  	  			model.addAttribute("total", total);
  	  			model.addAttribute("userList",userList);


  			} catch (Throwable t) {
  			    t.printStackTrace();
  				log.error(t.getMessage());
  				log.error("/a/u/moduls/user ");
  				model.addAttribute("code", -6002);
  			}

  			
  		return "/graship-home-service/user/json/userListJson";
  	}

  		
  	
  		//点击Level得到对应的列表
  	@RequestMapping(value="/a/u/moduls/user/grade" , method=RequestMethod.GET)
  	public String getLevelList(HttpServletRequest request, HttpServletResponse response, ModelMap model, 
  			Integer grade ,Integer page, Integer size, Integer limit){
  		
  		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 8;
		}
		if (limit == null) {
			limit=1000086;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
  		
		
		try {
			
  		//通过grade字段得到对应的id
			Map<String, Object> params = DynamicUtil.getIdsBygrade(grade);
  		log.info("params ===="+params);
  		List<Long> idsList = userService.getIdsByDynamicCondition(User.class, params, start, limit);
  		
  		//通过id得到UserList列表
  		Integer total = idsList.size();
  		log.info("total is :" + total);
  		List<User> userList = userService.getObjectsByIds(idsList); 
  		
  		model.addAttribute("code",0);
  		model.addAttribute("total", total);
  		model.addAttribute("userList", userList);
  		
			
		}catch (Throwable t){
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get LevelList error ");
			model.addAttribute("code", -1);
		}
  		
  		
  		
		return "/graship-home-service/user/json/userListJson";
  	}
  	
  	
    
	  	//点击立即申请count+1,并返回总数
	  /*	@RequestMapping(value="/a/u/moduls/count",method=RequestMethod.PUT)
	  	public String getCount(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long id, Long count){
	  		
	  		try{
	  			User user = userService.getObjectById(id);
	  			Long count1=user.getCount();
	  			count1=count1+1;
	  			user.setCount(count1);
	  			model.addAttribute("code", 0);
	  			model.addAttribute("count",count);
	  			model.addAttribute("user", user);
	  			
	  			boolean result = userService.update(user);
	  			if(result==true){
	  				log.info("update success");
	  			}
	  			
	  			
	  			
	  		}catch(Throwable t){
	  			t.printStackTrace();
	  			log.error("update faild");
	  			model.addAttribute("code", -1);
	  			
	  		}
	  		
	  		
	  		return "/common/success1";
	  	}
*/
}

