package com.ptteng.graship.home.controller;

import com.ptteng.graship.home.model.Component;
import com.ptteng.graship.home.model.Product;
import com.ptteng.graship.home.service.ComponentService;
import com.ptteng.graship.home.service.ProductService;
import com.ptteng.graship.home.util.DynamicUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Component  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 *
 */
@Controller
public class ComponentController {
	private static final Log log = LogFactory.getLog(ComponentController.class);

	@Autowired
	private ComponentService componentService;

	private ProductService productService;




	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/component", method = RequestMethod.GET)
	public String getcomponentList(HttpServletRequest request,
	                               HttpServletResponse response, ModelMap model) throws Exception {



		log.info("/component  to /component/view/componentList");

		return "/graship-home-service/component/view/componentList";
	}

/*
* 点击产品显示组件列表
* @param id
* @return componentList
*
* */

	@RequestMapping(value = "/a/component/{pid}", method = RequestMethod.GET)
	public String getComponent(HttpServletRequest request,
	                           HttpServletResponse response, ModelMap model, @PathVariable Long pid,
	                           Integer page, Integer size)throws Exception {

		log.info("get componentList from product ,pid is:" + pid + ",url is  to /a/component/{pid}");
		//入参校验
		if(null != pid){
			log.info("pid is ：" + pid);
		}else{
			log.error("pid is null");
			model.addAttribute("code",-10200);
		}


		List<Long> idsList = new ArrayList();
		List<Component> componentList = new ArrayList<>();
		List<Component> componentList1 = new ArrayList<>();
		List<Component> componentList2 = new ArrayList<>();

		Long childComponentParentId = null;
		List<Long> childIdsList = new ArrayList<>();
		try {
			//拼接params，查询所有状态为上架的父组件
			Map<String, Object> params = DynamicUtil.getComponentListByPidParams(pid);
			log.info("params is :" + params);
			//执行sql
			idsList = componentService.getIdsByDynamicCondition(Component.class, params, 0, Integer.MAX_VALUE);
			log.info("idsList is :" + idsList);

			//得到组件列表
			componentList = componentService.getObjectsByIds(idsList);
			log.info("componentList are :" + componentList);
			componentList2.addAll(componentList);
			if (null == componentList) {
				log.error("componentList is null,get componentList failed >_<");
				model.addAttribute("code", -10123);
				return "/common/success";
			}
			//遍历组件，取出组件的id，即为子组件的parentId，通过parentId且状态为上架 得到子组件列表，列表合并输出
			for(Component component:componentList){
				log.info("component is ：" + component);
				childComponentParentId = component.getId();
				Map<String, Object> params2 = DynamicUtil.getChildComponentListParams(childComponentParentId);
				log.info("params2 is :" + params2);
				childIdsList=componentService.getIdsByDynamicCondition(Component.class,params2,0,Integer.MAX_VALUE);
				componentList1 = componentService.getObjectsByIds(childIdsList);
				log.info("child component List is :" + componentList1);

				componentList2.addAll(componentList1);
			}
			log.info("componentList2 is :" + componentList2);

			int total = componentList2.size();
			model.addAttribute("code", 0);
			model.addAttribute("total", total);
			model.addAttribute("componentList", componentList2);
		}catch (Throwable t){
			log.error(t.getMessage());
			log.error("get componentList error,I don't mean so >_<");
			model.addAttribute("code",-1);
		}

		return "/graship-home-service/component/json/componentListJson";
	}





	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/a/component1 ", method = RequestMethod.GET)
	public String getComponentIdsByPidAndStatusOrderByCreateAtJsonList(HttpServletRequest request,
	                                                                   HttpServletResponse response, ModelMap model, Integer page,
	                                                                   Integer size,Long pid,Integer status) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= componentService.getComponentIdsByPidAndStatusOrderByCreateAt(pid,status,start,size);
			log.info("get countComponentIdsByPidAndStatusOrderByCreateAt size is " + ids.size());

			List<Component> componentList = componentService.getObjectsByIds(ids);
			log.info("get component data is " + componentList.size());

			Integer total = componentService. countComponentIdsByPidAndStatusOrderByCreateAt(pid,status);
			log.info("get component count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("componentList", componentList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get component list error,page is  " + start + " , size "
				          + size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/graship-home-service/component/json/componentListJson";
	}







	/*@RequestMapping(value = "/a/component/{id}", method = RequestMethod.GET)
	public String getComponentJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Component component = componentService.getObjectById(id);
			log.info("get component data is " + component);

			model.addAttribute("code", 0);

			model.addAttribute("component", component);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get component error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/graship-home-service/component/json/componentDetailJson";
	}
*/

	@RequestMapping(value = "/a/component/{id}", method = RequestMethod.PUT)
	public String updateComponentJson(HttpServletRequest request,
	                                  HttpServletResponse response, ModelMap model, Component component) throws Exception {

		log.info("update component : component= " + component);

		try {

			componentService.update(component);

			model.addAttribute("code", 0);

			model.addAttribute("component", component);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update component error,id is  " + component.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/component", method = RequestMethod.POST)
	public String addComponentJson(HttpServletRequest request,
	                               HttpServletResponse response, ModelMap model, Component component) throws Exception {

		log.info("update component : component= " + component);

		try {
			component.setId(null);

			componentService.insert(component);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add component error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/component/{id}", method = RequestMethod.DELETE)
	public String deleteComponentJson(HttpServletRequest request,
	                                  HttpServletResponse response, ModelMap model, @PathVariable Long id)
		throws Exception {

		log.info("delete component : id= " + id);
		try {
			componentService.delete(id);

			log.info("add component success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete component error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}


	@RequestMapping(value = "/a/multi/component", method = RequestMethod.GET)
	public String getMultiComponentJson(HttpServletRequest request,
	                                    HttpServletResponse response, ModelMap model, Long[] ids)
		throws Exception {

		List<Long> idList = new ArrayList();
		if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {



			List<Component> componentList = componentService.getObjectsByIds(idList);
			log.info("get  component data is " + componentList);

			model.addAttribute("code", 0);
			model.addAttribute("total",componentList.size());

			model.addAttribute("componentList", componentList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get component error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/graship-home-service/component/json/componentListJson";
	}
	
	
	
	
	
}

