package com.ptteng.graship.home.interceptor;


import com.ptteng.graship.home.model.User;
import com.ptteng.graship.home.service.UserService;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Map;



public class UserInterceptor extends HandlerInterceptorAdapter {

    private static final Log log = LogFactory.getLog(UserInterceptor.class);

    @Autowired
    private UserService userService;

    @Autowired
    private CookieUtil cookieUtil;

    /**
     * In this case intercept the request BEFORE it reaches the controller
     */
    @Override
    public boolean preHandle(HttpServletRequest request,
                             HttpServletResponse response, Object handler) throws Exception {
    	log.info("request uri: "+request.getRequestURI());
    	
        Cookie[] cookies = request.getCookies();
        log.info("get cookies  " + Arrays.asList(cookies));
        Map<String, String> maps = cookieUtil.getIdentity(request);
        log.info("get maps  from cookie is " + maps);
        Long uid = cookieUtil.getID(request);
        if (uid == null) {

            log.error("not legal user request");
            return wrongUser(response);

        }
        log.info("get uid  from cookie is " + uid);
        User user = this.userService.getObjectById(uid);
        if (user == null) {
            log.error(uid + " not get any data ");
            return wrongUser(response);
        } else {
            log.info("get usr " + user);
            request.setAttribute("user", user);
        }
        log.info("get uid is " + uid);

        return true;
    }

    private boolean wrongUser(HttpServletResponse response) throws IOException {

        response.sendRedirect("/a/wrong");

        return false;

    }

    @Override
    public void postHandle(HttpServletRequest request,
                           HttpServletResponse response, Object handler,
                           ModelAndView modelAndView) throws Exception {

        log.info("p =========================================== ");
    }

    /**
     * 获取跳转链接的地址
     *
     * @param request
     * @return
     */
    public String getInterceptorUrl(HttpServletRequest request) {

        String interceptorUrl = request.getRequestURI()
                + (null == request.getQueryString() ? "" : "?"
                + request.getQueryString()).toString();
        interceptorUrl = interceptorUrl.replace("/app/", "/");

        log.info("get getInterceptorUrl is " + interceptorUrl);

        return interceptorUrl;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {

        String x = URLEncoder.encode("p/hello", "utf-8");
        log.info(x);

    }
}
