package com.ptteng.graship.home.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;




import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.graship.home.model.UserServerRelation;
import com.ptteng.graship.home.service.UserServerRelationService;

/**
 * UserServerRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserServerRelationController {
	private static final Log log = LogFactory.getLog(UserServerRelationController.class);

	@Autowired
	private UserServerRelationService userServerRelationService;






    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/userServerRelation", method = RequestMethod.GET)
	public String getuserServerRelationList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/userServerRelation  to /userServerRelation/view/userServerRelationList");

		return "/graship-home-service/userServerRelation/view/userServerRelationList";
	}
    
    

    
	
	@RequestMapping(value = "/c/userServerRelation/{id}", method = RequestMethod.GET)
	public String getUserServerRelation(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/userServerRelation/" + id + "  to /userServerRelation/view/userServerRelationDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/graship-home-service/userServerRelation/view/userServerRelationDetail";
	}
	
	
	
	    
	

	@RequestMapping(value = "/a/userServerRelation/{id}", method = RequestMethod.GET)
	public String getUserServerRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			UserServerRelation userServerRelation = userServerRelationService.getObjectById(id);
			log.info("get userServerRelation data is " + userServerRelation);

			model.addAttribute("code", 0);

			model.addAttribute("userServerRelation", userServerRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userServerRelation error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/graship-home-service/userServerRelation/json/userServerRelationDetailJson";
	}

	@RequestMapping(value = "/a/userServerRelation/{id}", method = RequestMethod.PUT)
	public String updateUserServerRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, UserServerRelation userServerRelation) throws Exception {
		
		log.info("update userServerRelation : userServerRelation= " + userServerRelation);
		
		try {
			
			userServerRelationService.update(userServerRelation);

			model.addAttribute("code", 0);

			model.addAttribute("userServerRelation", userServerRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update userServerRelation error,id is  " + userServerRelation.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userServerRelation", method = RequestMethod.POST)
	public String addUserServerRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, UserServerRelation userServerRelation) throws Exception {
		
		log.info("update userServerRelation : userServerRelation= " + userServerRelation);
		
		try { 
			userServerRelation.setId(null);

			userServerRelationService.insert(userServerRelation);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add userServerRelation error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userServerRelation/{id}", method = RequestMethod.DELETE)
	public String deleteUserServerRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete userServerRelation : id= " + id);
		try {
			userServerRelationService.delete(id);

			log.info("add userServerRelation success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete userServerRelation error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/userServerRelation", method = RequestMethod.GET)
	public String getMultiUserServerRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			log.info("ids:"+ids);
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<UserServerRelation> userServerRelationList = userServerRelationService.getObjectsByIds(idList);
			log.info("get  userServerRelation data is " + userServerRelationList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",userServerRelationList.size());

			model.addAttribute("userServerRelationList", userServerRelationList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get userServerRelation error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/graship-home-service/userServerRelation/json/userServerRelationListJson";
	}
	
	
	
	
	
}

