package com.ptteng.graship.home.controller;

import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ptteng.common.storage.util.CaptchaUtil;
import com.ptteng.graship.home.constant.InterfaceCodeConstant;
import com.ptteng.graship.home.interceptor.CookieConstant;
import com.ptteng.graship.home.model.CompanyServerRelation;
import com.ptteng.graship.home.model.Message;
import com.ptteng.graship.home.model.Moduls;
import com.ptteng.graship.home.model.Order;
import com.ptteng.graship.home.model.Serve;
import com.ptteng.graship.home.model.Sms;
import com.ptteng.graship.home.service.CompanyServerRelationService;
import com.ptteng.graship.home.service.MessageService;
import com.ptteng.graship.home.service.ModulsService;
import com.ptteng.graship.home.service.OrderService;
import com.ptteng.graship.home.service.ServeService;
import com.ptteng.graship.home.service.UserService;
import com.ptteng.graship.home.util.DynamicUtil;
import com.ptteng.graship.home.vo.ModulsAndOrder;
import com.ptteng.graship.home.vo.ModulsAndUser;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.http.cookie.RequestUtil;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.PasswordUtils;
import com.gemantic.common.util.StringUtil;
import com.gemantic.common.util.http.cookie.MD5Util;
import com.ptteng.graship.home.service.SmsService;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.graship.home.model.User;

/**
 * User crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserController {
	private static final Log log = LogFactory.getLog(UserController.class);

	@Autowired
	private UserService userService;

	@Autowired
	private OrderService orderService;

	@Autowired
	private SmsService smsService;

	@Autowired
	private ModulsService modulsService;

	@Autowired
	private MessageService messageService;

	@Autowired
	private CookieUtil cookieUtil;

	@Autowired
	private ServeService serveService;
	@Autowired
	private CompanyServerRelationService companyServerRelationService;
	@Resource(name = "accountConfig")
	private Map<String, String> accountConfig;

	private boolean isCaptcha = false;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	// =============================登录注册========================================
	// 用户登录
	@RequestMapping(value = "/a/login", method = RequestMethod.POST)
	public String aLogin(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile,
			String pwd) throws Exception {

		log.info("mobile is " + mobile + "pwd is " + pwd);

		if (mobile == null) {
			model.addAttribute("code", -1000);

			return "/common/success";
		}

		Long uid = userService.getUserIdByMobile(mobile);
		if (uid == null) {
			model.addAttribute("code", -2000);
			return "/common/success";
		}
		log.info(" uid is " + uid);
		User user = this.userService.getObjectById(uid);
		String pass = PasswordUtils.encode(pwd);
		Boolean verify = user.getPwd().equals(pass);
		if (verify) {
			log.info(uid + " login ");
			Map<String, String> maps = new HashMap();

			maps.put(CookieUtil.USER_ID, uid + "");
			maps.put(CookieConstant.Cookie_WEB_mobile, mobile);
			cookieUtil.setIdentity(request, response, maps, uid);

			model.addAttribute("code", 0);
			model.addAttribute("uid", uid);

		} else {
			log.info(mobile + " wrong pwd " + pwd);

			model.put("code", -2006);

			return "/common/success";

		}

		return "/graship-home-service/user/json/register";
	}

	// 个人信息
	@RequestMapping(value = "/a/u/user", method = RequestMethod.GET)
	public String userSeeSelf(HttpServletRequest request, HttpServletResponse response, ModelMap model, String name,
			String mail, String head) throws Exception {
		log.info(" name:" + name + ", mail:" + mail + ", head:" + head);
		Long id = Long
				.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));

		// 根据id获取对象
		User user = userService.getObjectById(id);
		log.info("  user is" + user);

		model.addAttribute("code", 1);
		model.addAttribute("message", "success");
		model.addAttribute("user", user);

		return "/graship-home-service/user/json/userDetailJson";
	}

	// 验证手机号码是否已经注册
	@RequestMapping(value = "/a/mobile", method = RequestMethod.GET)
	public String verifyNick(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile)
			throws Exception {

		log.info("verify the mobile: " + mobile);

		if (StringUtils.isBlank(mobile)) {
			model.addAttribute("code", -1000);
			log.info("params is null");
			return "/common/success";
		}
		try {
			Long id = userService.getUserIdByMobile(mobile);
			log.info("1111111111111111111111111111111111111111111111111111111111");
			if (id != null) {
				model.addAttribute("code", -2007);
				log.info("mobile exist");
				return "common/success";
			}
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add user error ");
			model.addAttribute("code", -1);
		}

		return "common/success";

	}

	// 3、用户注册
	@RequestMapping(value = "/a/user", method = RequestMethod.POST)
	public String register(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile,
			String verify, String password) throws Exception {

		String type = "register";

		log.info(mobile + " is mobile " + verify + " is verify " + password + " is password ");

		if (mobile == null) {
			log.info("mobile is null");
			model.addAttribute("code", -2001);
			return "/common/success";
		}
		if (StringUtils.isBlank(verify)) {
			log.info("verify is null");
			model.addAttribute("code", -2005);
			return "/common/success";
		}
		if (StringUtils.isBlank(password)) {
			log.info("password is null");
			model.addAttribute("code", -2006);
			return "/common/success";
		}

		try {
			// 是否已注册
			Long uid = userService.getUserIdByMobile(mobile);

			if (uid != null) {
				log.info(mobile + " is already exist  " + uid);
				model.addAttribute("code", -2007);

				return "/common/success";

			} else {
				log.info(mobile + " not exist ,so can register ");
			}

			boolean verifyResult = false;

			if (verifyModel()) {
				log.info("is test model ");
				if ("555555".equals(verify)) {
					log.info("test ,so not verify mobile ");
					verifyResult = true;
				} else {
					log.info("log1: mobile is " + mobile + ",type = " + type + ",verify" + verify);
					verifyResult = verifyMobileCode(model, mobile, type, verify);
				}
			} else {
				log.info("log1: mobile is " + mobile + ",type = " + type + ",verify" + verify);
				verifyResult = verifyMobileCode(model, mobile, type, verify);
			}

			// 校验验证码
			Long now = System.currentTimeMillis();
			SimpleDateFormat myFmt2 = new SimpleDateFormat("yyyyMMdd");
			String date = myFmt2.format(now);
			if (verifyResult) {
				User user = new User();
				user.setMobile(mobile);
				mobile.split(mobile);
				// 生成带星号码
				// if (name.equals(null)) {
				// String result = "";
				// char b[] = mobile.toCharArray();
				// for (int i = 0; i < b.length; i++) {
				// String c;
				// if (i > 2 && i < 8) {
				// c = "*";
				// } else {
				// c = b[i] + "";
				// }
				// result = result + c;
				// }
				// log.info(result);
				// user.setName(result);
				// } else {
				// user.setName(name);
				// }
				user.setHead("http://test.download.ptteng.com/skill/thumb/84da5e81-cee8-4ebd-ba43-359192a211c0.png");

				String encodePass = PasswordUtils.encode(password);
				user.setPwd(encodePass);

				Long userID = userService.insert(user);
				log.info(mobile + " register success,userID is " + userID);

				Map<String, String> maps = new HashMap();
				maps.put(CookieUtil.USER_ID, userID + "");
				maps.put(CookieConstant.Cookie_WEB_mobile, mobile);
				cookieUtil.setIdentity(request, response, maps, userID);

				model.put("uid", userID);

				model.addAttribute("code", 0);

			} else {
				log.error("wrong verifycode");
				model.addAttribute("code", -2005);

				return "/common/success";
			}

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add user error ");
			model.addAttribute("code", -1);
		}

		return "/graship-home-service/user/json/register";
	}

	private boolean verifyModel() {

		return "test".equals(this.accountConfig.get("testModel"));

	}

	// 验证码校验
	private boolean verifyMobileCode(ModelMap model, String mobile, String type, String verify)
			throws ServiceException, ServiceDaoException {
		log.info("log2: mobile is " + mobile + ",type = " + type + ",verify" + verify);
		// 是否有发送验证码
		Long sid = smsService.getSmsIdByMobileAndType(mobile, type);
		log.info("sid is " + sid);

		if (sid == null) {
			return false;
		}
		// 获取验证码信息
		Sms sms = smsService.getObjectById(sid);
		log.info("sms is " + sms);
		// 获取验证码
		String message = sms.getMessage();
		log.info("message is " + message);

		// 发送是否超时
		Long delay = System.currentTimeMillis() - sms.getSendAt();

		if (delay > 600000) {
			log.info("require verify too long");
			return false;
		}

		if (message.equals(verify)) {
			return true;
		} else {
			return false;
		}

	}

	// 发送验证码
	@RequestMapping(value = "/a/code/send", method = RequestMethod.POST)
	public String sendVerify(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile,
			String type) throws ServiceException, ServiceDaoException {
		log.info(mobile + " want send sms of type " + type);

		// if (!isCaptcha){
		// model.addAttribute("code", -2005);
		// return "/common/success";
		// }

		if (StringUtils.isBlank(mobile)) {
			log.info(mobile + " want send sms of type " + type + " null mobile ");
			model.addAttribute("code", InterfaceCodeConstant.Mobile_Null);
			return "/common/success";
		}

		// if (StringUtils.isBlank(type)) {
		// type = "password";
		// }

		if ("register".equals(type)) {
			Long uid = this.userService.getUserIdByMobile(mobile);
			if (uid != null) {

				log.info(type + " is already exist  " + mobile);

				model.addAttribute("code", InterfaceCodeConstant.Mobile_AlreadyExist);
				return "/common/success";
			}

		} else {
			Long uid = this.userService.getUserIdByMobile(mobile);
			if (uid == null) {

				log.info(type + " is not already exist  " + mobile);

				model.addAttribute("code", InterfaceCodeConstant.User_NotExist);
				return "/common/success";
			}
		}

		int code = InterfaceCodeConstant.System_Success;

		try {
			String result = this.smsService.sendMsg(mobile, type);
			// smsService.getSmsIdByMobileAndType(mobile,type);

			switch (result) {
			case SmsService.ErrorCode_SMS_InvalidType:
				code = InterfaceCodeConstant.VerifyCode_Type_NotSupport;
				break;
			case SmsService.ErrorCode_SMS_smsMoreThan5:
				code = InterfaceCodeConstant.VerifyCode_MoreThan5;
				break;
			default:

			}

			model.addAttribute("code", code);

		} catch (Exception t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error(mobile + " send message error of type " + type);
			model.addAttribute("code", InterfaceCodeConstant.System_Exception);

		}
		return "/common/success";

	}

	// 忘记密码接口
	@RequestMapping(value = "/a/password/forget", method = RequestMethod.PUT)
	public String rewritepwd(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile,
			String verify, String newpwd) throws Exception {
		try {

			// 是否已注册
			Long uid = userService.getUserIdByMobile(mobile);

			// 用户不存在
			if (uid == null) {
				log.info(mobile + " not exist ");
				model.addAttribute("code", -2000);

				return "/common/success";

			} else {
				log.info(mobile + " exist and uid is " + uid);
			}

			boolean verifyResult = false;

			String type = "password";

			// 测试模式
			if (verifyModel()) {
				if ("555555".equals(verify)) {
					log.info("test ,so not verify mobile ");
					verifyResult = true;
				} else {
					verifyResult = verifyMobileCode(model, mobile, type, verify);
				}
			} else {
				verifyResult = verifyMobileCode(model, mobile, type, verify);
			}

			if (verifyResult) {
				User user = userService.getObjectById(uid);
                
				String encodePass = PasswordUtils.encode(newpwd);
				//验证是否新密码旧密码相同
				if(user.getPwd().equals(encodePass))
				{
					model.addAttribute("code", -2010);
					return "/common/success";
				}
				user.setPwd(encodePass);
				boolean result = userService.update(user);

				log.info(mobile + " change password," + newpwd + "result is " + result);
				log.error("rewrite password success! ");

				model.addAttribute("code", 0);
			} else {
				log.error("rewritepwd verifycode");
				model.addAttribute("code", -2005);

				return "/common/success";
			}

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add user error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";

	}

	// 7、退出登录
	@RequestMapping(value = "/a/u/logout", method = RequestMethod.POST)
	public String logout(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
		log.info(" welcome to manager logout ");

		try {
			cookieUtil.clearCookie(response);

			model.addAttribute("code", 0);

			return "/common/success";
		} catch (Throwable t) {
			log.error("user logout error  ");
			t.printStackTrace();

			return "/common/success";

		}

	}

	// =============================用户中心========================================

	// 用户中心详情页
	@RequestMapping(value = "/a/u/user/self", method = RequestMethod.GET)
	public String getUserJson(HttpServletRequest request, HttpServletResponse response, ModelMap model)
			throws Exception {

		Long id = Long
				.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
		log.info("get data : id= " + id);
		try {
			User user = userService.getObjectById(id);
			log.info("get user data is " + user);

			model.addAttribute("code", 0);

			model.addAttribute("user", user);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get user error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/graship-home-service/user/json/userDetailJson";
	}

	// 修改个人信息
	@RequestMapping(value = "/a/u/user/self", method = RequestMethod.PUT)
	public String updateSelf(HttpServletRequest request, HttpServletResponse response, ModelMap model, String name,
			String mail, String head) throws Exception {
		if (name == null && mail == null && head == null) {
			log.info("update false can't be null");
			model.addAttribute("code", -1);
			return null;
		}
		log.info("update cpy name=" + name + "mail" + mail + "head" + head);
		Long uid = Long
				.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
		try {

			User user = userService.getObjectById(uid);

			user.setName(name);
			user.setMail(mail);
			user.setHead(head);
			log.info("update user and user is" + user);
			userService.update(user);

			model.addAttribute("code", 0);
			model.addAttribute("user", user);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("update  error,id is  ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	// 修改密码
	@RequestMapping(value = "/a/u/pwd/change", method = RequestMethod.PUT)
	public String updatepwd(HttpServletRequest request, HttpServletResponse response, ModelMap model, String pwd,
			String pwdNew) throws Exception {
		log.info("pwd============= " + pwd);
		log.info("pwdNew============= " + pwdNew);
		Long uid = Long
				.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
		log.info("get data : id= " + uid);

		User user = userService.getObjectById(uid);
		// 以前存储的密码
		String pwdOld = user.getPwd();
		log.info("pwdOld======");
		// 用户输入的原密码
		String pwdoldencode = PasswordUtils.encode(pwd);
		// 用户输入的新密码
		String pwdnewencode = PasswordUtils.encode(pwdNew);
		log.info("pwdnewencode======");
		log.info(pwdOld + "======" + pwdoldencode);
		log.info("pwdnewencode======" + pwdnewencode);
		// 校验用户输入的密码是否正确
		if (pwdoldencode.equals(pwdOld)) {
			log.info("update true ,pwd can be update" + pwd);

			user.setPwd(pwdnewencode);
			userService.update(user);
			model.addAttribute("code", 0);
			return "/common/success";

		} else {

			log.info("update fault ,pwd can not be update" + pwd);
			model.addAttribute("code", -10000);
			return null;

		}

	}

	// 更新公司信息
	@RequestMapping(value = "/a/u/user/cpy", method = RequestMethod.PUT)
	public String updateMyCpy(HttpServletRequest request, HttpServletResponse response, ModelMap model, String logo,
			String cpyName, String webside, String phone, String industry, Integer stage, String profile,
			String details, String servers, String advantage, String advertising) throws Exception {
		Long uid = Long
				.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
		log.info("update cpyname=" + cpyName + "webside" + webside + "phone" + phone);
		try {
			User user = userService.getObjectById(uid);
			/*
			 * user.setCpyName(cpyName); user.setWebside(webside);
			 * user.setPhone(phone); user.setIndustry(industry);
			 * user.setStage(stage); user.setProfile(profile);
			 * user.setDetails(details); user.setServers(servers);
			 * user.setAdvantage(advantage); user.setAdvertising(advertising);
			 */
			log.info("update user and user is" + user);
			Boolean result = userService.update(user);

			model.addAttribute("code", 0);

			model.addAttribute("user", user);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("update  error,id is  ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	// 用户中心-提供服务
	@RequestMapping(value = "/a/u/user/selfserve", method = RequestMethod.GET)
	public String getUserProServe(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Integer size, Integer page) throws Exception {

		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		// 从cookie中获取用户id
		Long id = Long
				.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
		log.info("get data : id= " + id);
		if (id == null) {
			log.info("id不存在" + id);
			model.addAttribute("code", -2000);
		}
		try {
			// 根据公司id获取服务列表的多种服务
			Map<String, Object> param = DynamicUtil.getIdsByCpyId(id);
			log.info("get regist ids param is " + param);
			List<Long> serveIds = serveService.getIdsByDynamicCondition(Serve.class, param, start, size);
			List<Long> total = serveService.getIdsByDynamicCondition(Serve.class, param, 0, Integer.MAX_VALUE);
			Integer totalList = total.size();
			log.info("get totalList ids param is=ooooooooooooo " + totalList);
			// 获取服务对象列表
			List<Serve> serveList = serveService.getObjectsByIds(serveIds);
			log.info("get user data is " + serveList.toString());

			List<ModulsAndUser> modulsAndUserList = new ArrayList<ModulsAndUser>();
			List<Long> modulsServeaIds = new ArrayList();
			List<Long> modulsServebIds = new ArrayList();

			// 循环获得serve表中servea和serveb
			for (Serve serve : serveList) {
				modulsServeaIds.add(serve.getServea());
				modulsServebIds.add(serve.getServeb());

				ModulsAndUser modulsAndUser = new ModulsAndUser();
				modulsAndUser.setServe(serve);
				modulsAndUserList.add(modulsAndUser);
			}
			log.info("get user modulsServebIds is " + modulsServebIds.toString());

			// 分别获取moduls中的对象
			List<Moduls> modulsaList = modulsService.getObjectsByIds(modulsServeaIds);
			List<Moduls> modulsbList = modulsService.getObjectsByIds(modulsServebIds);

			log.info("get modulsaList======123====== modulsaList is " + modulsaList.toString());
			// 遍历将moduls放进list中
			int i = 0;
			for (ModulsAndUser modulsAndUser : modulsAndUserList) {
				modulsAndUser.setModulsServea(modulsaList.get(i));
				modulsAndUser.setModulsServeb(modulsbList.get(i));
				i++;
			}

			log.info("get modulsAndUserList ids param is " + modulsAndUserList);
			model.addAttribute("code", 0);
			model.addAttribute("total", totalList);
			model.addAttribute("modulsAndUserList", modulsAndUserList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get user error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/graship-home-service/user/json/userSuccServeModulsListJson";
	}

	// 服务信息-申请认证

	// 展示父类接口
	@RequestMapping(value = "/a/admin/moduls/modulsa", method = RequestMethod.GET)
	public String getserveaList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Integer groups, Long parentId, Integer size, Integer page) throws Exception {
		log.info("get moduls and moduls ids is = i don't know");
		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		Map<String, Object> param = DynamicUtil.getModulsServea(groups, parentId);
		log.info("param is" + param);

		List<Long> modulsIds = modulsService.getIdsByDynamicCondition(Moduls.class, param, start, size);

		List<Moduls> modulsList = modulsService.getObjectsByIds(modulsIds);

		log.info("get modulsAndUserList ids param is " + modulsList);

		model.addAttribute("code", 0);
		model.addAttribute("modulsList", modulsList);

		return "/graship-home-service/serve/json/userServeaJson";

	}

	// 展示子类的接口
	@RequestMapping(value = "/a/admin/moduls/modulsb", method = RequestMethod.POST)
	public String getservebList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long parentId,
			Integer groups, Integer size, Integer page, Long serveaId) throws Exception {
		log.info("get moduls and moduls ids is = i don't know");
		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		Map<String, Object> param = DynamicUtil.getModulsServeb(serveaId);
		List<Long> modulsIds = modulsService.getIdsByDynamicCondition(Moduls.class, param, start, size);

		List<Moduls> modulsList = modulsService.getObjectsByIds(modulsIds);

		log.info("param is" + param);
		log.info("get modulsAndUserList ids param is " + modulsList);

		model.addAttribute("code", 0);
		model.addAttribute("modulsList", modulsList);

		return "/graship-home-service/serve/json/userServebJson";
	}

	// 申请认证
	@RequestMapping(value = "/a/u/user/selfproserve", method = RequestMethod.PUT)
	public String getUserProModuls(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long sid,
			Long uid, Long cid, String favo) throws Exception {

		log.info("param is" + sid + ":uid" + uid + ":cid" + cid);
		try {
			CompanyServerRelation serve = new CompanyServerRelation();
            
			serve.setSid(sid);
			serve.setCid(cid);
			serve.setUid(uid);
			serve.setFavo(favo);
			serve.setStatus(1);
			companyServerRelationService.insert(serve);
			log.info("update cpy successqqqqq");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("更新异常了！！！ ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	// 我的服务--服务申请===============================================================

	@RequestMapping(value = "/a/u/user/selforder", method = RequestMethod.GET)
	public String getUserProOrder(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Integer size, Integer page, Integer ostage) throws Exception {

		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		Long id = Long
				.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
		log.info("get data : id= " + id);
		try {
			// 根据公司id获取order的id
			Map<String, Object> param = DynamicUtil.getOrderIdsByCpyId(id, ostage);
			log.info("get regist ids param is " + param);
			List<Long> orderIds = orderService.getIdsByDynamicCondition(Order.class, param, start, size);
			// 获取总数
			List<Long> total = orderService.getIdsByDynamicCondition(Order.class, param, 0, Integer.MAX_VALUE);
			Integer totalList = total.size();
			// 获取order对象
			List<Order> orderList = orderService.getObjectsByIds(orderIds);

			List<ModulsAndOrder> modulsAndOrderList = new ArrayList<ModulsAndOrder>();
			List<Long> applyaIds = new ArrayList();
			List<Long> applybIds = new ArrayList();

			// 将order加入list
			for (Order order : orderList) {

				applyaIds.add(order.getApplya());
				applybIds.add(order.getApplyb());

				ModulsAndOrder modulsAndOrder = new ModulsAndOrder();
				modulsAndOrder.setOrder(order);
				modulsAndOrderList.add(modulsAndOrder);
			}

			List<Moduls> modulsaList = modulsService.getObjectsByIds(applyaIds);
			List<Moduls> modulsbList = modulsService.getObjectsByIds(applybIds);

			// 将父类服务和子类服务加入到list中
			// 123
			int i = 0;
			for (ModulsAndOrder modulsAndOrder : modulsAndOrderList) {
				modulsAndOrder.setModulsApplya(modulsaList.get(i));
				modulsAndOrder.setModulsApplyb(modulsbList.get(i));
				i++;
			}

			log.info("get modulsAndUserList ids param is " + modulsAndOrderList);
			model.addAttribute("code", 0);
			model.addAttribute("total", totalList);
			model.addAttribute("modulsAndOrderList", modulsAndOrderList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get user error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/graship-home-service/order/json/userOrderModulsListJson";
	}

	/**
	 * 编辑用户
	 */
	@RequestMapping(value = "/a/u/change/user", method = RequestMethod.PUT)
	public String updateUser(HttpServletRequest request, HttpServletResponse response, ModelMap model, String name,
			String mail, Long id, String head) throws Exception {
		try {
			User user = userService.getObjectById(id);
			// 邮箱
			if (StringUtil.isEmpty(mail)) {
				user.setMail("");
			} else {
				user.setMail(mail);
			}
			// 姓名
			if (StringUtil.isEmpty(mail)) {
				user.setName("");
			} else {
				user.setName(name);
			}
			// 头像
			if (StringUtil.isEmpty(mail)) {
				user.setHead("");
			} else {
				user.setHead(head);
			}
			userService.update(user);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("更新异常了！！！ ");
			model.addAttribute("code", -1);
		}
		return "/common/success";

	}
	// 生成图形验证码
			@RequestMapping(value = "/a/captcha/generate", method = RequestMethod.GET)
			public void captchaGenerate(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
				log.info("To captchaGenerate ------------------");
				try {
					// 设置页面不缓存
					response.reset();
					response.setHeader("Pragma", "No-cache");
					response.setHeader("Cache-Control", "no-cache");
					response.setDateHeader("Expires", 0);
					response.setContentType("image/gif");

					// 生成随机字符
					String randomStr = RandomStringUtils.randomAlphabetic(4).toUpperCase();
					log.info("randomStr: " + randomStr);
					// 存入cookie
					response.addCookie(new Cookie("captcha", MD5Util.getMd5Sum(randomStr)));

					// 生成图片流
					BufferedImage bi = new CaptchaUtil().generate(165, 40, randomStr).getImage();
					// 创建输出流
					OutputStream out = response.getOutputStream();
					// 将图片写入到输出流中去
					ImageIO.write(bi, "JPG", out);
					// 强制刷新
					out.flush();
					// 关闭输出流
					out.close();
				} catch (Exception e) {
					log.error("get captchaGenerate error", e);
					model.addAttribute("code", -1);
				}

			}


			// 验证图形验证码
			@RequestMapping(value = "/a/captcha/verify", method = RequestMethod.GET)
			public String captchaVerify(HttpServletRequest request, HttpServletResponse response, ModelMap model,
										String inputValue) throws Exception {
				log.info("To captchaVerify ------------------");

				log.info("inputValue: " + inputValue);

				try {
					String cookieValue = "";
					try {
						cookieValue = RequestUtil.getCookie(request, "captcha").getValue();
					} catch (Exception e) {
						log.error("got error when getCookie");
					}
					log.info("cookieValue: " + cookieValue);

					if (StringUtils.isBlank(inputValue) || StringUtils.isBlank(cookieValue)) {
						model.addAttribute("code", -2009);
						return "/common/success";
					}

					String md5Value = "";
					try {
						md5Value = MD5Util.getMd5Sum(inputValue.toUpperCase());
					} catch (NoSuchAlgorithmException e) {
						log.error("got error when getMD5");
					}

					log.info("md5Value: " + md5Value);

					if (md5Value.equals(cookieValue)) {
						isCaptcha = true;
						model.addAttribute("code", 0);
					} else {
						isCaptcha = false;
						model.addAttribute("code", -2009);
					}
				} catch (Exception e) {
					log.error("get captchaVerify error", e);
					model.addAttribute("code", -1);
				}

				return "/common/success";
			}

}
