package com.ptteng.graship.home.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.graship.home.util.DynamicUtil;
import com.ptteng.graship.home.model.Company;
import com.ptteng.graship.home.model.UserCompanyRelation;
import com.ptteng.graship.home.service.CompanyService;
import com.ptteng.graship.home.service.UserCompanyRelationService;

/**
 * UserCompanyRelation crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserCompanyRelationController {
	private static final Log log = LogFactory.getLog(UserCompanyRelationController.class);

	@Autowired
	private UserCompanyRelationService userCompanyRelationService;
	@Autowired
	private CompanyService companyService;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/userCompanyRelation", method = RequestMethod.GET)
	public String getuserCompanyRelationList(HttpServletRequest request, HttpServletResponse response, ModelMap model)
			throws Exception {

		log.info("/userCompanyRelation  to /userCompanyRelation/view/userCompanyRelationList");

		return "/graship-home-service/userCompanyRelation/view/userCompanyRelationList";
	}

	@RequestMapping(value = "/c/userCompanyRelation/{id}", method = RequestMethod.GET)
	public String getUserCompanyRelation(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("/userCompanyRelation/" + id + "  to /userCompanyRelation/view/userCompanyRelationDeail");
		if (null != id) {
			model.addAttribute("id", id);
		} else {
			model.addAttribute("id", 0);
		}

		return "/graship-home-service/userCompanyRelation/view/userCompanyRelationDetail";
	}

	@RequestMapping(value = "/a/userCompanyRelation/{id}", method = RequestMethod.GET)
	public String getUserCompanyRelationJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			UserCompanyRelation userCompanyRelation = userCompanyRelationService.getObjectById(id);
			log.info("get userCompanyRelation data is " + userCompanyRelation);

			model.addAttribute("code", 0);

			model.addAttribute("userCompanyRelation", userCompanyRelation);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userCompanyRelation error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/graship-home-service/userCompanyRelation/json/userCompanyRelationDetailJson";
	}

	@RequestMapping(value = "/a/userCompanyRelation/{id}", method = RequestMethod.PUT)
	public String updateUserCompanyRelationJson(HttpServletRequest request, HttpServletResponse response,
			ModelMap model, UserCompanyRelation userCompanyRelation) throws Exception {

		log.info("update userCompanyRelation : userCompanyRelation= " + userCompanyRelation);

		try {

			userCompanyRelationService.update(userCompanyRelation);

			model.addAttribute("code", 0);

			model.addAttribute("userCompanyRelation", userCompanyRelation);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update userCompanyRelation error,id is  " + userCompanyRelation.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/cpy/regist", method = RequestMethod.PUT)
	public String updateUserCompanyRelationJson(HttpServletRequest request, HttpServletResponse response,
			ModelMap model, String barcode, String license, String creditCode, Long uid, Long cid) throws Exception {

		log.info("update userCompanyRelation : barcode= " + barcode + ":license:" + license + ":creditCode:"
				+ creditCode);

		try {
			Map<String, Object> param = new HashMap<String, Object>();
			param = DynamicUtil.getUserCompanyRelation(cid, uid);
			List<Long> idList = userCompanyRelationService.getIdsByDynamicCondition(UserCompanyRelation.class, param, 0,
					Integer.MAX_VALUE);
			UserCompanyRelation userCompanyRelation = new UserCompanyRelation();
			if (idList.size() > 0) { // 判断有无审核通过且等级为L1及以上的，没有则新增
				Map<String, Object> param1 = new HashMap<String, Object>();
				param1 = DynamicUtil.getUserCompanyRelationStatus(cid, uid);
				List<Long> idList1 = userCompanyRelationService.getIdsByDynamicCondition(UserCompanyRelation.class,
						param1, 0, Integer.MAX_VALUE);
				UserCompanyRelation userCompanyRelation1 = new UserCompanyRelation();
				if (idList1.size() > 0) {
					// 不能提交，已存在审核通过且公司等级为L1及以上的记录
					model.addAttribute("code", -7004);
					return "/common/success";
				}
				// 有 则更新
				/*
				 * userCompanyRelation=userCompanyRelationService.getObjectById(
				 * idList.get(0)); userCompanyRelation.setBarcode(barcode);
				 * userCompanyRelation.setCreditCode(creditCode);
				 * userCompanyRelation.setLicense(license);
				 * userCompanyRelationService.update(userCompanyRelation);
				 */
				
			}
			// 新增
			Company company = new Company();
			company = companyService.getObjectById(cid);
			userCompanyRelation.setCid(cid);
			userCompanyRelation.setUid(uid);
			userCompanyRelation.setBarcode(barcode);
			userCompanyRelation.setCreditCode(creditCode);
			userCompanyRelation.setLicense(license);
			company.setStatus(1);
			userCompanyRelation.setStatus(1);
			companyService.update(company);
			userCompanyRelationService.insert(userCompanyRelation);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add userCompanyRelation error ");
			model.addAttribute("code", -10000);
		}

		return "/common/success";
	}

	@RequestMapping(value = "/a/userCompanyRelation", method = RequestMethod.POST)
	public String addUserCompanyRelationJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			UserCompanyRelation userCompanyRelation) throws Exception {

		log.info("update userCompanyRelation : userCompanyRelation= " + userCompanyRelation);

		try {
			userCompanyRelation.setId(null);

			userCompanyRelationService.insert(userCompanyRelation);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add userCompanyRelation error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userCompanyRelation/{id}", method = RequestMethod.DELETE)
	public String deleteUserCompanyRelationJson(HttpServletRequest request, HttpServletResponse response,
			ModelMap model, @PathVariable Long id) throws Exception {

		log.info("delete userCompanyRelation : id= " + id);
		try {
			userCompanyRelationService.delete(id);

			log.info("add userCompanyRelation success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete userCompanyRelation error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/multi/userCompanyRelation", method = RequestMethod.GET)
	public String getMultiUserCompanyRelationJson(HttpServletRequest request, HttpServletResponse response,
			ModelMap model, Long[] ids) throws Exception {
		log.info("ids:" + ids);
		List<Long> idList = new ArrayList();
		if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			List<UserCompanyRelation> userCompanyRelationList = userCompanyRelationService.getObjectsByIds(idList);
			log.info("get  userCompanyRelation data is " + userCompanyRelationList);

			model.addAttribute("code", 0);
			model.addAttribute("total", userCompanyRelationList.size());

			model.addAttribute("userCompanyRelationList", userCompanyRelationList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get userCompanyRelation error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/graship-home-service/userCompanyRelation/json/userCompanyRelationListJson";
	}

}
