package com.ptteng.graship.home.controller;

import java.util.ArrayList;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.graship.home.model.Company;
import com.ptteng.graship.home.model.CompanyServerRelation;
import com.ptteng.graship.home.model.Message;
import com.ptteng.graship.home.model.Server;
import com.ptteng.graship.home.model.User;
import com.ptteng.graship.home.model.UserCompanyRelation;
import com.ptteng.graship.home.model.UserServerRelation;
import com.ptteng.graship.home.service.CompanyServerRelationService;
import com.ptteng.graship.home.service.CompanyService;
import com.ptteng.graship.home.service.MessageService;
import com.ptteng.graship.home.service.ServerService;
import com.ptteng.graship.home.service.UserCompanyRelationService;
import com.ptteng.graship.home.service.UserServerRelationService;
import com.ptteng.graship.home.service.UserService;
import com.ptteng.graship.home.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;

/**
 * Server crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ServerController {
	private static final Log log = LogFactory.getLog(ServerController.class);
	
	@Autowired
	private ServerService serverService;

	@Autowired
	private CompanyService companyService;

	@Autowired
	private UserService userService;

	@Autowired
	private UserCompanyRelationService userCompanyRelationService;

	@Autowired
	private UserServerRelationService userServerRelationService;

	@Autowired
	private CookieUtil cookieUtil;

	@Autowired
	private CompanyServerRelationService companyServerRelationService;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/server", method = RequestMethod.GET)
	public String getserverList(HttpServletRequest request, HttpServletResponse response, ModelMap model)
			throws Exception {

		log.info("/server  to /server/view/serverList");

		return "/graship-home-service/server/view/serverList";
	}

	@RequestMapping(value = "/c/server/{id}", method = RequestMethod.GET)
	public String getServer(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("/server/" + id + "  to /server/view/serverDeail");
		if (null != id) {
			model.addAttribute("id", id);
		} else {
			model.addAttribute("id", 0);
		}

		return "/graship-home-service/server/view/serverDetail";
	}

	@RequestMapping(value = "/a/server/{id}", method = RequestMethod.GET)
	public String getServerJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			Server server = serverService.getObjectById(id);
			log.info("get server data is " + server);

			model.addAttribute("code", 0);

			model.addAttribute("server", server);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get server error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/graship-home-service/server/json/serverDetailJson";
	}

	@RequestMapping(value = "/a/server/{id}", method = RequestMethod.PUT)
	public String updateServerJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Server server) throws Exception {

		log.info("update server : server= " + server);

		try {

			serverService.update(server);

			model.addAttribute("code", 0);

			model.addAttribute("server", server);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update server error,id is  " + server.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/server/{id}", method = RequestMethod.DELETE)
	public String deleteServerJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete server : id= " + id);
		try {
			serverService.delete(id);

			log.info("add server success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete server error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	/**
	 * 服务二级列表
	 * 
	 * @param request
	 * @param response
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "/a/server/list", method = RequestMethod.GET)
	public String getMultiServerJson(HttpServletRequest request, HttpServletResponse response, ModelMap model) {

		List<Long> idList = new ArrayList();

		Map<String, Object> param = new HashMap<String, Object>();

		List<Long> sidList;
		List<Server> serverList;
		try {
			param = DynamicUtil.getIdsByparentId(0L);
			sidList = serverService.getIdsByDynamicCondition(Server.class, param, 0, Integer.MAX_VALUE);
			serverList = serverService.getObjectsByIds(sidList);
			model.addAttribute("code", 1);
			model.addAttribute("message", "success");
			model.addAttribute("serverList", serverList);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
		}

		return "/graship-home-service/server/json/serverListJson";
	}

	/**
	 * 点击服务后公司的显示
	 * 
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/server/company/list", method = RequestMethod.GET)
	public String getCompanyServerJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long id) {
		log.info("id:" + id);
		Map<String, Object> mparam = new HashMap<String, Object>();

		List<Long> spidList;
		List<Server> parentList;

		Map<String, Object> param = new HashMap<String, Object>();

		List<Long> sidList;
		try {
			mparam = DynamicUtil.getIdsByparentId(0L);
			spidList = serverService.getIdsByDynamicCondition(Server.class, mparam, 0, Integer.MAX_VALUE);
			parentList = serverService.getObjectsByIds(spidList);
			if (id == null || "".equals(id)) {
				id = spidList.get(0);
			}
			param = DynamicUtil.getIdsByparentId(id);

			sidList = serverService.getIdsByDynamicCondition(Server.class, param, 0, Integer.MAX_VALUE);
			List<Server> serverList = serverService.getObjectsByIds(sidList);
			Map<String, Object> comparam = new HashMap<String, Object>();
			Map<String, Object> cparam = new HashMap<String, Object>();

			Map<Long, Object> csMap = new HashMap<Long, Object>();
			Map<Long, Object> cMap = new HashMap<Long, Object>();
			Map<Long, Object> tMap = new HashMap<Long, Object>();
			for (Long sid : sidList) {
				cparam = DynamicUtil.getIdsByServerId(sid);
				comparam = DynamicUtil.getComidsByServerId(sid);
				List<Long> csList = companyServerRelationService.getIdsByDynamicCondition(CompanyServerRelation.class,
						cparam, 0, 8);
				List<Long> cList = companyService.getIdsByDynamicCondition(Company.class, comparam, 0, 8);
				List<Long> aList = companyService.getIdsByDynamicCondition(Company.class, comparam, 0,
						Integer.MAX_VALUE);
				int total = aList.size();
				List<CompanyServerRelation> companyServerList = companyServerRelationService.getObjectsByIds(csList);
				List<Company> companyList = companyService.getObjectsByIds(cList);
				cMap.put(sid, companyList);
				csMap.put(sid, companyServerList);
				tMap.put(sid, total);
			}
			model.addAttribute("code", 1);
			model.addAttribute("message", "success");
			model.addAttribute("parentList", parentList);
			model.addAttribute("serverList", serverList);
			model.addAttribute("cMap", cMap);
			model.addAttribute("csMap", csMap);
			model.addAttribute("tMap", tMap);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");

		}

		return "/graship-home-service/server/json/serverListJson";
	}

	@RequestMapping(value = "/a/server/more/list", method = RequestMethod.GET)
	public String getMoreCompanyServerJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long id) {
		log.info("id:" + id);
		Map<String, Object> param = new HashMap<String, Object>();
		param = DynamicUtil.getCompanyIdsByServerId(id);
		List<Company> companyList = null;
		try {
			List<Long> countList = companyService.getIdsByDynamicCondition(Company.class, param, 0, Integer.MAX_VALUE);
			Map<String, Object> cparam = new HashMap<String, Object>();
			Map<Long, Object> csrparam = new HashMap<Long, Object>();
			for (Long c : countList) {
				cparam = DynamicUtil.getIdsByServerIdAndCompanyId(id, c);
				List<Long> list = companyServerRelationService.getIdsByDynamicCondition(CompanyServerRelation.class,
						cparam, 0, Integer.MAX_VALUE);
				List<CompanyServerRelation> companyServerList = companyServerRelationService.getObjectsByIds(list);
				csrparam.put(c, companyServerList);
			}
			int total = countList.size();
			companyList = companyService.getObjectsByIds(countList);

			model.addAttribute("code", 1);
			model.addAttribute("message", "success");
			model.addAttribute("serverId", id);
			model.addAttribute("companyList", companyList);
			model.addAttribute("csrparam", csrparam);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
		}

		return "/graship-home-service/server/json/serverListResult";

	}

	// 首页统计
	@RequestMapping(value = "/a/occupation/count", method = RequestMethod.GET)
	public String getOccupationCount(HttpServletRequest request, HttpServletResponse response, ModelMap model) {

		Map<String, Object> param = new HashMap<String, Object>();
		param = DynamicUtil.getIdsByStatus(2);
		Map<String, Object> mparam = new HashMap<String, Object>();
		mparam = DynamicUtil.getCompanyServerIdsByStatus(2);
		try {
			List<Long> cList = companyService.getIdsByDynamicCondition(Company.class, param, 0, Integer.MAX_VALUE);
			int totalCompany = cList.size();
			List<Long> csList = companyServerRelationService.getIdsByDynamicCondition(CompanyServerRelation.class,
					mparam, 0, Integer.MAX_VALUE);
			int totalCSRelation = csList.size();
			model.addAttribute("code", 0);
			model.addAttribute("totalCompany", totalCompany);
			model.addAttribute("totalCSRelation", totalCSRelation);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
			model.addAttribute("code", -10000);
			model.addAttribute("message", "error");

		}
		return "/graship-home-service/server/json/totalCount";

	}

	// 申请
	@RequestMapping(value = "/a/u/server/apply", method = RequestMethod.POST)
	public String getServerApply(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long cid,
			Long sid) {
		log.info("cid:" + cid + ",sid:" + sid);
		Long uid = Long
				.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
		UserServerRelation userServerRelation = new UserServerRelation();
		userServerRelation.setId(null);
		userServerRelation.setSid(sid);
		userServerRelation.setUid(uid);
		userServerRelation.setCid(cid);
		userServerRelation.setStatus(1);
		try {
			userServerRelationService.insert(userServerRelation);

			model.addAttribute("code", 0);

		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
			model.addAttribute("code", -10000);
			model.addAttribute("message", "error");
		}

		return "/graship-home-service/server/json/result";

	}

	@RequestMapping(value = "/a/server/detail", method = RequestMethod.GET)
	public String getServerDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long cid,
			Long sid) {
		log.info("cid:" + cid + ",sid:" + sid);
		try {
			//Long uid = Long
			//		.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
			//Map<String, Object> umap = new HashMap<String, Object>();
			//umap = DynamicUtil.getCompanyServerByUIdAndSid(uid, sid);
			//List<Long> usidList = userServerRelationService.getIdsByDynamicCondition(UserServerRelation.class, umap, 0,
			//		Integer.MAX_VALUE);
			//List<UserServerRelation> usList = userServerRelationService.getObjectsByIds(usidList);
			//UserServerRelation userServerRelation = new UserServerRelation();
			//if (usList.size() > 0) {
			//	userServerRelation = usList.get(0);
			//}

			CompanyServerRelation companyServerRelation = new CompanyServerRelation();
			Map<String, Object> map = new HashMap<String, Object>();
			map = DynamicUtil.getCompanyServerByIdAndUid(cid, sid);
			List<Long> idList = companyServerRelationService.getIdsByDynamicCondition(CompanyServerRelation.class, map,
					0, Integer.MAX_VALUE);
			List<CompanyServerRelation> ucList = companyServerRelationService.getObjectsByIds(idList);
			if (ucList.size() > 0) {
				companyServerRelation = ucList.get(0);
			}
			Company company = companyService.getObjectById(cid);
			//近期申请企业数量
			model.addAttribute("code", 1);
			model.addAttribute("message", "success");
			model.addAttribute("companyServerRelation", companyServerRelation);
			model.addAttribute("company", company);
			//model.addAttribute("userServerRelation", userServerRelation);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
		}
		return "/graship-home-service/company/json/companyDetailJson";

	}

	@RequestMapping(value = "/a/server/level/list", method = RequestMethod.GET)
	public String getServerLevel(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Integer grade, Long id) {
		log.info("grade:" + grade + ",id:" + id);
		Map<String, Object> param = new HashMap<String, Object>();
		param = DynamicUtil.getCompanyIdsByGradeAndId(grade, id);
		try {
			List<Long> idList = companyService.getIdsByDynamicCondition(Company.class, param, 0, Integer.MAX_VALUE);
			List<Company> cList = companyService.getObjectsByIds(idList);
			Map<Long, Object> csrparam = new HashMap<Long, Object>();
			Map<String, Object> cparam = new HashMap<String, Object>();

			for (Long c : idList) {
				cparam = DynamicUtil.getIdsByServerIdAndCompanyId(id, c);
				List<Long> list = companyServerRelationService.getIdsByDynamicCondition(CompanyServerRelation.class,
						cparam, 0, Integer.MAX_VALUE);
				List<CompanyServerRelation> companyServerList = companyServerRelationService.getObjectsByIds(list);
				csrparam.put(c, companyServerList);
			}
			model.addAttribute("code", 1);
			model.addAttribute("message", "success");
			model.addAttribute("companyList", cList);
			model.addAttribute("csrparam", csrparam);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
		}
		return "/graship-home-service/server/json/serverListResult";

	}

	@RequestMapping(value = "/a/angle/venture/invest/list", method = RequestMethod.GET)
	public String getServerLevel(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long tid,
			Long fid) {
		log.info("tid:" + tid + ",fid:" + fid);
		try {
			Map<String, Object> param = new HashMap<String, Object>();
			param = DynamicUtil.getCompanyIdsById(tid);
			List<Long> tList = companyService.getIdsByDynamicCondition(Company.class, param, 0, Integer.MAX_VALUE);
			List<Company> cList = new ArrayList<Company>();
			Map<Long, Object> tmap = new HashMap<Long, Object>();
			Map<String, Object> cparam = new HashMap<String, Object>();
			Map<Long, Object> fmap = new HashMap<Long, Object>();

			for (Long c : tList) {
				cparam = DynamicUtil.getIdsByServerIdAndCompanyId(tid, c);
				List<Long> list = companyServerRelationService.getIdsByDynamicCondition(CompanyServerRelation.class,
						cparam, 0, 8);
				List<CompanyServerRelation> companyServerList = companyServerRelationService.getObjectsByIds(list);
				tmap.put(c, companyServerList);
			}

			List<Long> tmList = companyService.getIdsByDynamicCondition(Company.class, param, 0, 8);
			cList = companyService.getObjectsByIds(tmList);
			List<Long> taList = companyService.getIdsByDynamicCondition(Company.class, param, 0, Integer.MAX_VALUE);

			Map<Integer, Object> tamap = new HashMap<Integer, Object>();
			Map<Integer, Object> famap = new HashMap<Integer, Object>();

			int totala = taList.size();
			tamap.put(1, totala);
			Map<String, Object> fparam = new HashMap<String, Object>();
			fparam = DynamicUtil.getCompanyIdsById(fid);
			List<Company> cfList = new ArrayList<Company>();
			List<Long> fList = companyService.getIdsByDynamicCondition(Company.class, fparam, 0, 8);
			cfList = companyService.getObjectsByIds(fList);
			List<Long> faList = companyService.getIdsByDynamicCondition(Company.class, fparam, 0, Integer.MAX_VALUE);
			int totalb = faList.size();
			famap.put(1, totalb);
			for (Long c : fList) {
				cparam = DynamicUtil.getIdsByServerIdAndCompanyId(fid, c);
				List<Long> list = companyServerRelationService.getIdsByDynamicCondition(CompanyServerRelation.class,
						cparam, 0, 8);
				List<CompanyServerRelation> companyServerList = companyServerRelationService.getObjectsByIds(list);
				fmap.put(c, companyServerList);
			}
			model.addAttribute("code", 1);
			model.addAttribute("message", "success");
			model.addAttribute("totalfenxian", cfList.size());
			model.addAttribute("totaltianshi", cList.size());

			model.addAttribute("cList", cList);
			model.addAttribute("cfList", cfList);
			model.addAttribute("tmap", tmap);
			model.addAttribute("fmap", fmap);
			model.addAttribute("tamap", tamap);
			model.addAttribute("famap", famap);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
		}
		return "/graship-home-service/server/json/companyListJson";

	}

	// 新增服务
	@RequestMapping(value = "/a/u/apply/service/add", method = RequestMethod.POST)
	public String addServerJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long id,
			String favo) throws Exception {
		log.info("id:" + id + ",favo:" + favo);
		Long uid = Long
				.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
		CompanyServerRelation companyServerRelation = new CompanyServerRelation();

		companyServerRelation.setCid(uid);
		companyServerRelation.setSid(id);
		companyServerRelation.setStatus(1);
		companyServerRelation.setFavo(favo);
		try {
			companyServerRelation.setId(null);

			companyServerRelationService.insert(companyServerRelation);

			model.addAttribute("code", 1);
			model.addAttribute("message", "success");
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add server error ");
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
		}

		return "/data/json";
	}

	// 下拉框列表
	@RequestMapping(value = "/a/child/server/list", method = RequestMethod.GET)
	public String childListJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long parentId) {
		log.info("parentId:" + parentId);
		Map<String, Object> param = new HashMap<String, Object>();
		if (parentId == null) {
			parentId = 0L;
		}
		param = DynamicUtil.getIdsByparentId(parentId);
		List<Long> slist;
		try {
			slist = serverService.getIdsByDynamicCondition(Server.class, param, 0, Integer.MAX_VALUE);
			List<Server> childList = serverService.getObjectsByIds(slist);
			model.addAttribute("code", 1);
			model.addAttribute("message", "success");
			model.addAttribute("childList", childList);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
		}
		return "/graship-home-service/server/json/childListJson";

	}

}
