package com.ptteng.graship.home.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.graship.home.ex.CompanyServerEX;
import com.ptteng.graship.home.ex.UserServerEX;
import com.ptteng.graship.home.model.Company;
import com.ptteng.graship.home.model.CompanyServerRelation;
import com.ptteng.graship.home.model.Server;
import com.ptteng.graship.home.model.UserCompanyRelation;
import com.ptteng.graship.home.model.UserServerRelation;
import com.ptteng.graship.home.service.CompanyServerRelationService;
import com.ptteng.graship.home.service.CompanyService;
import com.ptteng.graship.home.service.ServerService;
import com.ptteng.graship.home.service.UserCompanyRelationService;
import com.ptteng.graship.home.service.UserServerRelationService;
import com.ptteng.graship.home.util.DynamicUtil;
import com.qding.common.util.http.cookie.CookieUtil;

/**
 * CompanyServerRelation crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class CompanyServerRelationController {
	private static final Log log = LogFactory.getLog(CompanyServerRelationController.class);

	@Autowired
	private CompanyServerRelationService companyServerRelationService;

	@Autowired
	private ServerService serverService;

	@Autowired
	private CompanyService companyService;

	@Autowired
	private CookieUtil cookieUtil;

	@Autowired
	private UserCompanyRelationService userCompanyRelationService;

	@Autowired
	private UserServerRelationService userServerRelationService;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/companyServerRelation", method = RequestMethod.GET)
	public String getcompanyServerRelationList(HttpServletRequest request, HttpServletResponse response, ModelMap model)
			throws Exception {

		log.info("/companyServerRelation  to /companyServerRelation/view/companyServerRelationList");

		return "/graship-home-service/companyServerRelation/view/companyServerRelationList";
	}

	@RequestMapping(value = "/c/companyServerRelation/{id}", method = RequestMethod.GET)
	public String getCompanyServerRelation(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("/companyServerRelation/" + id + "  to /companyServerRelation/view/companyServerRelationDeail");
		if (null != id) {
			model.addAttribute("id", id);
		} else {
			model.addAttribute("id", 0);
		}

		return "/graship-home-service/companyServerRelation/view/companyServerRelationDetail";
	}

	@RequestMapping(value = "/a/companyServerRelation/{id}", method = RequestMethod.GET)
	public String getCompanyServerRelationJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			CompanyServerRelation companyServerRelation = companyServerRelationService.getObjectById(id);
			log.info("get companyServerRelation data is " + companyServerRelation);

			model.addAttribute("code", 0);

			model.addAttribute("companyServerRelation", companyServerRelation);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get companyServerRelation error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/graship-home-service/companyServerRelation/json/companyServerRelationDetailJson";
	}

	@RequestMapping(value = "/a/companyServerRelation/{id}", method = RequestMethod.PUT)
	public String updateCompanyServerRelationJson(HttpServletRequest request, HttpServletResponse response,
			ModelMap model, CompanyServerRelation companyServerRelation) throws Exception {

		log.info("update companyServerRelation : companyServerRelation= " + companyServerRelation);

		try {

			companyServerRelationService.update(companyServerRelation);

			model.addAttribute("code", 0);

			model.addAttribute("companyServerRelation", companyServerRelation);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update companyServerRelation error,id is  " + companyServerRelation.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/companyServerRelation", method = RequestMethod.POST)
	public String addCompanyServerRelationJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			CompanyServerRelation companyServerRelation) throws Exception {

		log.info("update companyServerRelation : companyServerRelation= " + companyServerRelation);

		try {
			companyServerRelation.setId(null);

			companyServerRelationService.insert(companyServerRelation);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add companyServerRelation error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/companyServerRelation/{id}", method = RequestMethod.DELETE)
	public String deleteCompanyServerRelationJson(HttpServletRequest request, HttpServletResponse response,
			ModelMap model, @PathVariable Long id) throws Exception {

		log.info("delete companyServerRelation : id= " + id);
		try {
			companyServerRelationService.delete(id);

			log.info("add companyServerRelation success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete companyServerRelation error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/multi/companyServerRelation", method = RequestMethod.GET)
	public String getMultiCompanyServerRelationJson(HttpServletRequest request, HttpServletResponse response,
			ModelMap model, Long[] ids) throws Exception {
		log.info("ids:" + ids);
		List<Long> idList = new ArrayList();
		if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			List<CompanyServerRelation> companyServerRelationList = companyServerRelationService
					.getObjectsByIds(idList);
			log.info("get  companyServerRelation data is " + companyServerRelationList);

			model.addAttribute("code", 0);
			model.addAttribute("total", companyServerRelationList.size());

			model.addAttribute("companyServerRelationList", companyServerRelationList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get companyServerRelation error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/graship-home-service/companyServerRelation/json/companyServerRelationListJson";
	}

	// 提供的服务
	@RequestMapping(value = "/a/u/apply/server/list", method = RequestMethod.GET)
	public String applyListJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page,
			Integer size) {
		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		Long uid = Long
				.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
		Map<String, Object> param = new HashMap<String, Object>();
		param = DynamicUtil.getCompanyServerIdsByUid(uid);
		try {
			List<Long> csrList = companyServerRelationService.getIdsByDynamicCondition(CompanyServerRelation.class,
					param, start, size);
			List<CompanyServerRelation> companyServerList = companyServerRelationService.getObjectsByIds(csrList);

			int total = companyServerRelationService
					.getIdsByDynamicCondition(CompanyServerRelation.class, param, 0, Integer.MAX_VALUE).size();
			int totalPage = 0;
			if (total % size == 0) {
				totalPage = total / size;
			} else {
				totalPage = total / size + 1;
			}
			List<CompanyServerEX> companyServerEXList = new ArrayList<CompanyServerEX>();
			for (CompanyServerRelation companyServerRelation : companyServerList) {
				CompanyServerEX ex = new CompanyServerEX();
				ex.setCsid(companyServerRelation.getId());
				ex.setSid(companyServerRelation.getSid());
				ex.setFavo(companyServerRelation.getFavo());
				Server s = serverService.getObjectById(companyServerRelation.getSid());
				if (s.getParentId() == 0) {
					ex.setSname(s.getName());
				} else {
					Server s2 = serverService.getObjectById(s.getParentId());
					ex.setSname(s2.getName());
					ex.setsSonName(s.getName());
				}
				companyServerEXList.add(ex);
			}
			model.addAttribute("code", 1);
			model.addAttribute("message", "success");
			model.addAttribute("total", total);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("companyServerEXList", companyServerEXList);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
		}
		return "/graship-home-service/companyServerRelation/json/companyServerEXListJson";

	}

	// 查看服务
	@RequestMapping(value = "/a/u/apply/server/{id}", method = RequestMethod.GET)
	public String catJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) {
		log.info("id:" + id);
		try {
			CompanyServerRelation companyServer = companyServerRelationService.getObjectById(id);
			CompanyServerEX ex = new CompanyServerEX();
			ex.setCsid(companyServer.getId());
			ex.setSid(companyServer.getSid());
			ex.setFavo(companyServer.getFavo());
			Server s = serverService.getObjectById(companyServer.getSid());
			if (s.getParentId() == 0) {
				ex.setSname(s.getName());
			} else {
				Server s2 = serverService.getObjectById(s.getParentId());
				ex.setSname(s2.getName());
				ex.setsSonName(s.getName());
			}
			model.addAttribute("code", 0);
			model.addAttribute("message", "success");
			model.addAttribute("ex", ex);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
			model.addAttribute("code", -10000);
			model.addAttribute("message", "error");
		}
		return "/graship-home-service/companyServerRelation/json/companyServerRelationDetailJson";

	}

	// 服务申请
	@RequestMapping(value = "/a/u/service/apply/list", method = RequestMethod.GET)
	public String serviceListJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Integer page, Integer size, String status) {
		log.info("status:" + status);
		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		Long uid = Long
				.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
		Map<String, Object> param = new HashMap<String, Object>();

		param = DynamicUtil.getUserServerIdsByStatusAndUid(uid, status);
		try {
			List<Long> rcList = userServerRelationService.getIdsByDynamicCondition(UserServerRelation.class, param,
					start, size);
			List<UserServerRelation> ucList = userServerRelationService.getObjectsByIds(rcList);
			List<Long> allList = userServerRelationService.getIdsByDynamicCondition(UserServerRelation.class, param, 0,
					Integer.MAX_VALUE);
			List<UserServerEX> csList = new ArrayList<UserServerEX>();
			if (ucList.size() > 0) {
				for (UserServerRelation c : ucList) {
					UserServerEX cs = new UserServerEX();
					cs.setApplyDate(c.getCreateAt());
					log.info(c.getCid()+":cid");
					Company company = companyService.getObjectById(c.getCid());
					Server server = serverService.getObjectById(c.getSid());
					if (server.getParentId() == 0) {
						log.info("一级目录！");
						cs.setSname(server.getName());
					} else {
						log.info("二级目录!");
						Server s2 = serverService.getObjectById(server.getParentId());
						cs.setSname(s2.getName() + "-" + server.getName());
					}
					cs.setCname(company.getCname());
					cs.setStatus(c.getStatus());
					cs.setUsid(c.getId());
					cs.setApplyDate(c.getCreateAt());
					cs.setPreDate(c.getPreDate());
					csList.add(cs);
				}
			}
			int total = allList.size();
			int totalPage = 0;
			if (total % size == 0) {
				totalPage = total / size;
			} else {
				totalPage = total / size + 1;
			}

			model.addAttribute("code", 1);
			model.addAttribute("message", "success");
			model.addAttribute("total", total);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("csList", csList);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			;
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
			e.printStackTrace();
		}
		return "/graship-home-service/companyServerRelation/json/userServerListJson";

	}
}
