package com.ptteng.graship.home.controller;

import java.util.ArrayList;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.graship.home.util.DynamicUtil;
import com.ptteng.graship.home.model.Company;
import com.ptteng.graship.home.model.User;
import com.ptteng.graship.home.service.CompanyService;
import com.ptteng.graship.home.service.UserService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;

/**
 * Company crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class CompanyController {
	private static final Log log = LogFactory.getLog(CompanyController.class);

	@Autowired
	private CompanyService companyService;

	@Autowired
	private CookieUtil cookieUtil;

	@Autowired
	private UserService userService;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/company", method = RequestMethod.GET)
	public String getcompanyList(HttpServletRequest request, HttpServletResponse response, ModelMap model)
			throws Exception {

		log.info("/company  to /company/view/companyList");

		return "/graship-home-service/company/view/companyList";
	}

	@RequestMapping(value = "/c/company/{id}", method = RequestMethod.GET)
	public String getCompany(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("/company/" + id + "  to /company/view/companyDeail");
		if (null != id) {
			model.addAttribute("id", id);
		} else {
			model.addAttribute("id", 0);
		}

		return "/graship-home-service/company/view/companyDetail";
	}

	@RequestMapping(value = "/a/company/{id}", method = RequestMethod.PUT)
	public String updateCompanyJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Company company) throws Exception {

		log.info("update company : company= " + company);

		try {

			companyService.update(company);

			model.addAttribute("code", 0);

			model.addAttribute("company", company);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update company error,id is  " + company.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/company", method = RequestMethod.POST)
	public String addCompanyJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Company company) throws Exception {

		log.info("update company : company= " + company);

		try {
			company.setId(null);

			companyService.insert(company);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add company error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/company/{id}", method = RequestMethod.DELETE)
	public String deleteCompanyJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete company : id= " + id);
		try {
			companyService.delete(id);

			log.info("add company success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete company error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/multi/company", method = RequestMethod.GET)
	public String getMultiCompanyJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long[] ids) throws Exception {

		List<Long> idList = new ArrayList();
		if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			List<Company> companyList = companyService.getObjectsByIds(idList);
			log.info("get  company data is " + companyList);

			model.addAttribute("code", 0);
			model.addAttribute("total", companyList.size());

			model.addAttribute("companyList", companyList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get company error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/graship-home-service/company/json/companyListJson";
	}
    //判断是否有公司
	@RequestMapping(value = "/a/u/have/company", method = RequestMethod.GET)
	public String isCompany(HttpServletRequest request, HttpServletResponse response, ModelMap model)
			throws Exception {
		Long id = Long
				.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
		log.info("get data : id= " + id);
		try {
			Map<String, Object> param = DynamicUtil.getCpy(id);
			List<Long> ids = companyService.getIdsByDynamicCondition(Company.class, param, 0, Integer.MAX_VALUE);
			if (ids.size() > 0) {
				model.addAttribute("code",0);
			}else{
				model.addAttribute("code",-4);
			}
		} catch (Throwable t) {
			t.printStackTrace();
			model.addAttribute("code", -10000);
		}

		return "/common/success";
	}
	// 公司信息
	@RequestMapping(value = " /a/u/company/detail", method = RequestMethod.GET)
	public String getUserCompanyJson(HttpServletRequest request, HttpServletResponse response, ModelMap model)
			throws Exception {
		Long id = Long
				.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
		log.info("get data : id= " + id);
		try {
			Map<String, Object> param = DynamicUtil.getCpy(id);
			List<Long> ids = companyService.getIdsByDynamicCondition(Company.class, param, 0, Integer.MAX_VALUE);
			Company company = new Company();
			if (ids.size() > 0) {
				company = companyService.getObjectById(ids.get(0));
			}
			log.info("get company data is " + company);
			User u = userService.getObjectById(id);
			Map<Long, Object> map = new HashMap<Long, Object>();
			map.put(u.getId(), u.getMobile());
			model.addAttribute("code", 1);
			model.addAttribute("message", "success");
			model.addAttribute("company", company);
			model.addAttribute("map", map);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get company error,id is  " + id);
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
		}

		return "/graship-home-service/company/json/companyDetailJson";
	}

	// 编辑公司
	@RequestMapping(value = "/a/u/company/change", method = RequestMethod.POST)
	public String addOwnCompanyJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Company company) throws Exception {
		log.info("company:" + company);
		Long id = Long
				.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
		if (DataUtils.isNotNullOrEmpty(id)) {
			company.setUid(id);
		}
		try {
			if (company.getId() != null) {
				companyService.update(company);
			} else {
				company.setId(null);
				companyService.insert(company);
			}
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add ownCompany error ");
			model.addAttribute("code", -10000);
		}

		return "/graship-home-service/company/json/result";
	}

	// 合作入驻
	@RequestMapping(value = "/a/u/company/enter", method = RequestMethod.PUT)
	public String companyEnterJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			String barcode, String license, String creditCode) {
		log.info(" barcode:" + barcode + ", license:" + license + ", creditCode:" + creditCode);
		Long id = Long
				.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
		Company company;
		try {
			company = companyService.getObjectById(id);
			company.setBarcode(barcode);
			company.setLicense(license);
			company.setCreditCode(creditCode);
			company.setStatus(1);
			companyService.update(company);
			model.addAttribute("code", 1);
			model.addAttribute("message", "success");
		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
			e.printStackTrace();
		}
		return "/graship-home-service/company/json/result";

	}
}
