-- ----------------------------
-- Table structure for `product`
-- ----------------------------
-- DROP TABLE IF EXISTS `product`;
CREATE TABLE `product` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `name` varchar(20) NOT NULL   COMMENT '产品名称',
    `status` int(1) NOT NULL   COMMENT '状态',
    `create_at` bigint NOT NULL   COMMENT '创建时间',
    `update_at` bigint NOT NULL   COMMENT '更新时间',
    `create_by` bigint NOT NULL   COMMENT '创建人',
    `update_by` bigint NOT NULL   COMMENT '更新人',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `component`
-- ----------------------------
-- DROP TABLE IF EXISTS `component`;
CREATE TABLE `component` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `name` varchar(20) NOT NULL   COMMENT '组件名/子组件名',
    `pid` bigint NOT NULL   COMMENT '产品id',
    `detail` varchar(30)    COMMENT '子组件信息',
    `edition` int(1)    COMMENT '子组件版本',
    `status` int(1) NOT NULL   COMMENT '组件/子组件上下架状态',
    `parent_id` bigint NOT NULL   COMMENT '父类的id',
    `create_at` bigint NOT NULL   COMMENT '创建时间',
    `update_at` bigint NOT NULL   COMMENT '更新时间',
    `create_by` bigint NOT NULL   COMMENT '创建人',
    `update_by` bigint NOT NULL   COMMENT '更新人',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `project`
-- ----------------------------
-- DROP TABLE IF EXISTS `project`;
CREATE TABLE `project` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `type` int(2) NOT NULL   COMMENT '项目类型',
    `category` int(2) NOT NULL   COMMENT '类别',
    `name` varchar(50) NOT NULL   COMMENT '项目名称',
    `cycle` varchar(4) NOT NULL   COMMENT '项目周期',
    `number` int(3) NOT NULL   COMMENT '开发人数',
    `status` int(1) NOT NULL   COMMENT '项目状态',
    `banner_img` varchar(100) NOT NULL   COMMENT '（编辑页）banner图',
    `introduce` varchar(1000) NOT NULL   COMMENT '应用介绍',
    `android_url` varchar(50)    COMMENT '应用地址下的Android url',
    `ios_url` varchar(50)    COMMENT '应用地址下的iOS url',
    `website_url` varchar(50)    COMMENT '应用地址下的网站地址',
    `function` varchar(600) NOT NULL   COMMENT '应用地址下的功能简介',
    `feature` varchar(1000) NOT NULL   COMMENT '应用地址下的开发特色',
    `version` varchar(50) NOT NULL   COMMENT '开发版本',
    `fund` varchar(50) NOT NULL   COMMENT '开发资金',
    `frame_img` varchar(500) NOT NULL   COMMENT '界面视图',
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',
    `update_by` bigint(20) NOT NULL   COMMENT '更新人',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;








-- ----------------------------
-- Table structure for `user`
-- ----------------------------
-- DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `name` varchar NOT NULL  ,  
    `pwd` varchar NOT NULL  ,  
    `head` varchar   ,  
    `mobile` varchar NOT NULL  ,  
    `mail` varchar NOT NULL  ,  
    `phone` varchar NOT NULL  ,  
    `cpy_name` varchar NOT NULL  ,  
    `logo` varchar   ,  
    `grade` int   ,  
    `webside` varchar   ,  
    `profile` varchar   ,  
    `details` varchar   ,  
    `servers` varchar   ,  
    `industry` varchar   ,  
    `stage` int   ,  
    `advantage` varchar   ,  
    `advertising` varchar   ,  
    `barcode` varchar   ,  
    `license` varchar   ,  
    `credit_code` varchar   ,  
    `spare` varchar   ,  
    `count` bigint   ,  
    `status` int   ,  
    `createat_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `order`
-- ----------------------------
-- DROP TABLE IF EXISTS `order`;
CREATE TABLE `order` (
    `oid` bigint NOT NULL  ,  
    `user_name` varchar NOT NULL  ,  
    `mobile` varchar NOT NULL  ,  
    `cpy_id` bigint NOT NULL  ,  
    `cpy_name` varchar NOT NULL  ,  
    `applya` int NOT NULL  ,  
    `applyb` int NOT NULL  ,  
    `ostage` int NOT NULL  ,  
    `pact` bigint NOT NULL  ,  
    `createat_by` bigint NOT NULL  ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `serve`
-- ----------------------------
-- DROP TABLE IF EXISTS `serve`;
CREATE TABLE `serve` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `servea` int   ,  
    `serveb` int   ,  
    `favo` varchar   ,  
    `staus` int NOT NULL  ,  
    `createat_by` bigint NOT NULL  ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `message`
-- ----------------------------
-- DROP TABLE IF EXISTS `message`;
CREATE TABLE `message` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `content` bigint   ,  
    `mstage` int   ,  
    `createat_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





