/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.graship.home.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.graship.home.model.Serve;
import com.ptteng.graship.home.service.ServeService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServeServiceImpl
extends BaseDaoServiceImpl
implements ServeService {
    private static final Log log = LogFactory.getLog(ServeServiceImpl.class);

    public Long insert(Serve serve) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + serve));
        if (serve == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        serve.setCreateAt(Long.valueOf(currentTimeMillis));
        serve.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)serve);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + serve));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Serve> insertList(List<Serve> serveList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (serveList == null ? "null" : Integer.valueOf(serveList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(serveList)) {
            return new ArrayList<Serve>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Serve serve : serveList) {
            serve.setCreateAt(Long.valueOf(currentTimeMillis));
            serve.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(serveList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + serveList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Serve.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Serve serve) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (serve == null ? "null" : serve.getId())));
        boolean result = false;
        if (serve == null) {
            return true;
        }
        serve.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)serve);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + serve));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + serve));
        }
        return result;
    }

    public boolean updateList(List<Serve> serveList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (serveList == null ? "null" : Integer.valueOf(serveList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(serveList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Serve serve : serveList) {
            serve.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(serveList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + serveList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + serveList.size()));
        return result;
    }

    public Serve getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Serve serve = null;
        if (id == null) {
            return serve;
        }
        try {
            serve = (Serve)this.dao.get(Serve.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return serve;
    }

    public List<Serve> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List serve = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Serve>();
        }
        try {
            serve = this.dao.getList(Serve.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get serve success : " + (serve == null ? "null" : Integer.valueOf(serve.size()))));
        System.out.println(serve);
        return serve;
    }

    public List<Long> getServeIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getServeIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getServeIdsById(Long id, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getServeIdsById", new Object[]{id}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countServeIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getServeIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getServeIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public List<Long> getServeByCpyAndGrade(Long cpyId, Integer grade, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getServeByCpyAndGrade", new Object[]{cpyId, grade}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getServeByCpyAndFather(Long cpyId, Long servea, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getServeByCpyAndFather", new Object[]{cpyId, servea}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getCpyIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" \u81ea\u5df1\u5199\u7684 =======serve=========== " + ids));
        List idList = null;
        try {
            idList = this.dao.getIdList("getCpyIds", new Object[]{ids}, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), false);
            log.info((Object)("get List success the list is" + idList));
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by parentID)  : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        System.out.println(idList);
        return idList;
    }

    public List<Serve> getObjectsById(Long id) throws ServiceException, ServiceDaoException {
        return null;
    }
}

