/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.graship.home.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.graship.home.model.Information;
import com.ptteng.graship.home.service.InformationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InformationServiceImpl
extends BaseDaoServiceImpl
implements InformationService {
    private static final Log log = LogFactory.getLog(InformationServiceImpl.class);

    public Long insert(Information information) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + information));
        if (information == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        information.setCreateAt(Long.valueOf(currentTimeMillis));
        information.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)information);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + information));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Information> insertList(List<Information> informationList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (informationList == null ? "null" : Integer.valueOf(informationList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(informationList)) {
            return new ArrayList<Information>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Information information : informationList) {
            information.setCreateAt(Long.valueOf(currentTimeMillis));
            information.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(informationList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + informationList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Information.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Information information) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (information == null ? "null" : information.getId())));
        boolean result = false;
        if (information == null) {
            return true;
        }
        information.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)information);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + information));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + information));
        }
        return result;
    }

    public boolean updateList(List<Information> informationList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (informationList == null ? "null" : Integer.valueOf(informationList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(informationList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Information information : informationList) {
            information.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(informationList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + informationList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + informationList.size()));
        return result;
    }

    public Information getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Information information = null;
        if (id == null) {
            return information;
        }
        try {
            information = (Information)this.dao.get(Information.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return information;
    }

    public List<Information> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List information = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Information>();
        }
        try {
            information = this.dao.getList(Information.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (information == null ? "null" : Integer.valueOf(information.size()))));
        return information;
    }

    public List<Long> getInformationIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getInformationIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countInformationIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getInformationIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getInformationIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

