/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.graship.home.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.graship.home.model.Component;
import com.ptteng.graship.home.service.ComponentService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ComponentServiceImpl
extends BaseDaoServiceImpl
implements ComponentService {
    private static final Log log = LogFactory.getLog(ComponentServiceImpl.class);

    public Long insert(Component component) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + component));
        if (component == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        component.setCreateAt(Long.valueOf(currentTimeMillis));
        component.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)component);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + component));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Component> insertList(List<Component> componentList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (componentList == null ? "null" : Integer.valueOf(componentList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(componentList)) {
            return new ArrayList<Component>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Component component : componentList) {
            component.setCreateAt(Long.valueOf(currentTimeMillis));
            component.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(componentList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + componentList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Component.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Component component) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (component == null ? "null" : component.getId())));
        boolean result = false;
        if (component == null) {
            return true;
        }
        component.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)component);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + component));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + component));
        }
        return result;
    }

    public boolean updateList(List<Component> componentList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (componentList == null ? "null" : Integer.valueOf(componentList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(componentList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Component component : componentList) {
            component.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(componentList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + componentList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + componentList.size()));
        return result;
    }

    public Component getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Component component = null;
        if (id == null) {
            return component;
        }
        try {
            component = (Component)this.dao.get(Component.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return component;
    }

    public List<Component> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List component = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Component>();
        }
        try {
            component = this.dao.getList(Component.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (component == null ? "null" : Integer.valueOf(component.size()))));
        return component;
    }

    public List<Long> getComponentIdsByPidAndStatusOrderByCreateAt(Long pid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by pid,status,start,limit  : " + pid + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getComponentIdsByPidAndStatusOrderByCreateAt", new Object[]{pid, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by pid,status,start,limit)  : " + pid + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countComponentIdsByPidAndStatusOrderByCreateAt(Long pid, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by pid,status  : " + pid + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getComponentIdsByPidAndStatusOrderByCreateAt", new Object[]{pid, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by pid,status)  : " + pid + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getComponentIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getComponentIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countComponentIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getComponentIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getComponentIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

