/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.graship.home.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.graship.home.model.Company;
import com.ptteng.graship.home.service.CompanyService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompanyServiceImpl
extends BaseDaoServiceImpl
implements CompanyService {
    private static final Log log = LogFactory.getLog(CompanyServiceImpl.class);

    public Long insert(Company company) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + company));
        if (company == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        company.setCreateAt(Long.valueOf(currentTimeMillis));
        company.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)company);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + company));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Company> insertList(List<Company> companyList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (companyList == null ? "null" : Integer.valueOf(companyList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(companyList)) {
            return new ArrayList<Company>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Company company : companyList) {
            company.setCreateAt(Long.valueOf(currentTimeMillis));
            company.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(companyList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + companyList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Company.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Company company) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (company == null ? "null" : company.getId())));
        boolean result = false;
        if (company == null) {
            return true;
        }
        company.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)company);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + company));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + company));
        }
        return result;
    }

    public boolean updateList(List<Company> companyList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (companyList == null ? "null" : Integer.valueOf(companyList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(companyList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Company company : companyList) {
            company.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(companyList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + companyList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + companyList.size()));
        return result;
    }

    public Company getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Company company = null;
        if (id == null) {
            return company;
        }
        try {
            company = (Company)this.dao.get(Company.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return company;
    }

    public List<Company> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List company = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Company>();
        }
        try {
            company = this.dao.getList(Company.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (company == null ? "null" : Integer.valueOf(company.size()))));
        return company;
    }

    public List<Long> getCompanyIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCompanyIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCompanyIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getCompanyIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getCompanyIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

