package com.ptteng.graship.home.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.graship.home.model.UserServerRelation;
import com.ptteng.graship.home.service.UserServerRelationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class UserServerRelationServiceImpl extends BaseDaoServiceImpl implements UserServerRelationService {

 

	private static final Log log = LogFactory.getLog(UserServerRelationServiceImpl.class);



		   
		@Override
		public Long insert(UserServerRelation userServerRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userServerRelation);

		if (userServerRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userServerRelation.setCreateAt(currentTimeMillis);
		userServerRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userServerRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userServerRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserServerRelation> insertList(List<UserServerRelation> userServerRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userServerRelationList == null ? "null" : userServerRelationList.size()));
      
		List<UserServerRelation> resultList = null;

		if (CollectionUtils.isEmpty(userServerRelationList)) {
			return new ArrayList<UserServerRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserServerRelation userServerRelation : userServerRelationList) {
			userServerRelation.setCreateAt(currentTimeMillis);
			userServerRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserServerRelation>) dao.batchSave(userServerRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userServerRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserServerRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserServerRelation userServerRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userServerRelation == null ? "null" : userServerRelation.getId()));

		boolean result = false;

		if (userServerRelation == null) {
			return true;
		}

		userServerRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userServerRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + userServerRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userServerRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserServerRelation> userServerRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userServerRelationList == null ? "null" : userServerRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userServerRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserServerRelation userServerRelation : userServerRelationList) {
			userServerRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userServerRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userServerRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userServerRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserServerRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserServerRelation userServerRelation = null;

		if (id == null) {
			return userServerRelation;
		}

		try {
			userServerRelation = (UserServerRelation) dao.get(UserServerRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userServerRelation;		
		}	
		  
    	   
		@Override
		public List<UserServerRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserServerRelation> userServerRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserServerRelation>();
		}

		try {
			userServerRelation = (List<UserServerRelation>) dao.getList(UserServerRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userServerRelation == null ? "null" : userServerRelation.size()));
    
		return userServerRelation;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getUserServerRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserServerRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserServerRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserServerRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserServerRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

