package com.ptteng.graship.home.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.graship.home.model.Server;
import com.ptteng.graship.home.service.ServerService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class ServerServiceImpl extends BaseDaoServiceImpl implements ServerService {

 

	private static final Log log = LogFactory.getLog(ServerServiceImpl.class);



		   
		@Override
		public Long insert(Server server)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + server);

		if (server == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		server.setCreateAt(currentTimeMillis);
		server.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(server);
		} catch (DaoException e) {
			log.error(" insert wrong : " + server);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Server> insertList(List<Server> serverList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (serverList == null ? "null" : serverList.size()));
      
		List<Server> resultList = null;

		if (CollectionUtils.isEmpty(serverList)) {
			return new ArrayList<Server>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Server server : serverList) {
			server.setCreateAt(currentTimeMillis);
			server.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Server>) dao.batchSave(serverList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + serverList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Server.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Server server)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (server == null ? "null" : server.getId()));

		boolean result = false;

		if (server == null) {
			return true;
		}

		server.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(server);
		} catch (DaoException e) {
			log.error(" update wrong : " + server);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + server);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Server> serverList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (serverList == null ? "null" : serverList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(serverList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Server server : serverList) {
			server.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(serverList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + serverList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + serverList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Server getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Server server = null;

		if (id == null) {
			return server;
		}

		try {
			server = (Server) dao.get(Server.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return server;		
		}	
		  
    	   
		@Override
		public List<Server> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Server> server = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Server>();
		}

		try {
			server = (List<Server>) dao.getList(Server.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (server == null ? "null" : server.size()));
    
		return server;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getServerIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getServerIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countServerIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getServerIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getServerIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

