package com.ptteng.graship.home.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.graship.home.model.Serve;
import com.ptteng.graship.home.service.ServeService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class ServeServiceImpl extends BaseDaoServiceImpl implements ServeService {

 

	private static final Log log = LogFactory.getLog(ServeServiceImpl.class);



		   
		@Override
		public Long insert(Serve serve)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + serve);

		if (serve == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		serve.setCreateAt(currentTimeMillis);
		serve.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(serve);
		} catch (DaoException e) {
			log.error(" insert wrong : " + serve);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Serve> insertList(List<Serve> serveList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (serveList == null ? "null" : serveList.size()));
      
		List<Serve> resultList = null;

		if (CollectionUtils.isEmpty(serveList)) {
			return new ArrayList<Serve>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Serve serve : serveList) {
			serve.setCreateAt(currentTimeMillis);
			serve.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Serve>) dao.batchSave(serveList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + serveList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Serve.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Serve serve)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (serve == null ? "null" : serve.getId()));

		boolean result = false;

		if (serve == null) {
			return true;
		}

		serve.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(serve);
		} catch (DaoException e) {
			log.error(" update wrong : " + serve);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + serve);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Serve> serveList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (serveList == null ? "null" : serveList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(serveList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Serve serve : serveList) {
			serve.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(serveList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + serveList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + serveList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Serve getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Serve serve = null;

		if (id == null) {
			return serve;
		}

		try {
			serve = (Serve) dao.get(Serve.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return serve;		
		}	
		  
    	   
		@Override
		public List<Serve> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Serve> serve = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Serve>();
		}

		try {
			serve = (List<Serve>) dao.getList(Serve.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get serve success : " + (serve == null ? "null" : serve.size()));
			System.out.println(serve);

			return serve;
		}	
		  
    	
	//====================================================================================	
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getServeIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getServeIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	@Override
	public List<Long> getServeIdsById(Long id,Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getServeIdsById",new Object[] {id},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}

	
		@Override
	public Integer countServeIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getServeIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getServeIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

	@Override
	public List<Long> getServeByCpyAndGrade(Long cpyId, Integer grade,Integer start, Integer limit) throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getServeByCpyAndGrade",new Object[] {cpyId,grade},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}

	@Override
	public List<Long> getServeByCpyAndFather(Long cpyId, Long servea, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getServeByCpyAndFather",new Object[] {cpyId,servea},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


		@Override
		public List<Long> getCpyIds(List<Long> ids) throws ServiceException, ServiceDaoException {
			log.info(" 自己写的 =======serve=========== " +ids);
	        List<Long> idList = null;


	        try{
	            idList=dao.getIdList("getCpyIds",new Object[] {ids},0, Integer.MAX_VALUE, false);
	            log.info("get List success the list is"+idList);
	        }
	        catch (DaoException e) {
	            log.error(" get ids  wrong by parentID)  : " + ids);
	            log.error(e);
	            e.printStackTrace();
	            throw new ServiceDaoException(e);
	        }
	        if (log.isInfoEnabled()) {
	            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
	        }
	        System.out.println(idList);
	        return idList;
	    }


		@Override
		public List<Serve> getObjectsById(Long id) throws ServiceException, ServiceDaoException {
			// TODO Auto-generated method stub
			return null;
		}


		


}

