package com.ptteng.graship.home.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.graship.home.model.Information;
import com.ptteng.graship.home.service.InformationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class InformationServiceImpl extends BaseDaoServiceImpl implements InformationService {

 

	private static final Log log = LogFactory.getLog(InformationServiceImpl.class);



		   
		@Override
		public Long insert(Information information)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + information);

		if (information == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		information.setCreateAt(currentTimeMillis);
		information.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(information);
		} catch (DaoException e) {
			log.error(" insert wrong : " + information);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Information> insertList(List<Information> informationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (informationList == null ? "null" : informationList.size()));
      
		List<Information> resultList = null;

		if (CollectionUtils.isEmpty(informationList)) {
			return new ArrayList<Information>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Information information : informationList) {
			information.setCreateAt(currentTimeMillis);
			information.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Information>) dao.batchSave(informationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + informationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Information.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Information information)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (information == null ? "null" : information.getId()));

		boolean result = false;

		if (information == null) {
			return true;
		}

		information.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(information);
		} catch (DaoException e) {
			log.error(" update wrong : " + information);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + information);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Information> informationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (informationList == null ? "null" : informationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(informationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Information information : informationList) {
			information.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(informationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + informationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + informationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Information getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Information information = null;

		if (id == null) {
			return information;
		}

		try {
			information = (Information) dao.get(Information.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return information;		
		}	
		  
    	   
		@Override
		public List<Information> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Information> information = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Information>();
		}

		try {
			information = (List<Information>) dao.getList(Information.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (information == null ? "null" : information.size()));
    
		return information;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getInformationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getInformationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countInformationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getInformationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getInformationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

